"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Assignment = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const permissionset_common_1 = require("./private/permissionset-common");
const principal_common_1 = require("./private/principal-common");
/**
 * The base assignment class
 *
 * Currently this is mostly empty. There isn't any
 * valuable methods to apply here or any resulting
 * attributes to define.
 */
class AssignmentBase extends aws_cdk_lib_1.Resource {
}
;
/**
 * The assignment construct.
 *
 * Has no import method because there is no attributes to import.
 */
class Assignment extends AssignmentBase {
    constructor(scope, id, props) {
        super(scope, id);
        Assignment.validateTargetId(props.targetId);
        principal_common_1.validatePrincipal(props.principal);
        permissionset_common_1.validatePermissionSetArn(props.permissionSet.permissionSetArn);
        new aws_cdk_lib_1.aws_sso.CfnAssignment(this, 'assignment', {
            instanceArn: props.permissionSet.ssoInstanceArn,
            permissionSetArn: props.permissionSet.permissionSetArn,
            principalId: props.principal.principalId,
            principalType: props.principal.principalType,
            targetId: props.targetId,
            targetType: 'AWS_ACCOUNT',
        });
    }
    static validateTargetId(targetId) {
        if (!targetId.match(/\d{12}/)) {
            throw new Error(`targetId should be a 12 digit AWS account id, but was ${targetId}`);
        }
    }
}
exports.Assignment = Assignment;
_a = JSII_RTTI_SYMBOL_1;
Assignment[_a] = { fqn: "@renovosolutions/cdk-library-aws-sso.Assignment", version: "0.0.2" };
//# sourceMappingURL=data:application/json;base64,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