import { IResource, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IPermissionSet } from './permissionset';
import { PrincipalProperty } from './principal';
/**
 * The resource interface for an AWS SSO assignment.
 *
 * This interface has no attributes because the resulting resource has none.
 */
export interface IAssignment extends IResource {
}
/**
 * The base assignment class
 *
 * Currently this is mostly empty. There isn't any
 * valuable methods to apply here or any resulting
 * attributes to define.
 */
declare abstract class AssignmentBase extends Resource implements IAssignment {
}
/**
 * Attributes for an assignment of which there are none.
 */
export interface AssignmentAttributes {
}
/**
 * The properties of a new assignment.
 */
export interface AssignmentProps {
    /**
     * The permission set to assign to the principal
     */
    readonly permissionSet: IPermissionSet;
    /**
     * The principal to assign the permission set to
     */
    readonly principal: PrincipalProperty;
    /**
     * The target id the permission set will be assigned to
     */
    readonly targetId: string;
}
/**
 * The assignment construct.
 *
 * Has no import method because there is no attributes to import.
 */
export declare class Assignment extends AssignmentBase {
    private static validateTargetId;
    constructor(scope: Construct, id: string, props: AssignmentProps);
}
export {};
