"""
Defines exceptions that are used by various applications, both on the LOD server and in locally running applications.

(This file is used both on the server, and in several local applications, for consistency)
"""


##############################################################################################################
#
# NOTE !!!
#
# THIS FILE MAY BE AUTOGENERATED.
# ONLY MODIFY THE ORIGINAL FILE IN THE /sharedData/ FOLDER!
# OTHER INSTANCES OF THIS FILE ARE COPIES!
#
# NOTE !
#
##############################################################################################################


class ServersideProgrammingError(Exception):
    """
    This exception shouldn't happen during the normal course of operations at all.
    If it does, it means that a programming mistake has been made.
    """
    pass


class AccessRightsException(Exception):
    """
    An exception that indicates that an illegal operation was requested by a user.
    This exception should not occur if the user only makes use of provided libraries.
    Unlike :class:`.InvalidParamsException`, this exception is not completely benign and can indicate that the user is actively attempting to gain access to things they shouldn't have access to.
    """
    pass


class InvalidParamsException(Exception):
    """
    An exception that indicates that a parameter given to the server is invalid.
    This exception is the standard exception generated when a user does anything incorrectly.
    """
    pass


class BenignException(Exception):
    """
    An exception that is benign, i.e. not a problem.
    It is supposed to happen and can be ignored.
    It does not need to be reported or logged.
    """
    pass
