/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.pgraphs.io.GenericParser;

public class TestGenericParser
extends TestCase {
    public void testParseBlock() {
        StringReader empty = new StringReader("VOID\nEND\n");
        GenericParser emptyParser = new GenericParser(empty);
        GenericParser.Block block = emptyParser.parseDataBlock();
        TestGenericParser.assertEquals((int)0, (int)block.getEntries().length);
        TestGenericParser.assertEquals((String)"void", (String)emptyParser.getDataType());
        TestGenericParser.assertEquals((int)2, (int)emptyParser.getLineNumber());
        StringReader test = new StringReader("GARBAGE\n  # this is a comment - test test test\n  JUNK a \"1\" -1/2\n\"JUNK\" asdf\nTRASH 127 1.2e7 1.2i8\n  VOID\n  1/2.3\nEND\n");
        HashMap<String, String> synonyms = new HashMap<String, String>();
        synonyms.put("trash", "junk");
        GenericParser parser = new GenericParser(test);
        parser.setSynonyms(synonyms);
        block = parser.parseDataBlock();
        GenericParser.Entry[] entries = block.getEntries();
        TestGenericParser.assertEquals((int)4, (int)entries.length);
        TestGenericParser.assertEquals((String)"junk", (String)entries[0].key);
        TestGenericParser.assertEquals((int)3, (int)entries[0].lineNumber);
        List<Object> row = entries[0].values;
        TestGenericParser.assertEquals((int)3, (int)row.size());
        TestGenericParser.assertEquals((Object)"a", (Object)row.get(0));
        TestGenericParser.assertEquals((Object)"1", (Object)row.get(1));
        TestGenericParser.assertEquals((Object)new Fraction(-1L, 2L), (Object)row.get(2));
        TestGenericParser.assertEquals((String)"junk", (String)entries[1].key);
        TestGenericParser.assertEquals((int)4, (int)entries[1].lineNumber);
        row = entries[1].values;
        TestGenericParser.assertEquals((int)2, (int)row.size());
        TestGenericParser.assertEquals((Object)"JUNK", (Object)row.get(0));
        TestGenericParser.assertEquals((Object)"asdf", (Object)row.get(1));
        TestGenericParser.assertEquals((String)"junk", (String)entries[2].key);
        TestGenericParser.assertEquals((int)5, (int)entries[2].lineNumber);
        row = entries[2].values;
        TestGenericParser.assertEquals((int)3, (int)row.size());
        TestGenericParser.assertEquals((Object)new Whole(127L), (Object)row.get(0));
        TestGenericParser.assertEquals((Object)new FloatingPoint(1.2E7), (Object)row.get(1));
        TestGenericParser.assertEquals((Object)"1.2i8", (Object)row.get(2));
        TestGenericParser.assertEquals((String)"void", (String)entries[3].key);
        TestGenericParser.assertEquals((int)7, (int)entries[3].lineNumber);
        row = entries[3].values;
        TestGenericParser.assertEquals((int)1, (int)row.size());
        TestGenericParser.assertEquals((Object)"1/2.3", (Object)row.get(0));
        TestGenericParser.assertEquals((int)2, (int)block.getKeys().size());
        TestGenericParser.assertEquals((int)3, (int)block.getEntries("junk").size());
        TestGenericParser.assertEquals((int)1, (int)block.getEntries("void").size());
    }
}

