/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.simple.DataFormatException;
import org.gavrog.box.simple.NamedConstant;
import org.gavrog.box.simple.TaskController;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Lattices;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.io.GenericParser;
import org.gavrog.joss.pgraphs.io.Net;

public class NetParser
extends GenericParser {
    private static final boolean DEBUG = false;
    public static InfoType CONNECTIVITY = new InfoType("Connectivity");
    public static InfoType COORDINATION_SEQUENCE = new InfoType("Coordination-Sequence");
    public static InfoType POSITION = new InfoType("Position");
    private GenericParser.Block lastBlock;
    private static final DecimalFormat fmtReal4 = new DecimalFormat("0.0000");

    public NetParser(BufferedReader bufferedReader) {
        super(bufferedReader);
        this.synonyms = NetParser.makeSynonyms();
        this.defaultKey = "edge";
    }

    public NetParser(Reader reader) {
        this(new BufferedReader(reader));
    }

    public NetParser(String string) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(string)));
    }

    private static Map<String, String> makeSynonyms() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("vertex", "node");
        hashMap.put("vertices", "node");
        hashMap.put("vertexes", "node");
        hashMap.put("atom", "node");
        hashMap.put("atoms", "node");
        hashMap.put("nodes", "node");
        hashMap.put("bond", "edge");
        hashMap.put("bonds", "edge");
        hashMap.put("edges", "edge");
        hashMap.put("faces", "face");
        hashMap.put("ring", "face");
        hashMap.put("rings", "face");
        hashMap.put("tiles", "tile");
        hashMap.put("body", "tile");
        hashMap.put("bodies", "tile");
        hashMap.put("spacegroup", "group");
        hashMap.put("space_group", "group");
        hashMap.put("id", "name");
        hashMap.put("edge_centers", "edge_center");
        hashMap.put("edge_centre", "edge_center");
        hashMap.put("edge_centres", "edge_center");
        hashMap.put("edgecenter", "edge_center");
        hashMap.put("edgecenters", "edge_center");
        hashMap.put("edgecentre", "edge_center");
        hashMap.put("edgecentres", "edge_center");
        hashMap.put("coordination_sequences", "coordination_sequence");
        hashMap.put("coordinationsequence", "coordination_sequence");
        hashMap.put("coordinationsequences", "coordination_sequence");
        hashMap.put("cs", "coordination_sequence");
        return Collections.unmodifiableMap(hashMap);
    }

    public static PeriodicGraph stringToNet(String string) {
        return new NetParser(new StringReader(string)).parseNet();
    }

    public Net parseNet() {
        return this.parseNet(this.parseDataBlock());
    }

    public Net parseNet(GenericParser.Block block) {
        Net net;
        block6: {
            GenericParser.Entry[] entryArray = block.getEntries();
            if (entryArray == null) {
                return null;
            }
            String string = block.getType().toLowerCase();
            this.lastBlock = block;
            net = null;
            try {
                if (string.equals("periodic_graph")) {
                    net = this.parsePeriodicGraph(entryArray);
                    break block6;
                }
                if (string.equals("crystal")) {
                    net = this.parseCrystal(entryArray);
                    break block6;
                }
                if (string.equals("net")) {
                    net = this.parseSymmetricNet(entryArray);
                    break block6;
                }
                throw new DataFormatException("type " + string + " not supported");
            }
            catch (DataFormatException dataFormatException) {
                net = new Net(0, this.getName(), this.getSpaceGroup());
                net.logError(dataFormatException);
            }
        }
        return net;
    }

    private String getName() {
        return this.lastBlock.getEntriesAsString("name");
    }

    private String getSpaceGroup() {
        String string = this.lastBlock.getEntriesAsString("group");
        if (string == null) {
            return "P1";
        }
        return string;
    }

    private String keywordWarning(GenericParser.Entry entry) {
        return "Unknown keyword '" + entry.originalKey + "' at line " + entry.lineNumber;
    }

    private Net parsePeriodicGraph(GenericParser.Entry[] entryArray) {
        Net net = null;
        HashMap<Object, INode> hashMap = new HashMap<Object, INode>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < entryArray.length; ++i) {
            if (entryArray[i].key.equals("edge")) {
                INode iNode;
                List<Object> list = entryArray[i].values;
                int n = list.size() - 2;
                if (n < 1) {
                    throw new DataFormatException("not enough fields at line " + entryArray[i].lineNumber);
                }
                if (net == null) {
                    net = new Net(n, this.getName(), this.getSpaceGroup());
                } else if (n != net.getDimension()) {
                    throw new DataFormatException("inconsistent shift dimensions at line " + entryArray[i].lineNumber);
                }
                INode iNode2 = (INode)hashMap.get(list.get(0));
                if (iNode2 == null) {
                    iNode2 = net.newNode("" + list.get(0));
                    hashMap.put(list.get(0), iNode2);
                }
                if ((iNode = (INode)hashMap.get(list.get(1))) == null) {
                    iNode = net.newNode("" + list.get(1));
                    hashMap.put(list.get(1), iNode);
                }
                int[] nArray = new int[n];
                for (int j = 0; j < n; ++j) {
                    nArray[j] = ((Whole)list.get(j + 2)).intValue();
                }
                net.newEdge(iNode2, iNode, nArray);
                continue;
            }
            if (entryArray[i].key.equals("name")) continue;
            arrayList.add(this.keywordWarning(entryArray[i]));
        }
        if (net == null) {
            throw new DataFormatException("Empty graph");
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            net.addWarning((String)iterator.next());
        }
        return net;
    }

    private static SpaceGroup parseSpaceGroupName(String string) {
        int n = Character.isLowerCase(string.charAt(0)) ? (string.charAt(0) == 'o' ? 1 : 2) : 3;
        List<Operator> list = SpaceGroupCatalogue.operators(n, string);
        if (list == null) {
            return null;
        }
        return new SpaceGroup(n, list, false, false);
    }

    private Net parseSymmetricNet(GenericParser.Entry[] entryArray) {
        Object object;
        Object object2;
        Object object3;
        Operator operator;
        Object object4;
        Object object5;
        Object object6;
        Object object72;
        Object object9;
        Object object10;
        Object object11;
        String string = null;
        int n = 0;
        SpaceGroup spaceGroup = null;
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        LinkedList<EdgeDescriptor> linkedList3 = new LinkedList<EdgeDescriptor>();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < entryArray.length; ++i) {
            object11 = entryArray[i].values;
            object10 = entryArray[i].key;
            if (((String)object10).equals("group")) {
                if (string == null) {
                    if (object11.size() < 1) {
                        throw new DataFormatException("Missing argument at line " + entryArray[i].lineNumber);
                    }
                    string = (String)object11.get(0);
                    spaceGroup = NetParser.parseSpaceGroupName(string);
                    if (spaceGroup == null) {
                        object9 = "Space group \"" + string + "\" not recognized at line ";
                        throw new DataFormatException((String)object9 + entryArray[i].lineNumber);
                    }
                    n = spaceGroup.getDimension();
                    arrayList.addAll(spaceGroup.getOperators());
                    continue;
                }
                throw new DataFormatException("Group specified twice at line " + entryArray[i].lineNumber);
            }
            if (((String)object10).equals("node")) {
                if (object11.size() < 1) {
                    throw new DataFormatException("Missing argument at line " + entryArray[i].lineNumber);
                }
                object9 = object11.get(0);
                if (hashMap.containsKey(object9)) {
                    throw new DataFormatException("Node specified twice at line " + entryArray[i].lineNumber);
                }
                Operator operator2 = NetParser.parseSiteOrOperator((List<Object>)object11, 1);
                object72 = new NodeDescriptor(object9, -1, operator2, false);
                linkedList2.add(object72);
                hashMap.put(object9, object72);
                continue;
            }
            if (((String)object10).equals("edge")) {
                if (object11.size() < 2) {
                    throw new DataFormatException("Not enough arguments at line " + entryArray[i].lineNumber);
                }
                object9 = object11.get(0);
                Object e = object11.get(1);
                object72 = NetParser.parseSiteOrOperator((List<Object>)object11, 2);
                if (!arrayList.contains(((Operator)object72).modZ())) {
                    throw new DataFormatException("Operator not in given group at line " + entryArray[i].lineNumber);
                }
                EdgeDescriptor edgeDescriptor = new EdgeDescriptor(object9, e, (Operator)object72);
                linkedList3.add(edgeDescriptor);
                continue;
            }
            if (((String)object10).equals("name")) continue;
            arrayList2.add(this.keywordWarning(entryArray[i]));
        }
        Set<Operator> set = spaceGroup.primitiveOperators();
        object11 = spaceGroup.transformationToPrimitive();
        object10 = (Operator)((Operator)object11).inverse();
        arrayList.clear();
        for (Operator operator3 : set) {
            arrayList.add(((Operator)((Operator)object10).times(operator3).times(object11)).modZ());
        }
        object9 = new LinkedList();
        for (Object object72 : linkedList2) {
            object9.add(new NodeDescriptor(((NodeDescriptor)object72).name, ((NodeDescriptor)object72).connectivity, ((NodeDescriptor)object72).site.times(object11), ((NodeDescriptor)object72).isEdgeCenter));
        }
        linkedList2.clear();
        linkedList2.addAll((Collection<Object>)object9);
        LinkedList<EdgeDescriptor> linkedList = new LinkedList<EdgeDescriptor>();
        for (EdgeDescriptor edgeDescriptor : linkedList3) {
            linkedList.add(new EdgeDescriptor(edgeDescriptor.source, edgeDescriptor.target, (Operator)((Operator)object10).times(edgeDescriptor.shift).times(object11)));
        }
        linkedList3.clear();
        linkedList3.addAll(linkedList);
        object72 = new Net(n, this.getName(), this.getSpaceGroup());
        HashMap<Pair<Object, Operator>, Object> hashMap2 = new HashMap<Pair<Object, Operator>, Object>();
        HashMap<Object, Vector> hashMap3 = new HashMap<Object, Vector>();
        for (NodeDescriptor nodeDescriptor : linkedList2) {
            object6 = nodeDescriptor.name;
            object5 = (Operator)nodeDescriptor.site;
            object4 = new HashMap();
            for (Operator operator4 : arrayList) {
                operator = (Operator)((Operator)object5).times(operator4);
                object3 = operator.modZ();
                object2 = new Pair<Object, Operator>(object6, operator4);
                if (object4.containsKey(object3)) {
                    object = (INode)object4.get(object3);
                } else {
                    object = ((Net)object72).newNode("" + object6);
                    object4.put(object3, object);
                }
                hashMap2.put((Pair<Object, Operator>)object2, object);
                hashMap3.put(object2, operator.floorZ());
            }
        }
        for (EdgeDescriptor edgeDescriptor : linkedList3) {
            object6 = edgeDescriptor.source;
            object5 = edgeDescriptor.target;
            object4 = edgeDescriptor.shift;
            for (Operator operator4 : arrayList) {
                operator = (Operator)((Operator)object4).times(operator4);
                object3 = new Pair<Object, Operator>(object6, operator4.modZ());
                object = new Pair<Object, Operator>(object5, operator.modZ());
                object2 = (Vector)operator.floorZ().minus(operator4.floorZ());
                INode iNode = (INode)hashMap2.get(object3);
                INode iNode2 = (INode)hashMap2.get(object);
                Vector vector = (Vector)hashMap3.get(object3);
                Vector vector2 = (Vector)hashMap3.get(object);
                Vector vector3 = (Vector)((Vector)object2).plus(vector2.minus(vector));
                if (((PeriodicGraph)object72).getEdge(iNode, iNode2, vector3) != null) continue;
                ((PeriodicGraph)object72).newEdge(iNode, iNode2, vector3);
            }
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ((Net)object72).addWarning((String)iterator.next());
        }
        return object72;
    }

    private static Operator parseSiteOrOperator(List<Object> list, int n) {
        if (list.size() <= n) {
            return Operator.identity(3);
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        for (int i = n; i < list.size(); ++i) {
            stringBuffer.append(' ');
            stringBuffer.append(list.get(i));
        }
        return new Operator(stringBuffer.toString());
    }

    private Net parseCrystal(GenericParser.Entry[] entryArray) {
        Object object;
        Iterator<INode> iterator;
        Object object2;
        Object object3;
        Object object5;
        HashSet<Object> hashSet = new HashSet<Object>();
        String string = null;
        int n = 3;
        SpaceGroup spaceGroup = null;
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        Matrix matrix = null;
        double d = 0.001;
        double d2 = 0.1;
        LinkedList<NodeDescriptor> linkedList = new LinkedList<NodeDescriptor>();
        HashMap<Object, NodeDescriptor> hashMap = new HashMap<Object, NodeDescriptor>();
        LinkedList<EdgeDescriptor> linkedList2 = new LinkedList<EdgeDescriptor>();
        LinkedList<List<Object>> linkedList3 = new LinkedList<List<Object>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < entryArray.length; ++i) {
            int n2;
            List<Object> list = entryArray[i].values;
            object5 = entryArray[i].key;
            int n3 = entryArray[i].lineNumber;
            if (((String)object5).equals("group")) {
                if (hashSet.contains(object5)) {
                    throw new DataFormatException("Group specified twice at line " + n3);
                }
                if (list.size() < 1) {
                    throw new DataFormatException("Missing argument at line " + n3);
                }
                string = (String)list.get(0);
                spaceGroup = NetParser.parseSpaceGroupName(string);
                if (spaceGroup == null) {
                    String string2 = "Space group \"" + string + "\" not recognized at line ";
                    throw new DataFormatException(string2 + n3);
                }
                n = spaceGroup.getDimension();
                string = SpaceGroupCatalogue.listedName(n, string);
                arrayList.addAll(spaceGroup.getOperators());
            } else if (((String)object5).equals("cell")) {
                if (hashSet.contains(object5)) {
                    throw new DataFormatException("Cell specified twice at line " + n3);
                }
                int n4 = n + n * (n - 1) / 2;
                if (list.size() != n4) {
                    String string3 = "Expected " + n4 + " arguments at line ";
                    throw new DataFormatException(string3 + n3);
                }
                for (int j = 0; j < n4; ++j) {
                    if (list.get(i) instanceof Real) continue;
                    throw new DataFormatException("Arguments must be real numbers at line " + n3);
                }
                matrix = NetParser.gramMatrix(n, list);
            } else if (((String)object5).equals("node") || ((String)object5).equals("edge_center")) {
                int n4;
                if (list.size() != n + 2) {
                    String string4 = "Expected " + (n + 2) + " arguments at line ";
                    throw new DataFormatException(string4 + n3);
                }
                Object object6 = list.get(0);
                if (hashMap.containsKey(object6)) {
                    throw new DataFormatException("Node specified twice at line " + n3);
                }
                Object object7 = list.get(1);
                if (!(object7 instanceof Whole) || !((Whole)object7).isNonNegative()) {
                    throw new DataFormatException("Connectivity must be a non-negative integer at line " + n3);
                }
                IArithmetic[] iArithmeticArray = new IArithmetic[n];
                for (n4 = 0; n4 < n; ++n4) {
                    iArithmeticArray[n4] = (IArithmetic)list.get(n4 + 2);
                }
                n4 = Math.max(0, ((Whole)object7).intValue());
                if (((String)object5).equals("node")) {
                    n2 = 0;
                } else {
                    if (n4 != 2) {
                        throw new DataFormatException("Edge center connectivity must be 2" + n3);
                    }
                    n2 = 1;
                }
                object3 = new NodeDescriptor(object6, n4, new Point(iArithmeticArray), n2 != 0);
                linkedList.add((NodeDescriptor)object3);
                hashMap.put(object6, (NodeDescriptor)object3);
            } else if (((String)object5).equals("edge")) {
                Object object8;
                Object object9;
                if (list.size() == 2 * n) {
                    double[] dArray = new double[n];
                    for (int j = 0; j < n; ++j) {
                        dArray[j] = ((Real)list.get(j)).doubleValue();
                    }
                    object9 = new Point(dArray);
                    double[] dArray2 = new double[n];
                    for (n2 = 0; n2 < n; ++n2) {
                        dArray2[n2] = ((Real)list.get(n2 + n)).doubleValue();
                    }
                    object8 = new Point(dArray2);
                } else if (list.size() == n + 1) {
                    object9 = list.get(0);
                    double[] dArray = new double[n];
                    for (int j = 0; j < n; ++j) {
                        dArray[j] = ((Real)list.get(j + 1)).doubleValue();
                    }
                    object8 = new Point(dArray);
                } else if (list.size() == 2) {
                    object9 = list.get(0);
                    object8 = list.get(1);
                } else {
                    String string2 = "Expected 2, " + (n + 1) + " or " + 2 * n + " arguments at line";
                    throw new DataFormatException(string2 + n3);
                }
                EdgeDescriptor edgeDescriptor = new EdgeDescriptor(object9, object8, null);
                linkedList2.add(edgeDescriptor);
            } else if (((String)object5).equals("coordination_sequence")) {
                linkedList3.add(list);
            } else if (!((String)object5).equals("name")) {
                arrayList2.add(this.keywordWarning(entryArray[i]));
            }
            hashSet.add(object5);
        }
        HashMap hashMap2 = new HashMap();
        for (int i = 0; i < linkedList3.size(); ++i) {
            hashMap2.put(((NodeDescriptor)linkedList.get((int)i)).name, linkedList3.get(i));
        }
        if (spaceGroup == null) {
            arrayList2.add("No space group given - assuming P1");
            string = "P1";
            spaceGroup = NetParser.parseSpaceGroupName(string);
            n = spaceGroup.getDimension();
            arrayList.addAll(spaceGroup.getOperators());
        }
        if (matrix == null) {
            if (linkedList2.size() == 0) {
                arrayList2.add("** WARNING! Neither cell parameters nor explicit edges given **");
            } else {
                arrayList2.add("No unit cell parameters given - using defaults");
            }
            matrix = NetParser.defaultGramMatrix(string, n);
        } else if (linkedList2.size() == 0) {
            arrayList2.add("No explicit edges given - using nearest nodes");
        }
        if (NetParser.gramMatrixError(n, spaceGroup, matrix) > 0.01) {
            arrayList2.add("Unit cell parameters illegal for this group");
        }
        Matrix matrix2 = spaceGroup.primitiveCell();
        object5 = spaceGroup.transformationToPrimitive();
        Operator operator = (Operator)((Operator)object5).inverse();
        Set<Operator> set = spaceGroup.primitiveOperators();
        arrayList.clear();
        for (Operator operator2 : set) {
            arrayList.add(((Operator)operator.times(operator2).times(object5)).modZ());
        }
        LinkedList linkedList4 = new LinkedList();
        for (NodeDescriptor nodeDescriptor : linkedList) {
            NodeDescriptor nodeDescriptor2 = new NodeDescriptor(nodeDescriptor.name, nodeDescriptor.connectivity, nodeDescriptor.site.times(object5), nodeDescriptor.isEdgeCenter);
            linkedList4.add(nodeDescriptor2);
            hashMap.put(nodeDescriptor.name, nodeDescriptor2);
        }
        linkedList.clear();
        linkedList.addAll(linkedList4);
        LinkedList<EdgeDescriptor> linkedList5 = new LinkedList<EdgeDescriptor>();
        for (EdgeDescriptor edgeDescriptor : linkedList2) {
            object3 = edgeDescriptor.source instanceof Point ? ((Point)edgeDescriptor.source).times(object5) : edgeDescriptor.source;
            object2 = edgeDescriptor.target instanceof Point ? ((Point)edgeDescriptor.target).times(object5) : edgeDescriptor.target;
            linkedList5.add(new EdgeDescriptor(object3, object2, edgeDescriptor.shift));
        }
        linkedList2.clear();
        linkedList2.addAll(linkedList5);
        if (matrix != null) {
            matrix = ((Matrix)matrix2.times(matrix).times(matrix2.transposed())).symmetric();
        }
        List<Pair<NodeDescriptor, Operator>> list = this.applyOps(arrayList, linkedList, d);
        Net net = new Net(n, this.getName(), this.getSpaceGroup());
        object3 = new HashMap<INode, Pair<NodeDescriptor, Operator>>();
        object2 = list.iterator();
        while (object2.hasNext()) {
            iterator = (Pair)object2.next();
            NodeDescriptor nodeDescriptor = (NodeDescriptor)((Pair)((Object)iterator)).getFirst();
            object = net.newNode("" + nodeDescriptor.name);
            net.setNodeInfo((INode)object, CONNECTIVITY, new Integer(nodeDescriptor.connectivity));
            net.setNodeInfo((INode)object, COORDINATION_SEQUENCE, hashMap2.get(nodeDescriptor.name));
            object3.put((INode)object, iterator);
        }
        object2 = new HashMap();
        for (INode iNode : object3.keySet()) {
            object = (Pair)object3.get(iNode);
            object2.put(iNode, (Point)((NodeDescriptor)((Pair)object).getFirst()).site.times(((Pair)object).getSecond()));
        }
        this.addExplicitEdges(net, linkedList2, arrayList, hashMap, (Map<INode, Point>)object2, operator, d);
        if (linkedList2.size() == 0) {
            this.computeImplicitEdges(net, matrix, (Map<INode, Pair<NodeDescriptor, Operator>>)object3, (Map<INode, Point>)object2, operator, d2);
        }
        this.removeEdgeCenters(net, (Map<INode, Pair<NodeDescriptor, Operator>>)object3);
        for (INode iNode : net.nodes()) {
            net.setNodeInfo(iNode, POSITION, object2.get(iNode));
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            net.addWarning((String)((Object)iterator.next()));
        }
        return net;
    }

    private static Matrix defaultGramMatrix(String string, int n) {
        if (n == 1) {
            return new Matrix(new double[][]{{1.0}});
        }
        if (n == 2) {
            char c = string.charAt(1);
            if (c == '3' || c == '6') {
                return new Matrix(new double[][]{{1.0, -0.5}, {-0.5, 1.0}});
            }
            return new Matrix(new double[][]{{1.0, 0.0}, {0.0, 1.0}});
        }
        if (n == 3) {
            char c = string.charAt(1) == '-' ? string.charAt(2) : string.charAt(1);
            if (!(c != '3' && c != '6' || string.toLowerCase().endsWith(":r"))) {
                return new Matrix(new double[][]{{1.0, -0.5, 0.0}, {-0.5, 1.0, 0.0}, {0.0, 0.0, 1.0}});
            }
            return new Matrix(new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
        }
        throw new RuntimeException("illegal dimension " + n);
    }

    private void computeImplicitEdges(Net net, Matrix matrix, Map<INode, Pair<NodeDescriptor, Operator>> map, Map<INode, Point> map2, Operator operator, double d) {
        Object object;
        Object object2;
        Object object3;
        Pair<INode, Vector> pair;
        Object object4;
        int n;
        Vector[] vectorArray;
        Object object5;
        Object object6;
        ArrayList<Pair<Pair<INode, Vector>, Pair<INode, Object>>> arrayList;
        Object object7;
        Vector[] vectorArray2 = Vector.rowVectors(Matrix.one(net.getDimension()));
        Vector[] vectorArray3 = Lattices.dirichletVectors(vectorArray2, matrix);
        for (INode object82 : map2.keySet()) {
            object7 = map2.get(object82);
            arrayList = Lattices.dirichletShifts((Point)object7, vectorArray3, matrix, 1)[0];
            map2.put(object82, (Point)((Point)object7).plus(arrayList));
            net.shiftNode(object82, (Vector)((Object)arrayList));
        }
        Vector vector = Vector.zero(net.getDimension());
        ArrayList<Pair<INode, Object>> arrayList2 = new ArrayList<Pair<INode, Object>>();
        object7 = new HashMap();
        for (INode iNode : net.nodes()) {
            TaskController.getInstance().bailOutIfCancelled();
            Point point = map2.get(iNode);
            arrayList2.add(new Pair<INode, Object>(iNode, vector));
            object7.put(new Pair<INode, Object>(iNode, vector), point);
            for (int i = 0; i < vectorArray3.length; ++i) {
                object6 = vectorArray3[i];
                object5 = (Point)point.plus(object6);
                vectorArray = Lattices.dirichletShifts((Point)object5, vectorArray3, matrix, 2);
                for (n = 0; n < vectorArray.length; ++n) {
                    object4 = vectorArray[n];
                    pair = new Pair<INode, Vector>(iNode, (Vector)((Vector)object6).plus(object4));
                    arrayList2.add(pair);
                    object7.put(pair, (Point)((Point)object5).plus(object4));
                }
            }
        }
        arrayList = new ArrayList<Pair<Pair<INode, Vector>, Pair<INode, Object>>>();
        for (INode iNode : net.nodes()) {
            TaskController.getInstance().bailOutIfCancelled();
            NodeDescriptor nodeDescriptor = map.get(iNode).getFirst();
            object6 = new Pair<INode, Object>(iNode, vector);
            object5 = map2.get(iNode);
            vectorArray = new ArrayList();
            for (n = 0; n < arrayList2.size(); ++n) {
                TaskController.getInstance().bailOutIfCancelled();
                object4 = (Pair)arrayList2.get(n);
                if (((Pair)object4).equals((Pair<?, ?>)object6)) continue;
                pair = map.get(((Pair)object4).getFirst()).getFirst();
                if (nodeDescriptor.isEdgeCenter && ((NodeDescriptor)((Object)pair)).isEdgeCenter) continue;
                object3 = (Point)object7.get(object4);
                object2 = (Vector)((Point)object3).minus(object5);
                object = ((Vector)object2).getCoordinates();
                IArithmetic iArithmetic = LinearAlgebra.dotRows((Matrix)object, (Matrix)object, matrix);
                vectorArray.add(new Pair<IArithmetic, Integer>(iArithmetic, n));
            }
            Collections.sort(vectorArray, Pair.defaultComparator());
            for (n = 0; n < nodeDescriptor.connectivity; ++n) {
                object4 = (Pair)vectorArray.get(n);
                pair = (IArithmetic)((Pair)object4).getFirst();
                object3 = (Integer)((Pair)object4).getSecond();
                arrayList.add(new Pair<Pair<INode, Vector>, Pair<INode, Object>>(pair, new Pair<INode, Object>(iNode, object3)));
            }
        }
        Collections.sort(arrayList, Pair.firstItemComparator());
        for (Pair pair2 : arrayList) {
            double d2 = ((Real)pair2.getFirst()).doubleValue();
            object5 = (Pair)pair2.getSecond();
            vectorArray = (INode)((Pair)object5).getFirst();
            Pair pair3 = (Pair)arrayList2.get((Integer)((Pair)object5).getSecond());
            object4 = (INode)pair3.getFirst();
            pair = (Vector)pair3.getSecond();
            object3 = map.get(vectorArray).getFirst();
            object2 = map.get(object4).getFirst();
            if (vectorArray.degree() >= ((NodeDescriptor)object3).connectivity && object4.degree() >= ((NodeDescriptor)object2).connectivity) continue;
            if (d2 < d) {
                throw new DataFormatException("Found points closer than minimal edge length of " + d);
            }
            if (net.getEdge((INode)vectorArray, (INode)object4, (Vector)((Object)pair)) == null) {
                net.newEdge((INode)vectorArray, (INode)object4, (Vector)((Object)pair));
            }
            if (vectorArray.degree() > ((NodeDescriptor)object3).connectivity) {
                object = "Found " + vectorArray.degree() + " neighbors for node " + ((NodeDescriptor)object3).name + " (should be " + ((NodeDescriptor)object3).connectivity + ")";
                throw new DataFormatException((String)object);
            }
            if (object4.degree() <= ((NodeDescriptor)object2).connectivity) continue;
            object = "Found " + object4.degree() + " neighbors for node " + ((NodeDescriptor)object2).name + " (should be " + ((NodeDescriptor)object2).connectivity + ")";
            throw new DataFormatException((String)object);
        }
    }

    private void removeEdgeCenters(Net net, Map<INode, Pair<NodeDescriptor, Operator>> map) {
        HashSet<INode> hashSet = new HashSet<INode>();
        for (INode iNode : net.nodes()) {
            if (!map.get((Object)iNode).getFirst().isEdgeCenter) continue;
            hashSet.add(iNode);
        }
        for (INode iNode : hashSet) {
            Vector vector;
            IEdge iEdge;
            INode iNode2;
            List<IEdge> list = net.allIncidences(iNode);
            if (list.size() != 2) {
                throw new DataFormatException("Edge center has connectivity != 2");
            }
            IEdge iEdge2 = list.get(0);
            INode iNode3 = iEdge2.opposite(iNode);
            if (net.getEdge(iNode3, iNode2 = (iEdge = list.get(1)).opposite(iNode), vector = (Vector)net.getShift(iEdge).minus(net.getShift(iEdge2))) != null) {
                throw new DataFormatException("duplicate edge");
            }
            if (iNode3.equals(iNode2) && vector.equals(vector.zero())) {
                throw new DataFormatException("trivial loop");
            }
            net.newEdge(iNode3, iNode2, vector);
            net.delete(iEdge2);
            net.delete(iEdge);
            net.delete(iNode);
        }
    }

    private String format(Point point) {
        String string = "";
        for (int i = 0; i < point.getDimension(); ++i) {
            if (i > 0) {
                string = string + " ";
            }
            string = string + fmtReal4.format(((Real)point.get(i)).doubleValue());
        }
        return string;
    }

    private void addExplicitEdges(Net net, List<EdgeDescriptor> list, List<Operator> list2, Map<Object, NodeDescriptor> map, Map<INode, Point> map2, Operator operator, double d) {
        for (EdgeDescriptor edgeDescriptor : list) {
            Point point = edgeDescriptor.source instanceof Point ? (Point)edgeDescriptor.source : (Point)map.get((Object)edgeDescriptor.source).site;
            Point point2 = edgeDescriptor.target instanceof Point ? (Point)edgeDescriptor.target : (Point)map.get((Object)edgeDescriptor.target).site;
            for (Operator operator2 : list2) {
                Operator operator3 = operator2.modZ();
                Point point3 = (Point)point.times(operator3);
                Point point4 = (Point)point2.times(operator3);
                Pair<INode, Vector> pair = NetParser.lookup(point3, map2, d);
                Pair<INode, Vector> pair2 = NetParser.lookup(point4, map2, d);
                if (pair == null) {
                    throw new DataFormatException("no point at " + this.format((Point)point3.times(operator)));
                }
                if (pair2 == null) {
                    throw new DataFormatException("no point at " + this.format((Point)point4.times(operator)));
                }
                INode iNode = pair.getFirst();
                INode iNode2 = pair2.getFirst();
                Vector vector = pair.getSecond();
                Vector vector2 = pair2.getSecond();
                Vector vector3 = (Vector)vector2.minus(vector);
                if (net.getEdge(iNode, iNode2, vector3) != null) continue;
                net.newEdge(iNode, iNode2, vector3);
            }
        }
    }

    private List<Pair<NodeDescriptor, Operator>> applyOps(List<Operator> list, List<NodeDescriptor> list2, double d) {
        LinkedList<Pair<NodeDescriptor, Operator>> linkedList = new LinkedList<Pair<NodeDescriptor, Operator>>();
        for (NodeDescriptor nodeDescriptor : list2) {
            Point point = (Point)nodeDescriptor.site;
            Set<Operator> set = NetParser.pointStabilizer(point, list, d);
            HashSet<Operator> hashSet = new HashSet<Operator>();
            for (Operator operator : list) {
                Operator operator2 = operator.modZ();
                if (hashSet.contains(operator2)) continue;
                linkedList.add(new Pair<NodeDescriptor, Operator>(nodeDescriptor, operator2));
                for (Operator operator3 : set) {
                    Operator operator4 = ((Operator)operator3.times(operator2)).modZ();
                    hashSet.add(operator4);
                }
            }
        }
        return linkedList;
    }

    private static double gramMatrixError(int n, SpaceGroup spaceGroup, Matrix matrix) {
        double[] dArray = new double[n * (n + 1) / 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                dArray[n2] = ((Real)matrix.get(i, j)).doubleValue();
                ++n2;
            }
        }
        Matrix matrix2 = spaceGroup.configurationSpaceForGramMatrix();
        Matrix matrix3 = new Matrix(new double[][]{dArray});
        Matrix matrix4 = LinearAlgebra.solutionInRows(matrix2, matrix3, false);
        if (matrix4 == null) {
            return 1.0;
        }
        Matrix matrix5 = (Matrix)((Matrix)matrix4.times(matrix2)).minus(matrix3);
        return ((Real)matrix5.norm()).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    private static FaceListDescriptor parseFaceList(GenericParser.Entry[] entryArray) {
        Object object;
        Comparable<Face> comparable;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object7;
        Object object8;
        HashSet<Object> hashSet = new HashSet<Object>();
        String string = null;
        int n3 = 3;
        SpaceGroup spaceGroup = null;
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        Matrix matrix = null;
        double d = 0.001;
        boolean bl = false;
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Point[]> arrayList3 = new ArrayList<Point[]>();
        IArithmetic[] iArithmeticArray = null;
        int n4 = 0;
        ArrayList<String> arrayList4 = new ArrayList<String>();
        for (int i = 0; i < entryArray.length; ++i) {
            int n5;
            object8 = entryArray[i].values;
            object7 = entryArray[i].key;
            int n6 = entryArray[i].lineNumber;
            if (((String)object7).equals("group")) {
                if (hashSet.contains(object7)) {
                    throw new DataFormatException("Group specified twice at line " + n6);
                }
                if (object8.size() < 1) {
                    throw new DataFormatException("Missing argument at line " + n6);
                }
                string = (String)object8.get(0);
                spaceGroup = NetParser.parseSpaceGroupName(string);
                if (spaceGroup == null) {
                    String string2 = "Space group \"" + string + "\" not recognized at line ";
                    throw new DataFormatException(string2 + n6);
                }
                n3 = spaceGroup.getDimension();
                string = SpaceGroupCatalogue.listedName(n3, string);
                arrayList.addAll(spaceGroup.getOperators());
            } else if (((String)object7).equals("cell")) {
                void e;
                if (hashSet.contains(object7)) {
                    throw new DataFormatException("Cell specified twice at line " + n6);
                }
                n5 = n3 + n3 * (n3 - 1) / 2;
                if (object8.size() != n5) {
                    String string3 = "Expected " + n5 + " arguments at line ";
                    throw new DataFormatException(string3 + n6);
                }
                boolean j = false;
                while (e < n5) {
                    if (!(object8.get(i) instanceof Real)) {
                        throw new DataFormatException("Arguments must be real numbers at line " + n6);
                    }
                    ++e;
                }
                matrix = NetParser.gramMatrix(n3, (List<Object>)object8);
            } else if (((String)object7).equals("face")) {
                for (n5 = 0; n5 < object8.size(); ++n5) {
                    int string5;
                    Object operator = object8.get(n5);
                    if (iArithmeticArray == null) {
                        if (operator instanceof Whole) {
                            string5 = ((Whole)operator).intValue();
                            iArithmeticArray = new IArithmetic[string5 * n3];
                            n4 = 0;
                            continue;
                        }
                        String string2 = "face size expected at line ";
                        throw new DataFormatException(string2 + n6);
                    }
                    if (operator instanceof IArithmetic) {
                        iArithmeticArray[n4++] = (IArithmetic)operator;
                        if (n4 != iArithmeticArray.length) continue;
                        string5 = iArithmeticArray.length / n3;
                        Point[] pointArray = new Point[string5];
                        int n = 0;
                        for (int j = 0; j < string5; ++j) {
                            object5 = new IArithmetic[n3];
                            for (int k = 0; k < n3; ++k) {
                                object5[k] = iArithmeticArray[n++];
                            }
                            pointArray[j] = new Point((IArithmetic[])object5);
                        }
                        arrayList3.add(pointArray);
                        iArithmeticArray = null;
                        continue;
                    }
                    String list = "coordinate expected at line ";
                    throw new DataFormatException(list + n6);
                }
            } else if (((String)object7).equals("tile")) {
                bl = true;
                if (arrayList3.size() > 0) {
                    arrayList2.add(arrayList3);
                }
                arrayList3 = new ArrayList();
            }
            hashSet.add(object7);
        }
        if (arrayList3.size() > 0) {
            arrayList2.add(arrayList3);
        }
        if (spaceGroup == null) {
            arrayList4.add("No space group given - assuming P1");
            string = "P1";
            spaceGroup = NetParser.parseSpaceGroupName(string);
            n3 = spaceGroup.getDimension();
            arrayList.addAll(spaceGroup.getOperators());
        }
        if (matrix != null && NetParser.gramMatrixError(n3, spaceGroup, matrix) > 0.01) {
            arrayList4.add("Unit cell parameters illegal for this group");
        }
        Matrix matrix2 = spaceGroup.primitiveCell();
        object8 = spaceGroup.transformationToPrimitive();
        object7 = (Operator)((Operator)object8).inverse();
        Set<Operator> set = spaceGroup.primitiveOperators();
        arrayList.clear();
        for (Operator list : set) {
            arrayList.add(((Operator)((Operator)object7).times(list).times(object8)).modZ());
        }
        for (List hashMap2 : arrayList2) {
            for (int hashSet2 = 0; hashSet2 < hashMap2.size(); ++hashSet2) {
                Point[] pointArray = (Point[])hashMap2.get(hashSet2);
                Point[] pointArray2 = new Point[pointArray.length];
                for (int i = 0; i < pointArray.length; ++i) {
                    pointArray2[i] = (Point)pointArray[i].times(object8);
                }
                hashMap2.set(hashSet2, pointArray2);
            }
        }
        if (matrix != null) {
            matrix = ((Matrix)matrix2.times(matrix).times(matrix2.transposed())).symmetric();
        }
        HashMap hashMap = new HashMap();
        for (List list : arrayList2) {
            for (Point[] pointArray : list) {
                for (int i = 0; i < pointArray.length; ++i) {
                    object5 = pointArray[i];
                    if (NetParser.lookup((Point)object5, hashMap, d) != null) continue;
                    Set<Operator> set2 = NetParser.pointStabilizer((Point)object5, arrayList, d);
                    object4 = new HashSet();
                    for (Operator operator : arrayList) {
                        Point[] pointArray3 = operator.modZ();
                        if (object4.contains(pointArray3)) continue;
                        Point point = (Point)((Point)object5).times(pointArray3);
                        hashMap.put(hashMap.size(), point);
                        object3 = set2.iterator();
                        while (object3.hasNext()) {
                            object2 = (Operator)object3.next();
                            comparable = (Operator)((Operator)object2).times(pointArray3);
                            object = ((Operator)comparable).modZ();
                            object4.add(object);
                        }
                    }
                }
            }
        }
        HashMap<Pair<Operator, Integer>, Pair<Integer, Vector>> hashMap2 = new HashMap<Pair<Operator, Integer>, Pair<Integer, Vector>>();
        for (Operator operator : arrayList) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                object5 = (Point)((Point)hashMap.get(n)).times(operator);
                hashMap2.put(new Pair<Operator, Integer>(operator, n), NetParser.lookup((Point)object5, hashMap, d));
            }
        }
        HashSet<Object> hashSet2 = new HashSet<Object>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        for (List list : arrayList2) {
            for (Operator operator : arrayList) {
                List<Pair<Face, Vector>> list2;
                object4 = operator.modZ();
                ArrayList arrayList6 = new ArrayList();
                for (Point[] pointArray3 : list) {
                    int n = pointArray3.length;
                    object3 = new int[n];
                    object2 = new Vector[n];
                    for (int i = 0; i < n; ++i) {
                        object = NetParser.lookup((Point)pointArray3[i].times(object4), hashMap, d);
                        object3[i] = (Integer)((Pair)object).getFirst();
                        object2[i] = (Vector)((Pair)object).getSecond();
                    }
                    comparable = new Face((int[])object3, (Vector[])object2);
                    object = NetParser.normalizedFace((Face)comparable);
                    if (bl) {
                        arrayList6.add(object);
                        continue;
                    }
                    Face face = ((Pair)object).getFirst();
                    if (hashSet2.contains(face)) continue;
                    arrayList5.add(face);
                    hashSet2.add(face);
                }
                if (!bl || hashSet2.contains(list2 = NetParser.normalizedTile(arrayList6))) continue;
                arrayList5.add(list2);
                hashSet2.add(list2);
            }
        }
        return new FaceListDescriptor(arrayList5, hashMap, arrayList, hashMap2, matrix);
    }

    public static FaceListDescriptor parseFaceList(GenericParser.Block block) {
        return NetParser.parseFaceList(block.getEntries());
    }

    public static Pair<Face, Vector> normalizedFace(Face face) {
        int n = face.size();
        Face face2 = null;
        Vector vector = null;
        for (int i = 0; i < n; ++i) {
            Vector vector2;
            int n2;
            int n3;
            int n4;
            Vector vector3 = face.shift(i);
            int[] nArray = new int[n];
            Vector[] vectorArray = new Vector[n];
            for (n4 = 0; n4 < n; ++n4) {
                n3 = (i + n4) % n;
                n2 = face.vertex(n3);
                vector2 = face.shift(n3);
                nArray[n4] = n2;
                vectorArray[n4] = (Vector)vector2.minus(vector3);
            }
            Face face3 = new Face(nArray, vectorArray);
            for (n4 = 0; n4 <= 1; ++n4) {
                if (face2 == null || face2.compareTo(face3) > 0) {
                    face2 = face3;
                    vector = vector3;
                }
                for (n3 = 1; n3 < (n + 1) / 2; ++n3) {
                    n2 = nArray[n3];
                    nArray[n3] = nArray[n - n3];
                    nArray[n - n3] = n2;
                    vector2 = vectorArray[n3];
                    vectorArray[n3] = vectorArray[n - n3];
                    vectorArray[n - n3] = vector2;
                }
                face3 = new Face(nArray, vectorArray);
            }
        }
        return new Pair<Object, Object>(face2, vector);
    }

    private static List<Pair<Face, Vector>> normalizedTile(List<Pair<Face, Vector>> list) {
        Comparator comparator = Pair.defaultComparator();
        Comparator comparator2 = NiftyList.lexicographicComparator(comparator);
        ArrayList<Pair<Face, Vector>> arrayList = null;
        for (int i = 0; i < list.size(); ++i) {
            Vector vector = list.get(i).getSecond();
            ArrayList<Pair<Face, Vector>> arrayList2 = new ArrayList<Pair<Face, Vector>>();
            for (Pair<Face, Vector> pair : list) {
                Face face = pair.getFirst();
                Vector vector2 = pair.getSecond();
                arrayList2.add(new Pair<Face, Vector>(face, (Vector)vector2.minus(vector)));
            }
            Collections.sort(arrayList2, comparator);
            if (arrayList != null && comparator2.compare(arrayList, arrayList2) >= 0) continue;
            arrayList = arrayList2;
        }
        return arrayList;
    }

    private static <K> Pair<K, Vector> lookup(Point point, Map<K, Point> map, double d) {
        int n = point.getDimension();
        for (K k : map.keySet()) {
            Point point2 = map.get(k);
            if (!(NetParser.distModZ(point, point2) <= d)) continue;
            Vector vector = (Vector)point.minus(point2);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                double d2 = ((Real)vector.get(i)).doubleValue();
                nArray[i] = (int)Math.round(d2);
            }
            return new Pair<K, Vector>(k, new Vector(nArray));
        }
        return null;
    }

    private static Matrix gramMatrix(int n, List<Object> list) {
        if (n == 2) {
            Real real = (Real)list.get(0);
            Real real2 = (Real)list.get(1);
            Real real3 = (Real)list.get(2);
            Real real4 = (Real)NetParser.cosine(real3).times(real).times(real2);
            return new Matrix(new IArithmetic[][]{{real.raisedTo(2L), real4}, {real4, real2.raisedTo(2L)}});
        }
        if (n == 3) {
            Real real = (Real)list.get(0);
            Real real5 = (Real)list.get(1);
            Real real6 = (Real)list.get(2);
            Real real7 = (Real)list.get(3);
            Real real8 = (Real)list.get(4);
            Real real9 = (Real)list.get(5);
            Real real10 = (Real)NetParser.cosine(real7).times(real5).times(real6);
            Real real11 = (Real)NetParser.cosine(real8).times(real).times(real6);
            Real real12 = (Real)NetParser.cosine(real9).times(real).times(real5);
            return new Matrix(new IArithmetic[][]{{real.raisedTo(2L), real12, real11}, {real12, real5.raisedTo(2L), real10}, {real11, real10, real6.raisedTo(2L)}});
        }
        throw new DataFormatException("supporting only dimensions 2 and 3");
    }

    private static Real cosine(Real real) {
        return new FloatingPoint(Math.cos(real.doubleValue() * (Math.PI / 180)));
    }

    private static Set<Operator> pointStabilizer(Point point, List<Operator> list, double d) {
        HashSet<Operator> hashSet = new HashSet<Operator>();
        for (Operator operator : list) {
            double d2 = NetParser.distModZ(point, (Point)point.times(operator));
            if (!(d2 <= d)) continue;
            hashSet.add(operator.modZ());
        }
        if (!NetParser.formGroup(hashSet)) {
            throw new RuntimeException("precision problem in stabilizer computation");
        }
        return hashSet;
    }

    private static double distModZ(Point point, Point point2) {
        int n = point.getDimension();
        Vector vector = (Vector)point.minus(point2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = ((Real)vector.get(i).mod(Whole.ONE)).doubleValue();
            d = Math.max(d, Math.min(d2, 1.0 - d2));
        }
        return d;
    }

    static final boolean formGroup(Collection<Operator> collection) {
        for (Operator operator : collection) {
            for (Operator operator2 : collection) {
                Operator operator3 = ((Operator)operator.times(operator2.inverse())).modZ();
                if (collection.contains(operator3)) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        NetParser netParser = new NetParser(new StringReader("TILING\n  GROUP P432\n  FACE 4 0 0 0 1 0 0 1 1 0 0 1 0\nEND\n"));
        GenericParser.Block block = netParser.parseDataBlock();
        System.out.println(NetParser.parseFaceList(block));
    }

    public static class Face
    implements Comparable<Face> {
        private final int size;
        private final int[] vertices;
        private final Vector[] shifts;

        public Face(int[] nArray, Vector[] vectorArray) {
            if (nArray.length != vectorArray.length) {
                throw new RuntimeException("lengths do not match");
            }
            this.vertices = (int[])nArray.clone();
            this.shifts = (Vector[])vectorArray.clone();
            this.size = vectorArray.length;
        }

        public int vertex(int n) {
            return this.vertices[n];
        }

        public Vector shift(int n) {
            return this.shifts[n];
        }

        public int size() {
            return this.size;
        }

        public int hashCode() {
            int n = 0;
            for (int i = 0; i < this.size(); ++i) {
                n = (n * 37 + this.vertex(i)) * 127 + this.shift(i).hashCode();
            }
            return n;
        }

        @Override
        public int compareTo(Face face) {
            int n = 0;
            for (int i = 0; i < this.size(); ++i) {
                n = this.vertex(i) - face.vertex(i);
                if (n != 0) {
                    return n;
                }
                n = this.shift(i).compareTo(face.shift(i));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof Face) {
                return this.compareTo((Face)object) == 0;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append('-');
                }
                stringBuffer.append('(');
                stringBuffer.append(this.vertex(i));
                stringBuffer.append(',');
                stringBuffer.append(this.shift(i).toString().replaceFirst("Vector", ""));
                stringBuffer.append(')');
            }
            return stringBuffer.toString();
        }
    }

    public static class FaceListDescriptor {
        public final List<Object> faceLists;
        public final Map<Integer, Point> indexToPosition;
        public final List<Operator> symmetries;
        public final Matrix cellGramMatrix;
        public final Map<Pair<Operator, Integer>, Pair<Integer, Vector>> actions;

        public FaceListDescriptor(List<Object> list, Map<Integer, Point> map, List<Operator> list2, Map<Pair<Operator, Integer>, Pair<Integer, Vector>> map2, Matrix matrix) {
            this.faceLists = list;
            this.indexToPosition = map;
            this.symmetries = list2;
            this.actions = map2;
            this.cellGramMatrix = matrix;
        }

        public String toString() {
            return "FaceListDescriptor(" + this.faceLists + ", " + this.indexToPosition + ", " + this.symmetries + ", " + this.cellGramMatrix + ")";
        }
    }

    private static class EdgeDescriptor {
        public final Object source;
        public final Object target;
        public final Operator shift;

        public EdgeDescriptor(Object object, Object object2, Operator operator) {
            this.source = object;
            this.target = object2;
            this.shift = operator;
        }

        public String toString() {
            return "Edge(" + this.source + ", " + this.target + ", " + this.shift + ")";
        }
    }

    private static class NodeDescriptor {
        public final Object name;
        public final int connectivity;
        public final IArithmetic site;
        public boolean isEdgeCenter;

        public NodeDescriptor(Object object, int n, IArithmetic iArithmetic, boolean bl) {
            this.name = object;
            this.connectivity = n;
            this.site = iArithmetic;
            this.isEdgeCenter = bl;
        }

        public String toString() {
            if (this.isEdgeCenter) {
                return "EdgeCenter(" + this.name + ", " + this.connectivity + ", " + this.site + ")";
            }
            return "Node(" + this.name + ", " + this.connectivity + ", " + this.site + ")";
        }
    }

    public static class InfoType
    extends NamedConstant {
        private InfoType(String string) {
            super(string);
        }
    }
}

