/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.simple.DataFormatException;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public class GenericParser {
    private BufferedReader input;
    protected Map<String, String> synonyms;
    protected String defaultKey;
    private int lineno;
    private LinkedList<String> bufferedLine = null;
    private Block block;

    public GenericParser(BufferedReader bufferedReader) {
        this.input = bufferedReader;
        this.lineno = 0;
        this.synonyms = null;
        this.defaultKey = null;
    }

    public GenericParser(Reader reader) {
        this(new BufferedReader(reader));
    }

    private LinkedList<String> nextLineChopped() {
        String string;
        String string2;
        if (this.bufferedLine != null) {
            LinkedList<String> linkedList = this.bufferedLine;
            this.bufferedLine = null;
            return linkedList;
        }
        do {
            try {
                string = this.input.readLine();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (string == null) {
                return null;
            }
            ++this.lineno;
        } while ((string2 = string.trim()).length() == 0 || string2.charAt(0) == '#');
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = 0;
        while (n < string2.length()) {
            char c;
            int n2;
            while (n < string2.length() && Character.isWhitespace(string2.charAt(n))) {
                ++n;
            }
            if (n >= string2.length()) break;
            if (string2.charAt(n) == '\"') {
                ++n2;
                while (n2 < string2.length() - 1 && string2.charAt(n2) != '\"') {
                    ++n2;
                }
                if (string2.charAt(n2) != '\"') {
                    throw new DataFormatException("no closing quotes at line " + this.lineno);
                }
                if (++n2 < string2.length() && !Character.isWhitespace(c = string2.charAt(n2)) && c != '#') {
                    String string3 = "missing space after string at line ";
                    throw new DataFormatException(string3 + this.lineno);
                }
            } else {
                for (n2 = n; n2 < string2.length() && !Character.isWhitespace(c = string2.charAt(n2)) && c != '#'; ++n2) {
                }
            }
            if (n2 > n) {
                linkedList.add(string2.substring(n, n2));
            }
            if ((n = n2) >= string2.length() || string2.charAt(n) != '#') continue;
            break;
        }
        return linkedList;
    }

    public Block parseDataBlock() {
        Entry[] entryArray;
        HashMap<String, List<Entry>> hashMap;
        LinkedList<Object> linkedList;
        String string;
        block20: {
            LinkedList<String> linkedList2 = this.nextLineChopped();
            if (linkedList2 == null) {
                return null;
            }
            string = linkedList2.getFirst().toLowerCase();
            linkedList = new LinkedList<Object>();
            hashMap = new HashMap<String, List<Entry>>();
            String string2 = this.defaultKey;
            String string3 = this.defaultKey;
            while (true) {
                if ((entryArray = this.nextLineChopped()) == null) {
                    throw new DataFormatException("end of file while reading block");
                }
                String string4 = entryArray.getFirst();
                if (Character.isLetter(string4.charAt(0))) {
                    if (string4.equalsIgnoreCase("END")) break block20;
                    string3 = string2 = string4.toLowerCase();
                    if (this.synonyms != null) {
                        while (this.synonyms.containsKey(string3)) {
                            string3 = this.synonyms.get(string3);
                        }
                    }
                    entryArray.removeFirst();
                }
                LinkedList<Object> linkedList3 = new LinkedList<Object>();
                for (String string5 : entryArray) {
                    char c = string5.charAt(0);
                    if (c == '\"') {
                        linkedList3.add(string5.substring(1, string5.length() - 1));
                        continue;
                    }
                    if (Character.isDigit(c) || "+-.".indexOf(c) >= 0) {
                        Real real = null;
                        if (string5.indexOf(47) > 0) {
                            String[] stringArray = string5.split("/");
                            if (stringArray.length == 2) {
                                try {
                                    int n = Integer.parseInt(stringArray[0]);
                                    int n2 = Integer.parseInt(stringArray[1]);
                                    real = new Fraction((long)n, (long)n2);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                        } else {
                            try {
                                real = string5.startsWith("+") ? new Whole(Integer.parseInt(string5.substring(1))) : new Whole(Integer.parseInt(string5));
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    real = new FloatingPoint(Double.parseDouble(string5));
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    // empty catch block
                                }
                            }
                        }
                        if (real != null) {
                            linkedList3.add(real);
                            continue;
                        }
                        linkedList3.add(string5);
                        continue;
                    }
                    linkedList3.add(string5);
                }
                if (string3 == null) break;
                if (linkedList3.size() <= 0) continue;
                Entry entry = new Entry(this.lineno, string2, string3, linkedList3);
                linkedList.add(entry);
                if (!hashMap.containsKey(string3)) {
                    hashMap.put(string3, new LinkedList());
                }
                ((List)hashMap.get(string3)).add(entry);
            }
            throw new DataFormatException("keyless data found at line " + this.lineno);
        }
        entryArray = new Entry[linkedList.size()];
        linkedList.toArray(entryArray);
        this.block = new Block(string, entryArray, hashMap);
        return this.block;
    }

    public String getDataType() {
        return this.block.getType();
    }

    public int getLineNumber() {
        return this.lineno;
    }

    public Map<String, String> getSynonyms() {
        return this.synonyms;
    }

    public void setSynonyms(Map<String, String> map) {
        this.synonyms = map;
    }

    public String getDefaultKey() {
        return this.defaultKey;
    }

    public void setDefaultKey(String string) {
        this.defaultKey = string;
    }

    public boolean atEnd() {
        this.bufferedLine = this.nextLineChopped();
        return this.bufferedLine == null;
    }

    public class Block {
        private final String type;
        private final Entry[] entries;
        private final Map<String, List<Entry>> byKey;

        public Block(String string, Entry[] entryArray, Map<String, List<Entry>> map) {
            this.type = string;
            this.entries = entryArray;
            this.byKey = map;
        }

        public Map<String, List<Entry>> getByKey() {
            return this.byKey;
        }

        public Entry[] getEntries() {
            return this.entries;
        }

        public String getType() {
            return this.type;
        }

        public List<Entry> getEntries(String string) {
            List<Entry> list = this.getByKey().get(string);
            if (list == null) {
                return null;
            }
            return Collections.unmodifiableList(list);
        }

        public String getEntriesAsString(String string) {
            List<Entry> list = this.getEntries(string);
            if (list == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(20);
            for (int i = 0; i < list.size(); ++i) {
                Entry entry = list.get(i);
                List<Object> list2 = entry.values;
                if (i > 0) {
                    stringBuffer.append("; ");
                }
                for (int j = 0; j < list2.size(); ++j) {
                    if (j > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(String.valueOf(list2.get(j)));
                }
            }
            return stringBuffer.toString();
        }

        public Set<String> getKeys() {
            return this.getByKey().keySet();
        }
    }

    public class Entry {
        public final int lineNumber;
        public final String originalKey;
        public final String key;
        public final List<Object> values;

        public Entry(int n, String string, String string2, List<Object> list) {
            this.lineNumber = n;
            this.originalKey = string;
            this.key = string2;
            this.values = list;
        }
    }
}

