/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.embed;

import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.simple.Strings;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.joss.geometry.CellCorrection;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Lattices;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroupFinder;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.Cover;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.pgraphs.embed.Embedder;

public class ProcessedNet {
    private static final DecimalFormat fmtReal4 = new DecimalFormat("0.0000");
    private static final DecimalFormat fmtReal5 = new DecimalFormat("0.00000");
    static final boolean DEBUG = false;
    private boolean verified = false;
    private final PeriodicGraph graph;
    private final String name;
    private final Map<INode, String> node2name;
    private final SpaceGroupFinder finder;
    private final Embedder embedder;

    public ProcessedNet(PeriodicGraph periodicGraph, String string, Map<INode, String> map, SpaceGroupFinder spaceGroupFinder, Embedder embedder) {
        this.graph = periodicGraph;
        this.name = string;
        this.node2name = map;
        this.finder = spaceGroupFinder;
        this.embedder = embedder;
    }

    /*
     * WARNING - void declaration
     */
    public void writeEmbedding(Writer writer, boolean bl, boolean bl2, String string) {
        int n;
        Object object;
        Pair<PlacedNode, PlacedNode> pair2;
        List<Pair<PlacedNode, PlacedNode>> list;
        Object object2;
        PrintWriter printWriter = new PrintWriter(writer);
        int n2 = this.graph.getDimension();
        CoordinateChange coordinateChange = this.finder.getToStd();
        Matrix matrix = this.embedder.getGramMatrix();
        CoordinateChange coordinateChange2 = this.processCellParameters(printWriter, bl, bl2);
        Cover cover = this.graph.conventionalCellCover();
        Map<INode, Point> map = this.embedder.getPositions();
        INode iNode = cover.nodes().next();
        Vector vector = (Vector)map.get(cover.image(iNode)).times(coordinateChange).minus(cover.liftedPosition(iNode, map));
        HashMap<INode, Point> hashMap = new HashMap<INode, Point>();
        for (INode object3 : cover.nodes()) {
            hashMap.put(object3, (Point)cover.liftedPosition(object3, map).plus(vector).times(coordinateChange2));
        }
        Vector[] vectorArray = this.graph.getSpaceGroup().shiftSpace();
        if (vectorArray.length > 0) {
            void bl3;
            boolean i = false;
            while (bl3 < vectorArray.length) {
                vectorArray[bl3] = (Vector)vectorArray[bl3].times(coordinateChange).times(coordinateChange2);
                ++bl3;
            }
            Matrix matrix2 = Vector.toMatrix(vectorArray);
            object2 = Operator.orthogonalProjection(matrix2, Matrix.one(n2));
            INode iNode2 = (INode)hashMap.keySet().iterator().next();
            list = (Point)hashMap.get(iNode2);
            Vector vector2 = (Vector)Point.origin(n2).minus(((Point)((Object)list)).times(object2));
            pair2 = new CoordinateChange(new Operator(vector2));
            for (INode iNode3 : hashMap.keySet()) {
                hashMap.put(iNode3, (Point)((Point)hashMap.get(iNode3)).times(pair2));
            }
            coordinateChange2 = (CoordinateChange)coordinateChange2.times(pair2);
        }
        boolean bl3 = bl2;
        object2 = this.nodeReps(cover, hashMap, bl3);
        if (!bl) {
            printWriter.println("   " + string + " positions:");
        }
        int n3 = 0;
        for (INode iNode4 : object2.keySet()) {
            pair2 = (Point)object2.get(iNode4);
            object = bl3 ? "" + ++n3 : Strings.parsable(this.node2name.get(cover.image(iNode4)), false);
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder().append("  NODE ").append((String)object).append(" ");
                Cover cover2 = cover;
                cover2.getClass();
                printWriter.print(stringBuilder.append(new PeriodicGraph.CoverNode(cover2, iNode4).degree()).append(" ").toString());
            } else {
                printWriter.print("      Node " + object + ":   ");
            }
            for (int i = 0; i < n2; ++i) {
                printWriter.print(" " + fmtReal5.format(((Real)((Point)((Object)pair2)).get(i)).doubleValue()));
            }
            printWriter.println();
        }
        if (!bl) {
            printWriter.println("   Edges:");
        }
        list = this.edgeReps(cover, (Map<INode, Point>)object2, hashMap, coordinateChange2, bl2);
        for (Pair<PlacedNode, PlacedNode> pair2 : list) {
            object = ((PlacedNode)pair2.getFirst()).p;
            Point point = ((PlacedNode)pair2.getSecond()).p;
            if (bl) {
                printWriter.print("  EDGE ");
            } else {
                printWriter.print("     ");
            }
            for (n = 0; n < n2; ++n) {
                printWriter.print(" " + fmtReal5.format(((Real)((Point)object).get(n)).doubleValue()));
            }
            if (bl) {
                printWriter.print("  ");
            } else {
                printWriter.print("  <-> ");
            }
            for (n = 0; n < n2; ++n) {
                printWriter.print(" " + fmtReal5.format(((Real)point.get(n)).doubleValue()));
            }
            printWriter.println();
        }
        if (!bl) {
            printWriter.println("   Edge centers:");
        }
        for (Pair<PlacedNode, PlacedNode> pair2 : list) {
            object = pair2.getFirst().p;
            Point point = pair2.getSecond().p;
            if (bl) {
                printWriter.print("# EDGE_CENTER ");
            } else {
                printWriter.print("     ");
            }
            for (n = 0; n < n2; ++n) {
                double d = ((Real)((Point)object).get(n)).doubleValue();
                double d2 = ((Real)point.get(n)).doubleValue();
                printWriter.print(" " + fmtReal5.format((d + d2) / 2.0));
            }
            printWriter.println();
        }
        if (bl) {
            printWriter.println("END");
            printWriter.println();
        } else {
            this.writeStatistics(printWriter, matrix, map);
        }
        printWriter.flush();
    }

    private void writeStatistics(PrintWriter printWriter, Matrix matrix, Map<INode, Point> map) {
        String string = fmtReal5.format(this.embedder.minimalEdgeLength());
        String string2 = fmtReal5.format(this.embedder.maximalEdgeLength());
        String string3 = fmtReal5.format(this.embedder.averageEdgeLength());
        printWriter.println();
        printWriter.println("   Edge statistics: minimum = " + string + ", maximum = " + string2 + ", average = " + string3);
        double d = Double.MAX_VALUE;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        for (INode iNode : this.graph.nodes()) {
            Object object;
            Point point = map.get(iNode);
            List<IEdge> list = this.graph.allIncidences(iNode);
            ArrayList<Vector> arrayList = new ArrayList<Vector>();
            for (IEdge iEdge : list) {
                object = iEdge.target();
                Point point2 = map.get(object);
                arrayList.add((Vector)point2.plus(this.graph.getShift(iEdge)).minus(point));
            }
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                object = (Vector)arrayList.get(i);
                double d4 = ((Real)Vector.dot((Vector)object, (Vector)object, matrix)).sqrt().doubleValue();
                for (int j = i + 1; j < n2; ++j) {
                    Vector vector = (Vector)arrayList.get(j);
                    double d5 = ((Real)Vector.dot(vector, vector, matrix)).sqrt().doubleValue();
                    double d6 = ((Real)Vector.dot((Vector)object, vector, matrix)).doubleValue();
                    double d7 = Math.max(-1.0, Math.min(1.0, d6 / (d4 * d5)));
                    double d8 = Math.acos(d7) / Math.PI * 180.0;
                    d = Math.min(d, d8);
                    d2 = Math.max(d2, d8);
                    d3 += d8;
                    ++n;
                }
            }
        }
        printWriter.println("   Angle statistics: minimum = " + fmtReal5.format(d) + ", maximum = " + fmtReal5.format(d2) + ", average = " + fmtReal5.format(d3 / (double)n));
        printWriter.flush();
        double d9 = this.smallestNonBondedDistance(this.graph, map, matrix);
        if (d9 < 0.0) {
            printWriter.println("   Shortest non-bonded distance not determined.");
        } else {
            printWriter.println("   Shortest non-bonded distance = " + fmtReal5.format(d9));
        }
        if (this.embedder instanceof Embedder) {
            printWriter.println();
            printWriter.println("   Degrees of freedom: " + this.embedder.degreesOfFreedom());
        }
    }

    private CoordinateChange processCellParameters(PrintWriter printWriter, boolean bl, boolean bl2) {
        CoordinateChange coordinateChange;
        int n = this.graph.getDimension();
        String string = this.finder.getExtendedGroupName();
        CoordinateChange coordinateChange2 = this.finder.getToStd();
        CoordinateChange coordinateChange3 = (CoordinateChange)coordinateChange2.inverse();
        boolean bl3 = this.embedder.cellRelaxed();
        Matrix matrix = this.embedder.getGramMatrix();
        if (n == 3) {
            CellCorrection cellCorrection = new CellCorrection(this.finder, matrix);
            coordinateChange = cellCorrection.getCoordinateChange();
            String string2 = cellCorrection.getGroupName().equals(this.finder.getGroupName()) ? string : cellCorrection.getGroupName();
            CoordinateChange coordinateChange4 = (CoordinateChange)coordinateChange.inverse().times(coordinateChange3);
            Vector vector = (Vector)Vector.unit(3, 0).times(coordinateChange4);
            Vector vector2 = (Vector)Vector.unit(3, 1).times(coordinateChange4);
            Vector vector3 = (Vector)Vector.unit(3, 2).times(coordinateChange4);
            double d = Math.sqrt(((Real)Vector.dot(vector, vector, matrix)).doubleValue());
            double d2 = Math.sqrt(((Real)Vector.dot(vector2, vector2, matrix)).doubleValue());
            double d3 = Math.sqrt(((Real)Vector.dot(vector3, vector3, matrix)).doubleValue());
            double d4 = 57.29577951308232 * Math.acos(((Real)Vector.dot(vector2, vector3, matrix)).doubleValue() / (d2 * d3));
            double d5 = 57.29577951308232 * Math.acos(((Real)Vector.dot(vector, vector3, matrix)).doubleValue() / (d * d3));
            double d6 = 57.29577951308232 * Math.acos(((Real)Vector.dot(vector, vector2, matrix)).doubleValue() / (d * d2));
            if (bl) {
                printWriter.println("CRYSTAL");
                printWriter.println("  NAME " + Strings.parsable(this.name, false));
                if (bl2) {
                    printWriter.println("  GROUP P1");
                } else {
                    printWriter.println("  GROUP " + string2);
                }
            } else if (string2 != string && !bl2) {
                printWriter.println("   Group setting modified to " + string2);
            }
            if (bl) {
                printWriter.println("  CELL " + fmtReal5.format(d) + " " + fmtReal5.format(d2) + " " + fmtReal5.format(d3) + " " + fmtReal4.format(d4) + " " + fmtReal4.format(d5) + " " + fmtReal4.format(d6));
            } else {
                if (bl2) {
                    printWriter.println("   Coordinates below are given for a full conventional cell.");
                }
                printWriter.println("   " + (bl3 ? "R" : "Unr") + "elaxed cell parameters:");
                printWriter.println("       a = " + fmtReal5.format(d) + ", b = " + fmtReal5.format(d2) + ", c = " + fmtReal5.format(d3));
                printWriter.println("       alpha = " + fmtReal4.format(d4) + ", beta = " + fmtReal4.format(d5) + ", gamma = " + fmtReal4.format(d6));
                printWriter.println("   Cell volume: " + fmtReal5.format(((Real)Vector.volume3D(vector, vector2, vector3)).doubleValue() * Math.sqrt(((Real)matrix.determinant()).doubleValue())));
            }
        } else if (n == 2) {
            Vector vector = (Vector)Vector.unit(2, 0).times(coordinateChange3);
            Vector vector4 = (Vector)Vector.unit(2, 1).times(coordinateChange3);
            coordinateChange = new CoordinateChange(Operator.identity(n));
            double d = Math.sqrt(((Real)Vector.dot(vector, vector, matrix)).doubleValue());
            double d7 = Math.sqrt(((Real)Vector.dot(vector4, vector4, matrix)).doubleValue());
            double d8 = Math.acos(((Real)Vector.dot(vector, vector4, matrix)).doubleValue() / (d * d7)) * 57.29577951308232;
            if (bl) {
                printWriter.println("CRYSTAL");
                printWriter.println("  NAME " + Strings.parsable(this.name, false));
                if (bl2) {
                    printWriter.println("  GROUP p1");
                } else {
                    printWriter.println("  GROUP " + string);
                }
            }
            if (bl) {
                printWriter.println("  CELL " + fmtReal5.format(d) + " " + fmtReal5.format(d7) + " " + fmtReal4.format(d8));
            } else {
                if (bl2) {
                    printWriter.println("   Coordinates are for a full conventional cell.");
                }
                printWriter.println("   " + (bl3 ? "R" : "Unr") + "elaxed cell parameters:");
                printWriter.println("       a = " + fmtReal5.format(d) + ", b = " + fmtReal5.format(d7) + ", gamma = " + fmtReal4.format(d8));
            }
        } else if (n == 1) {
            coordinateChange = new CoordinateChange(Operator.identity(n));
            if (bl) {
                printWriter.println("CRYSTAL");
                printWriter.println("  NAME " + Strings.parsable(this.name, false));
                if (bl2) {
                    printWriter.println("  GROUP op1");
                } else {
                    printWriter.println("  GROUP " + string);
                }
            }
        } else {
            throw new RuntimeException("dimension must be 2 or 3");
        }
        return coordinateChange;
    }

    private Map<INode, Point> nodeReps(PeriodicGraph periodicGraph, Map<INode, Point> map, boolean bl) {
        LinkedHashMap<INode, Point> linkedHashMap = new LinkedHashMap<INode, Point>();
        Iterator<Set<INode>> iterator = periodicGraph.nodeOrbits();
        while (iterator.hasNext()) {
            Set<INode> set = iterator.next();
            ArrayList<PlacedNode> arrayList = new ArrayList<PlacedNode>();
            for (INode iNode : set) {
                Point point = map.get(iNode).modZ();
                arrayList.add(new PlacedNode(iNode, point));
            }
            Collections.sort(arrayList);
            if (bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    PlacedNode placedNode = (PlacedNode)arrayList.get(i);
                    linkedHashMap.put(placedNode.v, placedNode.p);
                }
                continue;
            }
            PlacedNode placedNode = (PlacedNode)arrayList.get(0);
            linkedHashMap.put(placedNode.v, placedNode.p);
        }
        return linkedHashMap;
    }

    private List<Pair<PlacedNode, PlacedNode>> edgeReps(PeriodicGraph periodicGraph, Map<INode, Point> map, Map<INode, Point> map2, CoordinateChange coordinateChange, boolean bl) {
        LinkedList<Pair<PlacedNode, PlacedNode>> linkedList = new LinkedList<Pair<PlacedNode, PlacedNode>>();
        Iterator<Set<IEdge>> iterator = periodicGraph.edgeOrbits();
        while (iterator.hasNext()) {
            Set<IEdge> set = iterator.next();
            ArrayList<IEdge> arrayList = new ArrayList<IEdge>();
            for (IEdge iEdge : set) {
                if (map.containsKey(iEdge.source())) {
                    arrayList.add(iEdge);
                }
                if (!map.containsKey(iEdge.target())) continue;
                arrayList.add(iEdge.reverse());
            }
            ArrayList arrayList2 = new ArrayList();
            for (IEdge iEdge : arrayList) {
                INode iNode = iEdge.source();
                INode iNode2 = iEdge.target();
                Point point = map2.get(iNode);
                Point point2 = (Point)map2.get(iNode2).plus(periodicGraph.getShift(iEdge).times(coordinateChange));
                Point point3 = point.modZ();
                Point point4 = (Point)point2.minus(point.minus(point3));
                arrayList2.add(new Pair<PlacedNode, PlacedNode>(new PlacedNode(iNode, point3), new PlacedNode(iNode2, point4)));
            }
            Collections.sort(arrayList2, Pair.defaultComparator());
            if (bl) {
                linkedList.addAll(arrayList2);
                continue;
            }
            linkedList.add((Pair<PlacedNode, PlacedNode>)arrayList2.get(0));
        }
        return linkedList;
    }

    private double smallestNonBondedDistance(PeriodicGraph periodicGraph, Map<INode, Point> map, Matrix matrix) {
        int n = periodicGraph.getDimension();
        Vector[] vectorArray = Vector.rowVectors(Matrix.one(periodicGraph.getDimension()));
        Vector[] vectorArray2 = Lattices.dirichletVectors(vectorArray, matrix);
        Vector[] vectorArray3 = Lattices.reducedLatticeBasis(vectorArray, matrix);
        Matrix matrix2 = Vector.toMatrix(vectorArray3);
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
        }
        block1: while (true) {
            int n2;
            Vector vector = new Vector(nArray);
            arrayList.add(new Vector((Matrix)vector.getCoordinates().times(matrix2)));
            for (n2 = n - 1; n2 >= 0 && nArray[n2] == 1; --n2) {
            }
            if (n2 < 0) break;
            int n3 = n2++;
            nArray[n3] = nArray[n3] + 1;
            while (true) {
                if (n2 >= n) continue block1;
                nArray[n2++] = -1;
            }
            break;
        }
        double d = Double.MAX_VALUE;
        for (INode iNode : periodicGraph.nodes()) {
            Point point = map.get(iNode);
            for (INode iNode2 : periodicGraph.nodes()) {
                Point point2 = map.get(iNode2);
                Point point3 = (Point)point2.minus(point).plus(Point.origin(n));
                Vector vector = Lattices.dirichletShifts(point3, vectorArray2, matrix, 1)[0];
                HashSet<Vector> hashSet = new HashSet<Vector>();
                if (iNode.equals(iNode2)) {
                    hashSet.add(Vector.zero(n));
                }
                HashSet<Vector> hashSet2 = new HashSet<Vector>();
                hashSet2.add(Vector.zero(n));
                for (IEdge iEdge : periodicGraph.allIncidences(iNode)) {
                    INode iNode3 = iEdge.target();
                    if (!iNode3.equals(iNode2)) continue;
                    hashSet.add(periodicGraph.getShift(iEdge));
                    hashSet2.add(periodicGraph.getShift(iEdge));
                }
                for (Vector vector2 : hashSet2) {
                    for (Vector vector3 : arrayList) {
                        Point point4;
                        Vector vector4;
                        double d2;
                        Vector vector5 = (Vector)vector3.plus(vector).plus(vector2);
                        if (hashSet.contains(vector5) || !((d2 = ((Real)Vector.dot(vector4 = (Vector)(point4 = (Point)point2.plus(vector5)).minus(point), vector4, matrix)).doubleValue()) < d)) continue;
                        d = d2;
                    }
                }
            }
        }
        if (d == Double.MAX_VALUE) {
            return -1.0;
        }
        return Math.sqrt(d);
    }

    public PeriodicGraph getGraph() {
        return this.graph;
    }

    public String getName() {
        return this.name;
    }

    public boolean getVerified() {
        return this.verified;
    }

    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    public boolean hasEmbedding() {
        return this.embedder != null;
    }

    private class PlacedNode
    implements Comparable<PlacedNode> {
        public final INode v;
        public final Point p;

        public PlacedNode(INode iNode, Point point) {
            this.v = iNode;
            this.p = point;
        }

        @Override
        public int compareTo(PlacedNode placedNode) {
            int n;
            Point point = this.p;
            Point point2 = placedNode.p;
            int n2 = point.getDimension();
            Point point3 = Point.origin(n2);
            Vector vector = (Vector)point.minus(point3);
            Vector vector2 = (Vector)point2.minus(point3);
            if (vector.isNegative()) {
                if (vector2.isNonNegative()) {
                    return 1;
                }
            } else if (vector2.isNegative()) {
                return -1;
            }
            if ((n = this.count_zeroes(vector2) - this.count_zeroes(vector)) != 0) {
                return n;
            }
            n = this.cmpCoords(Vector.dot(vector, vector), Vector.dot(vector2, vector2));
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < n2; ++i) {
                n = this.cmpCoords(point.get(i), point2.get(i));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        private int count_zeroes(Vector vector) {
            int n = 0;
            for (int i = 0; i < vector.getDimension(); ++i) {
                if (!(((Real)vector.get(i).abs()).doubleValue() < 1.0E-6)) continue;
                ++n;
            }
            return n;
        }

        private int cmpCoords(IArithmetic iArithmetic, IArithmetic iArithmetic2) {
            double d;
            double d2 = ((Real)iArithmetic).doubleValue();
            double d3 = ((Real)iArithmetic2).doubleValue();
            if (d2 < 0.0) {
                if (d3 > 0.0) {
                    return 1;
                }
            } else if (d3 < 0.0) {
                return -1;
            }
            if (Math.abs(d = Math.abs(d2) - Math.abs(d3)) < 1.0E-6) {
                return 0;
            }
            return Double.compare(Math.abs(d2), Math.abs(d3));
        }
    }
}

