/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.pgraphs.basic;

import java.util.List;
import junit.framework.TestCase;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.UndirectedGraph;

public class TestUndirectedGraph
extends TestCase {
    private UndirectedGraph G;
    private INode v1;
    private INode v2;
    private INode v3;
    private INode v4;
    private INode v5;
    private IEdge e1;
    private IEdge e2;
    private IEdge e3;
    private IEdge e4;

    protected void setUp() throws Exception {
        super.setUp();
        this.G = new UndirectedGraph();
        this.v1 = this.G.newNode();
        this.v2 = this.G.newNode();
        this.v3 = this.G.newNode();
        this.v4 = this.G.newNode();
        this.v5 = this.G.newNode();
        this.e1 = this.G.newEdge(this.v1, this.v2);
        this.e2 = this.G.newEdge(this.v1, this.v3);
        this.e3 = this.G.newEdge(this.v1, this.v4);
        this.e4 = this.G.newEdge(this.v2, this.v3);
    }

    protected void tearDown() throws Exception {
        this.G = null;
        this.v5 = null;
        this.v4 = null;
        this.v3 = null;
        this.v2 = null;
        this.v1 = null;
        this.e4 = null;
        this.e3 = null;
        this.e2 = null;
        this.e1 = null;
        super.tearDown();
    }

    public void testNodes() {
        List<INode> nodes = Iterators.asList(this.G.nodes());
        TestUndirectedGraph.assertEquals((int)5, (int)nodes.size());
        TestUndirectedGraph.assertTrue((boolean)nodes.contains(this.v1));
        TestUndirectedGraph.assertTrue((boolean)nodes.contains(this.v2));
        TestUndirectedGraph.assertTrue((boolean)nodes.contains(this.v3));
        TestUndirectedGraph.assertTrue((boolean)nodes.contains(this.v4));
        TestUndirectedGraph.assertTrue((boolean)nodes.contains(this.v5));
    }

    public void testEdges() {
        List<IEdge> edges = Iterators.asList(this.G.edges());
        TestUndirectedGraph.assertEquals((int)4, (int)edges.size());
        TestUndirectedGraph.assertTrue((boolean)edges.contains(this.e1));
        TestUndirectedGraph.assertTrue((boolean)edges.contains(this.e2));
        TestUndirectedGraph.assertTrue((boolean)edges.contains(this.e3));
        TestUndirectedGraph.assertTrue((boolean)edges.contains(this.e4));
    }

    public void testGetElements() {
        INode v = this.G.getNode(this.v1.id());
        TestUndirectedGraph.assertTrue((boolean)(v instanceof INode));
        TestUndirectedGraph.assertEquals((long)this.v1.id(), (long)v.id());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)v);
        IEdge e = this.G.getEdge(this.e1.id());
        TestUndirectedGraph.assertTrue((boolean)(e instanceof IEdge));
        TestUndirectedGraph.assertEquals((long)this.e1.id(), (long)e.id());
        TestUndirectedGraph.assertEquals((Object)this.e1, (Object)e);
    }

    public void testHasElements() {
        TestUndirectedGraph.assertTrue((boolean)this.G.hasNode(this.v1));
        TestUndirectedGraph.assertTrue((boolean)this.G.hasEdge(this.e1));
        TestUndirectedGraph.assertTrue((boolean)this.G.hasEdge(this.G.getEdge(this.e1.id())));
        TestUndirectedGraph.assertFalse((boolean)this.G.hasEdge(null));
        UndirectedGraph H = new UndirectedGraph();
        INode v = H.newNode();
        TestUndirectedGraph.assertFalse((boolean)this.G.hasNode(v));
        TestUndirectedGraph.assertFalse((boolean)H.hasNode(this.v1));
    }

    public void testOrientedEdge() {
        IEdge e1o = this.e1.oriented();
        TestUndirectedGraph.assertTrue((boolean)this.e1.equals(this.e1.reverse()));
        TestUndirectedGraph.assertFalse((boolean)e1o.equals(e1o.reverse()));
    }

    public void testConnectingEdges() {
        IteratorAdapter<IEdge> edges = this.G.connectingEdges(this.v2, this.v1);
        TestUndirectedGraph.assertTrue((boolean)edges.hasNext());
        IEdge e = (IEdge)edges.next();
        TestUndirectedGraph.assertFalse((boolean)edges.hasNext());
        TestUndirectedGraph.assertEquals((Object)this.v2, (Object)e.source());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)e.target());
        TestUndirectedGraph.assertFalse((boolean)this.G.connectingEdges(this.v2, this.v4).hasNext());
    }

    public void testNewNode() {
        this.G.newNode();
        this.G.newNode();
        TestUndirectedGraph.assertEquals((String)"(1,2)(1,3)(1,4)(2,3)(5)(6)(7)", (String)this.G.toString());
    }

    public void testNewEdge() {
        this.G.newEdge(this.v2, this.v1);
        TestUndirectedGraph.assertEquals((String)"(1,2)(1,2)(1,3)(1,4)(2,3)(5)", (String)this.G.toString());
        List<IEdge> edges = Iterators.asList(this.G.connectingEdges(this.v1, this.v2));
        TestUndirectedGraph.assertEquals((int)2, (int)edges.size());
    }

    public void testDelete() {
        this.G.delete(this.e3);
        this.G.delete(this.v4);
        TestUndirectedGraph.assertEquals((String)"(1,2)(1,3)(2,3)(5)", (String)this.G.toString());
        try {
            this.G.delete(this.v1);
            TestUndirectedGraph.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToString() {
        TestUndirectedGraph.assertEquals((String)"(1,2)(1,3)(1,4)(2,3)(5)", (String)this.G.toString());
    }

    public void testLoop() {
        IEdge loop = this.G.newEdge(this.v1, this.v1);
        TestUndirectedGraph.assertEquals((String)"(1,1)(1,2)(1,3)(1,4)(2,3)(5)", (String)this.G.toString());
        TestUndirectedGraph.assertEquals((int)1, (int)Iterators.size(this.G.connectingEdges(this.v1, this.v1)));
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)loop.source());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)loop.target());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)loop.reverse().source());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)loop.reverse().target());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)loop.opposite(this.v1));
        List<IEdge> incidences = Iterators.asList(this.v1.incidences());
        TestUndirectedGraph.assertEquals((int)4, (int)incidences.size());
        TestUndirectedGraph.assertTrue((boolean)incidences.contains(loop));
        this.G.delete(loop);
        TestUndirectedGraph.assertEquals((String)"(1,2)(1,3)(1,4)(2,3)(5)", (String)this.G.toString());
    }

    public void testNodeDegree() {
        TestUndirectedGraph.assertEquals((int)3, (int)this.v1.degree());
        TestUndirectedGraph.assertEquals((int)2, (int)this.v2.degree());
        TestUndirectedGraph.assertEquals((int)2, (int)this.v3.degree());
        TestUndirectedGraph.assertEquals((int)1, (int)this.v4.degree());
        TestUndirectedGraph.assertEquals((int)0, (int)this.v5.degree());
        this.G.newEdge(this.v2, this.v1);
        TestUndirectedGraph.assertEquals((int)4, (int)this.v1.degree());
        this.G.newEdge(this.v5, this.v5);
        TestUndirectedGraph.assertEquals((int)2, (int)this.v5.degree());
    }

    public void testEdgeSource() {
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e1.source());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e2.source());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e3.source());
        TestUndirectedGraph.assertEquals((Object)this.v2, (Object)this.e4.source());
        TestUndirectedGraph.assertEquals((Object)this.v2, (Object)this.e1.reverse().source());
        TestUndirectedGraph.assertEquals((Object)this.v3, (Object)this.e2.reverse().source());
        TestUndirectedGraph.assertEquals((Object)this.v4, (Object)this.e3.reverse().source());
        TestUndirectedGraph.assertEquals((Object)this.v3, (Object)this.e4.reverse().source());
    }

    public void testEdgeTarget() {
        TestUndirectedGraph.assertEquals((Object)this.v2, (Object)this.e1.target());
        TestUndirectedGraph.assertEquals((Object)this.v3, (Object)this.e2.target());
        TestUndirectedGraph.assertEquals((Object)this.v4, (Object)this.e3.target());
        TestUndirectedGraph.assertEquals((Object)this.v3, (Object)this.e4.target());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e1.reverse().target());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e2.reverse().target());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e3.reverse().target());
        TestUndirectedGraph.assertEquals((Object)this.v2, (Object)this.e4.reverse().target());
    }

    public void testEdgeOpposite() {
        TestUndirectedGraph.assertEquals((Object)this.v2, (Object)this.e1.opposite(this.v1));
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e1.opposite(this.v2));
        try {
            this.e1.opposite(this.v3);
            TestUndirectedGraph.fail((String)"should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestUndirectedGraph.assertEquals((Object)this.v3, (Object)this.e2.opposite(this.v1));
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)this.e2.opposite(this.v3));
    }

    public void testEdgeReverse() {
        IEdge r1 = this.e1.reverse();
        TestUndirectedGraph.assertEquals((Object)this.v2, (Object)r1.source());
        TestUndirectedGraph.assertEquals((Object)this.v1, (Object)r1.target());
        TestUndirectedGraph.assertEquals((Object)this.e1, (Object)r1);
    }

    public void testElementOwner() {
        TestUndirectedGraph.assertEquals((Object)this.G, (Object)this.v1.owner());
        TestUndirectedGraph.assertEquals((Object)this.G, (Object)this.G.getNode(this.v1.id()).owner());
        TestUndirectedGraph.assertEquals((Object)this.G, (Object)this.e1.owner());
    }

    public void testElementId() {
        TestUndirectedGraph.assertEquals((long)this.v1.id(), (long)this.G.getNode(this.v1.id()).id());
        TestUndirectedGraph.assertEquals((long)this.e1.reverse().id(), (long)this.e1.id());
    }

    public void testElementIncidences() {
        List<IEdge> incidences = Iterators.asList(this.v2.incidences());
        TestUndirectedGraph.assertEquals((int)2, (int)incidences.size());
        TestUndirectedGraph.assertTrue((boolean)incidences.contains(this.e1));
        TestUndirectedGraph.assertTrue((boolean)incidences.contains(this.e1.reverse()));
        TestUndirectedGraph.assertTrue((boolean)incidences.contains(this.e4));
        incidences = Iterators.asList(this.v5.incidences());
        TestUndirectedGraph.assertEquals((int)0, (int)incidences.size());
    }
}

