/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.graphics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.simple.NamedConstant;
import org.gavrog.joss.graphics.Vec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Surface {
    public static final Target FACE = new Target("face");
    public static final Target VERTEX = new Target("vertex");
    public static final Attribute CONVEX = new Attribute("convex");
    public static final Attribute NORMAL = new Attribute("normal");
    public static final Attribute TAG = new Attribute("tag");
    public final double[][] vertices;
    public final int[][] faces;
    public final int[] fixed;
    private final Map<AttributeKey, Object> attributes;

    public Surface(double[][] vertices, int[][] faces, int[] fixed) {
        this.vertices = (double[][])vertices.clone();
        this.faces = (int[][])faces.clone();
        this.fixed = (int[])fixed.clone();
        this.attributes = new HashMap<AttributeKey, Object>();
    }

    public void setAttribute(Target targetType, int targetIndex, Attribute attributeKey, Object attributeValue) {
        this.attributes.put(new AttributeKey(targetType, targetIndex, attributeKey), attributeValue);
    }

    public void setAttribute(Object targetType, int targetIndex, Object attributeKey, boolean attributeValue) {
        this.setAttribute(targetType, targetIndex, attributeKey, new Boolean(attributeValue));
    }

    public Object getAttribute(Target targetType, int targetIndex, Attribute attributeKey) {
        return this.attributes.get(new AttributeKey(targetType, targetIndex, attributeKey));
    }

    public boolean getBooleanAttribute(Target targetType, int targetIndex, Attribute attributeKey) {
        Object val = this.getAttribute(targetType, targetIndex, attributeKey);
        return val == null || (Boolean)val != false;
    }

    public void computeNormals() {
        int nv = this.vertices.length;
        double[][] vertexNormals = new double[nv][3];
        int nf = this.faces.length;
        int i = 0;
        while (i < nf) {
            int[] face = this.faces[i];
            int n = face.length;
            double[] normal = new double[]{0.0, 0.0, 0.0};
            int j = 0;
            while (j < n) {
                double[] p = this.vertices[face[j]];
                double[] q = this.vertices[face[(j + 1) % n]];
                Vec.plus(normal, normal, Vec.crossProduct(null, p, q));
                ++j;
            }
            Vec.normalized(normal, normal);
            this.setAttribute(FACE, i, NORMAL, normal);
            j = 0;
            while (j < n) {
                int v = face[j];
                Vec.plus(vertexNormals[v], vertexNormals[v], normal);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nv) {
            double[] normal = new double[3];
            Vec.normalized(normal, vertexNormals[i]);
            this.setAttribute(VERTEX, i, NORMAL, normal);
            ++i;
        }
    }

    public double[][] getFaceNormals() {
        int nf = this.faces.length;
        double[][] normals = new double[nf][3];
        int i = 0;
        while (i < nf) {
            double[] n = (double[])this.getAttribute(FACE, i, NORMAL);
            int j = 0;
            while (j < 3) {
                normals[i][j] = n[j];
                ++j;
            }
            ++i;
        }
        return normals;
    }

    public double[][] getVertexNormals() {
        int nv = this.vertices.length;
        double[][] normals = new double[nv][3];
        int i = 0;
        while (i < nv) {
            double[] n = (double[])this.getAttribute(VERTEX, i, NORMAL);
            int j = 0;
            while (j < 3) {
                normals[i][j] = n[j];
                ++j;
            }
            ++i;
        }
        return normals;
    }

    public void tagAll(Object tag) {
        int i = 0;
        while (i < this.faces.length) {
            this.setAttribute(FACE, i, TAG, tag);
            ++i;
        }
    }

    public Set<String> faceTags() {
        HashSet<String> res = new HashSet<String>();
        int i = 0;
        while (i < this.faces.length) {
            String tag = (String)this.getAttribute(FACE, i, TAG);
            if (tag != null) {
                res.add(tag);
            }
            ++i;
        }
        return res;
    }

    public static Surface concatenation(Surface[] parts) {
        int n = parts.length;
        int newNF = 0;
        int newNV = 0;
        int i = 0;
        while (i < n) {
            newNF += parts[i].faces.length;
            newNV += parts[i].vertices.length;
            ++i;
        }
        double[][] newVerts = new double[newNV][];
        int[] newFixed = new int[newNV];
        int[][] newFaces = new int[newNF][];
        int[][] mapV = new int[n][];
        int[][] mapF = new int[n][];
        int offsetV = 0;
        int offsetF = 0;
        int i2 = 0;
        while (i2 < n) {
            double[][] verts = parts[i2].vertices;
            int[][] faces = parts[i2].faces;
            int nv = verts.length;
            int nf = faces.length;
            mapV[i2] = new int[nv];
            mapF[i2] = new int[nf];
            int j = 0;
            while (j < nv) {
                mapV[i2][j] = offsetV + j;
                ++j;
            }
            j = 0;
            while (j < nf) {
                mapF[i2][j] = offsetF + j;
                ++j;
            }
            System.arraycopy(verts, 0, newVerts, offsetV, nv);
            System.arraycopy(parts[i2].fixed, 0, newFixed, offsetV, nv);
            j = 0;
            while (j < faces.length) {
                int[] face = faces[j];
                int[] newFace = new int[face.length];
                newFaces[j + offsetF] = newFace;
                int k = 0;
                while (k < face.length) {
                    newFace[k] = face[k] + offsetV;
                    ++k;
                }
                ++j;
            }
            offsetV += nv;
            offsetF += nf;
            ++i2;
        }
        Surface surf = new Surface(newVerts, newFaces, newFixed);
        int i3 = 0;
        while (i3 < n) {
            Surface part = parts[i3];
            for (AttributeKey key : part.attributes.keySet()) {
                int newIndex = key.targetType == FACE ? mapF[i3][key.index] : mapV[i3][key.index];
                if (newIndex < 0) continue;
                surf.setAttribute(key.targetType, newIndex, key.attribute, part.attributes.get(key));
            }
            ++i3;
        }
        return surf;
    }

    private boolean equal(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public Surface extract(Object tag) {
        int nf = this.faces.length;
        int nv = this.vertices.length;
        boolean[] usedV = new boolean[nv];
        boolean[] usedF = new boolean[nf];
        int newNV = 0;
        int newNF = 0;
        for (AttributeKey key : this.attributes.keySet()) {
            if (!key.targetType.equals(FACE) || !key.attribute.equals(TAG) || !this.equal(tag, this.attributes.get(key))) continue;
            int i = key.index;
            int[] face = this.faces[i];
            int j = 0;
            while (j < face.length) {
                int v = face[j];
                if (!usedV[v]) {
                    ++newNV;
                }
                usedV[v] = true;
                ++j;
            }
            if (!usedF[i]) {
                ++newNF;
            }
            usedF[i] = true;
        }
        int[] mapV = new int[nv];
        double[][] newVerts = new double[newNV][3];
        int[] newFixed = new int[newNV];
        int k = 0;
        int i = 0;
        while (i < nv) {
            if (usedV[i]) {
                mapV[i] = k;
                Vec.copy(newVerts[k], this.vertices[i]);
                newFixed[k] = this.fixed[i];
                ++k;
            } else {
                mapV[i] = -1;
            }
            ++i;
        }
        int[] mapF = new int[nf];
        int[][] newFaces = new int[newNF][];
        Object[] newTags = new Object[newNF];
        k = 0;
        int i2 = 0;
        while (i2 < nf) {
            if (usedF[i2]) {
                mapF[i2] = k;
                int[] face = this.faces[i2];
                int[] newFace = new int[face.length];
                int j = 0;
                while (j < face.length) {
                    newFace[j] = mapV[face[j]];
                    ++j;
                }
                newFaces[k] = newFace;
                newTags[k] = tag;
                ++k;
            } else {
                mapF[i2] = -1;
            }
            ++i2;
        }
        Surface surf = new Surface(newVerts, newFaces, newFixed);
        for (AttributeKey key : this.attributes.keySet()) {
            int newIndex = key.targetType == FACE ? mapF[key.index] : mapV[key.index];
            if (newIndex < 0) continue;
            surf.setAttribute(key.targetType, newIndex, key.attribute, this.attributes.get(key));
        }
        return surf;
    }

    public Surface subdivision() {
        int d;
        int nv = this.vertices.length;
        int nf = this.faces.length;
        int[][] edgeToIndex = new int[nv][nv];
        int i = 0;
        while (i < nv) {
            int j = 0;
            while (j < nv) {
                edgeToIndex[i][j] = -1;
                ++j;
            }
            ++i;
        }
        int ne = 0;
        int neInterior = 0;
        int i2 = 0;
        while (i2 < nf) {
            int[] face = this.faces[i2];
            int n = face.length;
            int j = 0;
            while (j < n) {
                int v = face[j];
                int w = face[(j + 1) % n];
                if (edgeToIndex[v][w] < 0) {
                    int n2 = ne++;
                    edgeToIndex[w][v] = n2;
                    edgeToIndex[v][w] = n2;
                } else {
                    ++neInterior;
                }
                ++j;
            }
            ++i2;
        }
        double[][] newVertices = new double[nf + ne + nv][3];
        int[][] newFaces = new int[ne + neInterior][4];
        int[] newFixed = new int[newVertices.length];
        boolean[] newConvex = new boolean[newVertices.length];
        int[][] mapF = new int[nf][];
        int facesMade = 0;
        int i3 = 0;
        while (i3 < nf) {
            int[] face = this.faces[i3];
            int n = face.length;
            mapF[i3] = new int[n];
            int j = 0;
            while (j < n) {
                int u = face[j];
                int v = face[(j + 1) % n];
                int w = face[(j + 2) % n];
                int k = edgeToIndex[u][v];
                int k1 = edgeToIndex[v][w];
                newFaces[facesMade] = new int[]{i3, nf + k, nf + ne + v, nf + k1};
                mapF[i3][j] = facesMade++;
                boolean cu = this.getBooleanAttribute(VERTEX, u, CONVEX);
                boolean cv = this.getBooleanAttribute(VERTEX, v, CONVEX);
                boolean bl = cu || cv;
                newConvex[nf + k] = bl;
                boolean convex = bl;
                int fu = this.fixed[u];
                int fv = this.fixed[v];
                newFixed[nf + k] = convex && (fu > 0 && fv <= 0 || fv > 0 && fu <= 0) ? 0 : Math.min(fu, fv) - 1;
                newFixed[nf + ne + u] = this.fixed[u] - 1;
                ++j;
            }
            ++i3;
        }
        double[][] vertexTmp = new double[newVertices.length][3];
        int[] vertexDeg = new int[newVertices.length];
        int k = 0;
        while (k < newFaces.length) {
            int[] face = newFaces[k];
            double[] p = vertexTmp[face[0]];
            double[] q = this.vertices[face[2] - nf - ne];
            p[0] = p[0] + q[0];
            p[1] = p[1] + q[1];
            p[2] = p[2] + q[2];
            int n = face[0];
            vertexDeg[n] = vertexDeg[n] + 1;
            ++k;
        }
        int i4 = 0;
        while (i4 < nf) {
            double[] p = newVertices[i4];
            double[] q = vertexTmp[i4];
            d = vertexDeg[i4];
            p[0] = q[0] / (double)d;
            p[1] = q[1] / (double)d;
            p[2] = q[2] / (double)d;
            ++i4;
        }
        k = 0;
        while (k < newFaces.length) {
            int[] face = newFaces[k];
            int e1 = face[1];
            int e2 = face[3];
            double[] p1 = vertexTmp[e1];
            double[] p2 = vertexTmp[e2];
            double[] q1 = this.vertices[face[2] - nf - ne];
            double[] q2 = newVertices[face[0]];
            int i5 = 0;
            while (i5 < 3) {
                int n = i5;
                p1[n] = p1[n] + q1[i5];
                int n3 = i5;
                p2[n3] = p2[n3] + q1[i5];
                ++i5;
            }
            int n = e1;
            vertexDeg[n] = vertexDeg[n] + 1;
            int n4 = e2;
            vertexDeg[n4] = vertexDeg[n4] + 1;
            if (newFixed[e1] < 0) {
                i5 = 0;
                while (i5 < 3) {
                    int n5 = i5;
                    p1[n5] = p1[n5] + q2[i5];
                    ++i5;
                }
                int n6 = e1;
                vertexDeg[n6] = vertexDeg[n6] + 1;
            }
            if (newFixed[e2] < 0) {
                i5 = 0;
                while (i5 < 3) {
                    int n7 = i5;
                    p2[n7] = p2[n7] + q2[i5];
                    ++i5;
                }
                int n8 = e2;
                vertexDeg[n8] = vertexDeg[n8] + 1;
            }
            ++k;
        }
        i4 = 0;
        while (i4 < ne) {
            double[] p = newVertices[nf + i4];
            double[] q = vertexTmp[nf + i4];
            d = vertexDeg[nf + i4];
            p[0] = q[0] / (double)d;
            p[1] = q[1] / (double)d;
            p[2] = q[2] / (double)d;
            ++i4;
        }
        k = 0;
        while (k < newFaces.length) {
            int[] face = newFaces[k];
            int v = face[2];
            if (newFixed[v] < 0) {
                double[] p = vertexTmp[v];
                double[] r = newVertices[face[0]];
                double[] q1 = newVertices[face[1]];
                double[] q2 = newVertices[face[3]];
                int nu = 0;
                while (nu < 3) {
                    int n = nu;
                    p[n] = p[n] + (2.0 * q1[nu] + 2.0 * q2[nu] - r[nu]);
                    ++nu;
                }
                int n = v;
                vertexDeg[n] = vertexDeg[n] + 1;
            }
            ++k;
        }
        i4 = 0;
        while (i4 < nv) {
            int v = nf + ne + i4;
            double[] p = newVertices[v];
            double[] q = this.vertices[i4];
            p[0] = q[0];
            p[1] = q[1];
            p[2] = q[2];
            if (newFixed[v] < 0) {
                double[] r = vertexTmp[v];
                int d2 = vertexDeg[v];
                int nu = 0;
                while (nu < 3) {
                    p[nu] = ((double)(d2 - 3) * p[nu] + r[nu] / (double)d2) / (double)d2;
                    ++nu;
                }
            }
            ++i4;
        }
        Surface surf = new Surface(newVertices, newFaces, newFixed);
        for (AttributeKey key : this.attributes.keySet()) {
            Target type = key.targetType;
            Attribute attr = key.attribute;
            Object val = this.attributes.get(key);
            if (key.targetType == FACE) {
                int[] o2n = mapF[key.index];
                int j = 0;
                while (j < o2n.length) {
                    surf.setAttribute(type, o2n[j], attr, val);
                    ++j;
                }
                continue;
            }
            surf.setAttribute(type, key.index + nf + ne, attr, val);
        }
        int i6 = 0;
        while (i6 < newVertices.length) {
            if (newConvex[i6]) {
                this.setAttribute(VERTEX, i6, CONVEX, CONVEX);
            }
            ++i6;
        }
        return surf;
    }

    public static Surface fromOutline(double[][] corners, int fixBorder) {
        int startNew;
        int n;
        ArrayList<double[]> vertices = new ArrayList<double[]>();
        ArrayList<int[]> faces = new ArrayList<int[]>();
        double[] tmp = new double[3];
        int startInner = 0;
        int i = 0;
        while (i < corners.length) {
            vertices.add(corners[i]);
            ++i;
        }
        while ((n = (startNew = vertices.size()) - startInner) > 4) {
            int f;
            int b;
            int i1;
            double[] normal = new double[3];
            double[] center = new double[3];
            int i2 = 0;
            while (i2 < n) {
                Vec.crossProduct(tmp, (double[])vertices.get(i2 + startInner), (double[])vertices.get((i2 + 1) % n + startInner));
                Vec.plus(normal, normal, tmp);
                Vec.plus(center, center, (double[])vertices.get(i2 + startInner));
                ++i2;
            }
            Vec.normalized(normal, normal);
            Vec.times(center, 1.0 / (double)n, center);
            int[] upDown = new int[n];
            int nOnMiddle = 0;
            int i3 = 0;
            while (i3 < n) {
                Vec.minus(tmp, (double[])vertices.get(i3 + startInner), center);
                double d0 = Vec.innerProduct(normal, tmp);
                if (d0 > 0.1) {
                    upDown[i3] = 1;
                } else if (d0 < -0.1) {
                    upDown[i3] = -1;
                } else {
                    upDown[i3] = 0;
                    ++nOnMiddle;
                }
                ++i3;
            }
            if (nOnMiddle == n) break;
            boolean[] changes = new boolean[n];
            int nChanging = 0;
            int i0 = 0;
            while (i0 < n) {
                int i12 = (i0 + 1) % n;
                if (upDown[i0] != upDown[i12]) {
                    changes[i0] = true;
                    ++nChanging;
                } else {
                    changes[i0] = false;
                }
                ++i0;
            }
            if (nChanging < 4) break;
            int[] back = new int[startNew + n];
            int[] forw = new int[startNew + n];
            int i4 = startInner;
            while (i4 < back.length) {
                forw[i4] = -1;
                back[i4] = -1;
                ++i4;
            }
            int i02 = 0;
            while (i02 < n) {
                block30: {
                    int b2;
                    int a;
                    double[] c;
                    int k;
                    block32: {
                        block31: {
                            if (i02 == 0 && changes[n - 1] && changes[0] && upDown[0] == 0) break block30;
                            i1 = (i02 + 1) % n;
                            k = vertices.size();
                            c = new double[3];
                            if (!changes[i02]) break block31;
                            if (changes[i1] && upDown[i1] == 0) {
                                a = i02;
                                b2 = (i1 + 1) % n;
                                Vec.linearCombination(tmp, 0.5, (double[])vertices.get(i02 + startInner), 0.5, (double[])vertices.get(i1 + startInner));
                                Vec.linearCombination(c, 0.667, tmp, 0.333, (double[])vertices.get(b2 + startInner));
                                ++i02;
                            } else {
                                a = i02;
                                b2 = i1;
                                Vec.linearCombination(c, 0.5, (double[])vertices.get(i02 + startInner), 0.5, (double[])vertices.get(i1 + startInner));
                            }
                            break block32;
                        }
                        if (changes[i1]) break block30;
                        a = b2 = i1;
                        Vec.copy(c, (double[])vertices.get(i1 + startInner));
                    }
                    back[k] = a + startInner;
                    forw[k] = b2 + startInner;
                    forw[a + startInner] = k;
                    back[b2 + startInner] = k;
                    double[] v = new double[3];
                    Vec.minus(tmp, c, center);
                    Vec.complementProjection(tmp, tmp, normal);
                    Vec.linearCombination(tmp, 0.5, tmp, 1.0, center);
                    Vec.linearCombination(v, 0.667, tmp, 0.333, c);
                    vertices.add(v);
                }
                ++i02;
            }
            i4 = startInner;
            while (i4 < startNew) {
                if (back[i4] >= 0 && forw[i4] >= 0 && (b = back[i4]) != (f = forw[i4])) {
                    faces.add(new int[]{i4, f, b});
                }
                ++i4;
            }
            i4 = startNew;
            while (i4 < vertices.size()) {
                if (back[i4] >= 0 && forw[i4] >= 0 && (b = back[i4]) != (f = forw[i4])) {
                    int m = (b + 1 - startInner) % n + startInner;
                    if (m == f) {
                        faces.add(new int[]{i4, b, f});
                    } else {
                        double[] u = new double[3];
                        double[] v = new double[3];
                        double[] w = new double[3];
                        Vec.minus(u, (double[])vertices.get(b), (double[])vertices.get(m));
                        Vec.minus(v, (double[])vertices.get(i4), (double[])vertices.get(m));
                        Vec.minus(w, (double[])vertices.get(f), (double[])vertices.get(m));
                        double angle = Vec.angle(u, v) + Vec.angle(v, w);
                        if (angle > 2.356194490192345) {
                            faces.add(new int[]{i4, b, m});
                            faces.add(new int[]{i4, m, f});
                        } else {
                            faces.add(new int[]{i4, b, m, f});
                        }
                    }
                }
                ++i4;
            }
            i02 = startInner;
            while (i02 < startNew) {
                if ((forw[i02] < 0 || forw[i02] == back[i02]) && back[i02] >= 0) {
                    i1 = (i02 + 1 - startInner) % n + startInner;
                    int b3 = back[i02];
                    int f2 = back[i1] >= 0 ? back[i1] : forw[i1];
                    faces.add(new int[]{i02, i1, f2, b3});
                }
                ++i02;
            }
            int x = vertices.size() - startNew;
            startInner = startNew;
            if (x != n) continue;
        }
        int[] inner = new int[vertices.size() - startInner];
        int i5 = startInner;
        while (i5 < vertices.size()) {
            inner[i5 - startInner] = i5;
            ++i5;
        }
        faces.add(inner);
        double[][] pos = new double[vertices.size()][];
        vertices.toArray((T[])pos);
        int[][] idcs = new int[faces.size()][];
        faces.toArray((T[])idcs);
        int[] fixed = new int[vertices.size()];
        int i6 = 0;
        while (i6 < corners.length) {
            fixed[i6] = fixBorder;
            ++i6;
        }
        return new Surface(pos, idcs, fixed);
    }

    public void write(OutputStream target) throws IOException {
        this.write(new OutputStreamWriter(target));
    }

    public void write(OutputStream target, int startIndex, String prefix, double[] transform, boolean invert) throws IOException {
        this.write(new OutputStreamWriter(target), startIndex, prefix, transform, invert);
    }

    public void write(Writer target) throws IOException {
        this.write(target, 1, "", new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0}, false);
    }

    public void write(Writer target, int startIndex, String prefix, double[] transform, boolean invert) throws IOException {
        double[] t = transform;
        BufferedWriter out = new BufferedWriter(target);
        int i = 0;
        while (i < this.vertices.length) {
            double[] v = this.vertices[i];
            out.write(String.format("v %f %f %f\n", v[0] * t[0] + v[1] * t[1] + v[2] * t[2] + t[3], v[0] * t[4] + v[1] * t[5] + v[2] * t[6] + t[7], v[0] * t[8] + v[1] * t[9] + v[2] * t[10] + t[11]));
            ++i;
        }
        this.computeNormals();
        double[][] normals = this.getVertexNormals();
        int i2 = 0;
        while (i2 < normals.length) {
            double[] n = normals[i2];
            if (invert) {
                out.write(String.format("vn %f %f %f\n", -n[0], -n[1], -n[2]));
            } else {
                out.write(String.format("vn %f %f %f\n", n[0], n[1], n[2]));
            }
            ++i2;
        }
        HashMap mats = new HashMap();
        int i3 = 0;
        while (i3 < this.faces.length) {
            String m = (String)this.getAttribute(FACE, i3, TAG);
            if (m == null) {
                m = "default";
            }
            if (mats.get(m) == null) {
                mats.put(m, new ArrayList());
            }
            ((List)mats.get(m)).add(i3);
            ++i3;
        }
        for (String m : mats.keySet()) {
            out.write(String.format("usemtl %s%s\n", prefix, m));
            Iterator iterator = ((List)mats.get(m)).iterator();
            while (iterator.hasNext()) {
                int k;
                int j;
                int i4 = (Integer)iterator.next();
                int[] f = this.faces[i4];
                out.write("f ");
                if (invert) {
                    j = f.length - 1;
                    while (j > -1) {
                        k = f[j] + startIndex;
                        out.write(String.format(" %d//%d", k, k));
                        --j;
                    }
                } else {
                    j = 0;
                    while (j < f.length) {
                        k = f[j] + startIndex;
                        out.write(String.format(" %d//%d", k, k));
                        ++j;
                    }
                }
                out.write("\n");
            }
        }
        out.flush();
    }

    public static void main(String[] args) {
        double[][] v = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}, {1.0, 1.0, 1.0}};
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{5, 4, 6, 7};
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[2] = 4;
        nArray2[3] = 5;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{2, 3, 7, 6};
        int[] nArray3 = new int[4];
        nArray3[1] = 2;
        nArray3[2] = 6;
        nArray3[3] = 4;
        nArrayArray[4] = nArray3;
        nArrayArray[5] = new int[]{3, 1, 5, 7};
        int[][] f = nArrayArray;
        int[] fixed = new int[8];
        Object[] tag = new Object[]{"left", "right", "bottom", "top", "back", "front"};
        Surface surf = new Surface(v, f, fixed);
        int i = 0;
        while (i < tag.length) {
            surf.setAttribute(FACE, i, TAG, tag[i]);
            ++i;
        }
        surf = surf.subdivision();
        surf.computeNormals();
        try {
            surf.write(System.out);
            surf.write(System.out, surf.vertices.length + 1, "second_", new double[]{1.1, 0.0, 0.0, 1.0, 0.0, 1.1, 0.0, 0.0, 0.0, 0.0, 1.1, 0.0}, false);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    private static class Attribute
    extends NamedConstant {
        protected Attribute(String name) {
            super(name);
        }
    }

    private static class AttributeKey {
        final Target targetType;
        final int index;
        final Attribute attribute;

        public AttributeKey(Target type, int idx, Attribute key) {
            this.targetType = type;
            this.index = idx;
            this.attribute = key;
        }

        public int hashCode() {
            return (this.targetType.hashCode() * 37 + this.index) * 37 + this.attribute.hashCode();
        }

        public boolean equals(Object x) {
            AttributeKey other = (AttributeKey)x;
            return this.targetType.equals(other.targetType) && this.index == other.index && this.attribute.equals(other.attribute);
        }
    }

    private static class Target
    extends NamedConstant {
        protected Target(String name) {
            super(name);
        }
    }
}

