/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.List;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.Complex;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;

public class Vector
extends ArithmeticBase
implements IArithmetic {
    final Matrix coords;
    final int dimension;

    public Vector(Matrix matrix) {
        int n;
        if (matrix.numberOfRows() != 1) {
            throw new IllegalArgumentException("matrix must have exactly 1 row");
        }
        this.dimension = n = matrix.numberOfColumns();
        this.coords = new Matrix(1, n + 1);
        this.coords.setSubMatrix(0, 0, matrix);
        this.coords.set(0, n, Whole.ZERO);
    }

    public Vector(IArithmetic[] iArithmeticArray) {
        this(new Matrix(new IArithmetic[][]{iArithmeticArray}));
    }

    public Vector(int[] nArray) {
        this(new Matrix(new int[][]{nArray}));
    }

    public Vector(double[] dArray) {
        this(new Matrix(new double[][]{dArray}));
    }

    public Vector(int n, int n2) {
        this(new int[]{n, n2});
    }

    public Vector(int n, int n2, int n3) {
        this(new int[]{n, n2, n3});
    }

    public Vector(IArithmetic iArithmetic, IArithmetic iArithmetic2) {
        this(new IArithmetic[]{iArithmetic, iArithmetic2});
    }

    public Vector(IArithmetic iArithmetic, IArithmetic iArithmetic2, IArithmetic iArithmetic3) {
        this(new IArithmetic[]{iArithmetic, iArithmetic2, iArithmetic3});
    }

    public Vector(Vector vector) {
        this.dimension = vector.dimension;
        this.coords = vector.coords;
    }

    Vector(Vector vector, Matrix matrix) {
        this(Vector.image(vector, matrix));
    }

    public double[] asDoubleArray() {
        double[] dArray = new double[this.getDimension()];
        for (int i = 0; i < this.getDimension(); ++i) {
            dArray[i] = ((Real)this.get(i)).doubleValue();
        }
        return dArray;
    }

    private static Matrix image(Vector vector, Matrix matrix) {
        int n = vector.getDimension();
        if (n != matrix.numberOfRows() - 1 || n != matrix.numberOfColumns() - 1) {
            throw new IllegalArgumentException("dimensions don't match");
        }
        Matrix matrix2 = (Matrix)vector.coords.times(matrix);
        if (!matrix2.get(0, n).isZero()) {
            throw new UnsupportedOperationException("the operation did not produce a vector");
        }
        return matrix2.getSubMatrix(0, 0, 1, n);
    }

    public static Vector zero(int n) {
        return new Vector(Matrix.zero(1, n));
    }

    public static Vector unit(int n, int n2) {
        int[] nArray = new int[n];
        nArray[n2] = 1;
        return new Vector(nArray);
    }

    public static Vector unit(Vector vector) {
        IArithmetic iArithmetic = Vector.dot(vector, vector);
        if (iArithmetic instanceof Real) {
            return (Vector)vector.dividedBy(((Real)iArithmetic).sqrt());
        }
        throw new IllegalArgumentException("cannot take square root");
    }

    public static IArithmetic dot(Vector vector, Vector vector2, Matrix matrix) {
        int n = vector.getDimension();
        if (vector2.getDimension() != n || matrix.numberOfRows() != n || matrix.numberOfColumns() != n) {
            throw new IllegalArgumentException("dimensions do not match");
        }
        if (!matrix.equals(matrix.transposed())) {
            throw new IllegalArgumentException("matrix must be symmetric, but was " + matrix);
        }
        Matrix matrix2 = vector.getCoordinates();
        Matrix matrix3 = vector2.getCoordinates();
        return ((Matrix)matrix2.times(matrix).times(matrix3.transposed())).get(0, 0);
    }

    public static IArithmetic dot(Vector vector, Vector vector2) {
        if (vector.getDimension() != vector2.getDimension()) {
            throw new IllegalArgumentException("dimensions do not match");
        }
        Matrix matrix = vector.getCoordinates();
        Matrix matrix2 = vector2.getCoordinates();
        return ((Matrix)matrix.times(matrix2.transposed())).get(0, 0);
    }

    public static Vector crossProduct3D(Vector vector, Vector vector2) {
        if (vector.getDimension() != 3 || vector2.getDimension() != 3) {
            throw new IllegalArgumentException("both vectors must be 3-dimensional");
        }
        IArithmetic iArithmetic = vector.get(0);
        IArithmetic iArithmetic2 = vector.get(1);
        IArithmetic iArithmetic3 = vector.get(2);
        IArithmetic iArithmetic4 = vector2.get(0);
        IArithmetic iArithmetic5 = vector2.get(1);
        IArithmetic iArithmetic6 = vector2.get(2);
        IArithmetic iArithmetic7 = iArithmetic2.times(iArithmetic6).minus(iArithmetic3.times(iArithmetic5));
        IArithmetic iArithmetic8 = iArithmetic3.times(iArithmetic4).minus(iArithmetic.times(iArithmetic6));
        IArithmetic iArithmetic9 = iArithmetic.times(iArithmetic5).minus(iArithmetic2.times(iArithmetic4));
        return new Vector(new IArithmetic[]{iArithmetic7, iArithmetic8, iArithmetic9});
    }

    public static IArithmetic volume3D(Vector vector, Vector vector2, Vector vector3) {
        return Vector.dot(vector, Vector.crossProduct3D(vector2, vector3));
    }

    public static IArithmetic area2D(Vector vector, Vector vector2) {
        if (vector.getDimension() != 2 || vector2.getDimension() != 2) {
            throw new IllegalArgumentException("both vectors must be 2-dimensional");
        }
        IArithmetic iArithmetic = vector.get(0);
        IArithmetic iArithmetic2 = vector.get(1);
        IArithmetic iArithmetic3 = vector2.get(0);
        IArithmetic iArithmetic4 = vector2.get(1);
        return iArithmetic.times(iArithmetic4).minus(iArithmetic2.times(iArithmetic3));
    }

    public boolean isCollinearTo(Vector vector) {
        int n = vector.getDimension();
        if (this.getDimension() != n) {
            throw new UnsupportedOperationException("dimensions must be equal");
        }
        for (int i = 0; i < n; ++i) {
            if (this.get(i).isZero()) continue;
            IArithmetic iArithmetic = vector.get(i).dividedBy(this.get(i));
            return vector.equals(this.times(iArithmetic));
        }
        return false;
    }

    public boolean isOrthogonalTo(Vector vector) {
        return Vector.dot(this, vector).isZero();
    }

    public int getDimension() {
        return this.dimension;
    }

    public IArithmetic get(int n) {
        if (n < 0 || n > this.getDimension()) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.coords.get(0, n);
    }

    public IArithmetic __getitem__(int n) {
        return this.get(n);
    }

    public Matrix getCoordinates() {
        return this.coords.getSubMatrix(0, 0, 1, this.getDimension());
    }

    public Vector modZ() {
        IArithmetic[] iArithmeticArray = new Rational[this.getDimension()];
        for (int i = 0; i < this.getDimension(); ++i) {
            iArithmeticArray[i] = (Real)((Real)this.get(i)).mod(1L);
        }
        return new Vector(iArithmeticArray);
    }

    public boolean isIntegral() {
        for (int i = 0; i < this.getDimension(); ++i) {
            if (this.get(i) instanceof Whole) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            if (this.getDimension() != vector.getDimension()) {
                throw new IllegalArgumentException("dimensions must be equal");
            }
            for (int i = 0; i < this.getDimension(); ++i) {
                int n = this.get(i).compareTo(vector.get(i));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
        throw new IllegalArgumentException("can only compare two vectors");
    }

    @Override
    public IArithmetic floor() {
        throw new UnsupportedOperationException("not defined on vectors");
    }

    @Override
    public int hashCode() {
        return this.getCoordinates().hashCode();
    }

    @Override
    public IArithmetic inverse() {
        throw new UnsupportedOperationException("not defined on vectors");
    }

    @Override
    public boolean isExact() {
        return this.coords.isExact();
    }

    @Override
    public IArithmetic negative() {
        return new Vector((Matrix)this.getCoordinates().negative());
    }

    @Override
    public IArithmetic one() {
        throw new UnsupportedOperationException("not defined on vectors");
    }

    @Override
    public IArithmetic plus(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            return new Vector((Matrix)this.getCoordinates().plus(vector.getCoordinates()));
        }
        if (object instanceof Point) {
            Point point = (Point)object;
            return new Point((Matrix)this.getCoordinates().plus(point.getCoordinates()));
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof Operator) {
            return new Vector(this, ((Operator)object).getCoordinates());
        }
        if (object instanceof Complex) {
            return new Vector((Matrix)this.getCoordinates().times(object));
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic rtimes(IArithmetic iArithmetic) {
        if (iArithmetic instanceof Complex) {
            return new Vector((Matrix)this.getCoordinates().times(iArithmetic));
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Vector(");
        for (int i = 0; i < this.getDimension(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (this.get(i) == null) continue;
            stringBuffer.append(this.get(i).toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public IArithmetic zero() {
        return new Vector((Matrix)this.getCoordinates().zero());
    }

    public static Vector[] rowVectors(Matrix matrix) {
        return Vector.fromMatrix(matrix);
    }

    public static Vector[] fromMatrix(Matrix matrix) {
        int n = matrix.numberOfRows();
        Vector[] vectorArray = new Vector[n];
        for (int i = 0; i < n; ++i) {
            vectorArray[i] = new Vector(matrix.getRow(i));
        }
        return vectorArray;
    }

    public static Matrix toMatrix(Vector[] vectorArray) {
        int n = vectorArray.length;
        int n2 = vectorArray[0].dimension;
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            matrix.setRow(i, vectorArray[i].getCoordinates());
        }
        matrix.makeImmutable();
        return matrix;
    }

    public static Matrix toMatrix(List<Vector> list) {
        int n = list.size();
        if (n == 0) {
            return new Matrix(0, 0);
        }
        int n2 = list.get((int)0).dimension;
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            matrix.setRow(i, list.get(i).getCoordinates());
        }
        matrix.makeImmutable();
        return matrix;
    }
}

