/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;

public class TestVector
extends TestCase {
    final Vector v = new Vector(1, 2, 3);
    final Vector w = new Vector(new double[]{1.0, 2.0, 4.0});
    final Matrix M;

    public TestVector() {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[]{1, 3, 2, 2};
        this.M = new Matrix(nArrayArray);
    }

    public void testHashCode() {
        Vector a = new Vector(1, 2, 3);
        Vector b = new Vector(1, 2, 4);
        TestVector.assertEquals((int)this.v.hashCode(), (int)a.hashCode());
        TestVector.assertFalse((this.v.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    public void testIsExact() {
        TestVector.assertTrue((boolean)this.v.isExact());
        TestVector.assertFalse((boolean)this.w.isExact());
    }

    public void testIsIntegral() {
        Vector u = new Vector(2, 4, 8);
        TestVector.assertTrue((boolean)this.v.isIntegral());
        TestVector.assertFalse((boolean)this.w.isIntegral());
        TestVector.assertFalse((boolean)((Vector)this.v.dividedBy(2L)).isIntegral());
        TestVector.assertTrue((boolean)((Vector)u.dividedBy(2L)).isIntegral());
    }

    public void testZero() {
        Vector z = new Vector(0, 0, 0);
        TestVector.assertEquals((Object)z, (Object)this.v.zero());
    }

    public void testUnit() {
        TestVector.assertEquals((Object)new Vector(0, 1, 0), (Object)Vector.unit(3, 1));
        TestVector.assertEquals((Object)new Vector(1, 0, 0), (Object)Vector.unit(3, 0));
    }

    public void testOne() {
        try {
            this.v.one();
            TestVector.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testNegative() {
        Vector n = new Vector(-1, -2, -3);
        TestVector.assertEquals((Object)n, (Object)this.v.negative());
    }

    public void testInverse() {
        try {
            this.v.inverse();
            TestVector.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testPlus() {
        Vector s = new Vector(new double[]{2.0, 4.0, 7.0});
        Point p = new Point(new double[]{1.0, 2.0, 4.0});
        Point q = new Point(new double[]{2.0, 4.0, 7.0});
        TestVector.assertEquals((Object)s, (Object)this.v.plus(this.w));
        TestVector.assertEquals((Object)q, (Object)this.v.plus(p));
    }

    public void testTimes() {
        Vector a = new Vector(new double[]{1.5, 0.5, 1.0});
        TestVector.assertEquals((Object)a, (Object)this.v.times(new Operator(this.M)));
    }

    public void testCompareTo() {
        Vector a = new Vector(1, 2, 3);
        TestVector.assertTrue((this.v.compareTo(this.w) < 0 ? 1 : 0) != 0);
        TestVector.assertTrue((this.w.compareTo(this.v) > 0 ? 1 : 0) != 0);
        TestVector.assertTrue((this.v.compareTo(a) == 0 ? 1 : 0) != 0);
    }

    public void testFloor() {
        try {
            this.v.floor();
            TestVector.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToString() {
        String s = "Vector(1,2,3)";
        TestVector.assertEquals((String)"Vector(1,2,3)", (String)this.v.toString());
    }

    public void testVectorMatrix() {
        Vector a = new Vector(new Matrix(new int[][]{{1, 2, 3}}));
        TestVector.assertEquals((Object)this.v, (Object)a);
    }

    public void testVectorIArithmeticArray() {
        Vector a = new Vector(new IArithmetic[]{new Whole(1L), new Whole(2L), new Whole(3L)});
        TestVector.assertEquals((Object)this.v, (Object)a);
    }

    public void testVectorIntArray() {
        Vector a = new Vector(new int[]{1, 2, 3});
        TestVector.assertEquals((Object)this.v, (Object)a);
    }

    public void testVectorDoubleArray() {
        Vector a = new Vector(new double[]{1.0, 2.0, 4.0});
        TestVector.assertEquals((Object)this.w, (Object)a);
    }

    public void testVectorVector() {
        Vector a = new Vector(this.v);
        TestVector.assertEquals((Object)this.v, (Object)a);
    }

    public void testGetDimension() {
        TestVector.assertEquals((int)3, (int)this.v.getDimension());
    }

    public void testGet() {
        TestVector.assertEquals((Object)new Whole(2L), (Object)this.v.get(1));
    }

    public void testGetCoordinates() {
        Matrix A = new Matrix(new int[][]{{1, 2, 3}});
        TestVector.assertEquals((Object)A, (Object)this.v.getCoordinates());
    }

    public void testAsDoubleArray() {
        double[] c = this.v.asDoubleArray();
        TestVector.assertEquals((int)3, (int)c.length);
        TestVector.assertEquals((Object)1.0, (Object)c[0]);
        TestVector.assertEquals((Object)2.0, (Object)c[1]);
        TestVector.assertEquals((Object)3.0, (Object)c[2]);
    }

    public void testStaticZero() {
        Vector z = new Vector(Matrix.zero(1, 5));
        TestVector.assertEquals((Object)z, (Object)Vector.zero(5));
    }

    public void testDot() {
        TestVector.assertEquals((Object)new FloatingPoint(17.0), (Object)Vector.dot(this.v, this.w));
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        Matrix form = new Matrix(nArrayArray);
        TestVector.assertEquals((Object)new FloatingPoint(7.0), (Object)Vector.dot(this.v, this.w, form));
    }

    public void testRowVectors() {
        Matrix A = new Matrix(new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}, {13, 14, 15, 16}});
        Vector[] r = new Vector[]{new Vector(new int[]{1, 2, 3, 4}), new Vector(new int[]{5, 6, 7, 8}), new Vector(new int[]{9, 10, 11, 12}), new Vector(new int[]{13, 14, 15, 16})};
        Vector[] rows = Vector.rowVectors(A);
        TestVector.assertEquals((Object)r[0], (Object)rows[0]);
        TestVector.assertEquals((Object)r[1], (Object)rows[1]);
        TestVector.assertEquals((Object)r[2], (Object)rows[2]);
        TestVector.assertEquals((Object)r[3], (Object)rows[3]);
    }

    public void testIsCollinearTo() {
        Vector u = new Vector(new int[]{-2, -4, -6});
        TestVector.assertTrue((boolean)u.isCollinearTo(this.v));
        TestVector.assertFalse((boolean)u.isCollinearTo(this.w));
        TestVector.assertFalse((boolean)this.v.isCollinearTo(this.w));
    }

    public void testCrossProduct3D() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = -1;
        TestVector.assertEquals((Object)new Vector(nArray), (Object)Vector.crossProduct3D(this.v, this.w));
        int[] nArray2 = new int[3];
        nArray2[0] = -2;
        nArray2[1] = 1;
        TestVector.assertEquals((Object)new Vector(nArray2), (Object)Vector.crossProduct3D(this.w, this.v));
    }

    public void testVolume3D() {
        Vector u = new Vector(new int[]{1, 1, 1});
        TestVector.assertEquals((Object)new Whole(1L), (Object)Vector.volume3D(u, this.v, this.w));
    }

    public void testFromMatrix() {
        Matrix A = new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}});
        Vector[] rows = Vector.fromMatrix(A);
        TestVector.assertEquals((Object)new Vector(new int[]{1, 2, 3}), (Object)rows[0]);
        TestVector.assertEquals((Object)new Vector(new int[]{4, 5, 6}), (Object)rows[1]);
        TestVector.assertEquals((Object)new Vector(new int[]{7, 8, 9}), (Object)rows[2]);
    }

    public void testToMatrix() {
        Matrix A = new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}});
        Vector[] rows = new Vector[]{new Vector(1, 2, 3), new Vector(4, 5, 6), new Vector(7, 8, 9)};
        TestVector.assertEquals((Object)A, (Object)Vector.toMatrix(rows));
        ArrayList<Vector> list = new ArrayList<Vector>();
        list.add(new Vector(1, 2, 3));
        list.add(new Vector(4, 5, 6));
        list.add(new Vector(7, 8, 9));
        TestVector.assertEquals((Object)A, (Object)Vector.toMatrix(list));
    }
}

