/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.OperatorType;
import org.gavrog.joss.geometry.SpaceGroup;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;

public class TestSpaceGroup
extends TestCase {
    private SpaceGroup Fddd;
    private SpaceGroup P31;
    private SpaceGroup c2mm;

    public void setUp() {
        this.Fddd = new SpaceGroup(3, "Fddd");
        this.P31 = new SpaceGroup(3, "P31");
        this.c2mm = new SpaceGroup(2, "c2mm");
    }

    public void tearDown() {
        this.Fddd = null;
        this.c2mm = null;
        this.P31 = null;
    }

    public void testSpaceGroupByName() {
        Iterator<String> iter = SpaceGroupCatalogue.allKnownSettings(3);
        while (iter.hasNext()) {
            new SpaceGroup(3, iter.next());
        }
        iter = SpaceGroupCatalogue.allKnownSettings(2);
        while (iter.hasNext()) {
            new SpaceGroup(2, iter.next());
        }
    }

    public void testSpaceGroupByFullOpsList() {
        new SpaceGroup(3, SpaceGroupCatalogue.operators(3, "Ia-3d"), false, true);
        new SpaceGroup(2, SpaceGroupCatalogue.operators(2, "p4gm"), false, true);
        LinkedList<Operator> L = new LinkedList<Operator>();
        L.add(new Operator("x,2y"));
        try {
            new SpaceGroup(2, L, false, false);
            TestSpaceGroup.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        L.clear();
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        L.add(new Operator(new Matrix(nArrayArray)));
        try {
            new SpaceGroup(2, L, false, false);
            TestSpaceGroup.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        L.clear();
        L.add(new Operator("1/2x,y"));
        try {
            new SpaceGroup(2, L, false, false);
            TestSpaceGroup.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        L.clear();
        Matrix B = Matrix.one(3).mutableClone();
        B.set(2, 1, new FloatingPoint(0.5));
        L.add(new Operator(B));
        try {
            new SpaceGroup(2, L, false, false);
            TestSpaceGroup.fail((String)"should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSpaceGroupByGenerators() {
        LinkedList<Operator> L = new LinkedList<Operator>();
        L.add(new Operator("-x,y"));
        L.add(new Operator("x,-y"));
        L.add(new Operator("x-1/2,y-1/2"));
        SpaceGroup G = new SpaceGroup(2, L, true, false);
        TestSpaceGroup.assertEquals((int)8, (int)G.getOperators().size());
    }

    public void testGetDimension() {
        LinkedList<Operator> L = new LinkedList<Operator>();
        L.add(Operator.identity(2));
        SpaceGroup G = new SpaceGroup(2, L, false, false);
        TestSpaceGroup.assertEquals((int)2, (int)G.getDimension());
    }

    public void testPrimitiveCell() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[2] = 2;
        nArrayArray[2] = nArray3;
        Matrix B = (Matrix)new Matrix(nArrayArray).dividedBy(2L);
        TestSpaceGroup.assertEquals((Object)B, (Object)this.Fddd.primitiveCell());
        int[][] nArrayArray2 = new int[2][];
        nArrayArray2[0] = new int[]{1, 1};
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        nArrayArray2[1] = nArray4;
        Matrix C = (Matrix)new Matrix(nArrayArray2).dividedBy(2L);
        TestSpaceGroup.assertEquals((Object)C, (Object)this.c2mm.primitiveCell());
    }

    public void testGetOperators() {
        TestSpaceGroup.assertEquals((int)32, (int)this.Fddd.getOperators().size());
    }

    public void testPrimitiveOperators() {
        Set<Operator> ops = this.Fddd.getOperators();
        Set<Operator> prim = this.Fddd.primitiveOperators();
        TestSpaceGroup.assertEquals((int)8, (int)prim.size());
        Iterator<Operator> iter = prim.iterator();
        while (iter.hasNext()) {
            TestSpaceGroup.assertTrue((boolean)ops.contains(iter.next()));
        }
    }

    private Operator diagonal(int a, int b, int c) {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[0] = a;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = b;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[2] = c;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[3] = 1;
        nArrayArray[3] = nArray4;
        return new Operator(nArrayArray);
    }

    public void testPrimitiveOperatorsSorted() {
        List<Operator> opsFddd = this.Fddd.primitiveOperatorsSorted();
        TestSpaceGroup.assertEquals((int)8, (int)opsFddd.size());
        TestSpaceGroup.assertEquals((Object)this.diagonal(-1, -1, -1), (Object)opsFddd.get(0).linearPart());
        TestSpaceGroup.assertEquals((Object)this.diagonal(-1, -1, 1), (Object)opsFddd.get(1).linearPart());
        TestSpaceGroup.assertEquals((Object)this.diagonal(-1, 1, -1), (Object)opsFddd.get(2).linearPart());
        TestSpaceGroup.assertEquals((Object)this.diagonal(-1, 1, 1), (Object)opsFddd.get(3).linearPart());
        TestSpaceGroup.assertEquals((Object)this.diagonal(1, -1, -1), (Object)opsFddd.get(4).linearPart());
        TestSpaceGroup.assertEquals((Object)this.diagonal(1, -1, 1), (Object)opsFddd.get(5).linearPart());
        TestSpaceGroup.assertEquals((Object)this.diagonal(1, 1, -1), (Object)opsFddd.get(6).linearPart());
        TestSpaceGroup.assertEquals((Object)this.diagonal(1, 1, 1), (Object)opsFddd.get(7).linearPart());
        List<Operator> opsP31 = this.P31.primitiveOperatorsSorted();
        TestSpaceGroup.assertEquals((int)3, (int)opsP31.size());
        TestSpaceGroup.assertEquals((Object)new Operator("y-x,-x,z"), (Object)opsP31.get(0).linearPart());
        TestSpaceGroup.assertEquals((Object)new Operator("-y,x-y,z"), (Object)opsP31.get(1).linearPart());
        TestSpaceGroup.assertEquals((Object)new Operator("x,y,z"), (Object)opsP31.get(2).linearPart());
    }

    public void testOperatorsByType() {
        Map<OperatorType, Set<Operator>> map = this.c2mm.primitiveOperatorsByType();
        TestSpaceGroup.assertEquals((int)3, (int)map.size());
        Set<Operator> ops = map.get(new OperatorType(2, true, 1, true));
        TestSpaceGroup.assertEquals((int)1, (int)ops.size());
        ops = map.get(new OperatorType(2, true, 2, true));
        TestSpaceGroup.assertEquals((int)1, (int)ops.size());
        ops = map.get(new OperatorType(2, false, 2, false));
        TestSpaceGroup.assertEquals((int)2, (int)ops.size());
        map = this.Fddd.primitiveOperatorsByType();
        TestSpaceGroup.assertEquals((int)4, (int)map.size());
        ops = map.get(new OperatorType(3, true, 1, true));
        TestSpaceGroup.assertEquals((int)1, (int)ops.size());
        ops = map.get(new OperatorType(3, false, 1, true));
        TestSpaceGroup.assertEquals((int)1, (int)ops.size());
        ops = map.get(new OperatorType(3, true, 2, true));
        TestSpaceGroup.assertEquals((int)3, (int)ops.size());
        ops = map.get(new OperatorType(3, false, 2, true));
        TestSpaceGroup.assertEquals((int)3, (int)ops.size());
        map = this.P31.primitiveOperatorsByType();
        TestSpaceGroup.assertEquals((int)3, (int)map.size());
        ops = map.get(new OperatorType(3, true, 1, true));
        TestSpaceGroup.assertEquals((int)1, (int)ops.size());
        ops = map.get(new OperatorType(3, true, 3, true));
        TestSpaceGroup.assertEquals((int)1, (int)ops.size());
        ops = map.get(new OperatorType(3, true, 3, false));
        TestSpaceGroup.assertEquals((int)1, (int)ops.size());
    }
}

