/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import junit.framework.TestCase;
import org.gavrog.box.simple.DataFormatException;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;

public class TestOperator
extends TestCase {
    final int[][] M;
    final Operator op1;

    public TestOperator() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        this.M = nArrayArray;
        this.op1 = new Operator(this.M);
    }

    public void testHashCode() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] A = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = 1;
        nArrayArray2[1] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = 1;
        nArrayArray2[2] = nArray6;
        int[][] B = nArrayArray2;
        Operator opA = new Operator(A);
        Operator opB = new Operator(B);
        TestOperator.assertEquals((int)this.op1.hashCode(), (int)opA.hashCode());
        TestOperator.assertFalse((this.op1.hashCode() == opB.hashCode() ? 1 : 0) != 0);
    }

    public void testIsExact() {
        double[][] A = new double[][]{{0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}};
        Operator opA = new Operator(A);
        TestOperator.assertTrue((boolean)this.op1.isExact());
        TestOperator.assertFalse((boolean)opA.isExact());
    }

    public void testZero() {
        try {
            this.op1.zero();
            TestOperator.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testOne() {
        TestOperator.assertEquals((Object)this.op1, (Object)this.op1.times(this.op1.one()));
    }

    public void testNegative() {
        try {
            this.op1.negative();
            TestOperator.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testInverse() {
        TestOperator.assertEquals((Object)this.op1.one(), (Object)this.op1.times(this.op1.inverse()));
    }

    public void testIdentity() {
        TestOperator.assertEquals((Object)new Operator("x,y,z"), (Object)Operator.identity(3));
    }

    public void testPlus() {
        try {
            this.op1.plus(this.op1);
            TestOperator.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testTimes() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = -1;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{1, 1, 1};
        int[][] A = nArrayArray;
        Operator opA = new Operator(A);
        TestOperator.assertEquals((Object)opA, (Object)this.op1.times(this.op1));
        TestOperator.assertEquals((Object)new Operator("3-x,-y"), (Object)opA.times(new Vector(2, -1)));
    }

    public void testCompareTo() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 2;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] A = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[0] = -1;
        nArrayArray2[1] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[2] = 1;
        nArrayArray2[2] = nArray6;
        int[][] B = nArrayArray2;
        Operator opA = new Operator(A);
        Operator opB = new Operator(B);
        TestOperator.assertTrue((this.op1.compareTo(opA) < 0 ? 1 : 0) != 0);
        TestOperator.assertTrue((opA.compareTo(this.op1) > 0 ? 1 : 0) != 0);
        TestOperator.assertTrue((opB.compareTo(this.op1) == 0 ? 1 : 0) != 0);
    }

    public void testFloor() {
        try {
            this.op1.floor();
            TestOperator.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testModZ() {
        double[][] A = new double[][]{{0.0, 1.1, 0.0}, {-1.0, 0.0, 0.0}, {1.25, 0.0, 1.0}};
        double[][] B = new double[][]{{0.0, 1.1, 0.0}, {-1.0, 0.0, 0.0}, {0.25, 0.0, 1.0}};
        Operator opA = new Operator(A);
        Operator opB = new Operator(B);
        TestOperator.assertEquals((Object)opB, (Object)opA.modZ());
    }

    public void testFloorZ() {
        double[][] A = new double[][]{{0.0, 1.1, 0.0}, {-1.0, 0.0, 0.0}, {-1.25, 0.0, 1.0}};
        Operator opA = new Operator(A);
        Vector v = new Vector(-2, 0);
        TestOperator.assertEquals((Object)v, (Object)opA.floorZ());
    }

    public void testToString() {
        String s = "Operator([[0,1,0],[-1,0,0],[1,0,1]])";
        TestOperator.assertEquals((String)"Operator([[0,1,0],[-1,0,0],[1,0,1]])", (String)this.op1.toString());
    }

    public void testOperatorMatrix() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 2;
        nArray3[2] = 2;
        nArrayArray[2] = nArray3;
        Matrix A = new Matrix(nArrayArray);
        Operator opA = new Operator(A);
        TestOperator.assertEquals((Object)this.op1, (Object)opA);
    }

    public void testOperatorIArithmeticArrayArray() {
        IArithmetic[][] A = new IArithmetic[][]{{Whole.ZERO, Whole.ONE, Whole.ZERO}, {new Whole(-1L), Whole.ZERO, Whole.ZERO}, {Whole.ONE, Whole.ZERO, Whole.ONE}};
        Operator opA = new Operator(A);
        TestOperator.assertEquals((Object)this.op1, (Object)opA);
    }

    public void testOperatorIntArrayArray() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] A = nArrayArray;
        Operator opA = new Operator(A);
        TestOperator.assertEquals((Object)this.op1, (Object)opA);
    }

    public void testOperatorDoubleArrayArray() {
        double[][] A = new double[][]{{0.0, 1.0, 0.0}, {-1.0, 0.0, 0.0}, {1.0, 0.0, 1.0}};
        Operator opA = new Operator(A);
        TestOperator.assertEquals((Object)this.op1, (Object)opA);
    }

    public void testOperatorString() {
        Operator opA = new Operator("1-y,x");
        TestOperator.assertEquals((Object)this.op1, (Object)opA);
    }

    public void testOperatorVector() {
        Vector s = new Vector(1, -2, 3);
        TestOperator.assertEquals((Object)new Operator("x+1,y-2,z+3"), (Object)new Operator(s));
    }

    public void testGetDimension() {
        TestOperator.assertEquals((int)2, (int)this.op1.getDimension());
    }

    public void testGet() {
        TestOperator.assertEquals((Object)new Whole(-1L), (Object)this.op1.get(1, 0));
    }

    public void testGetCoordinates() {
        TestOperator.assertEquals((Object)new Matrix(this.M), (Object)this.op1.getCoordinates());
    }

    public void testLinearPart() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[][] A = nArrayArray;
        Operator opA = new Operator(A);
        TestOperator.assertEquals((Object)opA, (Object)this.op1.linearPart());
    }

    public void testLinearPartAsMatrix() {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = -1;
        nArrayArray[1] = nArray2;
        Matrix A = new Matrix(nArrayArray);
        TestOperator.assertEquals((Object)A, (Object)this.op1.linearPartAsMatrix());
    }

    public void testTranslationalPart() {
        int[] nArray = new int[2];
        nArray[0] = 1;
        Vector v = new Vector(nArray);
        TestOperator.assertEquals((Object)v, (Object)this.op1.translationalPart());
    }

    public void testApplyTo() {
        int[] nArray = new int[2];
        nArray[0] = 1;
        Point x = new Point(nArray);
        Point xy = new Point(new int[]{1, 1});
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        Point y = new Point(nArray2);
        Point z = new Point(new int[2]);
        TestOperator.assertEquals((Object)xy, (Object)this.op1.applyTo(x));
        TestOperator.assertEquals((Object)y, (Object)this.op1.applyTo(xy));
        TestOperator.assertEquals((Object)z, (Object)this.op1.applyTo(y));
        TestOperator.assertEquals((Object)x, (Object)this.op1.applyTo(z));
    }

    public void testParseOperator() {
        String s = "x-4y+7*z-10, +5/3y-8z+11-2x, +3*x+ 9z-6y - 12";
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = -2;
        nArray[2] = 3;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = -4;
        nArray2[1] = 5;
        nArray2[2] = -6;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 7;
        nArray3[1] = -8;
        nArray3[2] = 9;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[]{-10, 11, -12, 1};
        Matrix M = new Matrix(nArrayArray).mutableClone();
        M.set(1, 1, new Fraction(5L, 3L));
        TestOperator.assertEquals((Object)M, (Object)Operator.parse(s));
        TestOperator.assertFalse((boolean)Operator.parse(s).isMutable());
        TestOperator.assertEquals((Object)Matrix.one(4), (Object)Operator.parse("x,y,z"));
        try {
            Operator.parse("1,2,3,4");
            TestOperator.fail((String)"should throw an DataFormatException");
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        try {
            Operator.parse("a,2,3");
            TestOperator.fail((String)"should throw an DataFormatException");
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        try {
            Operator.parse("1,2/,3");
            TestOperator.fail((String)"should throw an DataFormatException");
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
        try {
            Operator.parse("x+3x,2,3");
            TestOperator.fail((String)"should throw an DataFormatException");
        }
        catch (DataFormatException dataFormatException) {
            // empty catch block
        }
    }

    public void testLinearAxis() {
        Operator op1 = new Operator("-y,x");
        Operator op2 = new Operator("y,x");
        Operator op3 = new Operator("z,x,y");
        Operator op4 = new Operator("y,z,x");
        Operator op5 = new Operator("x,y");
        Operator op6 = new Operator("x,y,z");
        Operator op7 = new Operator("y,-x");
        Operator op8 = new Operator("-y,-z,-x");
        Operator op9 = new Operator("-y,x-y,z");
        TestOperator.assertNull((Object)op1.linearAxis());
        TestOperator.assertTrue((boolean)op2.linearAxis().isCollinearTo(new Vector(new int[]{1, 1})));
        TestOperator.assertTrue((boolean)op3.linearAxis().isCollinearTo(new Vector(new int[]{1, 1, 1})));
        TestOperator.assertTrue((boolean)op4.linearAxis().isCollinearTo(new Vector(new int[]{1, 1, 1})));
        TestOperator.assertNull((Object)op5.linearAxis());
        TestOperator.assertNull((Object)op6.linearAxis());
        TestOperator.assertNull((Object)op7.linearAxis());
        TestOperator.assertTrue((boolean)op8.linearAxis().isCollinearTo(new Vector(new int[]{1, 1, 1})));
        int[] nArray = new int[3];
        nArray[2] = 1;
        TestOperator.assertTrue((boolean)op9.linearAxis().isCollinearTo(new Vector(nArray)));
    }

    public void testOrthogonalProjection() {
        Matrix I = Matrix.one(3);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        TestOperator.assertEquals((Object)new Operator("x, y, 0"), (Object)Operator.orthogonalProjection(new Matrix(nArrayArray), I));
        Operator op1 = new Operator("1/3x+1/3y+1/3z, 1/3x+1/3y+1/3z, 1/3x+1/3y+1/3z");
        Operator op2 = Operator.orthogonalProjection(new Matrix(new int[][]{{1, 1, 1}}), I);
        Matrix D = (Matrix)op1.getCoordinates().minus(op2.getCoordinates());
        TestOperator.assertTrue((boolean)D.norm().isLessThan(new FloatingPoint(1.0E-10)));
    }
}

