/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import junit.framework.TestCase;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;

public class TestCoordinateChange
extends TestCase {
    final Matrix M;
    final Point p;
    final CoordinateChange T;

    public TestCoordinateChange() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        this.M = new Matrix(nArrayArray);
        this.p = new Point(new int[]{-1, 1, 1});
        this.T = new CoordinateChange(this.M, this.p);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testHashCode() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        Matrix A = new Matrix(nArrayArray);
        Point q = new Point(new int[]{-1, 1, 1});
        TestCoordinateChange.assertEquals((int)this.T.hashCode(), (int)new CoordinateChange(A, q).hashCode());
    }

    public void testIsExact() {
        TestCoordinateChange.assertTrue((boolean)this.T.isExact());
        Point q = new Point(new double[]{-1.0, 1.0, 1.0});
        TestCoordinateChange.assertFalse((boolean)new CoordinateChange(this.M, q).isExact());
    }

    public void testZero() {
        try {
            this.T.zero();
            TestCoordinateChange.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testOne() {
        TestCoordinateChange.assertEquals((Object)this.T, (Object)this.T.times(this.T.one()));
    }

    public void testNegative() {
        try {
            this.T.negative();
            TestCoordinateChange.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testInverse() {
        TestCoordinateChange.assertEquals((Object)this.T.one(), (Object)this.T.times(this.T.inverse()));
    }

    public void testPlus() {
        try {
            this.T.plus(this.T);
            TestCoordinateChange.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testTimes() {
        Point o = Point.origin(3);
        TestCoordinateChange.assertEquals((Object)o, (Object)this.p.times(this.T));
        int[] nArray = new int[3];
        nArray[1] = 2;
        Vector v = new Vector(nArray);
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        Vector w = new Vector(nArray2);
        TestCoordinateChange.assertEquals((Object)w, (Object)v.times(this.T));
        Operator op1 = new Operator("-x, y, z");
        Operator op2 = new Operator("x, y, 2-z");
        TestCoordinateChange.assertEquals((Object)op2, (Object)op1.times(this.T));
        int[][] nArrayArray = new int[3][];
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArrayArray[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 2;
        nArrayArray[1] = nArray4;
        int[] nArray5 = new int[3];
        nArray5[2] = 1;
        nArrayArray[2] = nArray5;
        Matrix A = new Matrix(nArrayArray);
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        Point q = new Point(nArray6);
        int[][] nArrayArray2 = new int[3][];
        int[] nArray7 = new int[3];
        nArray7[1] = 2;
        nArrayArray2[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[2] = 2;
        nArrayArray2[1] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[0] = 1;
        nArrayArray2[2] = nArray9;
        Matrix B = new Matrix(nArrayArray2);
        Point r = new Point(new int[]{-1, 3, 1});
        TestCoordinateChange.assertEquals((Object)new CoordinateChange(B, r), (Object)this.T.times(new CoordinateChange(A, q)));
    }

    public void testCompareTo() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        int[][] A = nArrayArray;
        Point q = new Point(new int[]{-1, 1, 1});
        TestCoordinateChange.assertEquals((int)0, (int)this.T.compareTo(new CoordinateChange(new Matrix(A), q)));
        Point r = new Point(new int[]{-1, 1, 2});
        TestCoordinateChange.assertTrue((this.T.compareTo(new CoordinateChange(new Matrix(A), r)) < 0 ? 1 : 0) != 0);
    }

    public void testFloor() {
        try {
            this.T.floor();
            TestCoordinateChange.fail((String)"should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToString() {
        String s = "CoordinateChange(Matrix([[0,2,0],[0,0,1],[1,0,0]]),Point(-1,1,1))";
        TestCoordinateChange.assertEquals((String)"CoordinateChange(Matrix([[0,2,0],[0,0,1],[1,0,0]]),Point(-1,1,1))", (String)this.T.toString());
    }

    public void testGetDimension() {
        TestCoordinateChange.assertEquals((int)3, (int)this.T.getDimension());
    }

    public void testGetBasis() {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArrayArray[2] = nArray3;
        int[][] A = nArrayArray;
        TestCoordinateChange.assertEquals((Object)new Matrix(A), (Object)this.T.getBasis());
    }

    public void testGetOrigin() {
        Point p = new Point(new int[]{-1, 1, 1});
        TestCoordinateChange.assertEquals((Object)p, (Object)this.T.getOrigin());
    }

    public void testConstructorFromOperator() {
        CoordinateChange S = new CoordinateChange(new Operator("z-1,2x+1,y+1"));
        TestCoordinateChange.assertEquals((Object)this.T.inverse(), (Object)S);
    }

    public void testConstructorWithoutOriginChange() {
        Point z = new Point(new int[3]);
        TestCoordinateChange.assertEquals((Object)new CoordinateChange(this.M), (Object)new CoordinateChange(this.M, z));
    }

    public void testPartialBasis() {
        int[][] A = new int[][]{{1, 1, 1}, {-1, 1, 1}};
        CoordinateChange C = new CoordinateChange(new Matrix(A));
        Point p = new Point(new int[]{1, 1, 1});
        int[] nArray = new int[3];
        nArray[0] = 1;
        Point pC = new Point(nArray);
        Point q = new Point(new int[]{-1, 1, 1});
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        Point qC = new Point(nArray2);
        TestCoordinateChange.assertEquals((Object)pC, (Object)p.times(C));
        TestCoordinateChange.assertEquals((Object)qC, (Object)q.times(C));
        TestCoordinateChange.assertEquals((Object)C.one(), (Object)C.times(C.inverse()));
        TestCoordinateChange.assertEquals((Object)C.one(), (Object)C.inverse().times(C));
    }
}

