/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.Complex;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Vector;

public class Point
extends ArithmeticBase
implements IArithmetic {
    final Matrix coords;
    final int dimension;

    public Point(Matrix matrix) {
        int n;
        if (matrix.numberOfRows() != 1) {
            throw new IllegalArgumentException("matrix must have exactly 1 row");
        }
        this.dimension = n = matrix.numberOfColumns();
        this.coords = new Matrix(1, n + 1);
        this.coords.setSubMatrix(0, 0, matrix);
        this.coords.set(0, n, Whole.ONE);
    }

    public Point(IArithmetic[] iArithmeticArray) {
        this(new Matrix(new IArithmetic[][]{iArithmeticArray}));
    }

    public Point(int[] nArray) {
        this(new Matrix(new int[][]{nArray}));
    }

    public Point(double[] dArray) {
        this(new Matrix(new double[][]{dArray}));
    }

    public Point(Point point) {
        this.dimension = point.dimension;
        this.coords = point.coords;
    }

    Point(Point point, Matrix matrix) {
        this(Point.image(point, matrix));
    }

    private static Matrix image(Point point, Matrix matrix) {
        int n = point.getDimension();
        if (n != matrix.numberOfRows() - 1 || n != matrix.numberOfColumns() - 1) {
            throw new IllegalArgumentException("dimensions don't match");
        }
        Matrix matrix2 = (Matrix)point.coords.times(matrix);
        IArithmetic iArithmetic = matrix2.get(0, n);
        return ((Matrix)matrix2.dividedBy(iArithmetic)).getSubMatrix(0, 0, 1, n);
    }

    public static Point origin(int n) {
        return new Point(Matrix.zero(1, n));
    }

    public int getDimension() {
        return this.dimension;
    }

    public IArithmetic get(int n) {
        if (n < 0 || n > this.getDimension()) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.coords.get(0, n);
    }

    public IArithmetic __getitem__(int n) {
        return this.get(n);
    }

    public Matrix getCoordinates() {
        return this.coords.getSubMatrix(0, 0, 1, this.getDimension());
    }

    public Point modZ() {
        IArithmetic[] iArithmeticArray = new Real[this.getDimension()];
        for (int i = 0; i < this.getDimension(); ++i) {
            iArithmeticArray[i] = (Real)((Real)this.get(i)).mod(1L);
        }
        return new Point(iArithmeticArray);
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Point) {
            Point point = (Point)object;
            if (this.getDimension() != point.getDimension()) {
                throw new IllegalArgumentException("dimensions must be equal");
            }
            for (int i = 0; i < this.getDimension(); ++i) {
                int n = this.get(i).compareTo(point.get(i));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
        throw new IllegalArgumentException("can only compare two points");
    }

    @Override
    public IArithmetic floor() {
        throw new UnsupportedOperationException("not defined on points");
    }

    @Override
    public int hashCode() {
        return this.getCoordinates().hashCode();
    }

    @Override
    public IArithmetic inverse() {
        throw new UnsupportedOperationException("not defined on points");
    }

    @Override
    public boolean isExact() {
        return this.coords.isExact();
    }

    @Override
    public IArithmetic negative() {
        throw new UnsupportedOperationException("not defined on points");
    }

    @Override
    public IArithmetic one() {
        throw new UnsupportedOperationException("not defined on points");
    }

    @Override
    public IArithmetic plus(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            return new Point((Matrix)this.getCoordinates().plus(vector.getCoordinates()));
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic minus(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            return new Point((Matrix)this.getCoordinates().minus(vector.getCoordinates()));
        }
        if (object instanceof Point) {
            Point point = (Point)object;
            return new Vector((Matrix)this.getCoordinates().minus(point.getCoordinates()));
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof Operator) {
            return new Point(this, ((Operator)object).getCoordinates());
        }
        if (object instanceof Complex) {
            return new Point((Matrix)this.getCoordinates().times(object));
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("Point(");
        for (int i = 0; i < this.getDimension(); ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            if (this.get(i) == null) continue;
            stringBuffer.append(this.get(i).toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public IArithmetic zero() {
        throw new UnsupportedOperationException("not defined on points");
    }
}

