/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.geometry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.Vector;

public class CoordinateChange
extends ArithmeticBase
implements IArithmetic {
    final Matrix left;
    final Matrix right;
    final int dimension;

    public CoordinateChange(Matrix matrix, Point point) {
        Matrix matrix2 = this.extendedToBasis(matrix);
        int n = matrix2.numberOfRows();
        this.left = new Matrix(n + 1, n + 1);
        this.left.setSubMatrix(0, 0, matrix2);
        this.left.setSubMatrix(n, 0, point.getCoordinates());
        this.left.setSubMatrix(0, n, Matrix.zero(n, 1));
        this.left.set(n, n, Whole.ONE);
        this.right = (Matrix)this.left.inverse();
        this.dimension = n;
    }

    public CoordinateChange(Matrix matrix) {
        this(matrix, new Point(Matrix.zero(1, matrix.numberOfColumns())));
    }

    public CoordinateChange(Operator operator) {
        this.right = operator.getCoordinates();
        this.left = (Matrix)this.right.inverse();
        this.dimension = operator.getDimension();
    }

    private CoordinateChange(Matrix matrix, Matrix matrix2) {
        int n = matrix.numberOfRows() - 1;
        this.left = matrix;
        this.right = matrix2;
        this.dimension = n;
    }

    private Matrix extendedToBasis(Matrix matrix) {
        Matrix matrix2;
        int n = matrix.numberOfColumns();
        int n2 = matrix.numberOfRows();
        int n3 = matrix.rank();
        if (!matrix.getSubMatrix(n3, 0, n2 - n3, n).isZero()) {
            throw new IllegalArgumentException("matrix does not represent a subspace basis");
        }
        if (n3 < n) {
            matrix2 = new Matrix(n, n);
            matrix2.setSubMatrix(0, 0, matrix.getSubMatrix(0, 0, n3, n));
            matrix2.setSubMatrix(n3, 0, Matrix.zero(n - n3, n));
            Matrix matrix3 = Matrix.one(n);
            for (int i = 0; i < n; ++i) {
                matrix2.setRow(n3, matrix3.getRow(i));
                if (matrix2.rank() <= n3 || ++n3 < n) {
                    continue;
                }
                break;
            }
        } else {
            matrix2 = matrix;
        }
        return matrix2;
    }

    @Override
    public boolean isExact() {
        return this.left.isExact();
    }

    @Override
    public IArithmetic zero() {
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic one() {
        int n = this.dimension;
        return new CoordinateChange(Matrix.one(n));
    }

    @Override
    public IArithmetic negative() {
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic inverse() {
        return new CoordinateChange(this.right, this.left);
    }

    @Override
    public IArithmetic plus(Object object) {
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof CoordinateChange) {
            CoordinateChange coordinateChange = (CoordinateChange)object;
            return new CoordinateChange((Matrix)coordinateChange.left.times(this.left), (Matrix)this.right.times(coordinateChange.right));
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public IArithmetic rtimes(IArithmetic iArithmetic) {
        if (iArithmetic instanceof Point) {
            return new Point((Point)iArithmetic, this.right);
        }
        if (iArithmetic instanceof Vector) {
            return new Vector((Vector)iArithmetic, this.right);
        }
        if (iArithmetic instanceof Operator) {
            Operator operator = (Operator)iArithmetic;
            return new Operator((Matrix)this.left.times(operator.getCoordinates()).times(this.right));
        }
        throw new UnsupportedOperationException("operation not defined");
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof CoordinateChange) {
            CoordinateChange coordinateChange = (CoordinateChange)object;
            int n = this.getDimension();
            if (n != coordinateChange.getDimension()) {
                throw new IllegalArgumentException("dimensions must be equal");
            }
            Matrix matrix = this.left;
            Matrix matrix2 = coordinateChange.left;
            for (int i = 0; i < n + 1; ++i) {
                for (int j = 0; j < n + 1; ++j) {
                    int n2 = matrix.get(i, j).compareTo(matrix2.get(i, j));
                    if (n2 == 0) continue;
                    return n2;
                }
            }
            return 0;
        }
        throw new IllegalArgumentException("illegal argument type");
    }

    @Override
    public IArithmetic floor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append("CoordinateChange(");
        stringBuffer.append(this.getBasis().toString());
        stringBuffer.append(",");
        stringBuffer.append(this.getOrigin().toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public int hashCode() {
        return this.left.hashCode();
    }

    public int getDimension() {
        return this.dimension;
    }

    public Matrix getBasis() {
        int n = this.getDimension();
        return this.left.getSubMatrix(0, 0, n, n);
    }

    public Point getOrigin() {
        int n = this.getDimension();
        return new Point(this.left.getSubMatrix(n, 0, 1, n));
    }

    public Operator getOperator() {
        return new Operator(this.right);
    }

    public List<Operator> applyTo(Collection<Operator> collection) {
        ArrayList<Operator> arrayList = new ArrayList<Operator>();
        for (Operator operator : collection) {
            arrayList.add((Operator)operator.times(this));
        }
        return arrayList;
    }
}

