/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.generators.CombineTiles;

public class TestCombineTiles
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testcomponentMultiplicities() {
        DSymbol ds = new DSymbol("12:2 4 6 8 10 12,3 2 4 8 7 11 10 12,2 4 6 8 10 12:4 4 4,4 4 4");
        Map<DelaneySymbol<Integer>, Integer> counts = CombineTiles.componentMultiplicities(ds);
        TestCombineTiles.assertEquals((Object)new Integer(2), (Object)counts.get(new DSymbol("4:2 4,3 2 4,2 4:4,4")));
        TestCombineTiles.assertEquals((Object)new Integer(1), (Object)counts.get(new DSymbol("4:2 4,4 3,2 4:4,4")));
    }

    public void testFirstRepresentatives() {
        CombineTiles.firstRepresentatives(new DSymbol("0::"));
        List<Integer> list = CombineTiles.firstRepresentatives(new DSymbol("1:1,1,1:3,3"));
        TestCombineTiles.assertEquals((int)1, (int)list.size());
        TestCombineTiles.assertTrue((boolean)list.contains(new Integer(1)));
        list = CombineTiles.firstRepresentatives(new DSymbol("4:2 4,3 2 4,2 4:4,4"));
        TestCombineTiles.assertEquals((int)2, (int)list.size());
        TestCombineTiles.assertTrue((boolean)list.contains(new Integer(1)));
        TestCombineTiles.assertTrue((boolean)list.contains(new Integer(2)));
        list = CombineTiles.firstRepresentatives(new DSymbol("4:2 4,4 3,2 4:4,4"));
        TestCombineTiles.assertEquals((int)1, (int)list.size());
        TestCombineTiles.assertTrue((boolean)list.contains(new Integer(1)));
    }

    public void testSubCanonicalForms() {
        DSymbol ds = new DSymbol("4:2 4,3 2 4,2 4:4,4");
        List<DSymbol> forms = CombineTiles.subCanonicalForms(ds);
        TestCombineTiles.assertEquals((int)2, (int)forms.size());
        LinkedList<String> strings = new LinkedList<String>();
        strings.add(((Object)forms.get(0)).toString());
        strings.add(((Object)forms.get(1)).toString());
        TestCombineTiles.assertTrue((boolean)strings.contains("<1.1:4:2 4,3 2 4,2 4:4,4>"));
        TestCombineTiles.assertTrue((boolean)strings.contains("<1.1:4:2 4,1 3 4,2 4:4,4>"));
    }

    public void testIterator1() {
        DSymbol ds = new DSymbol("3 2:1 2 3,1 3,2 3:6 4,3");
        CombineTiles iter = new CombineTiles(ds);
        TestCombineTiles.assertEquals((Object)new DSymbol("3 3:1 2 3,1 3,2 3,1 2 3:6 4,3,0 0"), iter.next());
        TestCombineTiles.assertEquals((Object)new DSymbol("3 3:1 2 3,1 3,2 3,1 3:6 4,3,0"), iter.next());
        TestCombineTiles.assertFalse((boolean)iter.hasNext());
    }

    public void testIterator2() {
        DSymbol ds = new DSymbol("6:2 4 6,6 3 5,2 4 6:3,3");
        CombineTiles iter = new CombineTiles(ds);
        TestCombineTiles.assertEquals((Object)new DSymbol("6 3:2 4 6,6 3 5,2 4 6,1 2 3 4 5 6:3,3,0 0 0"), iter.next());
        TestCombineTiles.assertEquals((Object)new DSymbol("6 3:2 4 6,6 3 5,2 4 6,2 6 5:3,3,0 0"), iter.next());
        TestCombineTiles.assertFalse((boolean)iter.hasNext());
    }

    public void testIterator3() {
        DSymbol ds = new DSymbol("2:1 2,1 2,1 2:3 3,3 4");
        CombineTiles iter = new CombineTiles(ds);
        TestCombineTiles.assertEquals((Object)new DSymbol("2 3:1 2,1 2,1 2,2:3 3,3 4,0"), iter.next());
        TestCombineTiles.assertFalse((boolean)iter.hasNext());
    }

    public void testIterator4() {
        DSymbol ds = new DSymbol("4:1 2 3 4,1 2 4,1 3 4:3 3 4,3 3");
        CombineTiles iter = new CombineTiles(ds);
        TestCombineTiles.assertEquals((Object)new DSymbol("4 3:1 2 3 4,2 3 4,1 3 4,1 2 4:4 3 3,3 3,0 0"), iter.next());
        TestCombineTiles.assertEquals((Object)new DSymbol("4 3:1 2 3 4,2 3 4,1 3 4,2 4:4 3 3,3 3,0"), iter.next());
        TestCombineTiles.assertFalse((boolean)iter.hasNext());
    }

    public void testResume1() {
        DSymbol ds = new DSymbol("6 1:2 4 6,6 3 5:3");
        CombineTiles iter = new CombineTiles(ds);
        iter.setResumePoint("2-3");
        TestCombineTiles.assertEquals((Object)new DSymbol("6:2 4 6,6 3 5,2 5 6:3,0"), iter.next());
        TestCombineTiles.assertEquals((Object)new DSymbol("6:2 4 6,6 3 5,2 6 5:3,0 0"), iter.next());
        TestCombineTiles.assertFalse((boolean)iter.hasNext());
    }

    public void testResume2() {
        DSymbol ds = new DSymbol("6 1:2 4 6,6 3 5:3");
        CombineTiles iter = new CombineTiles(ds);
        iter.setResumePoint("2-5");
        TestCombineTiles.assertEquals((Object)new DSymbol("6:2 4 6,6 3 5,2 5 6:3,0"), iter.next());
        TestCombineTiles.assertEquals((Object)new DSymbol("6:2 4 6,6 3 5,2 6 5:3,0 0"), iter.next());
        TestCombineTiles.assertFalse((boolean)iter.hasNext());
    }

    public void testResume3() {
        DSymbol ds = new DSymbol("6 1:2 4 6,6 3 5:3");
        CombineTiles iter = new CombineTiles(ds);
        iter.setResumePoint("3");
        TestCombineTiles.assertFalse((boolean)iter.hasNext());
    }

    public void testTetra() {
        DSymbol base = new DSymbol("1:1,1,1:3,3");
        DSymbol tetra = new DSymbol(Covers.finiteUniversalCover(base));
        this.doTest(tetra, 34, 29, false);
        this.doTest(base, 67, 49, true);
    }

    public void xtestCube() {
        DSymbol base = new DSymbol("1:1,1,1:4,3");
        DSymbol cube = new DSymbol(Covers.finiteUniversalCover(base));
        this.doTest(cube, 1360, 1224, false);
    }

    public void doTest(DSymbol ds, int xTotal, int xGood, boolean multi) {
        int total = 0;
        int good = 0;
        Iterator<DSCover<Integer>> bases = multi ? Covers.allCovers(ds) : Iterators.singleton(ds);
        while (bases.hasNext()) {
            DSymbol base = bases.next();
            CombineTiles exts = new CombineTiles(base);
            while (exts.hasNext()) {
                DSymbol out = (DSymbol)exts.next();
                if (xTotal < 0) {
                    System.out.println(ds);
                }
                out.setVDefaultToOne(true);
                ++total;
                if (!out.isLocallyEuclidean3D()) continue;
                ++good;
            }
        }
        if (xTotal >= 0) {
            TestCombineTiles.assertEquals((int)xTotal, (int)total);
        } else {
            System.out.println("Found " + total + " symbols altogether.");
        }
        if (xGood >= 0) {
            TestCombineTiles.assertEquals((int)xGood, (int)good);
        } else {
            System.out.println("Found " + good + " good symbols.");
        }
    }
}

