/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.GroupAction;
import org.gavrog.jane.fpgroups.SmallActionsIterator;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.EuclidicityTester;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;
import org.gavrog.joss.dsyms.generators.DefineBranching3d;
import org.gavrog.joss.dsyms.generators.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generate3d
extends IteratorAdapter<DSymbol> {
    private static final IndexList edgeIndices = new IndexList(0, 2, 3);
    private final Iterator<GroupAction<String, Integer>> actions;
    private Iterator<DSymbol> current;
    private final FundamentalGroup<Integer> G = new FundamentalGroup<Integer>(new DSymbol("1 3:1,1,1,1:0,0,0"));
    final boolean allowEdgesOfDegreeTwo;
    final boolean edgeTransitive;

    public Generate3d(int size) {
        this(size, false, false);
    }

    public Generate3d(int size, boolean allowEdgesOfDegreeTwo, boolean edgeTransitive) {
        FpGroup<String> pG = this.G.getPresentation();
        this.actions = new SmallActionsIterator<String>(pG, size, false);
        this.current = Iterators.empty();
        this.allowEdgesOfDegreeTwo = allowEdgesOfDegreeTwo;
        this.edgeTransitive = edgeTransitive;
    }

    @Override
    protected DSymbol findNext() throws NoSuchElementException {
        while (true) {
            if (this.current.hasNext()) {
                DSymbol ds = this.current.next();
                if (!ds.isMinimal() || new EuclidicityTester(ds).isBad()) continue;
                return ds;
            }
            if (!this.actions.hasNext()) break;
            GroupAction<String, Integer> action = this.actions.next();
            DSCover<Integer> set = new DSCover<Integer>(this.G, action);
            if (this.edgeTransitive && set.numberOfOrbits(edgeIndices) > 1 || !Utils.mayBecomeLocallyEuclidean3D(set)) continue;
            this.current = new DefineProperBranching(set, this.allowEdgesOfDegreeTwo);
        }
        throw new NoSuchElementException("at end");
    }

    public static void main(String[] args) {
        boolean allowEdgesOfDegreeTwo = false;
        boolean edgeTransitive = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-x")) {
                allowEdgesOfDegreeTwo = !allowEdgesOfDegreeTwo;
            } else {
                if (!args[i].equalsIgnoreCase("-e")) break;
                edgeTransitive = !edgeTransitive;
            }
            ++i;
        }
        int maxSize = args.length > i ? Integer.parseInt(args[i]) : 6;
        Generate3d symbols = new Generate3d(maxSize, allowEdgesOfDegreeTwo, edgeTransitive);
        long start = System.currentTimeMillis();
        int count = Iterators.print(System.out, symbols, "\n");
        long stop = System.currentTimeMillis();
        System.out.println("\nGenerated " + count + " symbols.");
        System.out.println("Execution time was " + (double)(stop - start) / 1000.0 + " seconds.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefineProperBranching
    extends DefineBranching3d {
        public <T> DefineProperBranching(DelaneySymbol<T> ds, boolean deg2ok) {
            super(ds, deg2ok);
        }

        @Override
        protected List<DefineBranching3d.Move> getExtraDeductions(DelaneySymbol<Integer> ds, DefineBranching3d.Move move) {
            if (move.index == 1) {
                int D = move.element;
                int m = ds.m(1, 2, D);
                if (m == 1) {
                    return null;
                }
                if (m == 2) {
                    int E = D;
                    while ((E = ds.op(1, ds.op(0, E)).intValue()) != D && ds.m(1, 2, E) == 2) {
                    }
                    if (E == D) {
                        return null;
                    }
                    E = D;
                    while ((E = ds.op(2, ds.op(3, E)).intValue()) != D && ds.m(1, 2, E) == 2) {
                    }
                    if (E == D) {
                        return null;
                    }
                }
            }
            return new ArrayList<DefineBranching3d.Move>();
        }
    }
}

