/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import buoy.event.EventProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.box.collections.Pair;
import org.gavrog.box.collections.Partition;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.joss.algorithms.CheckpointEvent;
import org.gavrog.joss.algorithms.ResumableGenerator;
import org.gavrog.joss.dsyms.basic.DSMorphism;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.basic.Traversal;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.generators.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombineTiles
extends ResumableGenerator<DSymbol> {
    private static final boolean LOGGING = false;
    final int originalSize;
    private final int dim;
    private final List<List<DSymbol>> componentTypes;
    private final Map<Invariant, Integer> invarToIndex = new HashMap<Invariant, Integer>();
    private final List<Map<Integer, Integer>> indexToRepMap = new ArrayList<Map<Integer, Integer>>();
    private final DynamicDSymbol current;
    private final LinkedList<Move> stack;
    private final int[] unused;
    private int size;
    private Map<Integer, Pair<Integer, Integer>> signatures;
    private int[] resume = new int[0];
    private int resume_level = 0;
    private int resume_stack_level = 0;
    private boolean resume_point_reached = false;
    private final Stopwatch timer = Stopwatch.global("CombineTiles.total");
    private final Stopwatch signatureTimer = Stopwatch.global("CombineTiles.signatures");

    public <T> CombineTiles(DelaneySymbol<T> ds) {
        this.timer.start();
        this.dim = ds.dim() + 1;
        if (ds.equals(null)) {
            throw new IllegalArgumentException("null argument");
        }
        try {
            ds.size();
        }
        catch (UnsupportedOperationException ex) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        if (!ds.isComplete()) {
            throw new UnsupportedOperationException("symbol must be complete");
        }
        IndexList idcs = new IndexList(ds);
        for (T D : ds.orbitReps(idcs)) {
            Subsymbol<T> sub = new Subsymbol<T>(ds, idcs, D);
            if (this.dim != 3 || sub.isSpherical2D()) continue;
            throw new IllegalArgumentException("components must be spherical");
        }
        this.originalSize = ds.size();
        DSymbol canonical = new DSymbol(ds.canonical());
        Map<DelaneySymbol<Integer>, Integer> multiplicities = CombineTiles.componentMultiplicities(canonical);
        ArrayList<DelaneySymbol<Integer>> types = new ArrayList<DelaneySymbol<Integer>>(multiplicities.keySet());
        Collections.sort(types);
        ArrayList<List<DSymbol>> forms = new ArrayList<List<DSymbol>>();
        ArrayList<Integer> free = new ArrayList<Integer>();
        int i = 0;
        while (i < types.size()) {
            DelaneySymbol type = (DelaneySymbol)types.get(i);
            forms.add(Collections.unmodifiableList(CombineTiles.subCanonicalForms(type)));
            free.add(multiplicities.get(type));
            ++i;
        }
        this.componentTypes = Collections.unmodifiableList(forms);
        this.size = 0;
        this.signatures = new HashMap<Integer, Pair<Integer, Integer>>();
        this.stack = new LinkedList();
        this.unused = new int[free.size()];
        i = 0;
        while (i < free.size()) {
            this.unused[i] = (Integer)free.get(i);
            ++i;
        }
        this.current = new DynamicDSymbol(this.dim);
        DSymbol start = this.componentTypes.get(0).get(0);
        this.current.append((DSymbol)start.canonical());
        this.unused[0] = this.unused[0] - 1;
        this.size = this.current.size();
        this.signatures = this.elementSignatures(this.current, this.dim - 2);
        this.stack.addLast(new Move(1, 0, 0, 0, true, 0));
        this.timer.stop();
    }

    @Override
    protected DSymbol findNext() throws NoSuchElementException {
        this.timer.start();
        while (true) {
            Move move;
            Move choice;
            if (!this.resume_point_reached && this.resume_level >= this.resume.length) {
                this.resume_point_reached = true;
                if (this.resume.length > 0) {
                    this.postCheckpoint("resume point reached");
                }
            }
            if ((choice = this.undoLastChoice()) == null) {
                this.timer.stop();
                throw new NoSuchElementException();
            }
            if (!this.resume_point_reached && this.stack.size() < this.resume_stack_level) {
                this.resume_point_reached = true;
                if (this.resume.length > 0) {
                    this.postCheckpoint("resume point reached");
                }
            }
            if ((move = this.nextMove(choice)) == null) continue;
            boolean incr_level = false;
            if (!this.resume_point_reached && this.stack.size() == this.resume_stack_level && this.resume_level < this.resume.length && move.choiceNr == this.resume[this.resume_level]) {
                incr_level = true;
            }
            boolean success = this.performMove(move);
            this.postCheckpoint(null);
            if (incr_level) {
                this.resume_stack_level = this.stack.size();
                ++this.resume_level;
            }
            if (!success || !this.isCanonical()) continue;
            int D = this.nextFreeElement(choice.element);
            if (D == 0) {
                if (this.size != this.originalSize) continue;
                DSymbol ds = new DSymbol(this.current);
                if (this.dim == 3 && !Utils.mayBecomeLocallyEuclidean3D(ds)) continue;
                this.timer.stop();
                return new DSymbol(this.current);
            }
            if (!this.resume_point_reached && this.stack.size() != this.resume_stack_level) continue;
            this.stack.addLast(new Move(D, 0, -1, -1, true, 0));
        }
    }

    private void postCheckpoint(String message) {
        this.dispatchEvent(new CheckpointEvent(this, !this.resume_point_reached, message));
    }

    @Override
    public String getCheckpoint() {
        StringBuffer buf = new StringBuffer(20);
        for (Move move : this.stack) {
            if (!move.isChoice) continue;
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(move.choiceNr);
        }
        return buf.toString();
    }

    @Override
    public void setResumePoint(String spec) {
        if (spec == null || spec.length() == 0) {
            return;
        }
        String[] fields = spec.trim().split("-");
        this.resume = new int[fields.length];
        int i = 0;
        while (i < fields.length) {
            this.resume[i] = Integer.valueOf(fields[i]);
            ++i;
        }
    }

    private Move undoLastChoice() {
        Move last;
        IndexList idcs = new IndexList(this.current);
        do {
            if (this.stack.size() == 0) {
                return null;
            }
            last = this.stack.removeLast();
            if (this.current.hasElement(last.neighbor)) {
                this.current.undefineOp(this.dim, last.element);
            }
            if (last.newType < 0 || last.neighbor <= 0) continue;
            for (int D : this.current.orbit(idcs, last.neighbor)) {
                this.current.removeElement(D);
            }
            this.current.renumber();
            int n = last.newType;
            this.unused[n] = this.unused[n] + 1;
            this.size = this.current.size();
            this.signatures = this.elementSignatures(this.current, this.dim - 2);
        } while (!last.isChoice);
        return last;
    }

    private Move nextMove(Move choice) {
        int D = choice.element;
        Pair<Integer, Integer> sigD = this.signatures.get(D);
        int E = choice.neighbor + 1;
        while (E <= this.size) {
            if (!this.current.definesOp(this.dim, E) && sigD.equals(this.signatures.get(E))) {
                return new Move(choice.element, E, -1, -1, true, choice.choiceNr + 1);
            }
            ++E;
        }
        int type = Math.max(0, choice.newType);
        int form = Math.max(0, choice.newForm + 1);
        while (type < this.componentTypes.size()) {
            if (this.unused[type] > 0) {
                List<DSymbol> forms = this.componentTypes.get(type);
                while (form < forms.size()) {
                    DSymbol candidate = forms.get(form);
                    Map<Integer, Pair<Integer, Integer>> sigs = this.elementSignatures(candidate, this.dim - 2);
                    if (sigD.equals(sigs.get(1))) {
                        return new Move(choice.element, this.size + 1, type, form, true, choice.choiceNr + 1);
                    }
                    ++form;
                }
            }
            ++type;
            form = 0;
        }
        return null;
    }

    private boolean performMove(Move initial) {
        DynamicDSymbol ds = this.current;
        LinkedList<Move> queue = new LinkedList<Move>();
        queue.addLast(initial);
        while (queue.size() > 0) {
            Move move = (Move)queue.removeFirst();
            int type = move.newType;
            int form = move.newForm;
            int D = move.element;
            int E = move.neighbor;
            int d = this.dim;
            if (ds.definesOp(d, D) || ds.definesOp(d, E)) {
                if (ds.definesOp(d, D) && ds.op(d, D).equals(E)) continue;
                if (move == initial) {
                    throw new IllegalArgumentException("#    internal error: received illegal move.");
                }
                return false;
            }
            if (type >= 0) {
                DSymbol component = this.componentTypes.get(type).get(form);
                this.current.append(component);
                int n = type;
                this.unused[n] = this.unused[n] - 1;
                this.size = this.current.size();
                this.signatures = this.elementSignatures(this.current, this.dim - 2);
            }
            ds.redefineOp(d, D, E);
            this.stack.addLast(move);
            if (!this.signatures.get(D).equals(this.signatures.get(E))) {
                return false;
            }
            int i = 0;
            while (i <= d - 2) {
                int Di = ds.op(i, D);
                int Ei = ds.op(i, E);
                queue.addLast(new Move(Di, Ei, -1, -1, false, 0));
                ++i;
            }
            List<Move> extraDeductions = this.getExtraDeductions(ds, move);
            if (extraDeductions == null) {
                return false;
            }
            for (Move ded : extraDeductions) {
                queue.addLast(ded);
            }
        }
        return true;
    }

    private boolean isCanonical() {
        DSymbol flat = new DSymbol(this.current);
        return flat.getMapToCanonical().get(1).equals(1);
    }

    private int nextFreeElement(int element) {
        int D = element;
        do {
            if (++D <= this.size) continue;
            return 0;
        } while (this.current.definesOp(this.dim, D));
        return D;
    }

    public Map<Integer, Pair<Integer, Integer>> elementSignatures(DelaneySymbol<Integer> ds, int dim) {
        this.signatureTimer.start();
        HashMap<Integer, Pair<Integer, Integer>> signatures = new HashMap<Integer, Pair<Integer, Integer>>();
        ArrayList<Integer> idcs = new ArrayList<Integer>();
        int i = 0;
        while (i <= dim) {
            idcs.add(i);
            ++i;
        }
        for (int D : ds.orbitReps(idcs)) {
            Subsymbol<Integer> face = new Subsymbol<Integer>(ds, idcs, D);
            Invariant invariant = new Invariant(face.invariant());
            if (!this.invarToIndex.containsKey(invariant)) {
                int i2 = this.indexToRepMap.size();
                this.invarToIndex.put(invariant, i2);
                DSymbol canon = (DSymbol)face.canonical();
                this.indexToRepMap.add(CombineTiles.mapToFirstRepresentatives(canon));
            }
            Integer i3 = this.invarToIndex.get(invariant);
            Map<Integer, Integer> toRep = this.indexToRepMap.get(i3);
            Map toCanon = face.getMapToCanonical();
            Iterator iterator = ((DelaneySymbol)face).elements().iterator();
            while (iterator.hasNext()) {
                int E = (Integer)iterator.next();
                int rep = toRep.get(toCanon.get(E));
                signatures.put(E, new Pair<Integer, Integer>(i3, rep));
            }
        }
        this.signatureTimer.stop();
        return signatures;
    }

    public static Map<DelaneySymbol<Integer>, Integer> componentMultiplicities(DelaneySymbol<Integer> ds) {
        HashMap<DelaneySymbol<Integer>, Integer> type2number = new HashMap<DelaneySymbol<Integer>, Integer>();
        IndexList idcs = new IndexList(ds);
        for (int D : ds.orbitReps(idcs)) {
            DelaneySymbol<Integer> sub = new Subsymbol<Integer>(ds, idcs, D).canonical();
            if (type2number.containsKey(sub)) {
                type2number.put(sub, (Integer)type2number.get(sub) + 1);
                continue;
            }
            type2number.put(sub, 1);
        }
        return type2number;
    }

    public static List<Integer> firstRepresentatives(DelaneySymbol<Integer> ds) {
        Map<Integer, Integer> map = CombineTiles.mapToFirstRepresentatives(ds);
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int D : ds.elements()) {
            if (D != map.get(D)) continue;
            res.add(D);
        }
        return res;
    }

    public static Map<Integer, Integer> mapToFirstRepresentatives(DelaneySymbol<Integer> ds) {
        if (!ds.isConnected()) {
            throw new UnsupportedOperationException("symbol must be connected");
        }
        HashMap<Integer, Integer> res = new HashMap<Integer, Integer>();
        IteratorAdapter<Integer> elms = ds.elements();
        if (elms.hasNext()) {
            int first = (Integer)elms.next();
            Partition<Integer> classes = new Partition<Integer>();
            while (elms.hasNext()) {
                DSMorphism<Integer, Integer> morphism;
                int D = (Integer)elms.next();
                if (classes.areEquivalent(first, D)) continue;
                try {
                    morphism = new DSMorphism<Integer, Integer>(ds, ds, first, D);
                }
                catch (IllegalArgumentException ex) {
                    continue;
                }
                for (int E : ds.elements()) {
                    classes.unite(E, morphism.get(E));
                }
            }
            for (int D : ds.elements()) {
                int E = classes.find(D);
                if (!res.containsKey(E)) {
                    res.put(D, D);
                    res.put(E, D);
                    continue;
                }
                res.put(D, (Integer)res.get(E));
            }
        }
        return res;
    }

    public static List<DSymbol> subCanonicalForms(DelaneySymbol<Integer> ds) {
        if (!ds.isConnected()) {
            throw new UnsupportedOperationException("symbol must be connected");
        }
        if (!ds.hasStandardIndexSet()) {
            throw new UnsupportedOperationException("symbol must have indices 0..dim");
        }
        LinkedList<DSymbol> res = new LinkedList<DSymbol>();
        int size = ds.size();
        int dim = ds.dim();
        IndexList idcs = new IndexList(ds);
        List<Integer> reps = CombineTiles.firstRepresentatives(ds);
        for (int seed : reps) {
            Traversal<Integer> trav = new Traversal<Integer>(ds, (List<Integer>)idcs, seed, true);
            HashMap<Integer, Integer> old2new = new HashMap<Integer, Integer>();
            int nextE = 1;
            while (trav.hasNext()) {
                DSPair e = (DSPair)trav.next();
                int D = (Integer)e.getElement();
                Integer tmp = (Integer)old2new.get(D);
                if (tmp != null) continue;
                old2new.put(D, nextE);
                ++nextE;
            }
            int[][] op = new int[dim + 1][size + 1];
            int[][] v = new int[dim][size + 1];
            for (int E : ds.elements()) {
                int D = (Integer)old2new.get(E);
                int i = 0;
                while (i <= dim) {
                    op[i][D] = (Integer)old2new.get(ds.op(i, E));
                    if (i < dim) {
                        v[i][D] = ds.v(i, i + 1, E);
                    }
                    ++i;
                }
            }
            res.add(new DSymbol(op, v));
        }
        return res;
    }

    protected List<Move> getExtraDeductions(DelaneySymbol<Integer> ds, Move move) {
        return new ArrayList<Move>();
    }

    public static void main(String[] args) {
        boolean verbose = false;
        boolean useCover = false;
        String resume = null;
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            if (args[i].equals("-v")) {
                verbose = !verbose;
            } else if (args[i].equals("-c")) {
                useCover = !useCover;
            } else if (args[i].equals("-r")) {
                resume = args[++i];
            }
            ++i;
        }
        if (i >= args.length) {
            throw new RuntimeException("no input symbol given");
        }
        DSCover<Integer> ds = new DSCover<Integer>(args[i]);
        if (useCover) {
            ds = Covers.finiteUniversalCover(ds);
        }
        final Stopwatch timer = new Stopwatch();
        CombineTiles iter = new CombineTiles(ds);
        iter.addEventLink(CheckpointEvent.class, new EventProcessor(){

            public void handleEvent(Object event) {
                CheckpointEvent ev = (CheckpointEvent)event;
                timer.reset();
                System.out.format("#@@@ %sCheckpoint %s\n", ev.isOld() ? "Old " : "", ev.getSource().getCheckpoint());
            }
        });
        iter.setResumePoint(resume);
        int count = 0;
        try {
            for (DSymbol out : iter) {
                System.out.println(out);
                ++count;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        System.out.println("# produced " + count + " symbols");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Invariant
    extends NiftyList<Integer> {
        private static final long serialVersionUID = 9019321096153152091L;

        public Invariant(List<Integer> source) {
            super(source);
        }
    }

    protected class Move {
        public final int element;
        public final int neighbor;
        public final int newType;
        public final int newForm;
        public final boolean isChoice;
        public final int choiceNr;

        public Move(int element, int neighbor, int newType, int newForm, boolean isChoice, int choiceNr) {
            this.element = element;
            this.neighbor = neighbor;
            this.newType = newType;
            this.newForm = newForm;
            this.isChoice = isChoice;
            this.choiceNr = choiceNr;
        }

        public String toString() {
            return String.format("Move(%s, %s, %d, %d, %s, %d)", this.element, this.neighbor, this.newType, this.newForm, this.isChoice, this.choiceNr);
        }
    }
}

