/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.generators;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;
import org.gavrog.joss.dsyms.generators.CombineTiles;
import org.gavrog.joss.dsyms.generators.DefineBranching2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Azulenoids
extends IteratorAdapter<DSymbol> {
    private Iterator<DSymbol> sets;
    private DefineBranching2d syms;
    private int pos;
    private DSymbol ds;
    private Set<NiftyList<Integer>> seenInvariants;
    private int nrOctaSets = 0;
    private int nrOctaSyms = 0;
    private int nrAzulSyms = 0;
    private boolean trace = false;
    private static DSymbol template = new DSymbol("1.1:60:2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36 38 40 42 44 46 48 50 52 54 56 58 60,6 3 5 12 9 11 18 15 17 24 21 23 30 27 29 36 33 35 42 39 41 48 45 47 54 51 53 60 57 59,0 0 12 11 28 27 0 0 18 17 36 35 24 23 58 57 30 29 0 0 0 0 42 41 0 0 48 47 0 0 54 53 0 0 60 59 0 0:3 3 3 3 3 3 3 3 3 3,0 0 5 0 7 0 0 0 0 0");

    public Azulenoids() {
        int n = 8;
        DynamicDSymbol ds = new DynamicDSymbol(1);
        ds.grow(16);
        int D = 1;
        while (D < 17) {
            ds.redefineOp(0, D, D + 1);
            if (D > 1) {
                ds.redefineOp(1, D, D - 1);
            }
            D += 2;
        }
        ds.redefineOp(1, 1, 16);
        ds.redefineV(0, 1, 1, 1);
        this.sets = new CombineTiles(ds);
        this.syms = null;
        this.pos = 0;
        this.seenInvariants = new HashSet<NiftyList<Integer>>();
    }

    @Override
    protected DSymbol findNext() throws NoSuchElementException {
        NiftyList<Integer> key;
        DSymbol result;
        while (true) {
            if (this.pos < 1 || this.pos > 16) {
                while (this.syms == null || !this.syms.hasNext()) {
                    if (this.sets.hasNext()) {
                        DSymbol ds = this.sets.next();
                        ds.setVDefaultToOne(true);
                        Rational curv = ds.curvature2D();
                        ds.setVDefaultToOne(false);
                        if (curv.isNegative()) continue;
                        ++this.nrOctaSets;
                        this.syms = new DefineBranching2d(ds, 3, 2, Whole.ZERO);
                        continue;
                    }
                    throw new NoSuchElementException("At end");
                }
                this.ds = (DSymbol)this.syms.next();
                if (!this.ds.curvature2D().isZero()) continue;
                ++this.nrOctaSyms;
                if (this.trace) {
                    System.out.println("# Using octagon tiling " + this.ds);
                }
                this.pos = 1;
            }
            int p = this.pos;
            this.pos += 2;
            DynamicDSymbol tmp = new DynamicDSymbol(template);
            HashMap<Integer, Integer> tmp2oct = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> oct2tmp = new HashMap<Integer, Integer>();
            boolean E0 = true;
            int E = 1;
            int k = (3 - p + 16) % 16 + 1;
            do {
                tmp2oct.put(E, k);
                oct2tmp.put(k, E);
                E = tmp.op(0, E);
                k = k % 16 + 1;
                tmp2oct.put(E, k);
                oct2tmp.put(k, E);
                E = tmp.op(1, tmp.op(2, tmp.op(1, E)));
                if (tmp.definesOp(2, E)) {
                    E = tmp.op(1, tmp.op(2, E));
                }
                k = k % 16 + 1;
            } while (1 != E);
            for (int D : tmp.elements()) {
                if (tmp.definesOp(2, D)) continue;
                tmp.redefineOp(2, D, (Integer)oct2tmp.get(this.ds.op(2, (Integer)tmp2oct.get(D))));
            }
            for (int D : tmp2oct.keySet()) {
                if (tmp.definesV(1, 2, D)) continue;
                tmp.redefineV(1, 2, D, this.ds.v(1, 2, (Integer)tmp2oct.get(D)));
            }
            result = new DSymbol(tmp);
            key = result.minimal().invariant();
            if (!this.seenInvariants.contains(key)) break;
        }
        this.seenInvariants.add(key);
        ++this.nrAzulSyms;
        return new DSymbol(result.dual().minimal().canonical());
    }

    public int getNrAzulSyms() {
        return this.nrAzulSyms;
    }

    public int getNrOctaSets() {
        return this.nrOctaSets;
    }

    public int getNrOctaSyms() {
        return this.nrOctaSyms;
    }

    public boolean getTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public static void main(String[] args) {
        Azulenoids azul = new Azulenoids();
        azul.setTrace(true);
        while (azul.hasNext()) {
            System.out.println(azul.next());
        }
        System.out.println("#Generated:");
        System.out.println("#    " + azul.getNrOctaSets() + " octagonal D-sets.");
        System.out.println("#    " + azul.getNrOctaSyms() + " octagonal D-symbols.");
        System.out.println("#    " + azul.getNrAzulSyms() + " azulenoid D-symbols.");
    }
}

