/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.filters;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.generators.InputIterator;

public class FilterQuasiSimple {
    public static void main(String[] args) {
        try {
            InputStreamReader in;
            String inputPath;
            boolean reverse = false;
            boolean extended = false;
            boolean simple = false;
            int i = 0;
            while (i < args.length && args[i].startsWith("-")) {
                if (args[i].equalsIgnoreCase("-r")) {
                    reverse = !reverse;
                } else if (args[i].equalsIgnoreCase("-e")) {
                    extended = !extended;
                } else if (args[i].equalsIgnoreCase("-s")) {
                    simple = !simple;
                } else {
                    System.err.println("Unknown option '" + args[i] + "'");
                }
                ++i;
            }
            if (args.length > i) {
                inputPath = args[i];
                in = new FileReader(inputPath);
            } else {
                inputPath = null;
                in = new InputStreamReader(System.in);
            }
            OutputStreamWriter out = args.length > i + 1 ? new FileWriter(args[i + 1]) : new OutputStreamWriter(System.out);
            if (inputPath != null) {
                out.write("# Input file: " + inputPath + "\n");
            }
            out.write("# Options:\n");
            out.write("#     Extended: " + extended + "\n");
            out.write("#     Reverse:  " + reverse + "\n");
            int inCount = 0;
            int outCount = 0;
            for (DSymbol ds : new InputIterator(in)) {
                ++inCount;
                if (FilterQuasiSimple.isQuasiSimple(ds, extended, simple) == reverse) continue;
                ++outCount;
                out.write(ds.toString());
                ((Writer)out).write(10);
                ((Writer)out).flush();
            }
            out.write("# Read " + inCount + " symbols. Extracted " + outCount + " symbols.\n");
            ((Writer)out).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isQuasiSimple(DSymbol ds, boolean extended, boolean simple) {
        IndexList iVert = new IndexList(1, 2, 3);
        IndexList iFace = new IndexList(0, 1);
        Iterator iterator = ds.orbitReps(iVert).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            DSymbol sub = new DSymbol(new Subsymbol<Integer>(ds, iVert, D)).dual();
            if (!sub.curvature2D().isPositive()) {
                return false;
            }
            DSCover<Integer> cov = Covers.finiteUniversalCover(sub);
            Iterator iterator2 = cov.orbitReps(iFace).iterator();
            while (iterator2.hasNext()) {
                int E0;
                int E = E0 = ((Integer)iterator2.next()).intValue();
                int d = 0;
                do {
                    int m = cov.m(1, 2, E);
                    E = cov.op(0, cov.op(1, (Integer)E));
                    if (m == 3) {
                        ++d;
                        continue;
                    }
                    if (!simple && m == 2 && (extended || cov.m(1, 2, E) != 2)) continue;
                    return false;
                } while (E0 != E);
                if (d == 3) continue;
                return false;
            }
        }
        return true;
    }
}

