/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Traversal;
import org.gavrog.joss.dsyms.derived.FundamentalEdges;

public class TestFundamentalEdges
extends TestCase {
    private static final Integer one = new Integer(1);
    private static final Integer two = new Integer(2);
    private static final Integer three = new Integer(3);
    private static final Integer four = new Integer(4);
    private static final Integer five = new Integer(5);
    private static final Integer six = new Integer(6);
    private DelaneySymbol ds;

    protected void setUp() throws Exception {
        super.setUp();
        this.ds = new DSymbol("6:1 3 4 6,2 4 5 6,1 5 6 4:8 4,3 3");
    }

    protected void tearDown() throws Exception {
        this.ds = null;
        super.tearDown();
    }

    public void testFundamentalEdges1() {
        this.testFundamentalEdges(new FundamentalEdges(this.ds));
    }

    public void testFundamentalEdges2() {
        IndexList idcs = new IndexList(this.ds);
        Collections.reverse(idcs);
        Traversal trav = new Traversal(this.ds, (List<Integer>)idcs, this.ds.elements(), false);
        this.testFundamentalEdges(new FundamentalEdges(this.ds, trav));
    }

    public void testFundamentalEdges(FundamentalEdges iter) {
        HashSet edges = new HashSet();
        while (iter.hasNext()) {
            edges.add(iter.next());
        }
        Assert.assertTrue((edges.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((edges.contains(new DSPair<Integer>(1, one)) || edges.contains(new DSPair<Integer>(1, two)) ? 1 : 0) != 0);
        Assert.assertTrue((edges.contains(new DSPair<Integer>(1, three)) || edges.contains(new DSPair<Integer>(1, four)) ? 1 : 0) != 0);
        Assert.assertTrue((edges.contains(new DSPair<Integer>(0, two)) || edges.contains(new DSPair<Integer>(0, three)) ? 1 : 0) != 0);
        Assert.assertTrue((edges.contains(new DSPair<Integer>(0, five)) || edges.contains(new DSPair<Integer>(0, six)) ? 1 : 0) != 0);
        Assert.assertTrue((edges.contains(new DSPair<Integer>(2, two)) || edges.contains(new DSPair<Integer>(2, five)) ? 1 : 0) != 0);
        Assert.assertTrue((edges.contains(new DSPair<Integer>(2, three)) || edges.contains(new DSPair<Integer>(2, six)) ? 1 : 0) != 0);
    }
}

