/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gavrog.box.collections.HashMapWithDefault;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.derived.Covers;
import org.gavrog.joss.dsyms.derived.DSCover;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature {
    private static int gcd(int a, int b) {
        int t;
        if ((a = Math.abs(a)) < (b = Math.abs(b))) {
            t = b;
            b = a;
            a = t;
        }
        while (b > 0) {
            t = b;
            b = a % b;
            a = t;
        }
        return a;
    }

    private static <T> List<Integer> faceSizes(DelaneySymbol<T> ds) {
        IndexList idcs = new IndexList(0, 1);
        LinkedList<Integer> sizes = new LinkedList<Integer>();
        for (T D : ds.orbitReps(idcs)) {
            sizes.add(new Integer(ds.m(0, 1, D)));
        }
        Collections.sort(sizes);
        return new NiftyList<Integer>((List<Integer>)sizes);
    }

    private static String faceSizeToTileSig(List<Integer> sig) {
        int max = sig.get(sig.size() - 1) + 1;
        int[] mult = new int[max];
        Iterator<Integer> iterator = sig.iterator();
        while (iterator.hasNext()) {
            int m;
            int n = m = iterator.next().intValue();
            mult[n] = mult[n] + 1;
        }
        StringBuffer buf = new StringBuffer(100);
        boolean first = true;
        int i = 0;
        while (i < max) {
            int k = mult[i];
            if (k > 0) {
                if (first) {
                    first = false;
                } else {
                    buf.append('.');
                }
                buf.append(i);
                if (k > 1) {
                    buf.append('^');
                    buf.append(k);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static <T> String ofTiling(DelaneySymbol<T> base) {
        if (base.dim() == 3) {
            return Signature.ofTiling3d(base);
        }
        if (base.dim() == 2) {
            if (base.isSpherical2D()) {
                return Signature.ofTiling2dSpherical(base);
            }
            if (base.curvature2D().isZero()) {
                return Signature.ofTiling2dEuclidean(base);
            }
        }
        throw new UnsupportedOperationException("unsupported kind of tiling");
    }

    private static <T> String ofTiling2dSpherical(DelaneySymbol<T> base) {
        assert (base.dim() == 2) : "must be two-dimensional";
        DSCover<Integer> ds = Covers.finiteUniversalCover(new DSymbol(base));
        return Signature.faceSizeToTileSig(Signature.faceSizes(ds));
    }

    private static <T> String ofTiling2dEuclidean(DelaneySymbol<T> base) {
        assert (base.dim() == 2) : "must be two-dimensional";
        DSCover<Integer> ds = Covers.toroidalCover2D(new DSymbol(base));
        return Signature.faceSizeToTileSig(Signature.faceSizes(ds));
    }

    private static <T> String ofTiling3d(DelaneySymbol<T> base) {
        DSCover<T> ds = Covers.pseudoToroidalCover3D(base);
        HashMapWithDefault<List<Integer>, Integer> countSigs = new HashMapWithDefault<List<Integer>, Integer>(){
            private static final long serialVersionUID = -7426228956696237260L;

            @Override
            public Integer makeDefault() {
                return 0;
            }
        };
        IndexList idcs = new IndexList(0, 1, 2);
        Iterator iterator = ds.orbitReps(idcs).iterator();
        while (iterator.hasNext()) {
            int D = (Integer)iterator.next();
            NiftyList<Integer> s = new NiftyList<Integer>(Signature.faceSizes(new Subsymbol<Integer>(ds, idcs, D)));
            int n = (Integer)countSigs.get(s);
            countSigs.put(s, new Integer(n + 1));
        }
        ArrayList keys = new ArrayList(countSigs.keySet());
        Collections.sort(keys, NiftyList.lexicographicComparator());
        int t = 0;
        for (List key : keys) {
            t = Signature.gcd(t, (Integer)countSigs.get(key));
        }
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        while (i < keys.size()) {
            List s = (List)keys.get(i);
            int k = (Integer)countSigs.get(s) / t;
            if (i > 0) {
                buf.append(" + ");
            }
            if (k > 1) {
                buf.append(k);
            }
            buf.append('[');
            buf.append(Signature.faceSizeToTileSig(s));
            buf.append(']');
            ++i;
        }
        return buf.toString();
    }
}

