/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.derived;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.fpgroups.CosetAction;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.GroupAction;
import org.gavrog.jane.fpgroups.GroupActions;
import org.gavrog.jane.fpgroups.SmallActionsIterator;
import org.gavrog.jane.fpgroups.Stabilizer;
import org.gavrog.jane.numbers.Whole;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.dsyms.derived.FundamentalGroup;

public class Covers {
    public static <T> DSCover<T> finiteUniversalCover(DelaneySymbol<T> delaneySymbol) {
        if (delaneySymbol.dim() == 2 && !delaneySymbol.curvature2D().isPositive()) {
            throw new UnsupportedOperationException("result would be infinite");
        }
        FundamentalGroup<T> fundamentalGroup = new FundamentalGroup<T>(delaneySymbol);
        CosetAction cosetAction = new CosetAction(fundamentalGroup.getPresentation());
        int n = cosetAction.size();
        if (delaneySymbol.dim() == 2 && delaneySymbol.isSpherical2D()) {
            int n2 = delaneySymbol.sphericalGroupSize2D();
            assert (n2 == n) : "group size is " + n + ", but should be " + n2;
        }
        return new DSCover<T>(fundamentalGroup, cosetAction);
    }

    public static <T> Iterator<DSCover<T>> allCovers(DelaneySymbol<T> delaneySymbol) {
        if (delaneySymbol.dim() == 2 && !delaneySymbol.curvature2D().isPositive()) {
            throw new UnsupportedOperationException("result would be infinite");
        }
        final FundamentalGroup<T> fundamentalGroup = new FundamentalGroup<T>(delaneySymbol);
        FpGroup<String> fpGroup = fundamentalGroup.getPresentation();
        int n = new CosetAction(fpGroup).size();
        if (delaneySymbol.dim() == 2 && delaneySymbol.isSpherical2D()) {
            int n2 = delaneySymbol.sphericalGroupSize2D();
            assert (n2 == n) : "group size is " + n + ", but should be " + n2;
        }
        final SmallActionsIterator<String> smallActionsIterator = new SmallActionsIterator<String>(fpGroup, n, false);
        return new IteratorAdapter<DSCover<T>>(){

            @Override
            protected DSCover<T> findNext() throws NoSuchElementException {
                return new DSCover(fundamentalGroup, (GroupAction)smallActionsIterator.next());
            }
        };
    }

    public static <T> DSCover<T> toroidalCover2D(DelaneySymbol<T> delaneySymbol) {
        if (delaneySymbol.dim() != 2) {
            throw new UnsupportedOperationException("symbol must be 2-dimensional");
        }
        if (!delaneySymbol.curvature2D().isZero()) {
            throw new UnsupportedOperationException("symbol must be euclidean");
        }
        IndexList indexList = new IndexList(delaneySymbol);
        int n = 1;
        for (int i = 0; i < delaneySymbol.dim(); ++i) {
            int n2 = (Integer)indexList.get(i);
            for (int j = i + 1; j <= delaneySymbol.dim(); ++j) {
                int n3 = (Integer)indexList.get(j);
                for (Object object : delaneySymbol.orbitReps(new IndexList(n2, n3))) {
                    n = Math.max(n, delaneySymbol.v(n2, n3, object));
                }
            }
        }
        DelaneySymbol<Integer> delaneySymbol2 = delaneySymbol.orientedCover();
        FundamentalGroup<Integer> fundamentalGroup = new FundamentalGroup<Integer>(delaneySymbol2);
        FpGroup<String> fpGroup = fundamentalGroup.getPresentation();
        SmallActionsIterator<String> smallActionsIterator = new SmallActionsIterator<String>(fpGroup, n, true);
        while (smallActionsIterator.hasNext()) {
            Object object;
            GroupAction groupAction = (GroupAction)smallActionsIterator.next();
            if (!Covers.annihilatesAxes(groupAction, fundamentalGroup.getAxes())) continue;
            object = new DSCover<Integer>(fundamentalGroup, groupAction);
            return new DSCover<T>((DSymbol)object, delaneySymbol, delaneySymbol.elements().next());
        }
        throw new RuntimeException("serious problem here: missed the cover");
    }

    public static <T> DSCover<T> pseudoToroidalCover3D(DelaneySymbol<T> delaneySymbol) {
        GroupAction groupAction4;
        Pair<FreeWord<String>, Integer> pair22;
        if (delaneySymbol.dim() != 3) {
            throw new UnsupportedOperationException("symbol must be 3-dimensional");
        }
        if (!delaneySymbol.isLocallyEuclidean3D()) {
            throw new UnsupportedOperationException("symbol must be locally euclidean");
        }
        LinkedList<GroupAction<String, Integer>> linkedList = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList2 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList3 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList4 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList5 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList6 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList7 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList8 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList9 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList10 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction> linkedList11 = new LinkedList<GroupAction>();
        LinkedList<GroupAction<String, Integer>> linkedList12 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction> linkedList13 = new LinkedList<GroupAction>();
        LinkedList<GroupAction<String, Integer>> linkedList14 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<GroupAction<String, Integer>> linkedList15 = new LinkedList<GroupAction<String, Integer>>();
        LinkedList<LinkedList<GroupAction<String, Integer>>> linkedList16 = new LinkedList<LinkedList<GroupAction<String, Integer>>>();
        linkedList16.add(linkedList);
        linkedList16.add(linkedList2);
        linkedList16.add(linkedList5);
        linkedList16.add(linkedList7);
        linkedList16.add(linkedList8);
        linkedList16.add(linkedList9);
        linkedList16.add(linkedList11);
        linkedList16.add(linkedList12);
        linkedList16.add(linkedList13);
        linkedList16.add(linkedList14);
        linkedList16.add(linkedList15);
        DelaneySymbol<Integer> delaneySymbol2 = delaneySymbol.orientedCover();
        FundamentalGroup<Integer> fundamentalGroup = new FundamentalGroup<Integer>(delaneySymbol2);
        Set<Pair<FreeWord<String>, Integer>> set = fundamentalGroup.getAxes();
        HashSet<Pair<FreeWord<String>, Integer>> hashSet = new HashSet<Pair<FreeWord<String>, Integer>>();
        HashSet<Pair<FreeWord<String>, Integer>> hashSet2 = new HashSet<Pair<FreeWord<String>, Integer>>();
        for (Pair<FreeWord<String>, Integer> pair22 : set) {
            int n = pair22.getSecond();
            if (n == 2) {
                hashSet.add(pair22);
                continue;
            }
            if (n == 3) {
                hashSet2.add(pair22);
                continue;
            }
            if (n != 5 && n <= 6) continue;
            return null;
        }
        FpGroup<String> fpGroup = fundamentalGroup.getPresentation();
        pair22 = new SmallActionsIterator(fpGroup, 4, false);
        while (pair22.hasNext()) {
            GroupAction<String, Integer> groupAction2 = GroupActions.flat(GroupActions.orbit(GroupActions.cover((GroupAction)pair22.next())));
            int n = groupAction2.size();
            if (n == 2) {
                if (Covers.annihilatesAxes(groupAction2, hashSet)) {
                    linkedList3.add(groupAction2);
                }
                linkedList4.add(groupAction2);
            } else if (n == 3 && Covers.annihilatesAxes(groupAction2, hashSet2)) {
                linkedList6.add(groupAction2);
            } else if (n == 6 && Covers.annihilatesAxes(groupAction2, hashSet2)) {
                linkedList10.add(groupAction2);
            }
            if (!Covers.annihilatesAxes(groupAction2, set)) continue;
            if (n == 1) {
                linkedList.add(groupAction2);
                continue;
            }
            if (n == 2) {
                linkedList2.add(groupAction2);
                continue;
            }
            if (n == 3) {
                linkedList5.add(groupAction2);
                continue;
            }
            if (n == 4) {
                if (Covers.hasNonInvolutiveGenerator(groupAction2)) {
                    linkedList7.add(groupAction2);
                    continue;
                }
                linkedList8.add(groupAction2);
                continue;
            }
            if (n == 6) {
                linkedList9.add(groupAction2);
                continue;
            }
            if (n == 8) {
                linkedList12.add(groupAction2);
                continue;
            }
            if (n == 12) {
                linkedList14.add(groupAction2);
                continue;
            }
            if (n != 24) continue;
            linkedList15.add(groupAction2);
        }
        for (GroupAction groupAction3 : linkedList6) {
            for (GroupAction groupAction2 : linkedList3) {
                groupAction4 = GroupActions.flat(GroupActions.orbit(GroupActions.product(groupAction3, groupAction2)));
                if (groupAction4.size() != 6 || !Covers.annihilatesAxes(groupAction4, set)) continue;
                linkedList11.add(groupAction4);
            }
        }
        for (GroupAction groupAction4 : linkedList10) {
            for (GroupAction groupAction3 : linkedList4) {
                groupAction4 = GroupActions.flat(GroupActions.orbit(GroupActions.product(groupAction4, groupAction3)));
                if (groupAction4.size() != 12 || !Covers.annihilatesAxes(groupAction4, set)) continue;
                linkedList13.add(groupAction4);
            }
        }
        LinkedList linkedList17 = new LinkedList();
        linkedList17.add(Whole.ZERO);
        linkedList17.add(Whole.ZERO);
        linkedList17.add(Whole.ZERO);
        for (List list : linkedList16) {
            for (GroupAction groupAction4 : list) {
                int n;
                Stabilizer stabilizer = new Stabilizer(groupAction4, n = ((Integer)groupAction4.domain().next()).intValue());
                if (!stabilizer.getPresentation().abelianInvariants().equals(linkedList17)) continue;
                DSCover<Integer> dSCover = new DSCover<Integer>(fundamentalGroup, groupAction4);
                return new DSCover<T>(dSCover, delaneySymbol, delaneySymbol.elements().next());
            }
        }
        return null;
    }

    private static boolean hasNonInvolutiveGenerator(GroupAction<String, Integer> groupAction) {
        List<FreeWord<String>> list = groupAction.getGroup().getGenerators();
        Iterator<Integer> iterator = groupAction.domain();
        while (iterator.hasNext()) {
            int n = iterator.next();
            for (FreeWord<String> freeWord : list) {
                if (groupAction.apply(n, freeWord.raisedTo(2)).equals(n)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean annihilatesAxes(GroupAction<String, Integer> groupAction, Set<Pair<FreeWord<String>, Integer>> set) {
        int n = groupAction.domain().next();
        for (Pair<FreeWord<String>, Integer> pair : set) {
            FreeWord<String> freeWord = pair.getFirst();
            int n2 = pair.getSecond();
            int n3 = n;
            int n4 = 0;
            do {
                n3 = groupAction.apply(n3, freeWord);
                ++n4;
            } while (n3 != n);
            if (n2 % n4 != 0) {
                throw new RuntimeException("this should never happen");
            }
            if (n4 == n2) continue;
            return false;
        }
        return true;
    }
}

