/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.DynamicDSymbol;

public class TestDynamicDSymbol
extends TestCase {
    private static final Integer one = new Integer(1);
    private static final Integer two = new Integer(2);
    private static final Integer three = new Integer(3);
    private static final Integer four = new Integer(4);
    private static final Integer five = new Integer(5);
    private static final Integer six = new Integer(6);
    private static final Integer seven = new Integer(7);
    private DynamicDSymbol ds1;
    private DynamicDSymbol ds2;

    protected void setUp() throws Exception {
        super.setUp();
        this.ds1 = new DynamicDSymbol(new DSymbol("6:1 3 4 6,2 4 5 6,1 5 6 4:4 4,3 3"));
        this.ds2 = new DynamicDSymbol("6:1 3 0 6,2 4 5 6,1 5 6 4:8 6,0 3");
    }

    protected void tearDown() throws Exception {
        this.ds1 = null;
        this.ds2 = null;
        super.tearDown();
    }

    public void testDim() {
        Assert.assertTrue((this.ds1.dim() == 2 ? 1 : 0) != 0);
    }

    public void testSize() {
        Assert.assertTrue((this.ds1.size() == 6 ? 1 : 0) != 0);
    }

    public void testElements() {
        Assert.assertTrue((boolean)Iterators.equal(this.ds1.elements(), Iterators.range(1, 7)));
    }

    public void testHasElement() {
        Assert.assertTrue((boolean)this.ds1.hasElement(new Integer(3)));
        Assert.assertFalse((boolean)this.ds1.hasElement(new Integer(7)));
        Assert.assertFalse((boolean)this.ds1.hasElement(new Integer(0)));
    }

    public void testIndices() {
        Assert.assertTrue((boolean)Iterators.equal(this.ds1.indices(), Iterators.range(0, 3)));
    }

    public void testHasIndex() {
        Assert.assertTrue((boolean)this.ds1.hasIndex(0));
        Assert.assertTrue((boolean)this.ds1.hasIndex(2));
        Assert.assertFalse((boolean)this.ds1.hasIndex(-1));
        Assert.assertFalse((boolean)this.ds1.hasIndex(3));
    }

    public void testDefinesOp() {
        Assert.assertTrue((boolean)this.ds2.definesOp(1, one));
        Assert.assertFalse((boolean)this.ds2.definesOp(0, four));
        Assert.assertFalse((boolean)this.ds2.definesOp(0, seven));
        Assert.assertFalse((boolean)this.ds2.definesOp(-1, one));
    }

    public void testOp() {
        Assert.assertEquals((Object)this.ds1.op(1, one), (Object)two);
        Assert.assertEquals((Object)this.ds2.op(0, four), (Object)new Integer(0));
        try {
            this.ds1.op(0, new Integer(7));
            TestDynamicDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ds1.op(3, new Integer(4));
            TestDynamicDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDefinesV() {
        Assert.assertTrue((boolean)this.ds2.definesV(0, 1, two));
        Assert.assertTrue((boolean)this.ds2.definesV(0, 2, two));
        Assert.assertFalse((boolean)this.ds2.definesV(1, 2, two));
        Assert.assertFalse((boolean)this.ds2.definesV(0, 1, seven));
        Assert.assertFalse((boolean)this.ds2.definesV(1, 3, one));
    }

    public void testV() {
        Assert.assertTrue((this.ds1.v(1, 2, one) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.ds1.v(0, 2, one) == 2 ? 1 : 0) != 0);
        Assert.assertTrue((this.ds2.v(1, 2, two) == 0 ? 1 : 0) != 0);
        try {
            this.ds1.v(0, 1, seven);
            TestDynamicDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ds1.v(0, 3, four);
            TestDynamicDSymbol.fail((String)"Should raise an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testUndefineOp() {
        Assert.assertTrue((boolean)this.ds1.definesOp(0, two));
        Assert.assertTrue((boolean)this.ds1.definesOp(0, three));
        this.ds1.undefineOp(0, two);
        Assert.assertEquals((Object)new Integer(0), (Object)this.ds1.op(0, two));
        Assert.assertTrue((boolean)this.ds1.definesOp(0, one));
        Assert.assertTrue((boolean)this.ds1.definesOp(1, two));
        Assert.assertFalse((boolean)this.ds1.definesOp(0, two));
        Assert.assertFalse((boolean)this.ds1.definesOp(0, three));
        Assert.assertFalse((boolean)this.ds1.definesOp(0, three));
        this.ds2.undefineOp(0, three);
        Assert.assertFalse((boolean)this.ds1.definesOp(0, three));
    }

    public void testRedefineOp() {
        this.ds1.redefineOp(0, one, two);
        Assert.assertEquals((Object)two, (Object)this.ds1.op(0, one));
        Assert.assertEquals((Object)one, (Object)this.ds1.op(0, two));
        Assert.assertEquals((Object)new Integer(0), (Object)this.ds1.op(0, three));
    }

    public void testUndefineV() {
        this.ds1.undefineV(0, 1, one);
        Assert.assertFalse((boolean)this.ds1.definesV(0, 1, one));
        Assert.assertFalse((boolean)this.ds1.definesV(0, 1, two));
        Assert.assertFalse((boolean)this.ds1.definesV(0, 1, three));
        Assert.assertFalse((boolean)this.ds1.definesV(0, 1, four));
        Assert.assertEquals((int)0, (int)this.ds1.m(0, 1, one));
        Assert.assertEquals((int)4, (int)this.ds1.m(0, 1, five));
        Assert.assertEquals((int)4, (int)this.ds1.m(0, 1, six));
    }

    public void testRedefineV() {
        this.ds1.redefineV(0, 1, one, 3);
        Assert.assertEquals((int)12, (int)this.ds1.m(0, 1, one));
        Assert.assertEquals((int)12, (int)this.ds1.m(0, 1, two));
        Assert.assertEquals((int)12, (int)this.ds1.m(0, 1, three));
        Assert.assertEquals((int)12, (int)this.ds1.m(0, 1, four));
        Assert.assertEquals((int)4, (int)this.ds1.m(0, 1, five));
        Assert.assertEquals((int)4, (int)this.ds1.m(0, 1, six));
    }

    public void testAddElement() {
        Integer x = this.ds1.addElement();
        Assert.assertEquals((Object)x, (Object)seven);
        String out = "   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    3    1    5 |    1    1\n   3 |    2    4    6 |    1    1\n   4 |    4    3    4 |    1    1\n   5 |    6    5    2 |    2    1\n   6 |    5    6    3 |    2    1\n   7 |    -    -    - |    -    -\n";
        Assert.assertEquals((String)"   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    3    1    5 |    1    1\n   3 |    2    4    6 |    1    1\n   4 |    4    3    4 |    1    1\n   5 |    6    5    2 |    2    1\n   6 |    5    6    3 |    2    1\n   7 |    -    -    - |    -    -\n", (String)this.ds1.tabularDisplay());
    }

    public void testRemoveElement() {
        Assert.assertTrue((boolean)this.ds1.hasElement(three));
        this.ds1.removeElement(three);
        Assert.assertFalse((boolean)this.ds1.hasElement(three));
        String out = "   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    -    1    5 |    1    1\n   4 |    4    -    4 |    1    1\n   5 |    6    5    2 |    2    1\n   6 |    5    6    - |    2    1\n";
        Assert.assertEquals((String)"   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    -    1    5 |    1    1\n   4 |    4    -    4 |    1    1\n   5 |    6    5    2 |    2    1\n   6 |    5    6    - |    2    1\n", (String)this.ds1.tabularDisplay());
    }

    public void testCollapse() {
        LinkedList<Integer> disposable = new LinkedList<Integer>();
        disposable.add(two);
        disposable.add(five);
        try {
            this.ds1.collapse(disposable, 2);
            Assert.fail((String)"should have thrown an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.ds1.redefineV(0, 1, five, 1);
        this.ds1.collapse(disposable, 2);
        String out = "   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    1    1 |    1    1\n   3 |    6    4    6 |    1    1\n   4 |    4    3    4 |    1    1\n   6 |    3    6    3 |    1    1\n";
        Assert.assertEquals((String)"   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    1    1 |    1    1\n   3 |    6    4    6 |    1    1\n   4 |    4    3    4 |    1    1\n   6 |    3    6    3 |    1    1\n", (String)this.ds1.tabularDisplay());
    }

    public void testDual() {
        String out = "   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    4    1    - |    1    1\n   3 |    3    -    3 |    1    1\n   4 |    2    4    5 |    1    2\n   5 |    -    5    4 |    1    2\n";
        this.ds1.removeElement(three);
        Assert.assertEquals((String)"   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    4    1    - |    1    1\n   3 |    3    -    3 |    1    1\n   4 |    2    4    5 |    1    2\n   5 |    -    5    4 |    1    2\n", (String)this.ds1.dual().tabularDisplay());
    }

    public void testAppend() {
        DynamicDSymbol ds = new DynamicDSymbol(2);
        ds.append(new DSymbol("4:2 4,3 2 4,2 4:4,4"));
        ds.append(new DSymbol("4:2 4,4 3,2 4:4,4"));
        String out = "   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    2    3    2 |    1    1\n   2 |    1    2    1 |    1    1\n   3 |    4    1    4 |    1    1\n   4 |    3    4    3 |    1    1\n   5 |    6    8    6 |    2    2\n   6 |    5    7    5 |    2    2\n   7 |    8    6    8 |    2    2\n   8 |    7    5    7 |    2    2\n";
        TestDynamicDSymbol.assertEquals((String)"   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    2    3    2 |    1    1\n   2 |    1    2    1 |    1    1\n   3 |    4    1    4 |    1    1\n   4 |    3    4    3 |    1    1\n   5 |    6    8    6 |    2    2\n   6 |    5    7    5 |    2    2\n   7 |    8    6    8 |    2    2\n   8 |    7    5    7 |    2    2\n", (String)ds.tabularDisplay());
    }

    public void testRenumbert() {
        this.ds1.removeElement(three);
        this.ds1.renumber();
        String out = "   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    -    1    4 |    1    1\n   3 |    3    -    3 |    1    1\n   4 |    5    4    2 |    2    1\n   5 |    4    5    - |    2    1\n";
        Assert.assertEquals((String)"   D |  op0  op1  op2 |  v01  v12\n-----+----------------+-----------\n   1 |    1    2    1 |    1    1\n   2 |    -    1    4 |    1    1\n   3 |    3    -    3 |    1    1\n   4 |    5    4    2 |    2    1\n   5 |    4    5    - |    2    1\n", (String)this.ds1.tabularDisplay());
    }
}

