/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.List;
import java.util.TreeSet;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DelaneySymbol;
import org.gavrog.joss.dsyms.basic.Traversal;

public class Subsymbol<T>
extends DelaneySymbol<T> {
    private DelaneySymbol<T> ds;
    private TreeSet<Integer> indices;
    private TreeSet<T> elements;
    private int dim;
    private int size;

    public Subsymbol(DelaneySymbol<T> delaneySymbol, List<Integer> list, T t) {
        this.ds = delaneySymbol;
        this.indices = new TreeSet();
        this.indices.addAll(list);
        this.dim = this.indices.size() - 1;
        this.elements = new TreeSet();
        for (DSPair dSPair : new Traversal<IteratorAdapter<T>>(delaneySymbol, list, Iterators.singleton(t))) {
            this.elements.add(dSPair.getElement());
        }
        this.size = this.elements.size();
    }

    @Override
    public int dim() {
        return this.dim;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public IteratorAdapter<T> elements() {
        return new FilteredIterator<T, T>(this.elements.iterator()){

            @Override
            public T filter(T t) {
                return t;
            }
        };
    }

    @Override
    public boolean hasElement(Object object) {
        return this.elements.contains(object);
    }

    @Override
    public IteratorAdapter<Integer> indices() {
        return new FilteredIterator<Integer, Integer>(this.indices.iterator()){

            @Override
            public Integer filter(Integer n) {
                return n;
            }
        };
    }

    @Override
    public boolean hasIndex(int n) {
        return this.indices.contains(new Integer(n));
    }

    @Override
    public boolean definesOp(int n, T t) {
        return this.ds.definesOp(n, t);
    }

    @Override
    public T op(int n, T t) {
        if (!this.hasElement((Object)t)) {
            throw new IllegalArgumentException("not an element: " + t);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        return this.ds.op(n, t);
    }

    @Override
    public boolean definesV(int n, int n2, T t) {
        return this.ds.definesV(n, n2, t);
    }

    @Override
    public int v(int n, int n2, T t) {
        if (!this.hasElement((Object)t)) {
            throw new IllegalArgumentException("not an element: " + t);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (!this.hasIndex(n2)) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        return this.normalizedV(this.ds.v(n, n2, t));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Subsymbol(");
        stringBuffer.append(this.ds);
        stringBuffer.append(", (");
        IteratorAdapter<Integer> iteratorAdapter = this.indices();
        boolean bl = true;
        while (iteratorAdapter.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iteratorAdapter.next());
        }
        stringBuffer.append("), ");
        stringBuffer.append(this.elements.first());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

