/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.dsyms.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.FilteredIterator;
import org.gavrog.box.collections.IteratorAdapter;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.NiftyList;
import org.gavrog.box.simple.Strings;
import org.gavrog.jane.numbers.Fraction;
import org.gavrog.jane.numbers.Rational;
import org.gavrog.joss.dsyms.basic.DSPair;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.basic.NonSphericalException;
import org.gavrog.joss.dsyms.basic.Subsymbol;
import org.gavrog.joss.dsyms.basic.Traversal;
import org.gavrog.joss.dsyms.basic.TypedPartition;

public abstract class DelaneySymbol<T>
implements Comparable<DelaneySymbol<T>> {
    private boolean vDefaultToOne = false;
    private NiftyList<Integer> _invariant = null;
    private Map<T, Integer> original2canonical;

    public boolean isVDefaultToOne() {
        return this.vDefaultToOne;
    }

    public void setVDefaultToOne(boolean bl) {
        this.vDefaultToOne = bl;
    }

    protected int normalizedV(int n) {
        if (n > 0) {
            return n;
        }
        if (this.isVDefaultToOne()) {
            return 1;
        }
        return 0;
    }

    public abstract int dim();

    public abstract int size();

    public abstract IteratorAdapter<T> elements();

    public abstract boolean hasElement(T var1);

    public abstract IteratorAdapter<Integer> indices();

    public abstract boolean hasIndex(int var1);

    public abstract boolean definesOp(int var1, T var2);

    public abstract T op(int var1, T var2);

    public abstract boolean definesV(int var1, int var2, T var3);

    public abstract int v(int var1, int var2, T var3);

    public String tabularDisplay() {
        int n;
        int n2;
        int n3;
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        StringBuffer stringBuffer = new StringBuffer(500);
        IndexList indexList = new IndexList(this);
        int n4 = 4;
        int n5 = 4;
        for (T t : this.elements()) {
            n4 = Math.max(n4, t.toString().length());
            for (n3 = 0; n3 < this.dim(); ++n3) {
                n2 = (Integer)indexList.get(n3);
                int n6 = (Integer)indexList.get(n3 + 1);
                n5 = Math.max(n5, String.valueOf(this.v(n2, n6, t)).length());
            }
        }
        stringBuffer.append(Strings.rjust("D", n4));
        stringBuffer.append(" |");
        for (n = 0; n <= this.dim(); ++n) {
            stringBuffer.append(" ");
            stringBuffer.append(Strings.rjust("op" + indexList.get(n), n4));
        }
        stringBuffer.append(" |");
        for (n = 0; n < this.dim(); ++n) {
            stringBuffer.append(" ");
            stringBuffer.append(Strings.rjust("v" + indexList.get(n) + indexList.get(n + 1), n5));
        }
        stringBuffer.append("\n");
        stringBuffer.append(Strings.rjust("", n4, '-'));
        stringBuffer.append("-+");
        for (n = 0; n <= this.dim(); ++n) {
            stringBuffer.append(Strings.rjust("", n4 + 1, '-'));
        }
        stringBuffer.append("-+");
        for (n = 0; n < this.dim(); ++n) {
            stringBuffer.append(Strings.rjust("", n5 + 1, '-'));
        }
        stringBuffer.append("-\n");
        for (T t : this.elements()) {
            stringBuffer.append(Strings.rjust(t.toString(), n4));
            stringBuffer.append(" |");
            for (n3 = 0; n3 <= this.dim(); ++n3) {
                n2 = (Integer)indexList.get(n3);
                String string = this.definesOp(n2, t) ? "" + this.op(n2, t) : "-";
                stringBuffer.append(" ");
                stringBuffer.append(Strings.rjust(string, n4));
            }
            stringBuffer.append(" |");
            for (n3 = 0; n3 < this.dim(); ++n3) {
                int n7;
                n2 = (Integer)indexList.get(n3);
                String string = this.definesV(n2, n7 = ((Integer)indexList.get(n3 + 1)).intValue(), t) ? "" + this.v(n2, n7, t) : "-";
                stringBuffer.append(" ");
                stringBuffer.append(Strings.rjust(string, n5));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean hasStandardIndexSet() {
        IndexList indexList = new IndexList(this);
        for (int i = 0; i < indexList.size(); ++i) {
            if ((Integer)indexList.get(i) == i) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete() {
        IndexList indexList = new IndexList(this);
        for (T t : this.elements()) {
            for (int i = 0; i < indexList.size() - 1; ++i) {
                int n = (Integer)indexList.get(i);
                if (!this.definesOp(n, t)) {
                    return false;
                }
                for (int j = i + 1; j < indexList.size(); ++j) {
                    int n2 = (Integer)indexList.get(j);
                    if (this.definesV(n, n2, t)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public int r(int n, int n2, T t) {
        if (!this.hasElement(t)) {
            throw new IllegalArgumentException("not an element: " + t);
        }
        if (!this.hasIndex(n)) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        if (!this.hasIndex(n2)) {
            throw new IllegalArgumentException("invalid index: " + n2);
        }
        T t2 = t;
        int n3 = 0;
        do {
            if (this.definesOp(n, t2)) {
                t2 = this.op(n, t2);
            }
            if (this.definesOp(n2, t2)) {
                t2 = this.op(n2, t2);
            }
            ++n3;
        } while (!t2.equals(t));
        return n3;
    }

    public int m(int n, int n2, T t) {
        return this.v(n, n2, t) * this.r(n, n2, t);
    }

    public int numberOfOrbits(List<Integer> list) {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        int n = 0;
        for (DSPair dSPair : new Traversal<IteratorAdapter<T>>(this, list, this.elements())) {
            if (dSPair.getIndex() >= 0) continue;
            ++n;
        }
        return n;
    }

    public boolean isConnected() {
        return this.numberOfOrbits(new IndexList(this)) <= 1;
    }

    public IteratorAdapter<T> orbitReps(List<Integer> list) {
        return new FilteredIterator<T, DSPair<T>>(new Traversal<IteratorAdapter<T>>(this, list, this.elements())){

            @Override
            public T filter(DSPair<T> dSPair) {
                if (dSPair.getIndex() < 0) {
                    return dSPair.getElement();
                }
                return null;
            }
        };
    }

    public IteratorAdapter<T> orbit(List<Integer> list, T t) {
        return new FilteredIterator<T, DSPair<T>>(new Traversal<T>(this, list, t)){

            @Override
            public T filter(DSPair<T> dSPair) {
                return dSPair.getElement();
            }
        };
    }

    public Map<T, Integer> partialOrientation(List<Integer> list, Iterator<T> iterator) {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        HashMap hashMap = new HashMap();
        for (DSPair dSPair : new Traversal<Iterator<T>>(this, list, iterator)) {
            int n = dSPair.getIndex();
            Object t = dSPair.getElement();
            if (n < 0) {
                hashMap.put(t, 1);
                continue;
            }
            hashMap.put(t, -((Integer)hashMap.get(this.op(n, t))).intValue());
        }
        return hashMap;
    }

    public Map<T, Integer> partialOrientation() {
        return this.partialOrientation(new IndexList(this), this.elements());
    }

    private int orbitOrientation(List<Integer> list, T t) {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        Map<T, Integer> map = this.partialOrientation(list, Iterators.singleton(t));
        boolean bl = true;
        boolean bl2 = true;
        for (T t2 : this.orbit(list, t)) {
            for (int n : list) {
                T t3 = this.op(n, t2);
                if (t2.equals(t3)) {
                    bl2 = false;
                    continue;
                }
                if (!map.get(t2).equals(map.get(t3))) continue;
                bl = false;
            }
        }
        return (bl ? 2 : 0) + (bl2 ? 1 : 0);
    }

    public boolean orbitIsOriented(List<Integer> list, T t) {
        return this.orbitOrientation(list, t) == 3;
    }

    public boolean isOriented() {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        IndexList indexList = new IndexList(this);
        for (T t : this.orbitReps(indexList)) {
            if (this.orbitIsOriented(indexList, t)) continue;
            return false;
        }
        return true;
    }

    public boolean orbitIsLoopless(List<Integer> list, T t) {
        return this.orbitOrientation(list, t) % 2 == 1;
    }

    public boolean isLoopless() {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        IndexList indexList = new IndexList(this);
        for (T t : this.orbitReps(indexList)) {
            if (this.orbitIsLoopless(indexList, t)) continue;
            return false;
        }
        return true;
    }

    public boolean orbitIsWeaklyOriented(List<Integer> list, T t) {
        return this.orbitOrientation(list, t) >= 2;
    }

    public boolean isWeaklyOriented() {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        IndexList indexList = new IndexList(this);
        for (T t : this.orbitReps(indexList)) {
            if (this.orbitIsWeaklyOriented(indexList, t)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public NiftyList<Integer> invariant() {
        void var5_14;
        if (this._invariant != null) {
            return this._invariant;
        }
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        if (!this.isConnected()) {
            ArrayList<NiftyList<Integer>> arrayList = new ArrayList<NiftyList<Integer>>();
            IndexList indexList = new IndexList(this);
            for (Object object : this.orbitReps(indexList)) {
                DelaneySymbol<Integer> object2 = new Subsymbol<T>(this, indexList, object).flat();
                arrayList.add(object2.invariant());
            }
            Collections.sort(arrayList);
            LinkedList linkedList = new LinkedList();
            for (List list : arrayList) {
                linkedList.addAll(list);
            }
            this._invariant = new NiftyList(linkedList);
            return this._invariant;
        }
        IndexList indexList = new IndexList(this);
        int[] nArray = null;
        int[] nArray2 = new int[(this.size() + 1) * (4 * this.dim() + 3)];
        int n = 0;
        Object var5_13 = null;
        HashMap hashMap = new HashMap();
        for (int i = 0; i <= this.dim(); ++i) {
            hashMap.put(indexList.get(i), i);
        }
        for (T t : this.elements()) {
            HashMap hashMap2 = new HashMap();
            int n2 = 1;
            int n3 = 0;
            for (DSPair dSPair : new Traversal<T>(this, (List<Integer>)indexList, t, true)) {
                int n4;
                int n5;
                boolean bl;
                Object t2 = dSPair.getElement();
                int n6 = dSPair.getIndex();
                if (!hashMap2.containsKey(t2)) {
                    bl = true;
                    n5 = n2++;
                    hashMap2.put(t2, new Integer(n5));
                } else {
                    bl = false;
                    n5 = (Integer)hashMap2.get(t2);
                }
                int n7 = n6;
                if (n6 >= 0) {
                    n7 = (Integer)hashMap.get(n6);
                }
                if (nArray != null) {
                    if (n7 > nArray[n3]) break;
                    if (n7 < nArray[n3]) {
                        nArray = null;
                    }
                }
                nArray2[n3++] = n7;
                if (n6 >= 0) {
                    n4 = (Integer)hashMap2.get(this.op(n6, t2));
                    if (nArray != null) {
                        if (n4 > nArray[n3]) break;
                        if (n4 < nArray[n3]) {
                            nArray = null;
                        }
                    }
                    nArray2[n3++] = n4;
                }
                if (nArray != null) {
                    if (n5 > nArray[n3]) break;
                    if (n5 < nArray[n3]) {
                        nArray = null;
                    }
                }
                nArray2[n3++] = n5;
                if (!bl) continue;
                n4 = 0;
                for (int i = 0; i < this.dim(); ++i) {
                    int n8;
                    int n9;
                    int n10 = (Integer)indexList.get(i);
                    int n11 = n9 = this.definesV(n10, n8 = ((Integer)indexList.get(i + 1)).intValue(), t2) ? this.v(n10, n8, t2) : 0;
                    if (nArray != null) {
                        if (n9 > nArray[n3] || n9 == 0 && nArray[n3] != 0) {
                            n4 = 1;
                            break;
                        }
                        if (n9 < nArray[n3] || n9 != 0 && nArray[n3] == 0) {
                            nArray = null;
                        }
                    }
                    nArray2[n3++] = n9;
                }
                if (n4 == 0) continue;
                break;
            }
            if (nArray != null) continue;
            nArray = (int[])nArray2.clone();
            n = n3;
            HashMap hashMap3 = hashMap2;
        }
        this.original2canonical = Collections.unmodifiableMap(var5_14);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n; ++i) {
            arrayList.add((int)nArray[i]);
        }
        this._invariant = new NiftyList(arrayList);
        return this._invariant;
    }

    public boolean equals(Object object) {
        DelaneySymbol delaneySymbol;
        if (object instanceof DelaneySymbol && (delaneySymbol = (DelaneySymbol)object).dim() == this.dim() && delaneySymbol.size() == this.size()) {
            return this.invariant().equals(delaneySymbol.invariant());
        }
        return false;
    }

    @Override
    public int compareTo(DelaneySymbol<T> delaneySymbol) {
        if (this.dim() != delaneySymbol.dim()) {
            return this.dim() - delaneySymbol.dim();
        }
        return this.invariant().compareTo((List<Integer>)delaneySymbol.invariant());
    }

    public int hashCode() {
        return this.invariant().hashCode();
    }

    public DelaneySymbol<Integer> canonical() {
        int[][] nArray = new int[this.dim() + 1][this.size() + 1];
        int[][] nArray2 = new int[this.dim()][this.size() + 1];
        NiftyList<Integer> niftyList = this.invariant();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < niftyList.size()) {
            int n4;
            if ((n4 = ((Integer)niftyList.get(n3++)).intValue()) < 0) {
                n = n2;
            }
            int n5 = (Integer)niftyList.get(n3++) + n;
            int n6 = 0;
            if (n4 >= 0) {
                n6 = n5;
                n5 = (Integer)niftyList.get(n3++) + n;
                nArray[n4][n5] = n6;
                nArray[n4][n6] = n5;
            }
            if (n5 <= n2) continue;
            for (n4 = 0; n4 < this.dim(); ++n4) {
                nArray2[n4][n5] = (Integer)niftyList.get(n3++);
                n2 = n5;
            }
        }
        return new DSymbol(nArray, nArray2);
    }

    public Map<T, Integer> getMapToCanonical() {
        if (!this.isConnected()) {
            throw new UnsupportedOperationException("symbol must be connected");
        }
        this.invariant();
        return this.original2canonical;
    }

    public boolean isMinimal() {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        TypedPartition<Object> typedPartition = new TypedPartition<Object>(this);
        Object t = null;
        for (T t2 : this.elements()) {
            if (t == null) {
                t = t2;
                continue;
            }
            if (!typedPartition.unite(t, t2)) continue;
            return false;
        }
        return true;
    }

    public DelaneySymbol<Integer> minimal() {
        Object object;
        Object object22;
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        TypedPartition<T> typedPartition = new TypedPartition<T>(this);
        typedPartition.uniteAll();
        HashMap<T, Integer> hashMap = new HashMap<T, Integer>();
        ArrayList arrayList = new ArrayList();
        for (Object object22 : this.elements()) {
            object = typedPartition.find(object22);
            if (!hashMap.containsKey(object)) {
                arrayList.add(object);
                hashMap.put(object, arrayList.size());
            }
            hashMap.put(object22, (Integer)hashMap.get(object));
        }
        int n = arrayList.size();
        object22 = new int[this.dim() + 1][n + 1];
        object = new int[this.dim()][n + 1];
        IndexList indexList = new IndexList(this);
        for (int i = 1; i <= n; ++i) {
            Object e = arrayList.get(i - 1);
            for (int j = 0; j <= this.dim(); ++j) {
                int n2 = (Integer)indexList.get(j);
                object22[j][i] = (Integer)hashMap.get(this.op(n2, e));
                if (j >= this.dim()) continue;
                object[j][i] = true;
            }
        }
        DSymbol dSymbol = new DSymbol((int[][])object22, (int[][])object);
        for (int i = 0; i < this.dim(); ++i) {
            IndexList indexList2 = new IndexList(i, i + 1);
            Iterator<T> iterator = dSymbol.orbitReps(indexList2).iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                Object e = arrayList.get(n3 - 1);
                int n4 = (Integer)indexList.get(i);
                int n5 = (Integer)indexList.get(i + 1);
                int n6 = this.m(n4, n5, e);
                int n7 = dSymbol.r(i, i + 1, n3);
                int n8 = n6 / n7;
                for (int n9 : dSymbol.orbit(indexList2, n3)) {
                    object[i][n9] = n8;
                }
            }
        }
        return new DSymbol((int[][])object22, (int[][])object);
    }

    public DelaneySymbol<Integer> flat() {
        return new DSymbol(this);
    }

    private Rational curvatureSummands(int n, int n2) {
        Rational rational = new Fraction(0L, 1L);
        for (T t : this.orbitReps(new IndexList(n, n2))) {
            int n3 = this.orbitIsOriented(new IndexList(n, n2), t) ? 2 : 1;
            rational = (Rational)rational.plus(new Fraction((long)n3, (long)this.v(n, n2, t)));
        }
        return rational;
    }

    public Rational curvature2D() {
        if (this.dim() != 2) {
            String string = "symbol must be 2-dimensional";
            throw new UnsupportedOperationException(string);
        }
        Rational rational = new Fraction((long)(-this.size()), 1L);
        IteratorAdapter<Integer> iteratorAdapter = this.indices();
        int n = (Integer)iteratorAdapter.next();
        int n2 = (Integer)iteratorAdapter.next();
        int n3 = (Integer)iteratorAdapter.next();
        rational = (Rational)rational.plus(this.curvatureSummands(n, n2));
        rational = (Rational)rational.plus(this.curvatureSummands(n, n3));
        rational = (Rational)rational.plus(this.curvatureSummands(n2, n3));
        return rational;
    }

    public boolean isSpherical2D() {
        if (this.dim() != 2) {
            throw new IllegalArgumentException("symbol must be 2-dimensional");
        }
        if (!this.isConnected()) {
            throw new IllegalArgumentException("symbol must be connected");
        }
        if (this.curvature2D().isPositive()) {
            DSymbol dSymbol = new DSymbol(this.orientedCover());
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < 2; ++i) {
                for (int j = i + 1; j <= 2; ++j) {
                    Iterator<T> iterator = dSymbol.orbitReps(new IndexList(i, j)).iterator();
                    while (iterator.hasNext()) {
                        int n = (Integer)iterator.next();
                        int n2 = dSymbol.v(i, j, n);
                        if (n2 <= 1) continue;
                        arrayList.add(new Integer(n2));
                    }
                }
            }
            if (arrayList.size() == 1) {
                return false;
            }
            if (arrayList.size() == 2) {
                return ((Integer)arrayList.get(0)).equals(arrayList.get(1));
            }
            if (arrayList.size() == 3 || arrayList.size() == 0) {
                return true;
            }
            throw new RuntimeException("this should not happen");
        }
        return false;
    }

    public int sphericalGroupSize2D() {
        if (!this.isSpherical2D()) {
            throw new NonSphericalException("symbol must be spherical");
        }
        Rational rational = (Rational)new Fraction(4L, 1L).dividedBy(this.curvature2D());
        return rational.numerator().intValue();
    }

    public boolean isLocallyEuclidean3D() {
        if (this.dim() != 3) {
            String string = "symbol must be 3-dimensional";
            throw new UnsupportedOperationException(string);
        }
        for (int i = 0; i <= this.dim(); ++i) {
            IndexList indexList = new IndexList(this);
            indexList.remove(i);
            for (T t : this.orbitReps(indexList)) {
                Subsymbol<T> subsymbol = new Subsymbol<T>(this, indexList, t);
                if (subsymbol.isSpherical2D()) continue;
                return false;
            }
        }
        return true;
    }

    public String orbifoldSymbol2D() {
        if (this.dim() != 2) {
            throw new IllegalArgumentException("symbol must be 2-dimensional");
        }
        if (!this.isConnected()) {
            throw new IllegalArgumentException("symbol must be connected");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int[] nArray = new int[3];
        IteratorAdapter<Integer> iteratorAdapter = this.indices();
        nArray[0] = (Integer)iteratorAdapter.next();
        nArray[1] = (Integer)iteratorAdapter.next();
        nArray[2] = (Integer)iteratorAdapter.next();
        for (int i = 0; i < 3; ++i) {
            int n = (i + 1) % 3;
            int n2 = (i + 2) % 3;
            IndexList indexList = new IndexList(nArray[n], nArray[n2]);
            for (T t : this.orbitReps(indexList)) {
                int n3 = this.v(n, n2, t);
                if (n3 <= 1) continue;
                if (this.orbitIsLoopless(indexList, t)) {
                    arrayList.add(String.valueOf(n3));
                    continue;
                }
                arrayList2.add(String.valueOf(n3));
            }
        }
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        Collections.sort(arrayList2);
        Collections.reverse(arrayList2);
        StringBuffer stringBuffer = new StringBuffer(20);
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            stringBuffer.append('1');
        }
        for (String string : arrayList) {
            stringBuffer.append(string);
        }
        if (!this.isLoopless()) {
            stringBuffer.append('*');
        }
        for (String string : arrayList2) {
            stringBuffer.append(string);
        }
        if (!this.isWeaklyOriented()) {
            stringBuffer.append('x');
        }
        return stringBuffer.toString();
    }

    public DelaneySymbol<Integer> orientedCover() {
        try {
            this.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("symbol must be finite");
        }
        if (this.isOriented()) {
            return this.flat();
        }
        int n = this.size();
        int n2 = this.dim();
        int[][] nArray = new int[n2 + 1][2 * n + 1];
        int[][] nArray2 = new int[n2][2 * n + 1];
        DelaneySymbol<Integer> delaneySymbol = this.flat();
        Map<Integer, Integer> map = delaneySymbol.partialOrientation();
        for (int i = 0; i <= n2; ++i) {
            for (int j = 1; j <= n; ++j) {
                if (!delaneySymbol.definesOp(i, j)) continue;
                int n3 = delaneySymbol.op(i, j);
                if (map.get(j).equals(map.get(n3))) {
                    nArray[i][j] = n3 + n;
                    nArray[i][n3] = j + n;
                    nArray[i][j + n] = n3;
                    nArray[i][n3 + n] = j;
                } else {
                    nArray[i][j] = n3;
                    nArray[i][n3] = j;
                    nArray[i][j + n] = n3 + n;
                    nArray[i][n3 + n] = j + n;
                }
                if (i >= n2) continue;
                int n4 = delaneySymbol.v(i, i + 1, j);
                nArray2[i][j + n] = n4;
                nArray2[i][j] = n4;
            }
        }
        return new DSymbol(nArray, nArray2);
    }
}

