/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.joss.algorithms;

import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.gavrog.box.simple.NamedConstant;
import org.gavrog.joss.algorithms.CheckpointEvent;
import org.gavrog.joss.algorithms.ResumableGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BranchAndCut<T>
extends ResumableGenerator<T> {
    private static final boolean LOGGING = false;
    private boolean done = false;
    private final LinkedList<BC_Move> stack = new LinkedList();
    private int[] resume = new int[0];
    private int resume_level = 0;
    private int resume_stack_level = 0;
    private boolean resume_point_reached = false;

    protected void log(String text) {
    }

    @Override
    protected T findNext() throws NoSuchElementException {
        if (this.done) {
            throw new NoSuchElementException();
        }
        this.log("");
        this.log("entering findNext(): stack size = " + this.stack.size());
        if (this.stack.size() == 0) {
            Move choice = this.nextChoice(null);
            if (choice == null) {
                this.log("leaving findNext(): no initial choice");
                this.done = true;
                throw new NoSuchElementException();
            }
            this.log("  adding initial choice " + choice);
            this.stack.addLast(new BC_Move(choice, Type.CHOICE, 0));
        }
        while (true) {
            Move move;
            BC_Move decision;
            if (!this.resume_point_reached && this.resume_level >= this.resume.length) {
                this.resume_point_reached = true;
                if (this.resume.length > 0) {
                    this.postCheckpoint("resume point reached");
                }
                if (this.resume_level > this.resume.length) {
                    this.log("  past resume point at [" + this.getCheckpoint() + "]");
                } else {
                    this.log("  resume point reached at [" + this.getCheckpoint() + "]");
                }
            }
            if ((decision = this.undoLastDecision()) == null) {
                this.log("leaving findNext(): no more decisions to undo");
                this.done = true;
                throw new NoSuchElementException();
            }
            this.log("  last decision was " + decision);
            if (!this.resume_point_reached && this.stack.size() < this.resume_stack_level) {
                this.resume_point_reached = true;
                if (this.resume.length > 0) {
                    this.postCheckpoint("resume point reached");
                }
                this.log("  past resume point at [" + this.getCheckpoint() + "]");
            }
            if ((move = this.nextDecision(decision.getData())) == null) {
                this.log("  no potential move");
                continue;
            }
            BC_Move next = new BC_Move(move, Type.DECISION, decision.getDecisionNumber() + 1);
            this.log("  found potential move " + next);
            int old_stack_size = this.stack.size();
            boolean success = this.performMoveAndDeductions(next);
            this.postCheckpoint(null);
            if (!this.resume_point_reached && old_stack_size == this.resume_stack_level && this.resume_level < this.resume.length && next.getDecisionNumber() == this.resume[this.resume_level]) {
                this.resume_stack_level = this.stack.size();
                ++this.resume_level;
                this.log("  resume level raised to " + this.resume_level + " at stack level " + this.resume_stack_level);
            }
            if (success) {
                if (this.isValid()) {
                    T result = this.isComplete() ? (T)this.makeResult() : null;
                    Move choice = this.nextChoice(move);
                    if (choice != null && (this.resume_point_reached || this.stack.size() == this.resume_stack_level)) {
                        this.log("  adding choice " + choice);
                        this.stack.addLast(new BC_Move(choice, Type.CHOICE, 0));
                    }
                    if (result == null) continue;
                    this.log("leaving findNext() with result " + result);
                    return result;
                }
                this.log("  result or move is not valid");
                continue;
            }
            this.log("  move was rejected");
        }
    }

    private boolean performMoveAndDeductions(BC_Move initial) {
        LinkedList<BC_Move> queue = new LinkedList<BC_Move>();
        queue.addLast(initial);
        while (queue.size() > 0) {
            BC_Move move = (BC_Move)queue.removeFirst();
            Status status = this.checkMove(move.getData());
            if (status == Status.VOID) continue;
            if (status == Status.ILLEGAL) {
                this.log("    move " + move + " is impossible; backtracking");
                this.stack.addLast(move);
                return false;
            }
            this.performMove(move.getData());
            this.stack.addLast(move);
            List<Move> deductions = this.deductions(move.getData());
            if (deductions == null) continue;
            for (Move d : deductions) {
                this.log("    adding deduction " + d);
                queue.add(new BC_Move(d, Type.DEDUCTION, 0));
            }
        }
        return true;
    }

    private BC_Move undoLastDecision() {
        while (this.stack.size() > 0) {
            BC_Move last = this.stack.removeLast();
            if (last == null) continue;
            this.log("  undoing " + last);
            this.undoMove(last.getData());
            if (last.isDeduction()) continue;
            return last;
        }
        return null;
    }

    private void postCheckpoint(String message) {
        this.dispatchEvent(new CheckpointEvent(this, !this.resume_point_reached, message));
    }

    @Override
    public String getCheckpoint() {
        StringBuffer buf = new StringBuffer(20);
        for (BC_Move move : this.stack) {
            if (!move.isDecision()) continue;
            if (buf.length() > 0) {
                buf.append('-');
            }
            buf.append(move.decisionNr);
        }
        return buf.toString();
    }

    @Override
    public void setResumePoint(String spec) {
        if (spec == null || spec.length() == 0) {
            return;
        }
        String[] fields = spec.trim().split("-");
        this.resume = new int[fields.length];
        int i = 0;
        while (i < fields.length) {
            this.resume[i] = Integer.valueOf(fields[i]);
            ++i;
        }
    }

    protected abstract Move nextChoice(Move var1);

    protected abstract Move nextDecision(Move var1);

    protected abstract Status checkMove(Move var1);

    protected abstract void performMove(Move var1);

    protected abstract void undoMove(Move var1);

    protected abstract List<Move> deductions(Move var1);

    protected abstract boolean isValid();

    protected abstract boolean isComplete();

    protected abstract T makeResult();

    private class BC_Move {
        private final Move data;
        private final Type type;
        private final int decisionNr;

        public BC_Move(Move data, Type type, int decisionNr) {
            this.data = data;
            this.type = type;
            this.decisionNr = decisionNr;
        }

        public boolean isDecision() {
            return this.type == Type.DECISION;
        }

        public boolean isDeduction() {
            return this.type == Type.DEDUCTION;
        }

        public int getDecisionNumber() {
            return this.decisionNr;
        }

        public Move getData() {
            return this.data;
        }

        public String toString() {
            return String.format("<%s, %s, %s>", this.getData(), this.type, this.getDecisionNumber());
        }
    }

    public static interface Move {
    }

    public static class Status
    extends NamedConstant {
        public static final Status OK = new Status("ok");
        public static final Status VOID = new Status("void");
        public static final Status ILLEGAL = new Status("illegal");

        private Status(String name) {
            super(name);
        }
    }

    public static class Type
    extends NamedConstant {
        public static final Type CHOICE = new Type("Choice");
        public static final Type DECISION = new Type("Decision");
        public static final Type DEDUCTION = new Type("Deduction");

        private Type(String name) {
            super(name);
        }
    }
}

