/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.numbers;

import org.gavrog.jane.numbers.ArithmeticBase;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Imaginary;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public abstract class Complex
extends ArithmeticBase {
    public static final Complex I = new Imaginary((Real)Whole.ZERO, (Real)Whole.ONE);

    public abstract Real realPart();

    public abstract Real imaginaryPart();

    public Complex make(Real real, Real real2) {
        if (real2.isZero()) {
            return real;
        }
        return new Imaginary(real, real2);
    }

    @Override
    public boolean isExact() {
        return this.realPart().isExact() && this.imaginaryPart().isExact();
    }

    @Override
    public IArithmetic zero() {
        return Whole.ZERO;
    }

    @Override
    public IArithmetic one() {
        return Whole.ONE;
    }

    public IArithmetic i() {
        return I;
    }

    @Override
    public IArithmetic negative() {
        return this.make((Real)this.realPart().negative(), (Real)this.imaginaryPart().negative());
    }

    @Override
    public IArithmetic inverse() {
        Real real = this.realPart();
        Real real2 = this.imaginaryPart();
        IArithmetic iArithmetic = real.times(real).plus(real2.times(real2));
        real = (Real)this.realPart().dividedBy(iArithmetic);
        real2 = (Real)this.imaginaryPart().negative().dividedBy(iArithmetic);
        return this.make(real, real2);
    }

    @Override
    public IArithmetic plus(Object object) {
        if (object instanceof Imaginary) {
            Real real = (Real)this.realPart().plus(((Imaginary)object).realPart());
            Real real2 = (Real)this.imaginaryPart().plus(((Imaginary)object).imaginaryPart());
            return this.make(real, real2);
        }
        if (object instanceof Real) {
            Real real = (Real)this.realPart().plus(object);
            return this.make(real, this.imaginaryPart());
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rplus(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic times(Object object) {
        if (object instanceof Imaginary) {
            Real real = this.realPart();
            Real real2 = this.imaginaryPart();
            Real real3 = ((Imaginary)object).realPart();
            Real real4 = ((Imaginary)object).imaginaryPart();
            Real real5 = (Real)real.times(real3).minus(real2.times(real4));
            Real real6 = (Real)real.times(real4).plus(real2.times(real3));
            return this.make(real5, real6);
        }
        if (object instanceof Real) {
            Real real = (Real)this.realPart().times(object);
            Real real7 = (Real)this.imaginaryPart().times(object);
            return this.make(real, real7);
        }
        if (object instanceof IArithmetic) {
            return ((IArithmetic)object).rtimes(this);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IArithmetic norm() {
        Real real = this.realPart();
        Real real2 = this.imaginaryPart();
        Real real3 = (Real)real.times(real).plus(real2.times(real2));
        return new FloatingPoint(Math.sqrt(real3.doubleValue()));
    }

    @Override
    public String toString() {
        if (this.imaginaryPart().isPositive()) {
            return this.realPart().toString() + "+" + this.imaginaryPart().toString() + "i";
        }
        return this.realPart().toString() + this.imaginaryPart().toString() + "i";
    }

    @Override
    public int hashCode() {
        return 31 * this.realPart().hashCode() + this.imaginaryPart().hashCode();
    }
}

