/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.numbers;

import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.IArithmetic;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public abstract class ArithmeticBase
implements IArithmetic {
    @Override
    public abstract boolean isExact();

    @Override
    public abstract IArithmetic zero();

    @Override
    public abstract IArithmetic one();

    @Override
    public abstract IArithmetic negative();

    @Override
    public abstract IArithmetic inverse();

    @Override
    public abstract IArithmetic plus(Object var1);

    @Override
    public abstract IArithmetic times(Object var1);

    @Override
    public abstract int compareTo(Object var1);

    @Override
    public abstract IArithmetic floor();

    public abstract String toString();

    public abstract int hashCode();

    @Override
    public boolean isZero() {
        return this.equals(this.zero());
    }

    @Override
    public boolean isOne() {
        return this.equals(this.one());
    }

    @Override
    public IArithmetic plus(long l) {
        return this.plus(new Whole(l));
    }

    @Override
    public IArithmetic plus(double d) {
        return this.plus(new FloatingPoint(d));
    }

    @Override
    public IArithmetic rplus(IArithmetic iArithmetic) {
        return this.plus(iArithmetic);
    }

    @Override
    public IArithmetic minus(Object object) {
        return this.plus(((IArithmetic)object).negative());
    }

    @Override
    public IArithmetic minus(long l) {
        return this.minus(new Whole(l));
    }

    @Override
    public IArithmetic minus(double d) {
        return this.minus(new FloatingPoint(d));
    }

    @Override
    public IArithmetic rminus(IArithmetic iArithmetic) {
        return this.negative().plus(iArithmetic);
    }

    @Override
    public IArithmetic times(long l) {
        return this.times(new Whole(l));
    }

    @Override
    public IArithmetic times(double d) {
        return this.times(new FloatingPoint(d));
    }

    @Override
    public IArithmetic rtimes(IArithmetic iArithmetic) {
        return this.times(iArithmetic);
    }

    @Override
    public IArithmetic dividedBy(long l) {
        return this.dividedBy(new Whole(l));
    }

    @Override
    public IArithmetic dividedBy(double d) {
        return this.dividedBy(new FloatingPoint(d));
    }

    @Override
    public IArithmetic dividedBy(Object object) {
        return this.times(((IArithmetic)object).inverse());
    }

    @Override
    public IArithmetic rdividedBy(IArithmetic iArithmetic) {
        return this.inverse().times(iArithmetic);
    }

    public IArithmetic div(long l) {
        return this.div(new Whole(l));
    }

    public IArithmetic div(double d) {
        return this.div(new FloatingPoint(d));
    }

    @Override
    public IArithmetic div(Object object) {
        return this.dividedBy(object).floor();
    }

    public IArithmetic mod(long l) {
        return this.mod(new Whole(l));
    }

    public IArithmetic mod(double d) {
        return this.mod(new FloatingPoint(d));
    }

    @Override
    public IArithmetic mod(Object object) {
        return this.minus(this.div(object).times(object));
    }

    @Override
    public IArithmetic raisedTo(Object object) {
        return ArithmeticBase.power(this, (Real)object);
    }

    @Override
    public IArithmetic raisedTo(long l) {
        return ArithmeticBase.power(this, new Whole(l));
    }

    @Override
    public IArithmetic round() {
        IArithmetic iArithmetic = this.floor();
        IArithmetic iArithmetic2 = iArithmetic.plus(Whole.ONE);
        if (this.minus(iArithmetic).isLessThan(iArithmetic2.minus(this))) {
            return iArithmetic;
        }
        return iArithmetic2;
    }

    public static IArithmetic power(IArithmetic iArithmetic, Real real) {
        IArithmetic iArithmetic2 = real.zero();
        Real real2 = (Real)real.one();
        IArithmetic iArithmetic3 = real2.plus(real2);
        if (real.isNegative()) {
            iArithmetic = iArithmetic.inverse();
            real = (Real)real.negative();
        }
        Real real3 = real2;
        while (real3.isLessOrEqual(real)) {
            real3 = (Real)real3.plus(real3);
        }
        IArithmetic iArithmetic4 = iArithmetic.one();
        while (real3.isGreaterThan(real2)) {
            real3 = (Real)real3.dividedBy(iArithmetic3);
            iArithmetic4 = iArithmetic4.times(iArithmetic4);
            if (!real.isGreaterOrEqual(real3)) continue;
            iArithmetic4 = iArithmetic4.times(iArithmetic);
            real = (Real)real.minus(real3);
        }
        if (!real.equals(iArithmetic2)) {
            throw new IllegalArgumentException("exponent must be integral");
        }
        return iArithmetic4;
    }

    @Override
    public int sign() {
        int n = this.compareTo(this.zero());
        if (n < 0) {
            return -1;
        }
        if (n == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isPositive() {
        return this.sign() > 0;
    }

    @Override
    public boolean isNonNegative() {
        return this.sign() >= 0;
    }

    @Override
    public boolean isNegative() {
        return this.sign() < 0;
    }

    @Override
    public IArithmetic abs() {
        if (this.sign() < 0) {
            return this.negative();
        }
        return this;
    }

    @Override
    public IArithmetic norm() {
        return this.abs();
    }

    @Override
    public boolean isLessThan(Object object) {
        return this.compareTo(object) < 0;
    }

    @Override
    public boolean isLessOrEqual(Object object) {
        return this.compareTo(object) <= 0;
    }

    @Override
    public boolean isGreaterThan(Object object) {
        return this.compareTo(object) > 0;
    }

    @Override
    public boolean isGreaterOrEqual(Object object) {
        return this.compareTo(object) >= 0;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public IArithmetic __neg__() {
        return this.negative();
    }

    public IArithmetic __add__(Object object) {
        return this.plus(object);
    }

    public IArithmetic __add__(long l) {
        return this.plus(new Whole(l));
    }

    public IArithmetic __add__(double d) {
        return this.plus(new FloatingPoint(d));
    }

    public IArithmetic __radd__(long l) {
        return new Whole(l).plus(this);
    }

    public IArithmetic __radd__(double d) {
        return new FloatingPoint(d).plus(this);
    }

    public IArithmetic __sub__(Object object) {
        return this.minus(object);
    }

    public IArithmetic __sub__(long l) {
        return this.minus(new Whole(l));
    }

    public IArithmetic __sub__(double d) {
        return this.minus(new FloatingPoint(d));
    }

    public IArithmetic __rsub__(long l) {
        return new Whole(l).minus(this);
    }

    public IArithmetic __rsub__(double d) {
        return new FloatingPoint(d).minus(this);
    }

    public IArithmetic __mul__(Object object) {
        return this.times(object);
    }

    public IArithmetic __mul__(long l) {
        return this.times(new Whole(l));
    }

    public IArithmetic __mul__(double d) {
        return this.times(new FloatingPoint(d));
    }

    public IArithmetic __rmul__(long l) {
        return new Whole(l).times(this);
    }

    public IArithmetic __rmul__(double d) {
        return new FloatingPoint(d).times(this);
    }

    public IArithmetic __div__(Object object) {
        return this.dividedBy(object);
    }

    public IArithmetic __div__(long l) {
        return this.dividedBy(new Whole(l));
    }

    public IArithmetic __div__(double d) {
        return this.dividedBy(new FloatingPoint(d));
    }

    public IArithmetic __rdiv__(long l) {
        return new Whole(l).dividedBy(this);
    }

    public IArithmetic __rdiv__(double d) {
        return new FloatingPoint(d).dividedBy(this);
    }

    public IArithmetic __pow__(Object object) {
        return this.raisedTo(object);
    }

    public IArithmetic __pow__(long l) {
        return this.raisedTo(new Whole(l));
    }

    public IArithmetic __rpow__(long l) {
        return new Whole(l).raisedTo((Whole)this);
    }

    public IArithmetic __rpow__(double d) {
        return new FloatingPoint(d).raisedTo(this);
    }

    public boolean __eq__(Object object) {
        return this.equals(object);
    }

    public boolean __eq__(long l) {
        return this.equals(new Whole(l));
    }

    public boolean __eq__(double d) {
        return this.equals(new FloatingPoint(d));
    }

    public boolean __ne__(Object object) {
        return !this.equals(object);
    }

    public boolean __ne__(long l) {
        return !this.equals(new Whole(l));
    }

    public boolean __ne__(double d) {
        return !this.equals(new FloatingPoint(d));
    }

    public int __hash__() {
        return this.hashCode();
    }

    public boolean __lt__(Object object) {
        return this.compareTo(object) < 0;
    }

    public boolean __lt__(long l) {
        return this.compareTo(new Whole(l)) < 0;
    }

    public boolean __lt__(double d) {
        return this.compareTo(new FloatingPoint(d)) < 0;
    }

    public boolean __le__(Object object) {
        return this.compareTo(object) <= 0;
    }

    public boolean __le__(long l) {
        return this.compareTo(new Whole(l)) <= 0;
    }

    public boolean __le__(double d) {
        return this.compareTo(new FloatingPoint(d)) <= 0;
    }

    public boolean __gt__(Object object) {
        return this.compareTo(object) > 0;
    }

    public boolean __gt__(long l) {
        return this.compareTo(new Whole(l)) > 0;
    }

    public boolean __gt__(double d) {
        return this.compareTo(new FloatingPoint(d)) > 0;
    }

    public boolean __ge__(Object object) {
        return this.compareTo(object) >= 0;
    }

    public boolean __ge__(long l) {
        return this.compareTo(new Whole(l)) >= 0;
    }

    public boolean __ge__(double d) {
        return this.compareTo(new FloatingPoint(d)) >= 0;
    }
}

