/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.box.collections.Iterators;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FiniteGroupAction;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.GroupAction;

public class TestFiniteGroupAction
extends TestCase {
    private FiniteAlphabet A;
    private FpGroup G;
    private List domain;
    private GroupAction action;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = new FiniteAlphabet<String>(new String[]{"a", "b"});
        this.G = new FpGroup(this.A);
        this.domain = new LinkedList();
        int i = 0;
        while (i < 6) {
            this.domain.add(new Integer(i));
            ++i;
        }
        this.action = new FiniteGroupAction(this.G, this.domain){

            protected Object applyGenerator(Object x, int gen, int sign) {
                int i = (Integer)x;
                return new Integer((i + sign * gen + 6) % 6);
            }
        };
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.A = null;
        this.G = null;
        this.domain = null;
        this.action = null;
    }

    public void testGetGroup() {
        Assert.assertEquals((Object)this.G, this.action.getGroup());
    }

    public void testSize() {
        Assert.assertEquals((int)this.domain.size(), (int)this.action.size());
    }

    public void testIsDefinedOn() {
        int i = 0;
        while (i < 6) {
            Assert.assertTrue((boolean)this.action.isDefinedOn(new Integer(i)));
            ++i;
        }
        Assert.assertFalse((boolean)this.action.isDefinedOn(new Integer(7)));
        Assert.assertFalse((boolean)this.action.isDefinedOn("hello"));
    }

    public void testDomain() {
        Assert.assertTrue((boolean)Iterators.equal(this.domain.iterator(), this.action.domain()));
    }

    public void testApply() {
        FreeWord w1 = FreeWord.parsedWord(this.A, "a*b*a^-1*b^-1");
        FreeWord w2 = FreeWord.parsedWord(this.A, "a*b*a*b");
        FreeWord w3 = FreeWord.parsedWord(this.A, "a^3*b^2");
        int i = 0;
        while (i < 6) {
            Integer I = new Integer(i);
            Integer J = new Integer((i + 1) % 6);
            Assert.assertEquals((Object)I, (Object)this.action.apply(I, w1));
            Assert.assertEquals((Object)I, (Object)this.action.apply(I, w2));
            Assert.assertEquals((Object)J, (Object)this.action.apply(I, w3));
            ++i;
        }
        Assert.assertNull((Object)this.action.apply(new Integer(6), w1));
    }
}

