/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.gavrog.jane.fpgroups.FiniteAlphabet;

public class TestFiniteAlphabet
extends TestCase {
    private FiniteAlphabet A;
    private FiniteAlphabet sameAsA;
    private FiniteAlphabet otherThanA;

    protected void setUp() throws Exception {
        super.setUp();
        this.A = FiniteAlphabet.fromPrefix("s", 5);
        this.sameAsA = new FiniteAlphabet<String>(new String[]{"s1", "s2", "s3", "s4", "s5"});
        this.otherThanA = new FiniteAlphabet<String>(new String[]{"s1", "s2", "s3", "s4", "s_5"});
    }

    protected void tearDown() throws Exception {
        this.A = null;
        this.sameAsA = null;
        this.otherThanA = null;
        super.tearDown();
    }

    public void testConstructors() {
        Object[] names = new Object[]{"a", "b", "c", new Integer(3)};
        FiniteAlphabet<Object> B = new FiniteAlphabet<Object>(names);
        Assert.assertTrue((B.size() == 4 ? 1 : 0) != 0);
        Assert.assertEquals((Object)B.letterToName(1), (Object)"a");
        Assert.assertEquals((Object)B.letterToName(3), (Object)"c");
        Assert.assertEquals((Object)B.letterToName(4), (Object)new Integer(3));
    }

    public void testSize() {
        Assert.assertTrue((this.A.size() == 5 ? 1 : 0) != 0);
    }

    public void testGet() {
        Assert.assertEquals(this.A.letterToName(1), (Object)"s1");
        Assert.assertEquals(this.A.letterToName(5), (Object)"s5");
        try {
            this.A.letterToName(0);
            TestFiniteAlphabet.fail((String)"should throw an IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.A.letterToName(6);
            TestFiniteAlphabet.fail((String)"should throw an IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testToString() {
        Assert.assertEquals((String)"Alphabet({\"s1\", \"s2\", \"s3\", \"s4\", \"s5\"})", (String)this.A.toString());
    }

    public void testEquals() {
        Assert.assertEquals((Object)this.A, (Object)this.sameAsA);
        Assert.assertNotSame((Object)this.A, (Object)this.otherThanA);
    }

    public void testHashCode() {
        Assert.assertTrue((this.A.hashCode() == this.sameAsA.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((this.A.hashCode() == this.otherThanA.hashCode() ? 1 : 0) != 0);
    }
}

