/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.fpgroups.FiniteAlphabet;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.GroupAction;
import org.gavrog.jane.fpgroups.PrefixAlphabet;

public class Stabilizer<E, D> {
    private static final boolean LOGGING = false;
    private final GroupAction<E, D> action;
    private final D basepoint;
    private final int maxLabelLength;
    private final FpGroup<E> group;
    private Map<FreeWord<E>, Set<FreeWord<E>>> relatorsByStartGen;
    private List<FreeWord<E>> generators = null;
    private FpGroup<String> presentation = null;
    private Map<Pair<D, FreeWord<E>>, FreeWord<String>> edgeLabelling = null;

    public Stabilizer(GroupAction<E, D> groupAction, D d) {
        this(groupAction, d, 10);
    }

    public Stabilizer(GroupAction<E, D> groupAction, D d, int n) {
        if (groupAction == null) {
            throw new NullPointerException("action cannot be null");
        }
        if (!groupAction.isDefinedOn(d)) {
            throw new IllegalArgumentException("illegal basepoint for action");
        }
        this.action = groupAction;
        this.basepoint = d;
        this.maxLabelLength = n;
        this.group = groupAction.getGroup();
    }

    private void compute() {
        Object object;
        Object object2;
        Set<Pair<D, FreeWord<E>>> set;
        Object object7;
        Object object8;
        FreeWord<Object> freeWord22;
        if (this.generators != null) {
            return;
        }
        LinkedList<FreeWord<E>> linkedList = new LinkedList<FreeWord<E>>();
        for (FreeWord<Object> freeWord22 : this.group.getGenerators()) {
            linkedList.add(freeWord22);
            linkedList.add(freeWord22.inverse());
        }
        this.preprocessRelators();
        this.generators = new ArrayList<FreeWord<E>>();
        this.edgeLabelling = new HashMap<Pair<D, FreeWord<E>>, FreeWord<String>>();
        PrefixAlphabet prefixAlphabet = new PrefixAlphabet("s_");
        freeWord22 = FreeWord.parsedWord(prefixAlphabet, "*");
        HashMap hashMap = new HashMap();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        linkedList2.addLast(this.basepoint);
        hashMap.put(this.basepoint, this.group.getIdentity());
        while (linkedList2.size() > 0) {
            object8 = linkedList2.removeFirst();
            object7 = (FreeWord)hashMap.get(object8);
            for (FreeWord object62 : linkedList) {
                Object object3 = this.action.apply(object8, object62);
                if (hashMap.containsKey(object3)) continue;
                this.edgeLabelling.put(new Pair<Object, FreeWord>(object8, object62), freeWord22);
                this.edgeLabelling.put(new Pair(object3, object62.inverse()), freeWord22);
                linkedList2.addLast(object3);
                hashMap.put(object3, ((FreeWord)object7).times(object62));
                this.closeRelations(object3, object62.inverse());
            }
        }
        object8 = this.action.domain();
        while (object8.hasNext()) {
            object7 = object8.next();
            set = (FreeWord)hashMap.get(object7);
            for (FreeWord freeWord : linkedList) {
                object2 = new Pair<Object, FreeWord>(object7, freeWord);
                if (this.edgeLabelling.containsKey(object2)) continue;
                object = this.action.apply(object7, freeWord);
                FreeWord freeWord3 = (FreeWord)hashMap.get(object);
                Object object4 = new Pair(object, freeWord.inverse());
                int n = this.generators.size() + 1;
                FreeWord freeWord4 = new FreeWord(prefixAlphabet, n);
                this.edgeLabelling.put((Pair<D, FreeWord<E>>)object2, freeWord4);
                this.edgeLabelling.put((Pair<D, FreeWord<E>>)object4, freeWord4.inverse());
                FreeWord freeWord5 = ((FreeWord)((Object)set)).times(freeWord).times(freeWord3.inverse());
                this.generators.add(freeWord5);
                this.closeRelations(object7, freeWord);
                this.closeRelations(object, freeWord.inverse());
            }
        }
        int n = this.generators.size();
        object7 = FiniteAlphabet.fromPrefix("s_", n);
        set = this.edgeLabelling.keySet();
        for (Pair<D, FreeWord<E>> pair : set) {
            object2 = this.edgeLabelling.get(pair);
            this.edgeLabelling.put(pair, new FreeWord(object7, (FreeWord<?>)object2));
        }
        List<FreeWord<E>> list = this.group.getRelators();
        LinkedList linkedList3 = new LinkedList();
        object2 = this.action.domain();
        while (object2.hasNext()) {
            object = object2.next();
            for (Object object4 : list) {
                linkedList3.add(this.traceWord((D)object, (FreeWord<E>)object4));
            }
        }
        this.presentation = new FpGroup(object7, linkedList3);
    }

    private void preprocessRelators() {
        this.relatorsByStartGen = new HashMap<FreeWord<E>, Set<FreeWord<E>>>();
        List<FreeWord<E>> list = this.group.getRelators();
        for (FreeWord<E> freeWord : list) {
            for (int i = -1; i <= 1; i += 2) {
                FreeWord<E> freeWord2 = freeWord.raisedTo(i);
                int n = freeWord2.length();
                for (int j = 0; j < n; ++j) {
                    FreeWord<E> freeWord3 = freeWord2.subword(j, n).times(freeWord2.subword(0, j));
                    FreeWord<E> freeWord4 = freeWord3.subword(0, 1);
                    if (!this.relatorsByStartGen.containsKey(freeWord4)) {
                        this.relatorsByStartGen.put(freeWord4, new HashSet());
                    }
                    this.relatorsByStartGen.get(freeWord4).add(freeWord3);
                }
            }
        }
    }

    private void closeRelations(D d, FreeWord<E> freeWord) {
        LinkedList<Pair<Object, FreeWord<E>>> linkedList = new LinkedList<Pair<Object, FreeWord<E>>>();
        linkedList.addLast(new Pair<D, FreeWord<E>>(d, freeWord));
        HashSet<Pair> hashSet = new HashSet<Pair>();
        while (linkedList.size() > 0) {
            Pair pair = (Pair)linkedList.removeFirst();
            if (hashSet.contains(pair)) continue;
            hashSet.add(pair);
            Object f = pair.getFirst();
            FreeWord freeWord2 = (FreeWord)pair.getSecond();
            Set<FreeWord<E>> set = this.relatorsByStartGen.get(freeWord2);
            if (set == null) continue;
            for (FreeWord<E> freeWord3 : set) {
                FreeWord<E> freeWord4;
                Pair<Object, FreeWord<E>> pair2;
                FreeWord<Object> freeWord5;
                int n = freeWord3.length();
                Object object = f;
                Pair pair3 = null;
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    freeWord5 = freeWord3.subword(i, i + 1);
                    pair2 = new Pair(object, freeWord5);
                    if (!this.edgeLabelling.containsKey(pair2)) {
                        if (pair3 != null) {
                            pair3 = null;
                            break;
                        }
                        pair3 = pair2;
                        n2 = i;
                    }
                    object = this.action.apply(object, freeWord5);
                }
                if (pair3 == null) continue;
                object = pair3.getFirst();
                FreeWord freeWord6 = (FreeWord)pair3.getSecond();
                freeWord5 = this.action.apply(object, freeWord6);
                pair2 = new Pair(freeWord5, freeWord6.inverse());
                FreeWord<E> freeWord7 = freeWord3.subword(n2, n);
                FreeWord<E> freeWord8 = freeWord7.times(freeWord4 = freeWord3.subword(0, n2)).inverse();
                FreeWord<String> freeWord9 = this.traceWord(object, freeWord8);
                if (freeWord9 == null || freeWord9.length() > this.maxLabelLength) continue;
                this.edgeLabelling.put(pair3, freeWord9);
                this.edgeLabelling.put(pair2, freeWord9.inverse());
                linkedList.addLast(pair3);
            }
        }
    }

    private FreeWord<String> traceWord(D d, FreeWord<E> freeWord) {
        FreeWord<String> freeWord2 = null;
        D d2 = d;
        for (int i = 0; i < freeWord.length(); ++i) {
            FreeWord<E> freeWord3 = freeWord.subword(i, i + 1);
            Pair<D, FreeWord<E>> pair = new Pair<D, FreeWord<E>>(d2, freeWord3);
            FreeWord<String> freeWord4 = this.edgeLabelling.get(pair);
            if (freeWord2 == null) {
                freeWord2 = freeWord4;
            } else if (freeWord4 != null) {
                freeWord2 = freeWord2.times(freeWord4);
            }
            d2 = this.action.apply(d2, freeWord3);
        }
        return freeWord2;
    }

    public GroupAction<E, D> getAction() {
        return this.action;
    }

    public D getBasepoint() {
        return this.basepoint;
    }

    public Map<Pair<D, FreeWord<E>>, FreeWord<String>> getEdgeLabelling() {
        this.compute();
        return this.edgeLabelling;
    }

    public List<FreeWord<E>> getGenerators() {
        this.compute();
        return this.generators;
    }

    public FpGroup<String> getPresentation() {
        this.compute();
        return this.presentation;
    }
}

