/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.fpgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.collections.Iterators;
import org.gavrog.box.collections.Pair;
import org.gavrog.jane.fpgroups.FpGroup;
import org.gavrog.jane.fpgroups.FreeWord;
import org.gavrog.jane.fpgroups.GroupAction;

public final class GroupActions {
    private GroupActions() {
    }

    public static <E, A, B> GroupAction<E, Pair<A, B>> product(final GroupAction<E, A> groupAction, final GroupAction<E, B> groupAction2) {
        if (!groupAction.getGroup().equals(groupAction2.getGroup())) {
            throw new IllegalArgumentException("actions of different groups");
        }
        return new GroupAction<E, Pair<A, B>>(){

            @Override
            public FpGroup<E> getGroup() {
                return groupAction.getGroup();
            }

            @Override
            public Iterator<Pair<A, B>> domain() {
                return Iterators.cantorProduct(groupAction.domain(), groupAction2.domain());
            }

            @Override
            public int size() {
                return groupAction.size() * groupAction2.size();
            }

            @Override
            public Pair<A, B> apply(Pair<A, B> pair, FreeWord<E> freeWord) {
                return new Pair(groupAction.apply(pair.getFirst(), freeWord), groupAction2.apply(pair.getSecond(), freeWord));
            }

            @Override
            public boolean isDefinedOn(Pair<A, B> pair) {
                return groupAction.isDefinedOn(pair.getFirst()) && groupAction2.isDefinedOn(pair.getSecond());
            }
        };
    }

    public static <E, D> GroupAction<E, List<D>> cover(final GroupAction<E, D> groupAction) {
        int n;
        try {
            n = groupAction.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("base action has no defined size");
        }
        return new GroupAction<E, List<D>>(){

            @Override
            public FpGroup<E> getGroup() {
                return groupAction.getGroup();
            }

            @Override
            public Iterator<List<D>> domain() {
                Object[] objectArray = new Object[groupAction.size()];
                Iterator iterator = groupAction.domain();
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = iterator.next();
                }
                return Iterators.permutations(objectArray);
            }

            @Override
            public int size() {
                int n2 = 1;
                for (int i = 2; i <= n; ++i) {
                    n2 *= i;
                }
                return n2;
            }

            @Override
            public List<D> apply(List<D> list, FreeWord<E> freeWord) {
                if (!this.isDefinedOn(list)) {
                    return null;
                }
                ArrayList arrayList = new ArrayList();
                for (Object d : list) {
                    arrayList.add(groupAction.apply(d, freeWord));
                }
                return arrayList;
            }

            @Override
            public boolean isDefinedOn(List<D> list) {
                if (list.size() != n) {
                    return false;
                }
                HashSet hashSet = new HashSet();
                for (Object d : list) {
                    if (!groupAction.isDefinedOn(d) || hashSet.contains(d)) {
                        return false;
                    }
                    hashSet.add(d);
                }
                return true;
            }
        };
    }

    public static <E, D> GroupAction<E, D> orbit(D d, final GroupAction<E, D> groupAction) {
        try {
            groupAction.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("action must be finite");
        }
        List<FreeWord<E>> list = groupAction.getGroup().getGenerators();
        LinkedList<D> linkedList = new LinkedList<D>();
        final HashSet<D> hashSet = new HashSet<D>();
        linkedList.addLast(d);
        hashSet.add(d);
        while (linkedList.size() > 0) {
            Object e = linkedList.removeFirst();
            for (FreeWord<E> freeWord : list) {
                for (int i = -1; i <= 1; i += 2) {
                    FreeWord<E> freeWord2 = freeWord.raisedTo(i);
                    D d2 = groupAction.apply(e, freeWord2);
                    if (hashSet.contains(d2)) continue;
                    hashSet.add(d2);
                    linkedList.addLast(d2);
                }
            }
        }
        return new GroupAction<E, D>(){

            @Override
            public FpGroup<E> getGroup() {
                return groupAction.getGroup();
            }

            @Override
            public Iterator<D> domain() {
                return hashSet.iterator();
            }

            @Override
            public int size() {
                return hashSet.size();
            }

            @Override
            public D apply(D d, FreeWord<E> freeWord) {
                if (!this.isDefinedOn(d)) {
                    return null;
                }
                return groupAction.apply(d, freeWord);
            }

            @Override
            public boolean isDefinedOn(D d) {
                return groupAction.isDefinedOn(d) && hashSet.contains(d);
            }
        };
    }

    public static <E, D> GroupAction<E, D> orbit(GroupAction<E, D> groupAction) {
        D d = groupAction.domain().next();
        return GroupActions.orbit(d, groupAction);
    }

    public static <E, D> GroupAction<E, Integer> flat(final GroupAction<E, D> groupAction) {
        Object object;
        int n;
        try {
            n = groupAction.size();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new UnsupportedOperationException("action must be finite");
        }
        HashMap<D, Integer> hashMap = new HashMap<D, Integer>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = groupAction.domain();
        while (object2.hasNext()) {
            object = object2.next();
            hashMap.put(object, arrayList.size());
            arrayList.add(object);
        }
        object2 = groupAction.getGroup().getGenerators();
        object = new HashMap();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            FreeWord freeWord = (FreeWord)iterator.next();
            for (int i = -1; i <= 1; i += 2) {
                FreeWord freeWord2 = freeWord.raisedTo(i);
                int[] nArray = new int[n];
                for (int j = 0; j < n; ++j) {
                    nArray[j] = (Integer)hashMap.get(groupAction.apply(arrayList.get(j), freeWord2));
                }
                object.put(freeWord2, (int[])nArray);
            }
        }
        return new GroupAction<E, Integer>((Map)object){
            final /* synthetic */ Map val$generatorActions;
            {
                this.val$generatorActions = map;
            }

            @Override
            public FpGroup<E> getGroup() {
                return groupAction.getGroup();
            }

            @Override
            public Iterator<Integer> domain() {
                return Iterators.range(0, n);
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public Integer apply(Integer n3, FreeWord<E> freeWord) {
                if (!this.isDefinedOn(n3)) {
                    return null;
                }
                int n2 = n3;
                for (int i = 0; i < freeWord.length(); ++i) {
                    FreeWord freeWord2 = freeWord.subword(i, i + 1);
                    n2 = ((int[])this.val$generatorActions.get(freeWord2))[n2];
                }
                return n2;
            }

            @Override
            public boolean isDefinedOn(Integer n2) {
                return n2 >= 0 && n2 < n;
            }
        };
    }
}

