/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.jane.compounds;

import junit.framework.TestCase;
import org.gavrog.jane.compounds.LinearAlgebra;
import org.gavrog.jane.compounds.Matrix;
import org.gavrog.jane.numbers.FloatingPoint;
import org.gavrog.jane.numbers.Real;
import org.gavrog.jane.numbers.Whole;

public class TestLinearAlgebra
extends TestCase {
    private final Matrix I = Matrix.one(3);
    private final Matrix M = new Matrix(new int[][]{{4, 1, 3}, {1, 5, 2}, {3, 2, 6}});
    private final Matrix A = new Matrix(new int[][]{{1, 2, 3}, {4, 5, 6}, {7, 8, 8}});
    private final Real eps = new FloatingPoint(1.0E-12);

    public void testRowOrthonormalized() {
        Matrix B = LinearAlgebra.rowOrthonormalized(this.A, this.M);
        Matrix D = (Matrix)this.I.minus(B.times(this.M).times(B.transposed()));
        TestLinearAlgebra.assertTrue((boolean)D.norm().isLessOrEqual(this.eps));
        TestLinearAlgebra.assertFalse((boolean)B.determinant().isZero());
        int i = 1;
        while (i <= 3) {
            Matrix T = new Matrix(2 * i, 3);
            T.setSubMatrix(0, 0, this.A.getSubMatrix(0, 0, i, 3));
            T.setSubMatrix(i, 0, B.getSubMatrix(0, 0, i, 3));
            TestLinearAlgebra.assertEquals((int)i, (int)T.rank());
            ++i;
        }
    }

    public void testOrthonormalRowBasis() {
        Matrix B = LinearAlgebra.orthonormalRowBasis(this.M);
        Matrix D = (Matrix)this.I.minus(B.times(this.M).times(B.transposed()));
        TestLinearAlgebra.assertTrue((boolean)D.norm().isLessOrEqual(this.eps));
        TestLinearAlgebra.assertFalse((boolean)B.determinant().isZero());
    }

    private static boolean isDiagonal(Matrix M) {
        int n = M.numberOfRows();
        int m = M.numberOfColumns();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                if (i != j && !M.get(i, j).isZero()) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static boolean isUnimodular(Matrix M) {
        return M.determinant().abs().equals(Whole.ONE);
    }

    private static boolean isIntegral(Matrix M) {
        int n = M.numberOfRows();
        int m = M.numberOfColumns();
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < m) {
                if (!(M.get(i, j) instanceof Whole)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void testSmithNormalForm() {
        this.testSmithNormalForm(this.A, true);
        this.testSmithNormalForm(this.A, false);
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[6];
        nArray[0] = -2;
        nArray[3] = -2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = -2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[6];
        nArray3[5] = -2;
        nArrayArray[2] = nArray3;
        Matrix L = new Matrix(nArrayArray);
        this.testSmithNormalForm(L, true);
        this.testSmithNormalForm(L, false);
    }

    private void testSmithNormalForm(Matrix A, boolean integral) {
        Matrix[] snf = LinearAlgebra.smithNormalForm(A, integral);
        Matrix P = snf[0];
        Matrix D = snf[1];
        Matrix Q = snf[2];
        TestLinearAlgebra.assertEquals((Object)D, (Object)P.times(A).times(Q));
        TestLinearAlgebra.assertTrue((boolean)TestLinearAlgebra.isDiagonal(D));
        TestLinearAlgebra.assertTrue((boolean)TestLinearAlgebra.isUnimodular(P));
        TestLinearAlgebra.assertTrue((boolean)TestLinearAlgebra.isUnimodular(Q));
        if (integral) {
            TestLinearAlgebra.assertTrue((boolean)TestLinearAlgebra.isIntegral(P));
            TestLinearAlgebra.assertTrue((boolean)TestLinearAlgebra.isIntegral(Q));
        }
    }

    public void testNullSpace() {
        this.testColumnNullSpace(this.A, true);
        this.testColumnNullSpace(this.A, false);
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[5] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[6];
        nArray3[2] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[6];
        nArray4[3] = 1;
        nArray4[5] = -1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[6];
        nArray5[4] = 1;
        nArrayArray[4] = nArray5;
        Matrix M = new Matrix(nArrayArray);
        this.testColumnNullSpace(M, true);
        this.testColumnNullSpace(M, false);
    }

    private void testColumnNullSpace(Matrix A, boolean integral) {
        int n = A.numberOfRows();
        int m = A.numberOfColumns();
        Matrix B = LinearAlgebra.columnNullSpace(A, integral);
        int k = B.numberOfColumns();
        TestLinearAlgebra.assertEquals((int)m, (int)(A.rank() + k));
        TestLinearAlgebra.assertEquals((int)k, (int)B.rank());
        TestLinearAlgebra.assertEquals((Object)Matrix.zero(n, k), (Object)A.times(B));
    }

    public void testSolutionInColumns() {
        this.testSolutionInColumns(this.A, this.I, true, true);
        this.testSolutionInColumns(this.A, this.I, false, true);
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        Matrix M = new Matrix(nArrayArray);
        Matrix b = new Matrix(new int[][]{new int[1], {1}});
        this.testSolutionInColumns(M, b, true, true);
        this.testSolutionInColumns(M, b, false, false);
        this.testSolutionInColumns(M, (Matrix)b.dividedBy(2L), true, false);
        int[][] nArrayArray2 = new int[3][];
        int[] nArray3 = new int[3];
        nArray3[0] = -2;
        nArrayArray2[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = -2;
        nArrayArray2[1] = nArray4;
        nArrayArray2[2] = new int[3];
        Matrix L = new Matrix(nArrayArray2);
        Matrix r = new Matrix(new int[][]{new int[1], {-1}, {1}});
        this.testSolutionInColumns(L, r, true, true);
        this.testSolutionInColumns(L, r, false, false);
        this.testSolutionInColumns(L, (Matrix)r.dividedBy(2L), true, false);
    }

    private void testSolutionInColumns(Matrix A, Matrix b, boolean modZ, boolean exists) {
        Matrix x = LinearAlgebra.solutionInColumns(A, b, modZ);
        if (exists) {
            if (!modZ) {
                TestLinearAlgebra.assertEquals((Object)b, (Object)A.times(x));
            } else {
                TestLinearAlgebra.assertTrue((boolean)TestLinearAlgebra.isIntegral((Matrix)b.minus(A.times(x))));
            }
        } else {
            TestLinearAlgebra.assertNull((Object)x);
        }
    }

    public void testSolutionInRows() {
        this.testSolutionInRows(this.A, this.I, true, true);
        this.testSolutionInRows(this.A, this.I, false, true);
        Matrix M = new Matrix(new int[][]{{1, 1}, new int[2]});
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        Matrix b = new Matrix(nArrayArray);
        this.testSolutionInRows(M, b, true, true);
        this.testSolutionInRows(M, b, false, false);
        this.testSolutionInRows(M, (Matrix)b.dividedBy(2L), true, false);
        int[][] nArrayArray2 = new int[3][];
        int[] nArray2 = new int[6];
        nArray2[0] = -2;
        nArray2[3] = -2;
        nArrayArray2[0] = nArray2;
        int[] nArray3 = new int[6];
        nArray3[1] = -2;
        nArrayArray2[1] = nArray3;
        int[] nArray4 = new int[6];
        nArray4[5] = -2;
        nArrayArray2[2] = nArray4;
        Matrix L = new Matrix(nArrayArray2);
        int[][] nArrayArray3 = new int[1][];
        int[] nArray5 = new int[6];
        nArray5[1] = -1;
        nArray5[2] = 1;
        nArray5[3] = -1;
        nArray5[4] = 1;
        nArrayArray3[0] = nArray5;
        Matrix r = new Matrix(nArrayArray3);
        this.testSolutionInRows(L, r, true, true);
        this.testSolutionInRows(L, (Matrix)r.dividedBy(2L), true, false);
    }

    private void testSolutionInRows(Matrix A, Matrix b, boolean modZ, boolean exists) {
        Matrix x = LinearAlgebra.solutionInRows(A, b, modZ);
        if (exists) {
            if (!modZ) {
                TestLinearAlgebra.assertEquals((Object)b, (Object)x.times(A));
            } else {
                TestLinearAlgebra.assertTrue((boolean)TestLinearAlgebra.isIntegral((Matrix)b.minus(x.times(A))));
            }
        } else {
            TestLinearAlgebra.assertNull((Object)x);
        }
    }
}

