/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.simple;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gavrog.box.simple.TaskStoppedException;

public class TaskController {
    private static final Map<Thread, TaskController> controllers = new HashMap<Thread, TaskController>();
    private final Thread thread;
    private boolean cancelled = false;

    protected TaskController(Thread thread) {
        this.thread = thread;
    }

    public static synchronized TaskController getInstance(Thread thread) {
        TaskController taskController = controllers.get(thread);
        if (taskController == null) {
            taskController = new TaskController(thread);
            controllers.put(thread, taskController);
        }
        return taskController;
    }

    public static TaskController getInstance() {
        return TaskController.getInstance(Thread.currentThread());
    }

    public static void cleanup() {
        LinkedList<Thread> linkedList = new LinkedList<Thread>();
        for (Thread thread : controllers.keySet()) {
            if (thread.isAlive()) continue;
            linkedList.add(thread);
        }
        for (Thread thread : linkedList) {
            controllers.remove(thread);
        }
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    public synchronized void reset() {
        this.cancelled = false;
    }

    public synchronized void bailOutIfCancelled() {
        if (this.cancelled) {
            this.cancelled = false;
            throw new TaskStoppedException(this.thread);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TaskController taskController = TaskController.getInstance();
                    for (long i = 0L; i < 10000000L; ++i) {
                        try {
                            taskController.bailOutIfCancelled();
                            continue;
                        }
                        catch (TaskStoppedException taskStoppedException) {
                            System.err.println("Stopped at x = " + i);
                            return;
                        }
                    }
                    System.err.println("Finished");
                }
            });
            System.err.print(i + ": ");
            thread.start();
            TaskController taskController = TaskController.getInstance(thread);
            try {
                Thread.sleep(0L, 0);
                if (i % 3 != 0) {
                    taskController.cancel();
                }
                thread.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        TaskController.cleanup();
    }
}

