/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.box.gui;

import buoy.event.EventProcessor;
import buoy.event.EventSource;
import buoy.event.ValueChangedEvent;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;
import org.gavrog.box.gui.RangeSlider;
import org.gavrog.box.simple.Strings;

public class OptionRangeSliderBox
extends BorderContainer {
    private boolean eventsLocked = false;
    private final RangeSlider slider;

    public OptionRangeSliderBox(String label, final Object target, final String optionLo, final String optionHi, double min, double max, double major, double minor, double snap) throws Exception {
        Method t;
        this.setBackground(null);
        this.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(2, 8, 2, 8), null));
        this.slider = new RangeSlider(min, min, min, max);
        this.slider.setBackground(null);
        this.slider.setShowTicks(true);
        this.slider.setShowValue(true);
        this.slider.setMajorTickSpacing(major);
        this.slider.setMinorTickSpacing(minor);
        this.slider.setSnapInterval(snap);
        this.add(this.slider, BorderContainer.WEST);
        this.add(new BLabel(label), BorderContainer.EAST, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 10, 2, 10), null));
        Class<?> klazz = target instanceof Class ? (Class<?>)target : target.getClass();
        String optionLoCap = Strings.capitalized(optionLo);
        String optionHiCap = Strings.capitalized(optionHi);
        Method getterLo = klazz.getMethod("get" + optionLoCap, new Class[0]);
        Method getterHi = klazz.getMethod("get" + optionHiCap, new Class[0]);
        try {
            t = klazz.getMethod("set" + optionLoCap, Integer.TYPE);
        }
        catch (NoSuchMethodException ex) {
            t = klazz.getMethod("set" + optionLoCap, Double.TYPE);
        }
        final Method setterLo = t;
        try {
            t = klazz.getMethod("set" + optionHiCap, Integer.TYPE);
        }
        catch (NoSuchMethodException ex) {
            t = klazz.getMethod("set" + optionHiCap, Double.TYPE);
        }
        final Method setterHi = t;
        this.updateLoValue(getterLo.invoke(target, new Object[0]));
        this.updateHiValue(getterHi.invoke(target, new Object[0]));
        this.slider.addEventLink(ValueChangedEvent.class, new EventProcessor(){

            public void handleEvent(Object event) {
                if (OptionRangeSliderBox.this.obtainLock()) {
                    try {
                        Number arg = OptionRangeSliderBox.this.slider.getLow();
                        if (setterLo.getParameterTypes()[0].equals(Integer.TYPE)) {
                            arg = (int)Math.round((Double)arg);
                        }
                        setterLo.invoke(target, arg);
                        arg = OptionRangeSliderBox.this.slider.getHigh();
                        if (setterHi.getParameterTypes()[0].equals(Integer.TYPE)) {
                            arg = (int)Math.round((Double)arg);
                        }
                        setterHi.invoke(target, arg);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    OptionRangeSliderBox.this.releaseLock();
                }
            }
        });
        if (target instanceof EventSource) {
            EventSource s = (EventSource)target;
            s.addEventLink(PropertyChangeEvent.class, new EventProcessor(){

                public void handleEvent(Object event) {
                    if (OptionRangeSliderBox.this.obtainLock()) {
                        PropertyChangeEvent e = (PropertyChangeEvent)event;
                        if (e.getPropertyName().equals(optionLo)) {
                            OptionRangeSliderBox.this.updateLoValue(e.getNewValue());
                        } else if (e.getPropertyName().equals(optionHi)) {
                            OptionRangeSliderBox.this.updateHiValue(e.getNewValue());
                        }
                        OptionRangeSliderBox.this.releaseLock();
                    }
                }
            });
        }
    }

    private void updateLoValue(Object newValue) {
        double val = ((Number)newValue).doubleValue();
        if (val > this.slider.getHigh()) {
            this.slider.setHigh(val);
        }
        this.slider.setLow(val);
    }

    private void updateHiValue(Object newValue) {
        double val = ((Number)newValue).doubleValue();
        if (val < this.slider.getLow()) {
            this.slider.setLow(val);
        }
        this.slider.setHigh(val);
    }

    private boolean obtainLock() {
        if (this.eventsLocked) {
            return false;
        }
        this.eventsLocked = true;
        return true;
    }

    private void releaseLock() {
        this.eventsLocked = false;
    }

    public void setShowValue(boolean show) {
        this.slider.setShowValue(show);
    }

    public void setShowTicks(boolean show) {
        this.slider.setShowTicks(show);
    }

    public void setSnapInterval(double snap) {
        this.slider.setSnapInterval(snap);
    }
}

