/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps._3dt;

import buoy.event.CommandEvent;
import buoy.event.EventSource;
import buoy.event.MouseClickedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BSeparator;
import buoy.widget.BSplitPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTabbedPane;
import buoy.widget.BorderContainer;
import buoy.widget.ColumnContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import de.jreality.geometry.BallAndStickFactory;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.SphereUtility;
import de.jreality.geometry.TubeUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.Viewer;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.Tool;
import de.jreality.scene.tool.ToolContext;
import de.jreality.softviewer.SoftViewer;
import de.jreality.sunflow.RenderOptions;
import de.jreality.sunflow.Sunflow;
import de.jreality.ui.viewerapp.actions.file.ExportU3D;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import de.jtem.beans.DimensionPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gavrog.apps._3dt.ActionRegistry;
import org.gavrog.apps._3dt.DisplayList;
import org.gavrog.apps._3dt.Document;
import org.gavrog.apps._3dt.FileChooser;
import org.gavrog.apps._3dt.InterfaceOptions;
import org.gavrog.apps._3dt.Version;
import org.gavrog.apps._3dt.ViewerFrame;
import org.gavrog.box.gui.Config;
import org.gavrog.box.gui.ExtensionFilter;
import org.gavrog.box.gui.Invoke;
import org.gavrog.box.gui.OptionCheckBox;
import org.gavrog.box.gui.OptionColorBox;
import org.gavrog.box.gui.OptionInputBox;
import org.gavrog.box.gui.OptionRangeSliderBox;
import org.gavrog.box.gui.OptionSliderBox;
import org.gavrog.box.gui.TextAreaOutputStream;
import org.gavrog.box.simple.Stopwatch;
import org.gavrog.joss.dsyms.basic.DSymbol;
import org.gavrog.joss.dsyms.basic.IndexList;
import org.gavrog.joss.dsyms.derived.DSCover;
import org.gavrog.joss.geometry.CoordinateChange;
import org.gavrog.joss.geometry.Operator;
import org.gavrog.joss.geometry.Point;
import org.gavrog.joss.geometry.SpaceGroupCatalogue;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.graphics.Surface;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.io.Archive;
import org.gavrog.joss.pgraphs.io.Output;
import org.gavrog.joss.tilings.Tiling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main
extends EventSource {
    private static Archive systreArchive = new Archive("1.0");
    private static final Color textColor;
    private static final Color buttonColor;
    private static final Insets defaultInsets;
    private static final String configFileName;
    private final FileChooser inFileChooser = new FileChooser(FileChooser.OPEN_FILE);
    private final FileChooser outNetChooser = new FileChooser(FileChooser.SAVE_FILE);
    private final FileChooser outTilingChooser = new FileChooser(FileChooser.SAVE_FILE);
    private final FileChooser outSceneChooser = new FileChooser(FileChooser.SAVE_FILE);
    private final FileChooser outOBJChooser = new FileChooser(FileChooser.SAVE_FILE);
    private final FileChooser outSunflowChooser = new FileChooser(FileChooser.SAVE_FILE);
    private final FileChooser outScreenshotChooser = new FileChooser(FileChooser.SAVE_FILE);
    private final DimensionPanel screenshotDimPanel = new DimensionPanel();
    private final DimensionPanel sunflowDimPanel = new DimensionPanel();
    private int subdivisionLevel = 2;
    private int tileRelaxationSteps = 3;
    private double edgeWidth = 0.02;
    private int edgeRoundingLevel = 2;
    private Color edgeColor = Color.BLACK;
    private double edgeOpacity = 1.0;
    private boolean smoothFaces = true;
    private boolean drawEdges = true;
    private boolean drawFaces = true;
    private double tileSize = 0.9;
    private boolean showUnitCell = false;
    private Color unitCellColor = Color.BLACK;
    private double unitCellEdgeWidth = 0.02;
    private boolean showNet = true;
    private Color netEdgeColor = Color.BLACK;
    private Color netNodeColor = Color.RED;
    private double netEdgeRadius = 0.05;
    private double netNodeRadius = 0.075;
    private int minX = 0;
    private int maxX = 0;
    private int minY = 0;
    private int maxY = 0;
    private int minZ = 0;
    private int maxZ = 0;
    private boolean clearOnFill = true;
    private boolean usePrimitiveCell = false;
    private double ambientCoefficient = 0.0;
    private Color ambientColor = Color.WHITE;
    private double diffuseCoefficient = 0.8;
    private double specularCoefficient = 0.1;
    private double specularExponent = 15.0;
    private Color specularColor = Color.WHITE;
    private double faceTransparency = 0.0;
    private int equalEdgePriority = 2;
    private int embedderStepLimit = 100000;
    private boolean ignoreInputCell = false;
    private boolean ignoreInputCoordinates = false;
    private boolean relaxCoordinates = true;
    private boolean useMaximalSymmetry = true;
    private Color backgroundColor = Color.WHITE;
    private boolean useFog = false;
    private double fogDensity = 0.1;
    private Color fogColor = Color.WHITE;
    private boolean fogToBackground = true;
    private double fieldOfView = 25.0;
    private Color light1Color = Color.WHITE;
    private double light1Intensity = 0.75;
    private double light1AngleX = 30.0;
    private double light1AngleY = -30.0;
    private Color light2Color = Color.WHITE;
    private double light2Intensity = 0.75;
    private double light2AngleX = 0.0;
    private double light2AngleY = 0.0;
    private Color light3Color = Color.BLUE;
    private double light3Intensity = 0.6;
    private double light3AngleX = 0.0;
    private double light3AngleY = 120.0;
    private InterfaceOptions ui = new InterfaceOptions();
    private List<Document> documents;
    private int tilingCounter;
    private Document currentDocument;
    private Map<SceneGraphComponent, DisplayList.Item> node2item = new HashMap<SceneGraphComponent, DisplayList.Item>();
    private Map<DisplayList.Item, SceneGraphComponent> item2node = new HashMap<DisplayList.Item, SceneGraphComponent>();
    private DisplayList.Item selectedItem = null;
    private int selectedFace = -1;
    private BDialog aboutFrame;
    private BDialog controlsFrame;
    private BStandardDialog inputDialog = new BStandardDialog();
    private BStandardDialog messageDialog = new BStandardDialog();
    private Map<String, BLabel> tInfoFields;
    private Cursor busyCursor = new Cursor(3);
    private Cursor normalCursor = new Cursor(0);
    private final ViewerFrame viewerFrame;
    private final SceneGraphComponent world;
    public static final SceneGraphComponent sphereTemplate;
    private final SceneGraphComponent tiling;
    private final SceneGraphComponent net;
    private SceneGraphComponent unitCell;
    private SceneGraphComponent[] templates;
    private Appearance[] materials;
    protected String last_path;
    private JPopupMenu _selectionPopupForTiles = null;
    private JPopupMenu _selectionPopupForNodes = null;
    private JPopupMenu _selectionPopupForEdges = null;

    static {
        Main.readArchive(systreArchive, "org/gavrog/apps/systre/rcsr.arc");
        SpaceGroupCatalogue.load();
        textColor = new Color(255, 250, 240);
        buttonColor = new Color(224, 224, 240);
        defaultInsets = new Insets(5, 5, 5, 5);
        configFileName = String.valueOf(System.getProperty("user.home")) + "/.3dt";
        sphereTemplate = new SceneGraphComponent();
        sphereTemplate.setGeometry((Geometry)SphereUtility.sphericalPatch((double)0.0, (double)0.0, (double)360.0, (double)180.0, (int)40, (int)20, (double)1.0));
    }

    public Main(String[] args) {
        String infilename = null;
        if (args.length > 0) {
            infilename = args[0];
        }
        this.loadOptions();
        this.setupFileChoosers();
        this.world = SceneGraphUtility.createFullSceneGraphComponent((String)"World");
        Appearance a = new Appearance();
        this.updateAppearance(a);
        this.world.setAppearance(a);
        this.viewerFrame = new ViewerFrame(this.world);
        this.tiling = new SceneGraphComponent("Tiling");
        this.tiling.addTool((Tool)new SelectionTool());
        this.net = new SceneGraphComponent("Net");
        this.unitCell = new SceneGraphComponent("UnitCell");
        this.world.addChild(this.tiling);
        this.world.addChild(this.net);
        this.world.addChild(this.unitCell);
        this.updateLights();
        this.viewerFrame.setJMenuBar(this.createMenus());
        this.updateCamera();
        this.viewerFrame.setTitle("3dt Viewer");
        this.viewerFrame.validate();
        this.updateViewerSize();
        this.viewerFrame.setVisible(true);
        this.viewerFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent arg0) {
                System.exit(0);
            }
        });
        this.viewerFrame.getViewingComponent().addComponentListener(new ComponentListener(){

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                Dimension size = Main.this.viewerFrame.getViewerSize();
                Main.this.ui.setViewerWidth((int)size.getWidth());
                Main.this.ui.setViewerHeight((int)size.getHeight());
                Main.this.saveOptions();
            }
        });
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.showControls();
            }
        });
        if (this.viewerFrame.getViewer() instanceof SoftViewer) {
            Main.log("Hardware accelerated rendering is not available.");
            Main.log("If your graphics card supports OpenGL, you should check your Gavrog installation and your graphics drivers.");
        }
        if (infilename != null) {
            this.openFile(infilename);
        }
        this.viewerFrame.startRendering();
    }

    private JMenuBar createMenus() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.actionOpen());
        fileMenu.add(this.actionQuickSaveScene());
        fileMenu.add(this.actionSaveScene());
        fileMenu.add(this.actionSaveTiling());
        fileMenu.add(this.actionSaveNet());
        fileMenu.addSeparator();
        fileMenu.add(this.actionScreenshot());
        fileMenu.add(this.actionSunflowRender());
        fileMenu.add(this.actionSunflowPreview());
        fileMenu.addSeparator();
        fileMenu.add((Action)new ExportU3D("Export U3D...", this.viewerFrame.getViewer(), null));
        fileMenu.add(this.actionExportOBJ());
        fileMenu.addSeparator();
        fileMenu.add(this.actionQuit());
        menuBar.add(fileMenu);
        JMenu tilingMenu = new JMenu("Tiling");
        tilingMenu.add(this.actionReload());
        tilingMenu.add(this.actionFirst());
        tilingMenu.add(this.actionNext());
        tilingMenu.add(this.actionPrevious());
        tilingMenu.add(this.actionLast());
        tilingMenu.addSeparator();
        tilingMenu.add(this.actionJump());
        tilingMenu.add(this.actionSearch());
        tilingMenu.addSeparator();
        tilingMenu.add(this.actionDualize());
        tilingMenu.add(this.actionSymmetrize());
        tilingMenu.addSeparator();
        tilingMenu.add(this.actionRecolor());
        menuBar.add(tilingMenu);
        JMenu netMenu = new JMenu("Net");
        netMenu.add(this.actionUpdateNet());
        netMenu.add(this.actionGrowNet());
        netMenu.add(this.actionClearNet());
        menuBar.add(netMenu);
        JMenu viewMenu = new JMenu("View");
        viewMenu.add(this.actionEncompass());
        viewMenu.add(this.actionViewAlong());
        viewMenu.add(this.actionSetUpVector());
        viewMenu.addSeparator();
        viewMenu.add(this.actionXView());
        viewMenu.add(this.actionYView());
        viewMenu.add(this.actionZView());
        viewMenu.add(this.action011View());
        viewMenu.add(this.action101View());
        viewMenu.add(this.action110View());
        viewMenu.add(this.action111View());
        viewMenu.addSeparator();
        viewMenu.add(this.actionRotateRight());
        viewMenu.add(this.actionRotateLeft());
        viewMenu.add(this.actionRotateUp());
        viewMenu.add(this.actionRotateDown());
        viewMenu.add(this.actionRotateClockwise());
        viewMenu.add(this.actionRotateCounterClockwise());
        viewMenu.addSeparator();
        viewMenu.add(this.actionShowControls());
        menuBar.add(viewMenu);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(this.actionAbout());
        menuBar.add(helpMenu);
        return menuBar;
    }

    private void setupFileChoosers() {
        this.inFileChooser.setTitle("Open data file");
        this.inFileChooser.addChoosableFileFilter(new ExtensionFilter(new String[]{"ds", "tgs"}, "Delaney-Dress Symbol Files"));
        this.inFileChooser.addChoosableFileFilter(new ExtensionFilter("cgd", "Geometric Description Files"));
        this.inFileChooser.addChoosableFileFilter(new ExtensionFilter("gsl", "Gavrog Scene Files"));
        this.inFileChooser.addChoosableFileFilter(new ExtensionFilter(new String[]{"cgd", "ds", "tgs", "gsl"}, "All 3dt Files"));
        this.outNetChooser.setTitle("Save net");
        this.outNetChooser.addChoosableFileFilter(new ExtensionFilter("pgr", "Raw Periodic Net Files (for Systre)"));
        this.outNetChooser.setAppendEnabled(true);
        this.outTilingChooser.setTitle("Save tiling");
        this.outTilingChooser.addChoosableFileFilter(new ExtensionFilter("ds", "Delaney-Dress Symbol Files"));
        this.outTilingChooser.setAppendEnabled(true);
        this.outSceneChooser.setTitle("Save scene");
        this.outSceneChooser.addChoosableFileFilter(new ExtensionFilter("gsl", "Gavrog Scene Files"));
        this.outSceneChooser.setAppendEnabled(false);
        this.outOBJChooser.setTitle("Export as OBJ");
        this.outOBJChooser.addChoosableFileFilter(new ExtensionFilter("obj", "Wavefront OBJ Files"));
        this.outOBJChooser.setAppendEnabled(false);
        this.outSunflowChooser.setTitle("Save image");
        this.outSunflowChooser.addChoosableFileFilter(new ExtensionFilter(new String[]{"png", "tga", "hdr"}, "Images files"));
        this.sunflowDimPanel.setDimension(new Dimension(800, 600));
        this.sunflowDimPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Dimension"));
        this.outSunflowChooser.setAccessory((JComponent)this.sunflowDimPanel);
        this.outSunflowChooser.setAppendEnabled(false);
        this.outScreenshotChooser.setTitle("Save image");
        this.outScreenshotChooser.addChoosableFileFilter(new ExtensionFilter(new String[]{"bmp", "jpg", "jpeg", "png", "wbmp", "tiff", "tif", "gif"}, "Images files"));
        this.screenshotDimPanel.setDimension(new Dimension(800, 600));
        this.screenshotDimPanel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Dimension"));
        this.outScreenshotChooser.setAccessory((JComponent)this.screenshotDimPanel);
        this.outScreenshotChooser.setAppendEnabled(false);
    }

    private String getInput(String message, String title, String defaultVal) {
        this.inputDialog.setMessage(message);
        this.inputDialog.setTitle(title);
        this.inputDialog.setStyle(BStandardDialog.PLAIN);
        return this.inputDialog.showInputDialog(null, null, defaultVal);
    }

    private void messageBox(String message, String title, BStandardDialog.Style style) {
        this.messageDialog.setMessage(message);
        this.messageDialog.setTitle(title);
        this.messageDialog.setStyle(style);
        this.messageDialog.showMessageDialog(null);
    }

    private Action actionAbout() {
        String name = "About 3dt";
        if (ActionRegistry.instance().get("About 3dt") == null) {
            ActionRegistry.instance().put(new AbstractAction("About 3dt"){
                private static final long serialVersionUID = -6894141174367275467L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.showAbout();
                }
            }, null, null);
        }
        return ActionRegistry.instance().get("About 3dt");
    }

    private Action actionShowControls() {
        String name = "Show Controls";
        if (ActionRegistry.instance().get("Show Controls") == null) {
            ActionRegistry.instance().put(new AbstractAction("Show Controls"){
                private static final long serialVersionUID = -4205829340604887360L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.showControls();
                }
            }, null, null);
        }
        return ActionRegistry.instance().get("Show Controls");
    }

    private Action actionOpen() {
        String name = "Open...";
        if (ActionRegistry.instance().get("Open...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Open..."){
                private static final long serialVersionUID = -7633694682288607039L;

                public void actionPerformed(ActionEvent e) {
                    File file = Main.this.inFileChooser.pickFile(Main.this.ui.getLastInputPath(), null);
                    if (file == null) {
                        return;
                    }
                    Main.this.ui.setLastInputPath(file);
                    Main.this.saveOptions();
                    Main.this.openFile(file.getAbsolutePath());
                }
            }, "Open a tiling file", KeyStroke.getKeyStroke(79, 2));
        }
        return ActionRegistry.instance().get("Open...");
    }

    private Action actionSaveTiling() {
        String name = "Save Tiling as...";
        if (ActionRegistry.instance().get("Save Tiling as...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Save Tiling as..."){
                private static final long serialVersionUID = -4118040215806163426L;

                public void actionPerformed(ActionEvent e) {
                    File file = Main.this.outTilingChooser.pickFile(Main.this.ui.getLastTilingOutputPath(), "ds");
                    if (file == null) {
                        return;
                    }
                    Main.this.ui.setLastTilingOutputPath(file);
                    Main.this.saveOptions();
                    try {
                        DSymbol ds = Main.this.doc().getSymbol();
                        boolean append = Main.this.outTilingChooser.getAppend();
                        FileWriter out = new FileWriter(file, append);
                        for (String key : Main.this.tInfoFields.keySet()) {
                            if (key.startsWith("_")) continue;
                            out.write("#@ info " + key + " = " + ((BLabel)Main.this.tInfoFields.get(key)).getText() + "\n");
                        }
                        if (Main.this.doc().getName() != null) {
                            out.write("#@ name " + Main.this.doc().getName() + "\n");
                        }
                        out.write(ds.canonical().flat().toString());
                        out.write("\n");
                        ((Writer)out).flush();
                        ((Writer)out).close();
                    }
                    catch (IOException ex) {
                        Main.log(ex.toString());
                        return;
                    }
                    Main.log("Wrote file " + file.getName() + ".");
                }
            }, "Save the raw tiling as a Delaney-Dress symbol", null);
        }
        return ActionRegistry.instance().get("Save Tiling as...");
    }

    private Action actionSaveNet() {
        String name = "Save Net as...";
        if (ActionRegistry.instance().get("Save Net as...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Save Net as..."){
                private static final long serialVersionUID = -2752873210655489350L;

                public void actionPerformed(ActionEvent e) {
                    File file = Main.this.outNetChooser.pickFile(Main.this.ui.getLastNetOutputPath(), "pgr");
                    if (file == null) {
                        return;
                    }
                    Main.this.ui.setLastNetOutputPath(file);
                    Main.this.saveOptions();
                    try {
                        boolean append = Main.this.outNetChooser.getAppend();
                        FileWriter out = new FileWriter(file, append);
                        Output.writePGR(out, Main.this.doc().getNet(), Main.this.doc().getName());
                        ((Writer)out).flush();
                        ((Writer)out).close();
                    }
                    catch (IOException ex) {
                        Main.log(ex.toString());
                        return;
                    }
                    Main.log("Wrote file " + file.getName() + ".");
                }
            }, "Save the raw net as a Systre file", null);
        }
        return ActionRegistry.instance().get("Save Net as...");
    }

    private Action actionQuickSaveScene() {
        String name = "Save Scene";
        if (ActionRegistry.instance().get("Save Scene") == null) {
            ActionRegistry.instance().put(new AbstractAction("Save Scene"){
                private static final long serialVersionUID = 4065514611640844417L;

                public void actionPerformed(ActionEvent e) {
                    File file;
                    if (Main.this.doc().getSaveSceneFile() == null) {
                        file = Main.this.outSceneChooser.pickFile(Main.this.ui.getLastSceneOutputPath(), "gsl");
                        if (file == null) {
                            return;
                        }
                        Main.this.ui.setLastSceneOutputPath(file);
                        Main.this.doc().setSaveSceneFile(file);
                    } else {
                        file = Main.this.doc().getSaveSceneFile();
                    }
                    Main.this.saveOptions();
                    try {
                        FileWriter out = new FileWriter(file);
                        Main.this.doc().setTransformation(Main.this.getViewingTransformation());
                        out.write(Main.this.doc().toXML());
                        ((Writer)out).flush();
                        ((Writer)out).close();
                    }
                    catch (IOException ex) {
                        Main.log(ex.toString());
                        return;
                    }
                    Main.log("Wrote file " + file.getName() + ".");
                }
            }, "Save the scene", KeyStroke.getKeyStroke(83, 2));
        }
        return ActionRegistry.instance().get("Save Scene");
    }

    private Action actionSaveScene() {
        String name = "Save Scene as...";
        if (ActionRegistry.instance().get("Save Scene as...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Save Scene as..."){
                private static final long serialVersionUID = 4065514611640844417L;

                public void actionPerformed(ActionEvent e) {
                    File file = Main.this.outSceneChooser.pickFile(Main.this.ui.getLastSceneOutputPath(), "gsl");
                    if (file == null) {
                        return;
                    }
                    Main.this.ui.setLastSceneOutputPath(file);
                    Main.this.saveOptions();
                    try {
                        FileWriter out = new FileWriter(file);
                        Main.this.doc().setTransformation(Main.this.getViewingTransformation());
                        out.write(Main.this.doc().toXML());
                        ((Writer)out).flush();
                        ((Writer)out).close();
                    }
                    catch (IOException ex) {
                        Main.log(ex.toString());
                        return;
                    }
                    Main.log("Wrote file " + file.getName() + ".");
                }
            }, "Save the scene", null);
        }
        return ActionRegistry.instance().get("Save Scene as...");
    }

    private Action actionScreenshot() {
        String name = "Screen Shot...";
        if (ActionRegistry.instance().get("Screen Shot...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Screen Shot..."){
                private static final long serialVersionUID = -8294905204122328690L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.screenshotDimPanel.setDimension(Main.this.viewerFrame.getViewer().getViewingComponentSize());
                    final File file = Main.this.outScreenshotChooser.pickFile(Main.this.ui.getLastScreenshotPath(), "png");
                    if (file == null) {
                        return;
                    }
                    Main.this.ui.setLastScreenshotPath(file);
                    Main.this.saveOptions();
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                try {
                                    Main.this.busy();
                                    Main.this.viewerFrame.screenshot(Main.this.screenshotDimPanel.getDimension(), 4, file);
                                }
                                catch (Throwable ex) {
                                    Main.log(ex.toString());
                                    Main.this.done();
                                    return;
                                }
                            }
                            finally {
                                Main.this.done();
                            }
                            Main.log("Wrote image to file " + file.getName() + ".");
                        }
                    }).start();
                }
            }, "Export image file", KeyStroke.getKeyStroke(73, 2));
        }
        return ActionRegistry.instance().get("Screen Shot...");
    }

    private Action actionSunflowRender() {
        String name = "Raytraced Image...";
        if (ActionRegistry.instance().get("Raytraced Image...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Raytraced Image..."){
                private static final long serialVersionUID = -7566950527102492665L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.sunflowDimPanel.setDimension(Main.this.viewerFrame.getViewer().getViewingComponentSize());
                    File file = Main.this.outSunflowChooser.pickFile(Main.this.ui.getLastSunflowRenderPath(), "png");
                    if (file == null) {
                        return;
                    }
                    Main.this.ui.setLastSunflowRenderPath(file);
                    Main.this.saveOptions();
                    try {
                        RenderOptions opts = new RenderOptions();
                        opts.setProgressiveRender(false);
                        opts.setAaMin(0);
                        opts.setAaMax(2);
                        opts.setGiEngine("ambocc");
                        opts.setFilter("mitchell");
                        Sunflow.renderAndSave((Viewer)Main.this.viewerFrame.getViewer(), (RenderOptions)opts, (Dimension)Main.this.sunflowDimPanel.getDimension(), (File)file);
                    }
                    catch (Throwable ex) {
                        Main.log(ex.toString());
                        return;
                    }
                    Main.log("Wrote raytraced image to file " + file.getName() + ".");
                }
            }, "Render the scene using the Sunflow raytracer", KeyStroke.getKeyStroke(82, 2));
        }
        return ActionRegistry.instance().get("Raytraced Image...");
    }

    private Action actionSunflowPreview() {
        String name = "Preview Raytraced...";
        if (ActionRegistry.instance().get("Preview Raytraced...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Preview Raytraced..."){
                private static final long serialVersionUID = 3376824024688938452L;

                public void actionPerformed(ActionEvent e) {
                    try {
                        RenderOptions opts = new RenderOptions();
                        opts.setProgressiveRender(true);
                        Viewer v = Main.this.viewerFrame.getViewer();
                        Sunflow.render((Viewer)v, (Dimension)v.getViewingComponentSize(), (RenderOptions)opts);
                    }
                    catch (Throwable ex) {
                        Main.log(ex.toString());
                        return;
                    }
                }
            }, "Preview the Sunflow render", KeyStroke.getKeyStroke(80, 2));
        }
        return ActionRegistry.instance().get("Preview Raytraced...");
    }

    private Action actionExportOBJ() {
        String name = "Export OBJ...";
        if (ActionRegistry.instance().get("Export OBJ...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Export OBJ..."){
                private static final long serialVersionUID = -5865220771684507445L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.doc() == null) {
                        return;
                    }
                    File file = Main.this.outOBJChooser.pickFile(Main.this.ui.getLastObjExportPath(), "obj");
                    if (file == null) {
                        return;
                    }
                    Main.this.ui.setLastObjExportPath(file);
                    Main.this.saveOptions();
                    try {
                        Main.this.exportSceneToOBJ(file);
                    }
                    catch (IOException ex) {
                        Main.log(ex.toString());
                        return;
                    }
                    Main.log("Exported to " + file.getName() + ".");
                }
            }, "Export a Wavefront .obj file", null);
        }
        return ActionRegistry.instance().get("Export OBJ...");
    }

    private Action actionQuit() {
        String name = "Quit";
        if (ActionRegistry.instance().get("Quit") == null) {
            ActionRegistry.instance().put(new AbstractAction("Quit"){
                private static final long serialVersionUID = 7629324293326983871L;

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            }, "Quit the program", KeyStroke.getKeyStroke(81, 2));
        }
        return ActionRegistry.instance().get("Quit");
    }

    private Action actionReload() {
        String name = "This (reload)";
        if (ActionRegistry.instance().get("This (reload)") == null) {
            ActionRegistry.instance().put(new AbstractAction("This (reload)"){
                private static final long serialVersionUID = 6853426916731514941L;

                public void actionPerformed(ActionEvent arg0) {
                    Main.this.reloadCurrentTiling();
                }
            }, "Reload the current tiling", KeyStroke.getKeyStroke(84, 0));
        }
        return ActionRegistry.instance().get("This (reload)");
    }

    private Action actionFirst() {
        String name = "First";
        if (ActionRegistry.instance().get("First") == null) {
            ActionRegistry.instance().put(new AbstractAction("First"){
                private static final long serialVersionUID = 6853426916731514941L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.doTiling(1);
                }
            }, "Display the first tiling in this file", KeyStroke.getKeyStroke(70, 0));
        }
        return ActionRegistry.instance().get("First");
    }

    private Action actionNext() {
        String name = "Next";
        if (ActionRegistry.instance().get("Next") == null) {
            ActionRegistry.instance().put(new AbstractAction("Next"){
                private static final long serialVersionUID = -3764695742985872112L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.doTiling(Main.this.tilingCounter + 1);
                }
            }, "Display the next tiling in this file", KeyStroke.getKeyStroke(78, 0));
        }
        return ActionRegistry.instance().get("Next");
    }

    private Action actionPrevious() {
        String name = "Previous";
        if (ActionRegistry.instance().get("Previous") == null) {
            ActionRegistry.instance().put(new AbstractAction("Previous"){
                private static final long serialVersionUID = 7931268622003336578L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.doTiling(Main.this.tilingCounter - 1);
                }
            }, "Display the previous tiling in this file", KeyStroke.getKeyStroke(80, 0));
        }
        return ActionRegistry.instance().get("Previous");
    }

    private Action actionLast() {
        String name = "Last";
        if (ActionRegistry.instance().get("Last") == null) {
            ActionRegistry.instance().put(new AbstractAction("Last"){
                private static final long serialVersionUID = -7387980219457791631L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.doTiling(Main.this.documents.size());
                }
            }, "Display the last tiling in this file", KeyStroke.getKeyStroke(76, 0));
        }
        return ActionRegistry.instance().get("Last");
    }

    private Action actionJump() {
        String name = "Jump To...";
        if (ActionRegistry.instance().get("Jump To...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Jump To..."){
                private static final long serialVersionUID = 1790706172915770128L;

                public void actionPerformed(ActionEvent e) {
                    int n;
                    String input = Main.this.getInput("Jump to tiling #:", "3dt Jump To", String.valueOf(Main.this.tilingCounter + 1));
                    try {
                        n = Integer.parseInt(input);
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                    Main.this.doTiling(n);
                }
            }, "Jump to a specific tiling", KeyStroke.getKeyStroke(74, 0));
        }
        return ActionRegistry.instance().get("Jump To...");
    }

    private Action actionSearch() {
        String name = "Search...";
        if (ActionRegistry.instance().get("Search...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Search..."){
                private static final long serialVersionUID = 2991707420851482542L;

                public void actionPerformed(ActionEvent e) {
                    String input = Main.this.getInput("Find tiling by name pattern or number:", "3dt Search", String.valueOf(Main.this.tilingCounter + 1));
                    if (input != null && !input.equals("")) {
                        Pattern p;
                        try {
                            p = Pattern.compile(input, 2);
                        }
                        catch (PatternSyntaxException ex) {
                            Main.this.messageBox(ex.getMessage(), "3dt Search", BStandardDialog.INFORMATION);
                            return;
                        }
                        if (Main.this.documents != null) {
                            int n = 0;
                            while (n < Main.this.documents.size()) {
                                String name = ((Document)Main.this.documents.get(n)).getName();
                                if (name != null && p.matcher(name).find()) {
                                    Main.this.doTiling(n + 1);
                                    return;
                                }
                                ++n;
                            }
                            try {
                                n = Integer.parseInt(input);
                                Main.this.doTiling(n);
                            }
                            catch (NumberFormatException ex) {
                                Main.this.messageBox("Found no tiling matching '" + input + "'.", "3dt Search", BStandardDialog.INFORMATION);
                            }
                        }
                    }
                }
            }, "Search for a tiling by name", KeyStroke.getKeyStroke(70, 2));
        }
        return ActionRegistry.instance().get("Search...");
    }

    private Action actionDualize() {
        String name = "Dualize";
        if (ActionRegistry.instance().get("Dualize") == null) {
            ActionRegistry.instance().put(new AbstractAction("Dualize"){
                private static final long serialVersionUID = -2505330289266591494L;

                public void actionPerformed(ActionEvent e) {
                    DSymbol ds = Main.this.doc().getSymbol();
                    if (ds.equals(ds.dual())) {
                        Main.this.messageBox("The tiling is self-dual.", "3dt Dualize", BStandardDialog.INFORMATION);
                        return;
                    }
                    String name = Main.this.doc().getName();
                    String newName = name != null ? String.valueOf(name) + " (dual)" : "#" + Main.this.tilingCounter + " dual";
                    Document dual = new Document(ds.dual(), newName);
                    Main.this.documents.add(Main.this.tilingCounter, dual);
                    Main.this.doTiling(Main.this.tilingCounter + 1);
                }
            }, "Dualize the current tiling", null);
        }
        return ActionRegistry.instance().get("Dualize");
    }

    private Action actionSymmetrize() {
        String name = "Max. Symmetry";
        if (ActionRegistry.instance().get("Max. Symmetry") == null) {
            ActionRegistry.instance().put(new AbstractAction("Max. Symmetry"){
                private static final long serialVersionUID = 6906675574047428324L;

                public void actionPerformed(ActionEvent e) {
                    DSymbol ds = Main.this.doc().getSymbol();
                    if (ds.isMinimal()) {
                        Main.this.messageBox("The tiling is already maximally symmetric.", "3dt Max Symmetry", BStandardDialog.INFORMATION);
                        return;
                    }
                    String name = Main.this.doc().getName();
                    String newName = name != null ? String.valueOf(name) + " (symmetric)" : "#" + Main.this.tilingCounter + " symmetric";
                    Document minimal = new Document((DSymbol)ds.minimal(), newName);
                    Main.this.documents.add(Main.this.tilingCounter, minimal);
                    Main.this.doTiling(Main.this.tilingCounter + 1);
                }
            }, "Maximize the symmetry of the current tiling", null);
        }
        return ActionRegistry.instance().get("Max. Symmetry");
    }

    private Action actionRecolor() {
        String name = "Recolor";
        if (ActionRegistry.instance().get("Recolor") == null) {
            ActionRegistry.instance().put(new AbstractAction("Recolor"){
                private static final long serialVersionUID = -2790909738851691974L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.doc().randomlyRecolorTiles();
                    Main.this.suspendRendering();
                    Main.this.updateMaterials();
                    Main.this.resumeRendering();
                }
            }, "Pick new random colors for tiles", KeyStroke.getKeyStroke(67, 2));
        }
        return ActionRegistry.instance().get("Recolor");
    }

    private Action actionUpdateNet() {
        String name = "Update Net";
        if (ActionRegistry.instance().get("Update Net") == null) {
            ActionRegistry.instance().put(new AbstractAction("Update Net"){
                private static final long serialVersionUID = -6384997665916057307L;

                public void actionPerformed(ActionEvent e) {
                    ArrayList<DisplayList.Item> tiles = new ArrayList<DisplayList.Item>();
                    for (DisplayList.Item item : Main.this.doc()) {
                        if (!item.isTile()) continue;
                        tiles.add(item);
                    }
                    Main.this.suspendRendering();
                    for (DisplayList.Item item : tiles) {
                        Main.this.makeTileOutline(item.getTile(), item.getShift());
                    }
                    Main.this.resumeRendering();
                }
            }, "Add all edges and nodes in the outlines of visible tiles.", null);
        }
        return ActionRegistry.instance().get("Update Net");
    }

    private Action actionGrowNet() {
        String name = "Grow Net";
        if (ActionRegistry.instance().get("Grow Net") == null) {
            ActionRegistry.instance().put(new AbstractAction("Grow Net"){
                private static final long serialVersionUID = -7120597969940978950L;

                public void actionPerformed(ActionEvent e) {
                    LinkedList<DisplayList.Item> nodes = new LinkedList<DisplayList.Item>();
                    for (DisplayList.Item item : Main.this.doc()) {
                        if (!item.isNode()) continue;
                        nodes.add(item);
                    }
                    Main.this.suspendRendering();
                    int count = 0;
                    for (DisplayList.Item item : nodes) {
                        if (!item.isNode()) continue;
                        count += Main.this.doc().connectToExisting(item);
                    }
                    if (count == 0) {
                        for (DisplayList.Item item : nodes) {
                            if (!item.isNode()) continue;
                            count += Main.this.doc().addIncident(item);
                        }
                    }
                    Main.this.resumeRendering();
                }
            }, "Add all missing edges between or all edges incident with visible nodes.", KeyStroke.getKeyStroke(71, 0));
        }
        return ActionRegistry.instance().get("Grow Net");
    }

    private Action actionClearNet() {
        String name = "Clear Net";
        if (ActionRegistry.instance().get("Clear Net") == null) {
            ActionRegistry.instance().put(new AbstractAction("Clear Net"){
                private static final long serialVersionUID = -170822340264930999L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.suspendRendering();
                    Main.this.doc().removeAllEdges();
                    Main.this.doc().removeAllNodes();
                    Main.this.resumeRendering();
                }
            }, "Remove all nodes and edges of the net.", null);
        }
        return ActionRegistry.instance().get("Clear Net");
    }

    private Action actionAddTile() {
        String name = "Add Tile";
        if (ActionRegistry.instance().get("Add Tile") == null) {
            ActionRegistry.instance().put(new AbstractAction("Add Tile"){
                private static final long serialVersionUID = -8182351416550031897L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null && Main.this.selectedFace >= 0) {
                        Main.this.doc().addNeighbor(Main.this.selectedItem, Main.this.selectedFace);
                    }
                }
            }, "Add a tile at the selected face.", KeyStroke.getKeyStroke(65, 0));
        }
        return ActionRegistry.instance().get("Add Tile");
    }

    private Action actionAddFacet() {
        String name = "Add Facet";
        if (ActionRegistry.instance().get("Add Facet") == null) {
            ActionRegistry.instance().put(new AbstractAction("Add Facet"){
                private static final long serialVersionUID = -9211003340285294990L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null && Main.this.selectedFace >= 0) {
                        Main.this.doc().addNeighborFacet(Main.this.selectedItem, Main.this.selectedFace);
                    }
                }
            }, "Add a tile at the selected face.", null);
        }
        return ActionRegistry.instance().get("Add Facet");
    }

    private Action actionRemoveTile() {
        String name = "Remove Tile";
        if (ActionRegistry.instance().get("Remove Tile") == null) {
            ActionRegistry.instance().put(new AbstractAction("Remove Tile"){
                private static final long serialVersionUID = 8376315073641850092L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.doc().remove(Main.this.selectedItem);
                    }
                }
            }, "Remove the selected tile.", KeyStroke.getKeyStroke(68, 0));
        }
        return ActionRegistry.instance().get("Remove Tile");
    }

    private Action actionRemoveTileClass() {
        String name = "Remove Tile Class";
        if (ActionRegistry.instance().get("Remove Tile Class") == null) {
            ActionRegistry.instance().put(new AbstractAction("Remove Tile Class"){
                private static final long serialVersionUID = 587383657519440632L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.doc().removeKind(Main.this.selectedItem);
                    }
                }
            }, "Remove the selected tile and all its symmetric images.", KeyStroke.getKeyStroke(68, 64));
        }
        return ActionRegistry.instance().get("Remove Tile Class");
    }

    private Action actionAddFacetOutline() {
        String name = "Add Facet Outline to Net";
        if (ActionRegistry.instance().get("Add Facet Outline to Net") == null) {
            ActionRegistry.instance().put(new AbstractAction("Add Facet Outline to Net"){
                private static final long serialVersionUID = 7850801246685623875L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null && Main.this.selectedFace >= 0) {
                        Main.this.makeFacetOutline(Main.this.selectedItem.getTile().facet(Main.this.selectedFace), Main.this.selectedItem.getShift());
                    }
                }
            }, "Add all edges around the selected facet to the net.", null);
        }
        return ActionRegistry.instance().get("Add Facet Outline to Net");
    }

    private Action actionAddTileOutline() {
        String name = "Add Tile Outline to Net";
        if (ActionRegistry.instance().get("Add Tile Outline to Net") == null) {
            ActionRegistry.instance().put(new AbstractAction("Add Tile Outline to Net"){
                private static final long serialVersionUID = -3728286851012150260L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.makeTileOutline(Main.this.selectedItem.getTile(), Main.this.selectedItem.getShift());
                    }
                }
            }, "Add all edges around the selected tile to the net.", null);
        }
        return ActionRegistry.instance().get("Add Tile Outline to Net");
    }

    private Color pickColor(String title, Color oldColor) {
        return JColorChooser.showDialog(this.viewerFrame, title, oldColor);
    }

    private Action actionRecolorTileClass() {
        String name = "Recolor Tile Class";
        if (ActionRegistry.instance().get("Recolor Tile Class") == null) {
            ActionRegistry.instance().put(new AbstractAction("Recolor Tile Class"){
                private static final long serialVersionUID = 6427094147853988876L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem == null) {
                        return;
                    }
                    int kind = Main.this.selectedItem.getTile().getKind();
                    Color c = Main.this.doc().getTileClassColor(kind);
                    Color picked = Main.this.pickColor("Set Tile Class Color", c);
                    if (picked == null) {
                        return;
                    }
                    Main.this.doc().setTileClassColor(kind, picked);
                    Main.this.suspendRendering();
                    Main.this.updateMaterials();
                    Main.this.resumeRendering();
                }
            }, "Set the color for all tiles of the selected kind.", KeyStroke.getKeyStroke(67, 64));
        }
        return ActionRegistry.instance().get("Recolor Tile Class");
    }

    private Action actionRecolorTile() {
        String name = "Recolor Tile";
        if (ActionRegistry.instance().get("Recolor Tile") == null) {
            ActionRegistry.instance().put(new AbstractAction("Recolor Tile"){
                private static final long serialVersionUID = 6323346056587859863L;

                public void actionPerformed(ActionEvent e) {
                    Color picked;
                    if (Main.this.selectedItem == null) {
                        return;
                    }
                    Color c = Main.this.doc().color(Main.this.selectedItem);
                    if (c == null) {
                        int kind = Main.this.selectedItem.getTile().getKind();
                        c = Main.this.doc().getTileClassColor(kind);
                    }
                    if ((picked = Main.this.pickColor("Set Tile Color", c)) == null) {
                        return;
                    }
                    Main.this.suspendRendering();
                    Main.this.doc().recolor(Main.this.selectedItem, picked);
                    Main.this.resumeRendering();
                }
            }, "Set the color for this tile.", KeyStroke.getKeyStroke(67, 0));
        }
        return ActionRegistry.instance().get("Recolor Tile");
    }

    private Action actionUncolorTile() {
        String name = "Uncolor Tile";
        if (ActionRegistry.instance().get("Uncolor Tile") == null) {
            ActionRegistry.instance().put(new AbstractAction("Uncolor Tile"){
                private static final long serialVersionUID = -2773415235188149610L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.suspendRendering();
                        Main.this.doc().recolor(Main.this.selectedItem, null);
                        Main.this.resumeRendering();
                    }
                }
            }, "Use the tile class color for selected tile.", KeyStroke.getKeyStroke(85, 0));
        }
        return ActionRegistry.instance().get("Uncolor Tile");
    }

    private Action actionRecolorFacetClass() {
        String name = "Recolor Facet Class";
        if (ActionRegistry.instance().get("Recolor Facet Class") == null) {
            ActionRegistry.instance().put(new AbstractAction("Recolor Facet Class"){
                private static final long serialVersionUID = -8970108899758626493L;

                public void actionPerformed(ActionEvent e) {
                    Color picked;
                    if (Main.this.selectedItem == null || Main.this.selectedFace < 0) {
                        return;
                    }
                    Tiling.Facet f = Main.this.selectedItem.getTile().facet(Main.this.selectedFace);
                    Color c = Main.this.doc().getFacetClassColor(f);
                    if (c == null) {
                        c = Main.this.doc().color(Main.this.selectedItem);
                    }
                    if (c == null) {
                        int kind = Main.this.selectedItem.getTile().getKind();
                        c = Main.this.doc().getTileClassColor(kind);
                    }
                    if ((picked = Main.this.pickColor("Set the color for all facets of this kind", c)) == null) {
                        return;
                    }
                    Main.this.recolorFacetClass(f, picked);
                    Main.this.suspendRendering();
                    Main.this.updateMaterials();
                    Main.this.resumeRendering();
                }
            }, "Set the color for all facets of the selected kind.", KeyStroke.getKeyStroke(70, 64));
        }
        return ActionRegistry.instance().get("Recolor Facet Class");
    }

    private Action actionUncolorFacetClass() {
        String name = "Uncolor Facet Class";
        if (ActionRegistry.instance().get("Uncolor Facet Class") == null) {
            ActionRegistry.instance().put(new AbstractAction("Uncolor Facet Class"){
                private static final long serialVersionUID = 4748131954785975314L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem == null || Main.this.selectedFace < 0) {
                        return;
                    }
                    Main.this.uncolorFacetClass(Main.this.selectedItem.getTile().facet(Main.this.selectedFace));
                    Main.this.suspendRendering();
                    Main.this.updateMaterials();
                    Main.this.resumeRendering();
                }
            }, "Use the tile color for all facets of the selected kind.", null);
        }
        return ActionRegistry.instance().get("Uncolor Facet Class");
    }

    private Action actionHideFacetClass() {
        String name = "Hide Facet Class";
        if (ActionRegistry.instance().get("Hide Facet Class") == null) {
            ActionRegistry.instance().put(new AbstractAction("Hide Facet Class"){
                private static final long serialVersionUID = 7860790749462409702L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem == null || Main.this.selectedFace < 0) {
                        return;
                    }
                    Main.this.hideFacetClass(Main.this.selectedItem.getTile().facet(Main.this.selectedFace));
                    Main.this.suspendRendering();
                    Main.this.updateDisplayProperties();
                    Main.this.resumeRendering();
                }
            }, "Toggle visibility for this facet.", null);
        }
        return ActionRegistry.instance().get("Hide Facet Class");
    }

    private Action actionShowAllInTile() {
        String name = "Show All Facets in Tile";
        if (ActionRegistry.instance().get("Show All Facets in Tile") == null) {
            ActionRegistry.instance().put(new AbstractAction("Show All Facets in Tile"){
                private static final long serialVersionUID = -1574834084770081898L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.showAllInTile(Main.this.selectedItem.getTile());
                        Main.this.suspendRendering();
                        Main.this.updateDisplayProperties();
                        Main.this.resumeRendering();
                    }
                }
            }, "Show all facets in tiles of the selected kind.", null);
        }
        return ActionRegistry.instance().get("Show All Facets in Tile");
    }

    private Action actionAddEndNodes() {
        String name = "Add End Nodes";
        if (ActionRegistry.instance().get("Add End Nodes") == null) {
            ActionRegistry.instance().put(new AbstractAction("Add End Nodes"){
                private static final long serialVersionUID = 2437463150704689455L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.doc().addIncident(Main.this.selectedItem);
                    }
                }
            }, "Add the nodes at the ends of the selected edge.", KeyStroke.getKeyStroke(65, 0));
        }
        return ActionRegistry.instance().get("Add End Nodes");
    }

    private Action actionRemoveEdge() {
        String name = "Remove Edge";
        if (ActionRegistry.instance().get("Remove Edge") == null) {
            ActionRegistry.instance().put(new AbstractAction("Remove Edge"){
                private static final long serialVersionUID = -2847207125458667889L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.doc().remove(Main.this.selectedItem);
                    }
                }
            }, "Remove the selected edge.", KeyStroke.getKeyStroke(68, 0));
        }
        return ActionRegistry.instance().get("Remove Edge");
    }

    private Action actionConnectNode() {
        String name = "Connect Node";
        if (ActionRegistry.instance().get("Connect Node") == null) {
            ActionRegistry.instance().put(new AbstractAction("Connect Node"){
                private static final long serialVersionUID = 4552540269036574898L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null && Main.this.doc().connectToExisting(Main.this.selectedItem) == 0) {
                        Main.this.doc().addIncident(Main.this.selectedItem);
                    }
                }
            }, "Connect the selected node with all visible neighbors  or add all neighbors.", KeyStroke.getKeyStroke(65, 0));
        }
        return ActionRegistry.instance().get("Connect Node");
    }

    private Action actionRemoveNode() {
        String name = "Remove Node";
        if (ActionRegistry.instance().get("Remove Node") == null) {
            ActionRegistry.instance().put(new AbstractAction("Remove Node"){
                private static final long serialVersionUID = -4129847344733173243L;

                public void actionPerformed(ActionEvent e) {
                    if (Main.this.selectedItem != null) {
                        Main.this.doc().remove(Main.this.selectedItem);
                    }
                }
            }, "Remove the selected node.", KeyStroke.getKeyStroke(68, 0));
        }
        return ActionRegistry.instance().get("Remove Node");
    }

    private Action actionEncompass() {
        String name = "Fit To Scene";
        if (ActionRegistry.instance().get("Fit To Scene") == null) {
            ActionRegistry.instance().put(new AbstractAction("Fit To Scene"){
                private static final long serialVersionUID = 6888223854976424600L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.encompass();
                }
            }, "Adjust camera to fit scene to window", KeyStroke.getKeyStroke(48, 0));
        }
        return ActionRegistry.instance().get("Fit To Scene");
    }

    private Action actionViewAlong() {
        String name = "View along...";
        if (ActionRegistry.instance().get("View along...") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along..."){
                private static final long serialVersionUID = -305688356188357939L;

                public void actionPerformed(ActionEvent e) {
                    String input = Main.this.getInput("View along (x y z):", "3dt Viewing Direction", "");
                    String[] fields = input.trim().split("\\s+");
                    try {
                        double x = Double.parseDouble(fields[0]);
                        double y = Double.parseDouble(fields[1]);
                        double z = Double.parseDouble(fields[2]);
                        Vector eye = new Vector(new double[]{x, y, z});
                        Vector up = x == 0.0 && y == 0.0 ? new Vector(0, 1, 0) : new Vector(0, 0, 1);
                        Main.this.setViewingTransformation(eye, up);
                    }
                    catch (Exception ex) {
                        Main.this.messageBox("Can't view along '" + input.trim() + "'.", "3dt Viewing Direction", BStandardDialog.INFORMATION);
                    }
                    Main.this.encompass();
                }
            }, "View the scene along an arbitrary dirextion", KeyStroke.getKeyStroke(86, 0));
        }
        return ActionRegistry.instance().get("View along...");
    }

    private Action actionSetUpVector() {
        String name = "Upward vector...";
        if (ActionRegistry.instance().get("Upward vector...") == null) {
            ActionRegistry.instance().put(new AbstractAction("Upward vector..."){
                private static final long serialVersionUID = 183120034665786492L;

                public void actionPerformed(ActionEvent e) {
                    String input = Main.this.getInput("Vector to point upward (x y z):", "3dt Upward Vector", "0 1 0");
                    String[] fields = input.trim().split("\\s+");
                    try {
                        double x = Double.parseDouble(fields[0]);
                        double y = Double.parseDouble(fields[1]);
                        double z = Double.parseDouble(fields[2]);
                        Vector up = new Vector(new double[]{x, y, z});
                        Vector eye = Main.this.getEyeVector();
                        Main.this.setViewingTransformation(eye, up);
                    }
                    catch (Exception ex) {
                        Main.this.messageBox("Can't set '" + input.trim() + "' as upward.", "3dt Upward Vector", BStandardDialog.INFORMATION);
                    }
                    Main.this.encompass();
                }
            }, "Select a vector to point upward on the screen", KeyStroke.getKeyStroke(85, 0));
        }
        return ActionRegistry.instance().get("Upward vector...");
    }

    private Action actionXView() {
        String name = "View along X";
        if (ActionRegistry.instance().get("View along X") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along X"){
                private static final long serialVersionUID = 6334275391099765342L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.setViewingTransformation(new Vector(1, 0, 0), new Vector(0, 0, 1));
                    Main.this.encompass();
                }
            }, "View the scene along the X axis or 100 direction.", KeyStroke.getKeyStroke(88, 0));
        }
        return ActionRegistry.instance().get("View along X");
    }

    private Action actionYView() {
        String name = "View along Y";
        if (ActionRegistry.instance().get("View along Y") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along Y"){
                private static final long serialVersionUID = 5981350648939244817L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.setViewingTransformation(new Vector(0, 1, 0), new Vector(0, 0, 1));
                    Main.this.encompass();
                }
            }, "View the scene along the Y axis or 010 direction.", KeyStroke.getKeyStroke(89, 0));
        }
        return ActionRegistry.instance().get("View along Y");
    }

    private Action actionZView() {
        String name = "View along Z";
        if (ActionRegistry.instance().get("View along Z") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along Z"){
                private static final long serialVersionUID = -4817374897979508937L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.setViewingTransformation(new Vector(0, 0, 1), new Vector(0, 1, 0));
                    Main.this.encompass();
                }
            }, "View the scene along the Z axis or 001 direction.", KeyStroke.getKeyStroke(90, 0));
        }
        return ActionRegistry.instance().get("View along Z");
    }

    private Action action011View() {
        String name = "View along 011";
        if (ActionRegistry.instance().get("View along 011") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along 011"){
                private static final long serialVersionUID = 5974686631191014809L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.setViewingTransformation(new Vector(0, 1, 1), new Vector(0, 0, 1));
                    Main.this.encompass();
                }
            }, "View the scene along the 011 direction.", KeyStroke.getKeyStroke(65, 0));
        }
        return ActionRegistry.instance().get("View along 011");
    }

    private Action action101View() {
        String name = "View along 101";
        if (ActionRegistry.instance().get("View along 101") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along 101"){
                private static final long serialVersionUID = -8692969261308262530L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.setViewingTransformation(new Vector(1, 0, 1), new Vector(0, 0, 1));
                    Main.this.encompass();
                }
            }, "View the scene along the 101 direction.", KeyStroke.getKeyStroke(66, 0));
        }
        return ActionRegistry.instance().get("View along 101");
    }

    private Action action110View() {
        String name = "View along 110";
        if (ActionRegistry.instance().get("View along 110") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along 110"){
                private static final long serialVersionUID = -4318667902352263591L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.setViewingTransformation(new Vector(1, 1, 0), new Vector(0, 0, 1));
                    Main.this.encompass();
                }
            }, "View the scene along the 110 direction.", KeyStroke.getKeyStroke(67, 0));
        }
        return ActionRegistry.instance().get("View along 110");
    }

    private Action action111View() {
        String name = "View along 111";
        if (ActionRegistry.instance().get("View along 111") == null) {
            ActionRegistry.instance().put(new AbstractAction("View along 111"){
                private static final long serialVersionUID = -5470383467771465236L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.setViewingTransformation(new Vector(1, 1, 1), new Vector(0, 0, 1));
                    Main.this.encompass();
                }
            }, "View the scene along the 111 vector.", KeyStroke.getKeyStroke(68, 0));
        }
        return ActionRegistry.instance().get("View along 111");
    }

    private Action actionRotateRight() {
        String name = "Rotate Right";
        if (ActionRegistry.instance().get("Rotate Right") == null) {
            ActionRegistry.instance().put(new AbstractAction("Rotate Right"){
                private static final long serialVersionUID = -2300127714359881249L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.viewerFrame.rotateScene(new double[]{0.0, 1.0, 0.0}, Main.this.ui.getRotationStep() * Math.PI / 180.0);
                }
            }, "Rotate the scene to the right", KeyStroke.getKeyStroke(39, 0));
        }
        return ActionRegistry.instance().get("Rotate Right");
    }

    private Action actionRotateLeft() {
        String name = "Rotate Left";
        if (ActionRegistry.instance().get("Rotate Left") == null) {
            ActionRegistry.instance().put(new AbstractAction("Rotate Left"){
                private static final long serialVersionUID = 1760655291215774794L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.viewerFrame.rotateScene(new double[]{0.0, 1.0, 0.0}, -Main.this.ui.getRotationStep() * Math.PI / 180.0);
                }
            }, "Rotate the scene to the left", KeyStroke.getKeyStroke(37, 0));
        }
        return ActionRegistry.instance().get("Rotate Left");
    }

    private Action actionRotateUp() {
        String name = "Rotate Up";
        if (ActionRegistry.instance().get("Rotate Up") == null) {
            ActionRegistry.instance().put(new AbstractAction("Rotate Up"){
                private static final long serialVersionUID = -713840553786455658L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.viewerFrame.rotateScene(new double[]{1.0, 0.0, 0.0}, -Main.this.ui.getRotationStep() * Math.PI / 180.0);
                }
            }, "Rotate the scene upward", KeyStroke.getKeyStroke(38, 0));
        }
        return ActionRegistry.instance().get("Rotate Up");
    }

    private Action actionRotateDown() {
        String name = "Rotate Down";
        if (ActionRegistry.instance().get("Rotate Down") == null) {
            ActionRegistry.instance().put(new AbstractAction("Rotate Down"){
                private static final long serialVersionUID = -3357170530618835917L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.viewerFrame.rotateScene(new double[]{1.0, 0.0, 0.0}, Main.this.ui.getRotationStep() * Math.PI / 180.0);
                }
            }, "Rotate the scene downward", KeyStroke.getKeyStroke(40, 0));
        }
        return ActionRegistry.instance().get("Rotate Down");
    }

    private Action actionRotateClockwise() {
        String name = "Rotate Clockwise";
        if (ActionRegistry.instance().get("Rotate Clockwise") == null) {
            ActionRegistry.instance().put(new AbstractAction("Rotate Clockwise"){
                private static final long serialVersionUID = -1143902458135287185L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.viewerFrame.rotateScene(new double[]{0.0, 0.0, 1.0}, -Main.this.ui.getRotationStep() * Math.PI / 180.0);
                }
            }, "Rotate the scene clockwise", KeyStroke.getKeyStroke(39, 64));
        }
        return ActionRegistry.instance().get("Rotate Clockwise");
    }

    private Action actionRotateCounterClockwise() {
        String name = "Rotate Counter-Clockwise";
        if (ActionRegistry.instance().get("Rotate Counter-Clockwise") == null) {
            ActionRegistry.instance().put(new AbstractAction("Rotate Counter-Clockwise"){
                private static final long serialVersionUID = -4072606795429852563L;

                public void actionPerformed(ActionEvent e) {
                    Main.this.viewerFrame.rotateScene(new double[]{0.0, 0.0, 1.0}, Main.this.ui.getRotationStep() * Math.PI / 180.0);
                }
            }, "Rotate the scene counter-clockwise", KeyStroke.getKeyStroke(37, 64));
        }
        return ActionRegistry.instance().get("Rotate Counter-Clockwise");
    }

    private void disableTilingChange() {
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.actionOpen().setEnabled(false);
                Main.this.actionReload().setEnabled(false);
                Main.this.actionFirst().setEnabled(false);
                Main.this.actionNext().setEnabled(false);
                Main.this.actionPrevious().setEnabled(false);
                Main.this.actionLast().setEnabled(false);
                Main.this.actionJump().setEnabled(false);
                Main.this.actionSearch().setEnabled(false);
            }
        });
    }

    private void enableTilingChange() {
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.actionOpen().setEnabled(true);
                Main.this.actionReload().setEnabled(true);
                Main.this.actionFirst().setEnabled(true);
                Main.this.actionNext().setEnabled(true);
                Main.this.actionPrevious().setEnabled(true);
                Main.this.actionLast().setEnabled(true);
                Main.this.actionJump().setEnabled(true);
                Main.this.actionSearch().setEnabled(true);
            }
        });
    }

    private void openFile(final String path) {
        this.last_path = path;
        final String filename = new File(path).getName();
        this.disableTilingChange();
        this.busy();
        new Thread(new Runnable(){

            public void run() {
                try {
                    Main.this.documents = Document.load(path);
                    Main.this.done();
                    Main.this.enableTilingChange();
                    Invoke.later(new Runnable(){

                        public void run() {
                            Main.log("File " + filename + " opened with " + Main.this.documents.size() + " tiling" + (Main.this.documents.size() > 1 ? "s" : "") + ".");
                            for (String key : Main.this.tInfoFields.keySet()) {
                                Main.this.setTInfo(key, "");
                            }
                            Main.this.setTInfo("_file", filename);
                        }
                    });
                    Main.this.tilingCounter = 0;
                    if (Main.this.documents.size() == 1) {
                        Main.this.doTiling(1);
                    } else if (Main.this.documents.size() > 1) {
                        Main.this.actionSearch().actionPerformed(null);
                    }
                    return;
                }
                catch (FileNotFoundException ex) {
                    Main.log("Could not find file " + filename);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Main.this.done();
                Main.this.enableTilingChange();
            }
        }).start();
    }

    private void reloadCurrentTiling() {
        int n = this.tilingCounter;
        this.documents.set(n - 1, this.documents.get(n - 1).cleanCopy());
        this.doTiling(n);
    }

    private void reopenFile() {
        final String path = this.last_path;
        final String filename = new File(path).getName();
        this.disableTilingChange();
        this.busy();
        new Thread(new Runnable(){

            public void run() {
                try {
                    Main.this.documents = Document.load(path);
                    Main.this.done();
                    Main.this.enableTilingChange();
                    Main.this.doTiling(Main.this.tilingCounter);
                    return;
                }
                catch (FileNotFoundException ex) {
                    Main.log("Could not find file " + filename);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Main.this.done();
                Main.this.enableTilingChange();
            }
        }).start();
    }

    private void busy() {
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.viewerFrame.setCursor(Main.this.busyCursor);
                Main.this.controlsFrame.setCursor(Main.this.busyCursor);
            }
        });
    }

    private void done() {
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.viewerFrame.setCursor(Main.this.normalCursor);
                Main.this.controlsFrame.setCursor(Main.this.normalCursor);
            }
        });
    }

    private void doTiling(final int n) {
        if (this.documents == null || n < 1 || n > this.documents.size()) {
            return;
        }
        this.disableTilingChange();
        this.busy();
        new Thread(new Runnable(){

            public void run() {
                Main.this.tilingCounter = n;
                try {
                    Main.this.processTiling((Document)Main.this.documents.get(Main.this.tilingCounter - 1));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Main.this.done();
                Main.this.enableTilingChange();
            }
        }).start();
    }

    private Document doc() {
        return this.currentDocument;
    }

    private void processTiling(Document doc) {
        Stopwatch timer = new Stopwatch();
        if (doc.isUnprocessed()) {
            doc.setUseMaximalSymmetry(this.getUseMaximalSymmetry());
        }
        for (String key : this.tInfoFields.keySet()) {
            if (key == "_file") continue;
            this.setTInfo(key, "");
        }
        this.setTInfo("_num", String.valueOf(this.tilingCounter) + " of " + this.documents.size());
        String name = doc.getName();
        if (name == null) {
            name = "--";
        }
        this.setTInfo("_name", name);
        this.currentDocument = doc;
        if (doc.getProperties() != null) {
            try {
                Config.pushProperties(doc.getProperties(), this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        doc.removeEventLink(DisplayList.Event.class, this);
        doc.addEventLink(DisplayList.Event.class, (Object)this, "handleDisplayListEvent");
        try {
            DSymbol ds = this.doc().getSymbol();
            this.setTInfo("size", ds.size());
            this.setTInfo("dim", ds.dim());
            this.setTInfo("transitivity", this.doc().getTransitivity());
            this.setTInfo("minimal", ds.isMinimal());
            this.setTInfo("selfdual", ds.equals(ds.dual()));
            this.setTInfo("signature", "pending...");
            this.setTInfo("group", "pending...");
            this.setTInfo("net", "pending...");
        }
        catch (UnsupportedOperationException ex) {
            ex.printStackTrace();
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.suspendRendering();
        Main.log("Constructing geometry...");
        Main.startTimer(timer);
        try {
            this.construct();
        }
        catch (Exception ex) {
            this.clearSceneGraph();
            ex.printStackTrace();
            return;
        }
        Main.log("  " + Main.getTimer(timer));
        final Document oldDoc = this.doc();
        Thread worker = new Thread(new Runnable(){

            public void run() {
                String sig = oldDoc.getSignature();
                if (Main.this.doc() != oldDoc) {
                    return;
                }
                Main.this.setTInfo("signature", sig);
                String group = oldDoc.getGroupName();
                if (Main.this.doc() != oldDoc) {
                    return;
                }
                Main.this.setTInfo("group", group);
                Archive.Entry net = systreArchive.getByKey(oldDoc.getNet().minimalImage().getSystreKey());
                if (Main.this.doc() != oldDoc) {
                    return;
                }
                if (net == null) {
                    Main.this.setTInfo("net", "--unknown--");
                } else {
                    Main.this.setTInfo("net", net.getName());
                }
            }
        });
        worker.setPriority(1);
        worker.start();
        this.updateCamera();
        if (doc.getTransformation() != null) {
            this.setViewingTransformation(doc.getTransformation());
        } else {
            this.setViewingTransformation(new Vector(0, 0, 1), new Vector(0, 1, 0));
        }
        this.resumeRendering();
        this.encompass();
    }

    private Surface makeMesh(Tiling.Tile b) {
        Tiling.Facet face;
        Object d;
        int nFaces = b.size();
        int[] fStart = new int[nFaces];
        Surface[] fSurf = new Surface[nFaces];
        String[] fTag = new String[2 * nFaces];
        int outlineFixing = this.getSubdivisionLevel() - this.getEdgeRoundingLevel();
        int nextStart = 0;
        int i = 0;
        while (i < b.size()) {
            Tiling.Facet face2 = b.facet(i);
            int n = face2.size();
            fStart[i] = nextStart;
            double[][] corners = new double[n][3];
            int j = 0;
            while (j < n) {
                corners[j] = this.doc().cornerPosition(0, face2.chamber(j));
                ++j;
            }
            double[] center = this.doc().cornerPosition(2, face2.getChamber());
            double[][] p = new double[n][3];
            int j2 = 0;
            while (j2 < n) {
                double[] u = corners[(j2 + n - 1) % n];
                double[] v = corners[j2];
                double[] w = corners[(j2 + 1) % n];
                double[] vu = Rn.subtract(null, (double[])u, (double[])v);
                double[] vw = Rn.subtract(null, (double[])w, (double[])v);
                double[] vc = Rn.subtract(null, (double[])center, (double[])v);
                Rn.normalize((double[])vu, (double[])vu);
                Rn.normalize((double[])vw, (double[])vw);
                d = Rn.add(null, (double[])vu, (double[])vw);
                double f = Rn.innerProduct((double[])d, (double[])vu);
                double[] tmp = Rn.times(null, (double)f, (double[])vu);
                Rn.subtract((double[])tmp, (double[])d, (double[])tmp);
                double length = this.edgeWidth * Rn.euclideanNorm((double[])d) / Rn.euclideanNorm((double[])tmp);
                Rn.crossProduct((double[])tmp, (double[])vu, (double[])vw);
                Rn.crossProduct((double[])tmp, (double[])d, (double[])tmp);
                Rn.normalize((double[])tmp, (double[])tmp);
                f = Rn.innerProduct((double[])tmp, (double[])vc);
                Rn.times((double[])tmp, (double)f, (double[])tmp);
                Rn.subtract((double[])tmp, (double[])vc, (double[])tmp);
                f = length / Rn.euclideanNorm((double[])tmp);
                Rn.linearCombination((double[])p[j2], (double)1.0, (double[])corners[j2], (double)f, (double[])tmp);
                ++j2;
            }
            fSurf[i] = Surface.fromOutline(p, 1000);
            fTag[i] = String.format("face:%03d", face2.getIndex());
            fTag[nFaces + i] = String.format("outline:%03d", face2.getIndex());
            fSurf[i].tagAll(fTag[i]);
            nextStart += fSurf[i].vertices.length;
            ++i;
        }
        Surface allFaces = Surface.concatenation(fSurf);
        ArrayList<Object> vertices = new ArrayList<Object>();
        vertices.addAll(Arrays.asList(allFaces.vertices));
        ArrayList<Object> faces = new ArrayList<Object>();
        faces.addAll(Arrays.asList(allFaces.faces));
        ArrayList<Object> tagsList = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < allFaces.faces.length) {
            tagsList.add(allFaces.getAttribute(Surface.FACE, i2, Surface.TAG));
            ++i2;
        }
        ArrayList<Integer> fixedList = new ArrayList<Integer>();
        int i3 = 0;
        while (i3 < allFaces.fixed.length) {
            fixedList.add(allFaces.fixed[i3]);
            ++i3;
        }
        ArrayList<Boolean> convexList = new ArrayList<Boolean>();
        int i4 = 0;
        while (i4 < allFaces.vertices.length) {
            convexList.add(false);
            ++i4;
        }
        Tiling til = this.doc().getTiling();
        DSCover<Integer> cover = til.getCover();
        IndexList idcsB = new IndexList(0, 1, 2);
        IndexList idcsV = new IndexList(1, 2);
        int D = b.getChamber();
        HashMap<Integer, Integer> ch2edge = new HashMap<Integer, Integer>();
        d = cover.orbit(idcsB, D).iterator();
        while (d.hasNext()) {
            int E = (Integer)d.next();
            if (til.coverOrientation(E) < 0) continue;
            double[] v = this.doc().cornerPosition(0, E);
            double[] w = this.doc().cornerPosition(0, cover.op(0, (Integer)E));
            double f = this.getEdgeWidth() / Rn.euclideanNorm((double[])Rn.subtract(null, (double[])v, (double[])w));
            ch2edge.put(E, vertices.size());
            ch2edge.put(cover.op(2, (Integer)E), vertices.size());
            vertices.add(Rn.linearCombination(null, (double)(1.0 - f), (double[])v, (double)f, (double[])w));
            fixedList.add(outlineFixing);
            convexList.add(true);
        }
        HashMap<Integer, Integer> ch2vertex = new HashMap<Integer, Integer>();
        for (int E : cover.orbit(idcsB, D)) {
            if (ch2vertex.containsKey(E)) continue;
            double[] sum = new double[3];
            int n = 0;
            for (int C : cover.orbit(idcsV, E)) {
                ch2vertex.put(C, vertices.size());
                Rn.add((double[])sum, (double[])sum, (double[])((double[])vertices.get((Integer)ch2edge.get(C))));
                ++n;
            }
            if (this.getEdgeRoundingLevel() > 0) {
                vertices.add(Rn.linearCombination(null, (double)(0.5 / (double)n), (double[])sum, (double)0.5, (double[])this.doc().cornerPosition(0, E)));
            } else {
                vertices.add(this.doc().cornerPosition(0, E));
            }
            fixedList.add(outlineFixing);
            convexList.add(true);
        }
        HashMap<Integer, Integer> ch2inner = new HashMap<Integer, Integer>();
        int k = 0;
        while (k < b.size()) {
            face = b.facet(k);
            int i5 = 0;
            while (i5 < face.size()) {
                int E = face.chamber(i5);
                int pos = fStart[k] + i5;
                ch2inner.put(E, pos);
                ch2inner.put(cover.op(1, (Integer)E), pos);
                ++i5;
            }
            ++k;
        }
        k = 0;
        while (k < b.size()) {
            face = b.facet(k);
            int n = face.size();
            int i6 = 0;
            while (i6 < n) {
                int E = face.chamber(i6);
                int E0 = cover.op(0, (Integer)E);
                int E1 = cover.op(1, (Integer)E);
                if (this.getEdgeRoundingLevel() > 0) {
                    faces.add(new int[]{(Integer)ch2edge.get(E), (Integer)ch2edge.get(E0), (Integer)ch2inner.get(E0), (Integer)ch2inner.get(E)});
                    faces.add(new int[]{(Integer)ch2edge.get(E), (Integer)ch2inner.get(E), (Integer)ch2edge.get(E1), (Integer)ch2vertex.get(E)});
                    tagsList.add(fTag[nFaces + k]);
                    tagsList.add(fTag[nFaces + k]);
                } else {
                    faces.add(new int[]{(Integer)ch2edge.get(E), (Integer)ch2edge.get(E0), (Integer)ch2inner.get(E0), (Integer)ch2inner.get(E)});
                    faces.add(new int[]{(Integer)ch2edge.get(E), (Integer)ch2inner.get(E), (Integer)ch2vertex.get(E)});
                    faces.add(new int[]{(Integer)ch2inner.get(E), (Integer)ch2edge.get(E1), (Integer)ch2vertex.get(E)});
                    tagsList.add(fTag[nFaces + k]);
                    tagsList.add(fTag[nFaces + k]);
                    tagsList.add(fTag[nFaces + k]);
                }
                ++i6;
            }
            ++k;
        }
        double[][] pos = new double[vertices.size()][];
        vertices.toArray((T[])pos);
        int[][] idcs = new int[faces.size()][];
        faces.toArray((T[])idcs);
        int[] fixed = new int[vertices.size()];
        int i7 = 0;
        while (i7 < vertices.size()) {
            fixed[i7] = (Integer)fixedList.get(i7);
            ++i7;
        }
        Surface surf = new Surface(pos, idcs, fixed);
        int i8 = 0;
        while (i8 < tagsList.size()) {
            surf.setAttribute(Surface.FACE, i8, Surface.TAG, tagsList.get(i8));
            ++i8;
        }
        i8 = 0;
        while (i8 < convexList.size()) {
            surf.setAttribute(Surface.VERTEX, i8, Surface.CONVEX, convexList.get(i8));
            ++i8;
        }
        int level = 0;
        while (level < this.getSubdivisionLevel()) {
            surf = surf.subdivision();
            ++level;
        }
        surf.computeNormals();
        return surf;
    }

    private SceneGraphComponent makeBody(Tiling.Tile b) {
        Surface surf = this.makeMesh(b);
        SceneGraphComponent sgc = new SceneGraphComponent("template:" + b.getIndex());
        for (String tag : surf.faceTags()) {
            Surface surfPart = surf.extract(tag);
            IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
            ifsf.setVertexCount(surfPart.vertices.length);
            ifsf.setFaceCount(surfPart.faces.length);
            ifsf.setVertexCoordinates(surfPart.vertices);
            ifsf.setFaceIndices(surfPart.faces);
            ifsf.setGenerateEdgesFromFaces(true);
            ifsf.setFaceNormals(surfPart.getFaceNormals());
            if (this.getSmoothFaces()) {
                ifsf.setVertexNormals(surfPart.getVertexNormals());
            }
            ifsf.update();
            SceneGraphComponent part = new SceneGraphComponent(tag);
            part.setGeometry((Geometry)ifsf.getIndexedFaceSet());
            sgc.addChild(part);
        }
        return sgc;
    }

    private void addTile(DisplayList.Item item) {
        if (item == null) {
            return;
        }
        int kind = item.getTile().getIndex();
        Vector shift = item.getShift();
        SceneGraphComponent template = this.templates[kind];
        SceneGraphComponent sgc = new SceneGraphComponent("body");
        MatrixBuilder.euclidean().translate(((Vector)shift.times(this.doc().getEmbedderToWorld())).getCoordinates().asDoubleArray()[0]).assignTo(sgc);
        sgc.addChild(template);
        sgc.setAppearance(this.materials[kind]);
        this.tiling.addChild(sgc);
        this.node2item.put(sgc, item);
        this.item2node.put(item, sgc);
    }

    private void addFacet(DisplayList.Item item) {
        if (item == null) {
            return;
        }
        Tiling.Facet facet = item.getFacet();
        int kind = facet.getTile().getIndex();
        SceneGraphComponent template = this.templates[kind];
        SceneGraphComponent sgc = new SceneGraphComponent("facet");
        MatrixBuilder.euclidean().translate(((Vector)item.getShift().times(this.doc().getEmbedderToWorld())).getCoordinates().asDoubleArray()[0]).assignTo(sgc);
        String[] pattern = new String[]{String.format("face:%03d", facet.getIndex()), String.format("outline:%03d", facet.getIndex())};
        for (SceneGraphComponent c : template.getChildComponents()) {
            String name = c.getName();
            if (name == null || !name.equals(pattern[0]) && !name.equals(pattern[1])) continue;
            sgc.addChild(c);
        }
        Appearance a = new Appearance();
        this.setColor(a, this.doc().getEfffectiveColor(item));
        sgc.setAppearance(a);
        this.tiling.addChild(sgc);
        this.node2item.put(sgc, item);
        this.item2node.put(item, sgc);
    }

    private void addEdge(DisplayList.Item item) {
        if (item == null) {
            return;
        }
        Color c = this.getNetEdgeColor();
        double r = this.getNetEdgeRadius();
        IEdge e = item.getEdge();
        Vector s = (Vector)item.getShift().times(this.doc().getEmbedderToWorld());
        double[] p = ((Point)this.doc().edgeSourcePoint(e).plus(s)).getCoordinates().asDoubleArray()[0];
        double[] q = ((Point)this.doc().edgeTargetPoint(e).plus(s)).getCoordinates().asDoubleArray()[0];
        SceneGraphComponent sgc = TubeUtility.tubeOneEdge((double[])p, (double[])q, (double)r, (double[][])TubeUtility.octagonalCrossSection, (int)0);
        Appearance a = new Appearance();
        this.setColor(a, c);
        a.setAttribute("transparency", 0.0);
        sgc.setAppearance(a);
        this.net.addChild(sgc);
        this.node2item.put(sgc, item);
        this.item2node.put(item, sgc);
    }

    private void addNode(DisplayList.Item item) {
        if (item == null) {
            return;
        }
        Color c = this.getNetNodeColor();
        double r = this.getNetNodeRadius();
        INode node = item.getNode();
        Vector s = (Vector)item.getShift().times(this.doc().getEmbedderToWorld());
        double[] p = ((Point)this.doc().nodePoint(node).plus(s)).getCoordinates().asDoubleArray()[0];
        SceneGraphComponent sgc = SceneGraphUtility.createFullSceneGraphComponent((String)"node");
        MatrixBuilder.init(null, (int)0).translate(p).scale(r).assignTo(sgc.getTransformation());
        sgc.addChild(sphereTemplate);
        Appearance a = new Appearance();
        this.setColor(a, c);
        a.setAttribute("transparency", 0.0);
        sgc.setAppearance(a);
        this.net.addChild(sgc);
        this.node2item.put(sgc, item);
        this.item2node.put(item, sgc);
    }

    private void recolorTile(DisplayList.Item item, Color color) {
        Appearance a;
        if (color != null) {
            a = new Appearance();
            this.setColor(a, color);
        } else {
            a = this.materials[item.getTile().getIndex()];
        }
        this.item2node.get(item).setAppearance(a);
    }

    private void clearSceneGraph() {
        this.item2node.clear();
        this.node2item.clear();
        SceneGraphUtility.removeChildren((SceneGraphComponent)this.tiling);
        SceneGraphUtility.removeChildren((SceneGraphComponent)this.net);
    }

    public void handleDisplayListEvent(Object event) {
        DisplayList.Event e = (DisplayList.Event)event;
        DisplayList.Item item = e.getInstance();
        if (e.getEventType() != DisplayList.BEGIN && e.getEventType() != DisplayList.END) {
            if (e.getEventType() == DisplayList.ADD) {
                if (item.isTile()) {
                    this.addTile(item);
                } else if (item.isFacet()) {
                    this.addFacet(item);
                } else if (item.isEdge()) {
                    this.addEdge(item);
                } else if (item.isNode()) {
                    this.addNode(item);
                }
            } else if (e.getEventType() == DisplayList.DELETE) {
                SceneGraphNode node = (SceneGraphNode)this.item2node.get(item);
                this.item2node.remove(item);
                this.node2item.remove(node);
                if (item != null && node != null) {
                    if (item.isTile() || item.isFacet()) {
                        SceneGraphUtility.removeChildNode((SceneGraphComponent)this.tiling, (SceneGraphNode)node);
                    } else if (item.isEdge() || item.isNode()) {
                        SceneGraphUtility.removeChildNode((SceneGraphComponent)this.net, (SceneGraphNode)node);
                    }
                }
            } else if (e.getEventType() == DisplayList.RECOLOR && item.isTile()) {
                this.recolorTile(item, e.getNewColor());
            }
        }
    }

    private void construct() {
        Stopwatch timer = new Stopwatch();
        Main.log("    Making tiling...");
        Main.startTimer(timer);
        this.doc().getTiling();
        Main.log("      " + Main.getTimer(timer));
        Main.log("    Initializing embedder...");
        Main.startTimer(timer);
        this.doc().initializeEmbedder();
        Main.log("      " + Main.getTimer(timer));
        this.embed();
        this.makeTiles();
        this.makeMaterials();
        this.updateDisplayProperties();
        this.updateMaterials();
        if (this.doc().size() == 0) {
            this.clearSceneGraph();
            this.makeCopies();
        } else {
            this.refreshScene();
        }
    }

    private void reembed() {
        if (this.doc() == null) {
            return;
        }
        this.doc().invalidateEmbedding();
        this.embed();
        this.makeTiles();
        this.updateDisplayProperties();
        this.updateMaterials();
        this.suspendRendering();
        this.refreshScene();
        this.resumeRendering();
    }

    private void embed() {
        this.doc().setEmbedderStepLimit(this.getEmbedderStepLimit());
        this.doc().setEqualEdgePriority(this.getEqualEdgePriority());
        this.doc().setIgnoreInputCell(this.getIgnoreInputCell());
        this.doc().setIgnoreInputCoordinates(this.getIgnoreInputCoordinates());
        this.doc().setRelaxCoordinates(this.getRelaxCoordinates());
        Stopwatch timer = new Stopwatch();
        Main.log("    Embedding...");
        Main.startTimer(timer);
        this.doc().getEmbedderToWorld();
        Main.log("      " + Main.getTimer(timer));
    }

    private void makeUnitCell() {
        Stopwatch timer = new Stopwatch();
        Main.log("    Determining unit cell");
        Main.startTimer(timer);
        this.doc().setUsePrimitiveCell(this.getUsePrimitiveCell());
        double[] origin = this.doc().getOrigin();
        double[][] cellVecs = this.doc().getUnitCellVectors();
        Main.log("      " + Main.getTimer(timer));
        double[][] corners = new double[8][];
        corners[0] = origin;
        corners[1] = Rn.add(null, (double[])corners[0], (double[])cellVecs[0]);
        int i = 0;
        while (i < 2) {
            corners[i + 2] = Rn.add(null, (double[])corners[i], (double[])cellVecs[1]);
            ++i;
        }
        i = 0;
        while (i < 4) {
            corners[i + 4] = Rn.add(null, (double[])corners[i], (double[])cellVecs[2]);
            ++i;
        }
        int[][] nArrayArray = new int[12][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{2, 3};
        nArrayArray[2] = new int[]{4, 5};
        nArrayArray[3] = new int[]{6, 7};
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[4] = nArray2;
        nArrayArray[5] = new int[]{1, 3};
        nArrayArray[6] = new int[]{4, 6};
        nArrayArray[7] = new int[]{5, 7};
        int[] nArray3 = new int[2];
        nArray3[1] = 4;
        nArrayArray[8] = nArray3;
        nArrayArray[9] = new int[]{1, 5};
        nArrayArray[10] = new int[]{2, 6};
        nArrayArray[11] = new int[]{3, 7};
        int[][] idcs = nArrayArray;
        IndexedLineSetFactory ilsf = new IndexedLineSetFactory();
        ilsf.setVertexCount(corners.length);
        ilsf.setLineCount(idcs.length);
        ilsf.setVertexCoordinates((double[][])corners);
        ilsf.setEdgeIndices((int[][])idcs);
        ilsf.update();
        IndexedLineSet ils = ilsf.getIndexedLineSet();
        BallAndStickFactory basf = new BallAndStickFactory(ils);
        double r = this.getUnitCellEdgeWidth() / 2.0;
        Color c = this.getUnitCellColor();
        basf.setBallRadius(r);
        basf.setStickRadius(r);
        basf.update();
        SceneGraphComponent bas = basf.getSceneGraphComponent();
        bas.setName("UnitCell");
        Appearance a = new Appearance();
        this.setColor(a, c);
        bas.setAppearance(a);
        for (SceneGraphComponent child : bas.getChildComponents()) {
            child.setAppearance(null);
        }
        this.world.removeChild(this.unitCell);
        this.unitCell = basf.getSceneGraphComponent();
        this.world.addChild(this.unitCell);
    }

    private void makeTiles() {
        if (this.doc() == null) {
            return;
        }
        Stopwatch timer = new Stopwatch();
        Main.log("    Making tile templates...");
        Main.startTimer(timer);
        this.templates = new SceneGraphComponent[this.doc().getTiles().size()];
        for (Tiling.Tile b : this.doc().getTiles()) {
            this.templates[b.getIndex()] = this.makeBody(b);
        }
        Main.log("      " + Main.getTimer(timer));
    }

    private void refreshScene() {
        if (this.doc() == null) {
            return;
        }
        SceneGraphUtility.removeChildren((SceneGraphComponent)this.tiling);
        SceneGraphUtility.removeChildren((SceneGraphComponent)this.net);
        for (DisplayList.Item item : this.doc()) {
            if (item.isTile()) {
                this.addTile(item);
                if (this.doc().color(item) == null) continue;
                this.recolorTile(item, this.doc().color(item));
                continue;
            }
            if (item.isFacet()) {
                this.addFacet(item);
                continue;
            }
            if (item.isEdge()) {
                this.addEdge(item);
                continue;
            }
            if (!item.isNode()) continue;
            this.addNode(item);
        }
        this.net.setVisible(this.getShowNet());
    }

    private void exportSceneToOBJ(File file) throws IOException {
        if (this.doc() == null) {
            return;
        }
        File mtlFile = new File(file.getPath().replaceFirst("\\.obj$", ".mtl"));
        BufferedWriter obj = new BufferedWriter(new FileWriter(file));
        BufferedWriter mtl = new BufferedWriter(new FileWriter(mtlFile));
        int offset = 1;
        int i = 1;
        obj.write(String.format("mtllib %s\n", mtlFile.getName()));
        double ns = this.getSpecularExponent();
        float[] rgb_a = this.blendColors(Color.BLACK, this.getAmbientColor(), this.getAmbientCoefficient()).getRGBComponents(null);
        float[] rgb_s = this.blendColors(Color.BLACK, this.getSpecularColor(), this.getSpecularCoefficient()).getRGBComponents(null);
        for (DisplayList.Item item : this.doc()) {
            if (!item.isTile()) continue;
            Tiling.Tile t = item.getTile();
            Surface s = this.makeMesh(t);
            double[] center = this.doc().cornerPosition(3, t.getChamber());
            double[] cneg = new double[3];
            int j = 0;
            while (j < 3) {
                cneg[j] = -center[j];
                ++j;
            }
            double[] a = ((Vector)item.getShift().times(this.doc().getEmbedderToWorld())).asDoubleArray();
            double[] m = MatrixBuilder.euclidean().translate(a).translate(center).scale(this.getTileSize()).translate(cneg).getArray();
            String prefix = String.format("tile:%03d_", i);
            obj.write(String.format("o tile%03d\n", i));
            obj.write(String.format("g kind%03d\n", t.getKind()));
            s.write(obj, offset, prefix, m, this.doc().volume() < 0.0);
            offset += s.vertices.length;
            int j2 = 0;
            while (j2 < t.size()) {
                Color face_color = this.doc().getFacetClassColor(t.facet(j2));
                if (face_color == null) {
                    face_color = this.doc().color(item);
                }
                if (face_color == null) {
                    face_color = this.doc().getDefaultTileColor(t);
                }
                float[] rgb_face = this.blendColors(Color.BLACK, face_color, this.getDiffuseCoefficient()).getRGBComponents(null);
                Color edge_color = this.blendColors(face_color, this.getEdgeColor(), this.getEdgeOpacity());
                float[] rgb_edge = this.blendColors(Color.BLACK, edge_color, this.getDiffuseCoefficient()).getRGBComponents(null);
                mtl.write(String.format("newmtl %sface:%03d\n", prefix, j2));
                this.exportMaterial(mtl, ns, rgb_face, rgb_a, rgb_s);
                mtl.write(String.format("newmtl %soutline:%03d\n", prefix, j2));
                this.exportMaterial(mtl, ns, rgb_edge, rgb_a, rgb_s);
                ++j2;
            }
            ++i;
        }
        obj.flush();
        obj.close();
        mtl.flush();
        mtl.close();
    }

    private void exportMaterial(BufferedWriter mtl, double ns, float[] kd, float[] ka, float[] ks) throws IOException {
        mtl.write(String.format("Ns %f\n", ns));
        mtl.write("d 1.0\n");
        mtl.write("illum 2\n");
        mtl.write(String.format("Kd %f %f %f\n", Float.valueOf(kd[0]), Float.valueOf(kd[1]), Float.valueOf(kd[2])));
        mtl.write(String.format("Ka %f %f %f\n", Float.valueOf(ka[0]), Float.valueOf(ka[1]), Float.valueOf(ka[2])));
        mtl.write(String.format("Ks %f %f %f\n", Float.valueOf(ks[0]), Float.valueOf(ks[1]), Float.valueOf(ks[2])));
        mtl.write("Ke 0.0 0.0 0.0\n");
        mtl.write("\n");
    }

    private void makeMaterials() {
        if (this.doc() == null) {
            return;
        }
        this.materials = new Appearance[this.doc().getTiles().size()];
        int i = 0;
        while (i < this.templates.length) {
            this.materials[i] = new Appearance();
            this.setColor(this.materials[i], this.doc().getDefaultTileColor(i));
            ++i;
        }
    }

    private void setColor(Appearance a, Color c) {
        a.setAttribute("diffuseColor", (Object)c);
    }

    private void updateAppearance(Appearance a) {
        a.setAttribute("showLines", false);
        a.setAttribute("showPoints", false);
        a.setAttribute("ambientCoefficient", this.getAmbientCoefficient());
        a.setAttribute("diffuseCoefficient", this.getDiffuseCoefficient());
        a.setAttribute("specularCoefficient", this.getSpecularCoefficient());
        a.setAttribute("ambientColor", (Object)this.getAmbientColor());
        a.setAttribute("specularColor", (Object)this.getSpecularColor());
        a.setAttribute("specularExponent", this.getSpecularExponent());
        a.setAttribute("transparency", this.getFaceTransparency());
    }

    private Color blendColors(Color c1, Color c2, double f) {
        return new Color((int)((double)c1.getRed() * (1.0 - f) + (double)c2.getRed() * f + 0.5), (int)((double)c1.getGreen() * (1.0 - f) + (double)c2.getGreen() * f + 0.5), (int)((double)c1.getBlue() * (1.0 - f) + (double)c2.getBlue() * f + 0.5));
    }

    private void updateMaterials() {
        if (this.templates == null) {
            return;
        }
        Stopwatch timer = new Stopwatch();
        Main.log("    Updating materials...");
        Main.startTimer(timer);
        this.updateAppearance(this.world.getAppearance());
        this.viewerFrame.getViewer().getSceneRoot().getAppearance().setAttribute("transparencyEnabled", this.getFaceTransparency() > 0.0);
        for (Tiling.Tile b : this.doc().getTiles()) {
            int i = b.getIndex();
            Color tileColor = this.doc().getDefaultTileColor(i);
            this.setColor(this.materials[i], tileColor);
            SceneGraphComponent sgc = this.templates[b.getIndex()];
            for (Object node : sgc.getChildNodes()) {
                Appearance a;
                Color c;
                Tiling.Facet f;
                int j;
                if (!(node instanceof SceneGraphComponent)) continue;
                SceneGraphComponent child = (SceneGraphComponent)node;
                String name = child.getName();
                if (name.startsWith("face:")) {
                    j = Integer.parseInt(name.substring(5));
                    f = b.facet(j);
                    c = this.doc().getFacetClassColor(f);
                    if (c == null) {
                        child.setAppearance(null);
                        continue;
                    }
                    a = new Appearance();
                    this.setColor(a, c);
                    child.setAppearance(a);
                    continue;
                }
                if (!name.startsWith("outline:")) continue;
                j = Integer.parseInt(name.substring(8));
                f = b.facet(j);
                c = this.doc().getFacetClassColor(f);
                a = new Appearance();
                double factor = this.getEdgeOpacity();
                if (c == null) {
                    if (factor > 0.0) {
                        this.setColor(a, this.blendColors(tileColor, this.getEdgeColor(), factor));
                    } else {
                        this.setColor(a, tileColor);
                    }
                } else if (factor > 0.0) {
                    this.setColor(a, this.blendColors(c, this.getEdgeColor(), factor));
                } else {
                    this.setColor(a, c);
                }
                a.setAttribute("transparency", 0.0);
                child.setAppearance(a);
            }
        }
        Main.log("      " + Main.getTimer(timer));
    }

    private void updateDisplayProperties() {
        if (this.templates == null) {
            return;
        }
        Stopwatch timer = new Stopwatch();
        Main.log("    Updating display properties...");
        Main.startTimer(timer);
        for (Tiling.Tile b : this.doc().getTiles()) {
            int i = b.getIndex();
            SceneGraphComponent sgc = this.templates[b.getIndex()];
            double[] center = this.doc().cornerPosition(3, this.doc().getTile(i).getChamber());
            double[] cneg = new double[3];
            int j = 0;
            while (j < 3) {
                cneg[j] = -center[j];
                ++j;
            }
            MatrixBuilder mb = MatrixBuilder.euclidean().translate(center).scale(this.getTileSize()).translate(cneg);
            for (SceneGraphComponent child : sgc.getChildComponents()) {
                Tiling.Facet f;
                int j2;
                String name = child.getName();
                if (name.startsWith("outline:")) {
                    j2 = Integer.parseInt(name.substring(8));
                    f = b.facet(j2);
                    child.setVisible(this.getDrawEdges() && !this.doc().isHiddenFacetClass(f));
                    mb.assignTo(child);
                    continue;
                }
                if (!name.startsWith("face:")) continue;
                j2 = Integer.parseInt(name.substring(5));
                f = b.facet(j2);
                child.setVisible(this.getDrawFaces() && !this.doc().isHiddenFacetClass(f));
                mb.assignTo(child);
            }
        }
        this.makeUnitCell();
        this.unitCell.setVisible(this.getShowUnitCell());
        this.net.setVisible(this.getShowNet());
        Main.log("      " + Main.getTimer(timer));
    }

    private void makeCopies() {
        Stopwatch timer = new Stopwatch();
        Main.log("    Generating scene...");
        Main.startTimer(timer);
        this.doc().setUsePrimitiveCell(this.getUsePrimitiveCell());
        List<Vector> vecs = this.replicationVectors();
        for (Tiling.Tile b : this.doc().getTiles()) {
            for (Vector s : this.doc().centerIntoUnitCell(b)) {
                for (Vector v : vecs) {
                    Vector shift = (Vector)s.plus(v);
                    this.doc().add(b, shift);
                }
            }
        }
        Main.log("      " + Main.getTimer(timer));
    }

    private List<Vector> replicationVectors() {
        Vector[] xyz = this.doc().getUnitCellVectorsInEmbedderCoordinates();
        Vector vx = xyz[0];
        Vector vy = xyz[1];
        Vector vz = xyz[2];
        int loX = this.getMinX();
        int hiX = Math.max(this.minX, this.getMaxX()) + 1;
        int loY = this.getMinY();
        int hiY = Math.max(this.minY, this.getMaxY()) + 1;
        int loZ = this.getMinZ();
        int hiZ = Math.max(this.minZ, this.getMaxZ()) + 1;
        ArrayList<Vector> result = new ArrayList<Vector>();
        int x = loX;
        while (x < hiX) {
            int y = loY;
            while (y < hiY) {
                int z = loZ;
                while (z < hiZ) {
                    result.add((Vector)vx.times(x).plus(vy.times(y)).plus(vz.times(z)));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return result;
    }

    private void makeFacetOutline(Tiling.Facet f, Vector s) {
        int i = 0;
        while (i < f.size()) {
            this.doc().add(f.edge(i), (Vector)f.edgeShift(i).plus(s));
            ++i;
        }
    }

    private void makeTileOutline(Tiling.Tile t, Vector s) {
        int k = 0;
        while (k < t.size()) {
            Tiling.Facet f = t.facet(k);
            int i = 0;
            while (i < f.size()) {
                this.doc().add(f.edge(i), (Vector)f.edgeShift(i).plus(s));
                ++i;
            }
            ++k;
        }
    }

    public void encompass() {
        Invoke.later(new Runnable(){

            public void run() {
                Main.this.viewerFrame.encompass();
            }
        });
    }

    public Vector getEyeVector() {
        if (this.doc() == null) {
            return null;
        }
        SceneGraphComponent root = this.world;
        Matrix m = new Matrix(root.getTransformation()).getInverse().getTranspose();
        double[] b = m.getArray();
        double[][] a = new double[][]{{b[0], b[1], b[2], b[3]}, {b[4], b[5], b[6], b[7]}, {b[8], b[9], b[10], b[11]}, {b[12], b[13], b[14], b[15]}};
        Operator t = new Operator(a);
        CoordinateChange c = this.doc().getCellToWorld();
        return (Vector)new Vector(0, 0, 1).times(t).times(c.inverse());
    }

    public void setViewingTransformation(Vector eye, Vector up) {
        if (this.doc() == null) {
            return;
        }
        SceneGraphComponent root = this.world;
        CoordinateChange c = this.doc().getCellToWorld();
        Operator op = Operator.viewingRotation((Vector)eye.times(c), (Vector)up.times(c));
        double[][] a = op.getCoordinates().transposed().asDoubleArray();
        double[] b = new double[]{a[0][0], a[0][1], a[0][2], a[0][3], a[1][0], a[1][1], a[1][2], a[1][3], a[2][0], a[2][1], a[2][2], a[2][3], a[3][0], a[3][1], a[3][2], a[3][3]};
        MatrixBuilder.euclidean((Matrix)new Matrix(b)).assignTo(root);
    }

    private void updateCamera() {
        Camera cam = CameraUtility.getCamera((Viewer)this.viewerFrame.getViewer());
        boolean re_encompass = false;
        if (this.getFieldOfView() != cam.getFieldOfView()) {
            cam.setFieldOfView(this.getFieldOfView());
            re_encompass = true;
        }
        if (re_encompass) {
            this.encompass();
        }
        Appearance a = this.viewerFrame.getViewer().getSceneRoot().getAppearance();
        a.setAttribute("backgroundColors", Appearance.INHERITED);
        a.setAttribute("backgroundColor", (Object)this.getBackgroundColor());
        a.setAttribute("fogEnabled", this.getUseFog());
        a.setAttribute("fogDensity", this.getFogDensity());
        if (this.getFogToBackground()) {
            a.setAttribute("fogColor", (Object)this.getBackgroundColor());
        } else {
            a.setAttribute("fogColor", (Object)this.getFogColor());
        }
    }

    private void updateLights() {
        DirectionalLight l1 = new DirectionalLight();
        l1.setIntensity(this.getLight1Intensity());
        l1.setColor(this.getLight1Color());
        Transformation t1 = new Transformation();
        MatrixBuilder.euclidean().rotateX(Main.deg(-this.getLight1AngleX())).rotateY(Main.deg(this.getLight1AngleY())).assignTo(t1);
        this.viewerFrame.setLight("Light1", (Light)l1, t1);
        DirectionalLight l2 = new DirectionalLight();
        l2.setIntensity(this.getLight2Intensity());
        l2.setColor(this.getLight2Color());
        Transformation t2 = new Transformation();
        MatrixBuilder.euclidean().rotateX(Main.deg(-this.getLight2AngleX())).rotateY(Main.deg(this.getLight2AngleY())).assignTo(t2);
        this.viewerFrame.setLight("Light2", (Light)l2, t2);
        DirectionalLight l3 = new DirectionalLight();
        l3.setIntensity(this.getLight3Intensity());
        l3.setColor(this.getLight3Color());
        Transformation t3 = new Transformation();
        MatrixBuilder.euclidean().rotateX(Main.deg(-this.getLight3AngleX())).rotateY(Main.deg(this.getLight3AngleY())).assignTo(t3);
        this.viewerFrame.setLight("Light3", (Light)l3, t3);
    }

    private void suspendRendering() {
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.viewerFrame.pauseRendering();
            }
        });
    }

    private void resumeRendering() {
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.viewerFrame.startRendering();
            }
        });
    }

    private Transformation getViewingTransformation() {
        return this.world.getTransformation();
    }

    private void setViewingTransformation(Transformation trans) {
        this.world.setTransformation(trans);
    }

    private JPopupMenu selectionPopupForTiles() {
        if (this._selectionPopupForTiles == null) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this._selectionPopupForTiles = new JPopupMenu("Tile Actions");
            this._selectionPopupForTiles.setLightWeightPopupEnabled(false);
            this._selectionPopupForTiles.add(this.actionAddTile());
            this._selectionPopupForTiles.add(this.actionRemoveTile());
            this._selectionPopupForTiles.add(this.actionRemoveTileClass());
            this._selectionPopupForTiles.addSeparator();
            this._selectionPopupForTiles.add(this.actionHideFacetClass());
            this._selectionPopupForTiles.add(this.actionShowAllInTile());
            this._selectionPopupForTiles.addSeparator();
            this._selectionPopupForTiles.add(this.actionAddFacetOutline());
            this._selectionPopupForTiles.add(this.actionAddTileOutline());
            this._selectionPopupForTiles.addSeparator();
            this._selectionPopupForTiles.add(this.actionRecolorTile());
            this._selectionPopupForTiles.add(this.actionUncolorTile());
            this._selectionPopupForTiles.add(this.actionRecolorTileClass());
            this._selectionPopupForTiles.add(this.actionRecolorFacetClass());
            this._selectionPopupForTiles.add(this.actionUncolorFacetClass());
            this._selectionPopupForTiles.addSeparator();
            this._selectionPopupForTiles.add(this.actionAddFacet());
            this._selectionPopupForTiles.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    Main.this.viewerFrame.startRendering();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Main.this.viewerFrame.pauseRendering();
                }
            });
        }
        return this._selectionPopupForTiles;
    }

    private JPopupMenu selectionPopupForNodes() {
        if (this._selectionPopupForNodes == null) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this._selectionPopupForNodes = new JPopupMenu("Node Actions");
            this._selectionPopupForNodes.setLightWeightPopupEnabled(false);
            this._selectionPopupForNodes.add(this.actionConnectNode());
            this._selectionPopupForNodes.add(this.actionRemoveNode());
            this._selectionPopupForNodes.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    Main.this.viewerFrame.startRendering();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Main.this.viewerFrame.pauseRendering();
                }
            });
        }
        return this._selectionPopupForNodes;
    }

    private JPopupMenu selectionPopupForEdges() {
        if (this._selectionPopupForEdges == null) {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this._selectionPopupForEdges = new JPopupMenu("Edge Actions");
            this._selectionPopupForEdges.setLightWeightPopupEnabled(false);
            this._selectionPopupForEdges.add(this.actionAddEndNodes());
            this._selectionPopupForEdges.add(this.actionRemoveEdge());
            this._selectionPopupForEdges.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    Main.this.viewerFrame.startRendering();
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Main.this.viewerFrame.pauseRendering();
                }
            });
        }
        return this._selectionPopupForEdges;
    }

    private void updateViewerSize() {
        final Dimension d = new Dimension(this.ui.getViewerWidth(), this.ui.getViewerHeight());
        Invoke.andWait(new Runnable(){

            public void run() {
                Main.this.viewerFrame.setViewerSize(d);
            }
        });
    }

    private BButton makeButton(String label, Object target, String method) {
        BButton button = new BButton(label);
        button.setBackground(buttonColor);
        button.addEventLink(CommandEvent.class, target, method);
        return button;
    }

    private void saveOptions() {
        Properties ourProps = new Properties();
        try {
            Config.pullProperties(ourProps, this);
            if (this.doc() != null) {
                this.doc().setProperties(ourProps);
            }
            Config.pullProperties(ourProps, this.ui);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            ourProps.store(new FileOutputStream(configFileName), "3dt options");
        }
        catch (FileNotFoundException ex) {
            Main.log("Could not find configuration file " + configFileName);
        }
        catch (IOException ex) {
            Main.log("Exception occurred while writing configuration file");
        }
    }

    private void loadOptions() {
        Properties ourProps = new Properties();
        try {
            ourProps.load(new FileInputStream(configFileName));
        }
        catch (FileNotFoundException e1) {
            Main.log("Could not find configuration file " + configFileName);
            return;
        }
        catch (IOException e1) {
            Main.log("Exception occurred while reading configuration file");
            return;
        }
        for (Object x : ourProps.keySet()) {
            String key = (String)x;
            String val = System.getProperty(key);
            if (val == null) continue;
            ourProps.setProperty(key, val);
        }
        try {
            Config.pushProperties(ourProps, this);
            Config.pushProperties(ourProps, this.ui);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ColumnContainer emptyOptionsContainer() {
        ColumnContainer options = new ColumnContainer();
        options.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(2, 5, 2, 5), null));
        options.setBackground(null);
        return options;
    }

    private Widget separator() {
        return new BSeparator();
    }

    private Widget label(String txt, BorderContainer.Position pos) {
        BorderContainer result = new BorderContainer();
        result.setBackground(null);
        result.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 10, 2, 10), null));
        result.add(new BLabel(txt), pos);
        return result;
    }

    private Widget optionsDialog(Widget options, Widget buttons) {
        BorderContainer dialog = new BorderContainer();
        dialog.setBackground(null);
        dialog.add(options, BorderContainer.NORTH, new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.HORIZONTAL, defaultInsets, null));
        dialog.add(buttons, BorderContainer.SOUTH, new LayoutInfo(LayoutInfo.SOUTH, LayoutInfo.NONE, defaultInsets, null));
        BScrollPane scroll = new BScrollPane(dialog, BScrollPane.SCROLLBAR_NEVER, BScrollPane.SCROLLBAR_AS_NEEDED);
        scroll.setForceHeight(false);
        scroll.setForceWidth(true);
        scroll.setBackground(textColor);
        return scroll;
    }

    private OptionSliderBox slider(String label, String option, double min, double max, double major, double minor, double snap) throws Exception {
        return new OptionSliderBox(label, this, option, min, max, major, minor, snap);
    }

    private Widget optionsTilings() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(new OptionCheckBox("Use maximal symmetry", this, "useMaximalSymmetry"));
            options.add(new BLabel("(Needs tiling reload to take effect.)"));
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                Main.this.saveOptions();
                Main.this.reloadCurrentTiling();
            }
        };
        return this.optionsDialog(options, this.makeButton("Reload", apply, "call"));
    }

    private Widget optionsTiles() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(new OptionCheckBox("Smooth Shading", this, "smoothFaces"));
            options.add(this.slider("Surface Detail", "subdivisionLevel", 0.0, 4.0, 1.0, 1.0, 1.0));
            options.add(this.label("(reduce in case of memory problems)", BorderContainer.EAST));
            options.add(this.separator());
            options.add(this.label("Edges:", BorderContainer.WEST));
            options.add(this.slider("Width", "edgeWidth", 0.0, 0.25, 0.05, 0.01, 0.01));
            options.add(this.slider("Creasing", "edgeRoundingLevel", 0.0, 4.0, 1.0, 1.0, 1.0));
            options.add(new OptionColorBox("Color", this, "edgeColor"));
            options.add(this.slider("Blending", "edgeOpacity", 0.0, 1.0, 0.2, 0.05, 0.05));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                new Thread(new Runnable(){

                    public void run() {
                        Main.this.makeTiles();
                        Main.this.suspendRendering();
                        Main.this.updateDisplayProperties();
                        Main.this.updateMaterials();
                        Main.this.refreshScene();
                        Main.this.resumeRendering();
                        Main.this.saveOptions();
                    }
                }).start();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget optionsScene() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(new OptionCheckBox("Clear Existing", this, "clearOnFill"));
            options.add(new OptionCheckBox("Primitive Cell", this, "usePrimitiveCell"));
            options.add(new OptionRangeSliderBox("x Range", this, "minX", "maxX", -2.0, 2.0, 1.0, 1.0, 1.0));
            options.add(new OptionRangeSliderBox("y Range", this, "minY", "maxY", -2.0, 2.0, 1.0, 1.0, 1.0));
            options.add(new OptionRangeSliderBox("z Range", this, "minZ", "maxZ", -2.0, 2.0, 1.0, 1.0, 1.0));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                new Thread(new Runnable(){

                    public void run() {
                        if (Main.this.doc() != null) {
                            Main.this.suspendRendering();
                            if (Main.this.getClearOnFill()) {
                                Main.this.doc().removeAllTiles();
                            }
                            Main.this.makeCopies();
                            Main.this.makeUnitCell();
                            Main.this.unitCell.setVisible(Main.this.getShowUnitCell());
                            Main.this.resumeRendering();
                        }
                        Main.this.saveOptions();
                    }
                }).start();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget optionsDisplay() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(this.slider("Tile Size", "tileSize", 0.0, 1.0, 0.2, 0.05, 0.01));
            options.add(this.separator());
            options.add(this.label("Unit Cell:", BorderContainer.WEST));
            options.add(new OptionColorBox("Color", this, "unitCellColor"));
            options.add(this.slider("Edge Width", "unitCellEdgeWidth", 0.0, 0.25, 0.05, 0.01, 0.01));
            options.add(this.separator());
            options.add(this.label("Show:", BorderContainer.WEST));
            options.add(new OptionCheckBox("Faces", this, "drawFaces"));
            options.add(new OptionCheckBox("Edges", this, "drawEdges"));
            options.add(new OptionCheckBox("Unit Cell", this, "showUnitCell"));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                Main.this.suspendRendering();
                Main.this.updateDisplayProperties();
                Main.this.resumeRendering();
                Main.this.saveOptions();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget optionsGUI() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(new OptionSliderBox("Rotation Step", this.ui, "rotationStep", 0.0, 30.0, 5.0, 1.0, 1.0));
            options.add(this.separator());
            options.add(this.label("Viewer Size:", BorderContainer.WEST));
            options.add(new OptionInputBox("Width", this.ui, "viewerWidth"));
            options.add(new OptionInputBox("Height", this.ui, "viewerHeight"));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                Main.this.updateViewerSize();
                Main.this.saveOptions();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget optionsNet() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(new OptionCheckBox("Show Net", this, "showNet"));
            options.add(this.separator());
            options.add(this.label("Nodes:", BorderContainer.WEST));
            options.add(new OptionColorBox("Color", this, "netNodeColor"));
            options.add(this.slider("Radius", "netNodeRadius", 0.0, 1.0, 0.2, 0.05, 0.01));
            options.add(this.separator());
            options.add(this.label("Edges:", BorderContainer.WEST));
            options.add(new OptionColorBox("Color", this, "netEdgeColor"));
            options.add(this.slider("Radius", "netEdgeRadius", 0.0, 0.5, 0.1, 0.02, 0.01));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                Main.this.suspendRendering();
                Main.this.refreshScene();
                Main.this.resumeRendering();
                Main.this.saveOptions();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget optionsMaterial() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(this.label("Diffuse Reflection:", BorderContainer.WEST));
            options.add(this.slider("Strength", "diffuseCoefficient", 0.0, 1.0, 0.2, 0.05, 0.01));
            options.add(this.separator());
            options.add(this.label("Specular Reflection:", BorderContainer.WEST));
            options.add(new OptionColorBox("Color", this, "specularColor"));
            options.add(this.slider("Strength", "specularCoefficient", 0.0, 1.0, 0.2, 0.05, 0.01));
            options.add(this.slider("Shininess", "specularExponent", 0.0, 100.0, 20.0, 5.0, 1.0));
            options.add(this.separator());
            options.add(this.label("Ambient Illumination:", BorderContainer.WEST));
            options.add(new OptionColorBox("Color", this, "ambientColor"));
            options.add(this.slider("Strength", "ambientCoefficient", 0.0, 1.0, 0.2, 0.05, 0.01));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                Main.this.suspendRendering();
                Main.this.updateMaterials();
                Main.this.resumeRendering();
                Main.this.saveOptions();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget optionsEmbedding() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(new OptionCheckBox("Ignore Input Cell", this, "ignoreInputCell"));
            options.add(new OptionCheckBox("Ignore Input Coordinates", this, "ignoreInputCoordinates"));
            options.add(new OptionCheckBox("Relax Coordinates", this, "relaxCoordinates"));
            options.add(new OptionInputBox("Relaxation Step Limit", this, "embedderStepLimit"));
            options.add(new OptionInputBox("Edge Equalizing Priority", this, "equalEdgePriority"));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                new Thread(new Runnable(){

                    public void run() {
                        Main.this.reembed();
                        Main.this.saveOptions();
                    }
                }).start();
            }
        };
        return this.optionsDialog(options, this.makeButton("Embed", apply, "call"));
    }

    private Widget optionsCamera() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(this.slider("Field Of View", "fieldOfView", 0.0, 120.0, 20.0, 5.0, 1.0));
            options.add(new OptionColorBox("Background Color", this, "backgroundColor"));
            options.add(this.separator());
            options.add(this.label("Fog:", BorderContainer.WEST));
            options.add(new OptionCheckBox("Enable", this, "useFog"));
            options.add(new OptionInputBox("Density", this, "fogDensity"));
            options.add(new OptionCheckBox("To Background", this, "fogToBackground"));
            options.add(new OptionColorBox("Color", this, "fogColor"));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                new Thread(new Runnable(){

                    public void run() {
                        Main.this.updateCamera();
                        Main.this.saveOptions();
                    }
                }).start();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget optionsLights() {
        ColumnContainer options = this.emptyOptionsContainer();
        try {
            options.add(new OptionColorBox("Color", this, "light1Color"));
            options.add(this.slider("Intensity", "light1Intensity", 0.0, 1.0, 0.2, 0.05, 0.05));
            options.add(this.slider("Elevation", "light1AngleX", -90.0, 90.0, 30.0, 10.0, 5.0));
            options.add(this.slider("Heading", "light1AngleY", -180.0, 180.0, 60.0, 20.0, 5.0));
            options.add(this.separator());
            options.add(new OptionColorBox("Color", this, "light2Color"));
            options.add(this.slider("Intensity", "light2Intensity", 0.0, 1.0, 0.2, 0.05, 0.05));
            options.add(this.slider("Elevation", "light2AngleX", -90.0, 90.0, 30.0, 10.0, 5.0));
            options.add(this.slider("Heading", "light2AngleY", -180.0, 180.0, 60.0, 20.0, 5.0));
            options.add(this.separator());
            options.add(new OptionColorBox("Color", this, "light3Color"));
            options.add(this.slider("Intensity", "light3Intensity", 0.0, 1.0, 0.2, 0.05, 0.05));
            options.add(this.slider("Elevation", "light3AngleX", -90.0, 90.0, 30.0, 10.0, 5.0));
            options.add(this.slider("Heading", "light3AngleY", -180.0, 180.0, 60.0, 20.0, 5.0));
            options.add(this.separator());
        }
        catch (Exception ex) {
            Main.log(ex.toString());
            return null;
        }
        Object apply = new Object(){

            public void call() {
                Main.this.updateLights();
                Main.this.saveOptions();
            }
        };
        return this.optionsDialog(options, this.makeButton("Apply", apply, "call"));
    }

    private Widget allOptions() {
        BTabbedPane options = new BTabbedPane();
        options.setBackground(textColor);
        options.add(this.optionsTiles(), "Tiles");
        options.add(this.optionsScene(), "Fill Space");
        options.add(this.optionsDisplay(), "Display");
        options.add(this.optionsNet(), "Net");
        options.add(this.optionsMaterial(), "Material");
        options.add(this.optionsEmbedding(), "Embedding");
        options.add(this.optionsCamera(), "Camera");
        options.add(this.optionsLights(), "Lights");
        options.add(this.optionsGUI(), "GUI");
        options.add(this.optionsTilings(), "Tilings");
        return options;
    }

    private Widget tilingInfo() {
        RowContainer info = new RowContainer();
        info.setBackground(null);
        info.setDefaultLayout(new LayoutInfo(LayoutInfo.NORTH, LayoutInfo.BOTH, new Insets(10, 10, 10, 10), null));
        String[][] items = new String[][]{{"_file", "File:"}, {"_num", "#"}, {"_name", "Name:"}, {"dim", "Dimension:"}, {"size", "Complexity:"}, {"transitivity", "Transitivity:"}, {"selfdual", "Self-dual:"}, {"signature", "Signature:"}, {"group", "Symmetry:"}, {"minimal", "Max. Symmetric:"}, {"net", "Net Identifier:"}};
        ColumnContainer captions = new ColumnContainer();
        captions.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 0, 2, 0), null));
        captions.setBackground(null);
        ColumnContainer data = new ColumnContainer();
        data.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(2, 0, 2, 0), null));
        data.setBackground(null);
        this.tInfoFields = new LinkedHashMap<String, BLabel>();
        int i = 0;
        while (i < items.length) {
            BLabel label = new BLabel();
            this.tInfoFields.put(items[i][0], label);
            data.add(label);
            captions.add(new BLabel(items[i][1]));
            ++i;
        }
        info.add(captions);
        info.add(data);
        return info;
    }

    private void setTInfo(final String key, final String value) {
        Invoke.andWait(new Runnable(){

            public void run() {
                ((BLabel)Main.this.tInfoFields.get(key)).setText(value);
            }
        });
    }

    private void setTInfo(String key, int value) {
        this.setTInfo(key, String.valueOf(value));
    }

    private void setTInfo(String key, boolean value) {
        this.setTInfo(key, value ? "yes" : "no");
    }

    public void hideControls() {
        if (this.controlsFrame != null) {
            this.controlsFrame.setVisible(false);
        }
    }

    private void placeControls(Component parent, Component controls) {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int width = gd.getDisplayMode().getWidth();
        int x = Math.min(parent.getWidth(), width - 700);
        controls.setSize(600, parent.getHeight());
        controls.setLocation(x, 0);
    }

    public void showControls() {
        if (this.controlsFrame == null) {
            ViewerFrame vF = this.viewerFrame;
            LayoutManager vL = vF.getContentPane().getLayout();
            int vCO = vF.getDefaultCloseOperation();
            class WrappedFrame
            extends BFrame {
                private final /* synthetic */ JFrame val$vF;

                public WrappedFrame(JFrame jFrame, LayoutManager layoutManager, int n) {
                    this.val$vF = jFrame;
                    jFrame.getContentPane().setLayout(layoutManager);
                    jFrame.setDefaultCloseOperation(n);
                }

                protected JFrame createComponent() {
                    return this.val$vF;
                }
            }
            WrappedFrame viewerFrame = new WrappedFrame(vF, vL, vCO);
            BSplitPane top = new BSplitPane();
            top.setBackground(null);
            top.setOrientation(BSplitPane.HORIZONTAL);
            top.add(this.allOptions(), 0);
            BScrollPane scroll = new BScrollPane(this.tilingInfo(), BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_AS_NEEDED);
            scroll.setBackground(textColor);
            top.add(scroll, 1);
            TextAreaOutputStream out = new TextAreaOutputStream();
            PrintStream sysout = new PrintStream(out);
            System.setErr(sysout);
            System.setOut(sysout);
            BSplitPane content = new BSplitPane();
            content.setBackground(null);
            content.setOrientation(BSplitPane.VERTICAL);
            content.add(top, 0);
            content.add(out.getWidget(), 1);
            this.controlsFrame = new BDialog(viewerFrame, "3dt Controls", false);
            this.controlsFrame.addEventLink(WindowClosingEvent.class, (Object)this, "hideControls");
            this.controlsFrame.setContent(content);
            JDialog jf = this.controlsFrame.getComponent();
            this.placeControls(vF, jf);
            jf.validate();
            top.setDividerLocation(350);
            content.setDividerLocation(375);
        }
        if (!this.controlsFrame.isVisible()) {
            JDialog jf = this.controlsFrame.getComponent();
            this.placeControls(this.viewerFrame, jf);
        }
        this.controlsFrame.setVisible(true);
        this.controlsFrame.repaint();
    }

    public void hideAbout() {
        if (this.aboutFrame != null) {
            this.aboutFrame.setVisible(false);
        }
    }

    public void showAbout() {
        if (this.aboutFrame == null) {
            this.aboutFrame = new BDialog(this.controlsFrame, "About 3dt", true);
            this.aboutFrame.addEventLink(WindowClosingEvent.class, (Object)this, "hideAbout");
            this.aboutFrame.addEventLink(MouseClickedEvent.class, (Object)this, "hideAbout");
            BLabel label = new BLabel("<html><center><h2>Gavrog 3dt</h2><p>Version " + Version.full + "</p>" + "<p>by Olaf Delgado-Friedrichs 1997-2013<p>" + "<p>For further information visit<br>" + "<em>http://gavrog.org</em><p>" + "</center></html>");
            BOutline content = BOutline.createEmptyBorder(label, 20);
            content.setBackground(textColor);
            this.aboutFrame.setContent(content);
            this.aboutFrame.pack();
        }
        this.aboutFrame.setVisible(true);
    }

    private static double deg(double d) {
        return d / 180.0 * Math.PI;
    }

    private static void readArchive(Archive arc, String path) {
        InputStream stream = ClassLoader.getSystemResourceAsStream(path);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        arc.addAll(reader);
    }

    public static void main(String[] args) {
        new Main(args);
    }

    private static void startTimer(Stopwatch timer) {
        timer.stop();
        timer.reset();
        timer.start();
    }

    private static String getTimer(Stopwatch timer) {
        timer.stop();
        return timer.format();
    }

    private static void log(final Object x) {
        Invoke.later(new Runnable(){

            public void run() {
                System.err.println(x);
                System.err.flush();
            }
        });
    }

    private List<Tiling.Facet> equivalentFacets(Tiling.Facet f) {
        Integer D0 = f.getChamber();
        DSCover<Integer> ds = this.doc().getTiling().getCover();
        HashSet<Integer> orb = new HashSet<Integer>();
        for (int E0 : ds.elements()) {
            if (!ds.image(E0).equals(ds.image(D0))) continue;
            int E = E0;
            do {
                orb.add(E);
                E = ds.op(0, (Integer)E);
                orb.add(E);
            } while (E0 != (E = ds.op(1, (Integer)E).intValue()));
        }
        ArrayList<Tiling.Facet> result = new ArrayList<Tiling.Facet>();
        for (Tiling.Tile b : this.doc().getTiles()) {
            int j = 0;
            while (j < b.size()) {
                Tiling.Facet fj = b.facet(j);
                Integer E = fj.getChamber();
                if (orb.contains(E)) {
                    result.add(fj);
                }
                ++j;
            }
        }
        return result;
    }

    private void recolorFacetClass(Tiling.Facet f, Color color) {
        for (Tiling.Facet facet : this.equivalentFacets(f)) {
            this.doc().setFacetClassColor(facet, color);
        }
    }

    private void uncolorFacetClass(Tiling.Facet f) {
        for (Tiling.Facet facet : this.equivalentFacets(f)) {
            this.doc().removeFacetClassColor(facet);
        }
    }

    private void showAllInTile(Tiling.Tile t) {
        int i = 0;
        while (i < t.size()) {
            this.showFacetClass(t.facet(i));
            ++i;
        }
    }

    private void showFacetClass(Tiling.Facet f) {
        for (Tiling.Facet facet : this.equivalentFacets(f)) {
            this.doc().showFacetClass(facet);
        }
    }

    private void hideFacetClass(Tiling.Facet f) {
        for (Tiling.Facet facet : this.equivalentFacets(f)) {
            this.doc().hideFacetClass(facet);
        }
    }

    private void _setField(String name, Object value) {
        try {
            Field field = this.getClass().getDeclaredField(name);
            Object old = field.get(this);
            if (value == null ? old != null : !value.equals(old)) {
                this.dispatchEvent(new PropertyChangeEvent(this, name, old, value));
                field.set(this, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color value) {
        this._setField("edgeColor", value);
    }

    public double getEdgeWidth() {
        return this.edgeWidth;
    }

    public void setEdgeWidth(double value) {
        this._setField("edgeWidth", value);
    }

    public double getEdgeOpacity() {
        return this.edgeOpacity;
    }

    public void setEdgeOpacity(double value) {
        this._setField("edgeOpacity", value);
    }

    public boolean getUseEdgeColor() {
        return true;
    }

    public void setUseEdgeColor(boolean value) {
        if (!value) {
            this.setEdgeOpacity(0.0);
        }
    }

    public boolean getDrawEdges() {
        return this.drawEdges;
    }

    public void setDrawEdges(boolean value) {
        this._setField("drawEdges", value);
    }

    public boolean getDrawFaces() {
        return this.drawFaces;
    }

    public void setDrawFaces(boolean value) {
        this._setField("drawFaces", value);
    }

    public double getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(double value) {
        this._setField("tileSize", value);
    }

    public boolean getSmoothFaces() {
        return this.smoothFaces;
    }

    public void setSmoothFaces(boolean value) {
        this._setField("smoothFaces", value);
    }

    public int getSubdivisionLevel() {
        return this.subdivisionLevel;
    }

    public void setSubdivisionLevel(int value) {
        this._setField("subdivisionLevel", value);
    }

    public int getTileRelaxationSteps() {
        return this.tileRelaxationSteps;
    }

    public void setTileRelaxationSteps(int value) {
        this._setField("tileRelaxationSteps", value);
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinX(int value) {
        this._setField("minX", value);
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int value) {
        this._setField("maxX", value);
    }

    public int getMinY() {
        return this.minY;
    }

    public void setMinY(int value) {
        this._setField("minY", value);
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void setMaxY(int value) {
        this._setField("maxY", value);
    }

    public int getMinZ() {
        return this.minZ;
    }

    public void setMinZ(int value) {
        this._setField("minZ", value);
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(int value) {
        this._setField("maxZ", value);
    }

    public boolean getClearOnFill() {
        return this.clearOnFill;
    }

    public void setClearOnFill(boolean value) {
        this._setField("clearOnFill", value);
    }

    public boolean getUsePrimitiveCell() {
        return this.usePrimitiveCell;
    }

    public void setUsePrimitiveCell(boolean value) {
        this._setField("usePrimitiveCell", value);
    }

    public int getEmbedderStepLimit() {
        return this.embedderStepLimit;
    }

    public void setEmbedderStepLimit(int value) {
        this._setField("embedderStepLimit", value);
    }

    public int getEqualEdgePriority() {
        return this.equalEdgePriority;
    }

    public void setEqualEdgePriority(int value) {
        this._setField("equalEdgePriority", value);
    }

    public boolean getIgnoreInputCell() {
        return this.ignoreInputCell;
    }

    public void setIgnoreInputCell(boolean value) {
        this._setField("ignoreInputCell", value);
    }

    public boolean getIgnoreInputCoordinates() {
        return this.ignoreInputCoordinates;
    }

    public void setIgnoreInputCoordinates(boolean value) {
        this._setField("ignoreInputCoordinates", value);
    }

    public boolean getUseMaximalSymmetry() {
        return this.useMaximalSymmetry;
    }

    public void setUseMaximalSymmetry(boolean value) {
        this._setField("useMaximalSymmetry", value);
    }

    public boolean getRelaxCoordinates() {
        return this.relaxCoordinates;
    }

    public void setRelaxCoordinates(boolean value) {
        this._setField("relaxCoordinates", value);
    }

    public double getAmbientCoefficient() {
        return this.ambientCoefficient;
    }

    public void setAmbientCoefficient(double value) {
        this._setField("ambientCoefficient", value);
    }

    public Color getAmbientColor() {
        return this.ambientColor;
    }

    public void setAmbientColor(Color value) {
        this._setField("ambientColor", value);
    }

    public double getDiffuseCoefficient() {
        return this.diffuseCoefficient;
    }

    public void setDiffuseCoefficient(double value) {
        this._setField("diffuseCoefficient", value);
    }

    public double getSpecularCoefficient() {
        return this.specularCoefficient;
    }

    public void setSpecularCoefficient(double value) {
        this._setField("specularCoefficient", value);
    }

    public Color getSpecularColor() {
        return this.specularColor;
    }

    public void setSpecularColor(Color value) {
        this._setField("specularColor", value);
    }

    public double getSpecularExponent() {
        return this.specularExponent;
    }

    public void setSpecularExponent(double value) {
        this._setField("specularExponent", value);
    }

    public double getFaceTransparency() {
        return this.faceTransparency;
    }

    public void setFaceTransparency(double value) {
        this._setField("faceTransparency", 0.0);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color value) {
        this._setField("backgroundColor", value);
    }

    public int getEdgeRoundingLevel() {
        return this.edgeRoundingLevel;
    }

    public void setEdgeRoundingLevel(int value) {
        this._setField("edgeRoundingLevel", value);
    }

    public Color getFogColor() {
        return this.fogColor;
    }

    public void setFogColor(Color value) {
        this._setField("fogColor", value);
    }

    public double getFogDensity() {
        return this.fogDensity;
    }

    public void setFogDensity(double value) {
        this._setField("fogDensity", value);
    }

    public boolean getFogToBackground() {
        return this.fogToBackground;
    }

    public void setFogToBackground(boolean value) {
        this._setField("fogToBackground", value);
    }

    public double getFieldOfView() {
        return this.fieldOfView;
    }

    public void setFieldOfView(double value) {
        this._setField("fieldOfView", Math.max(value, 1.0));
    }

    public boolean getUseFog() {
        return this.useFog;
    }

    public void setUseFog(boolean value) {
        this._setField("useFog", value);
    }

    public Color getLight1Color() {
        return this.light1Color;
    }

    public void setLight1Color(Color value) {
        this._setField("light1Color", value);
    }

    public double getLight1Intensity() {
        return this.light1Intensity;
    }

    public void setLight1Intensity(double value) {
        this._setField("light1Intensity", value);
    }

    public double getLight1AngleX() {
        return this.light1AngleX;
    }

    public void setLight1AngleX(double value) {
        this._setField("light1AngleX", value);
    }

    public double getLight1AngleY() {
        return this.light1AngleY;
    }

    public void setLight1AngleY(double value) {
        this._setField("light1AngleY", value);
    }

    public Color getLight2Color() {
        return this.light2Color;
    }

    public void setLight2Color(Color value) {
        this._setField("light2Color", value);
    }

    public double getLight2Intensity() {
        return this.light2Intensity;
    }

    public void setLight2Intensity(double value) {
        this._setField("light2Intensity", value);
    }

    public double getLight2AngleX() {
        return this.light2AngleX;
    }

    public void setLight2AngleX(double value) {
        this._setField("light2AngleX", value);
    }

    public double getLight2AngleY() {
        return this.light2AngleY;
    }

    public void setLight2AngleY(double value) {
        this._setField("light2AngleY", value);
    }

    public Color getLight3Color() {
        return this.light3Color;
    }

    public void setLight3Color(Color value) {
        this._setField("light3Color", value);
    }

    public double getLight3Intensity() {
        return this.light3Intensity;
    }

    public void setLight3Intensity(double value) {
        this._setField("light3Intensity", value);
    }

    public double getLight3AngleX() {
        return this.light3AngleX;
    }

    public void setLight3AngleX(double value) {
        this._setField("light3AngleX", value);
    }

    public double getLight3AngleY() {
        return this.light3AngleY;
    }

    public void setLight3AngleY(double value) {
        this._setField("light3AngleY", value);
    }

    public boolean getShowUnitCell() {
        return this.showUnitCell;
    }

    public void setShowUnitCell(boolean value) {
        this._setField("showUnitCell", value);
    }

    public Color getUnitCellColor() {
        return this.unitCellColor;
    }

    public void setUnitCellColor(Color value) {
        this._setField("unitCellColor", value);
    }

    public double getUnitCellEdgeWidth() {
        return this.unitCellEdgeWidth;
    }

    public void setUnitCellEdgeWidth(double value) {
        this._setField("unitCellEdgeWidth", value);
    }

    public boolean getShowNet() {
        return this.showNet;
    }

    public void setShowNet(boolean value) {
        this._setField("showNet", value);
    }

    public Color getNetEdgeColor() {
        return this.netEdgeColor;
    }

    public void setNetEdgeColor(Color value) {
        this._setField("netEdgeColor", value);
    }

    public Color getNetNodeColor() {
        return this.netNodeColor;
    }

    public void setNetNodeColor(Color value) {
        this._setField("netNodeColor", value);
    }

    public double getNetEdgeRadius() {
        return this.netEdgeRadius;
    }

    public void setNetEdgeRadius(double value) {
        this._setField("netEdgeRadius", value);
    }

    public double getNetNodeRadius() {
        return this.netNodeRadius;
    }

    public void setNetNodeRadius(double value) {
        this._setField("netNodeRadius", value);
    }

    public class SelectionTool
    extends AbstractTool {
        final InputSlot activationSlot;
        final InputSlot addSlot;
        final InputSlot removeSlot;

        public SelectionTool() {
            super(new InputSlot[0]);
            this.activationSlot = InputSlot.getDevice((String)"PrimarySelection");
            this.addSlot = InputSlot.getDevice((String)"SecondarySelection");
            this.removeSlot = InputSlot.getDevice((String)"Meta");
            this.addCurrentSlot(this.activationSlot);
            this.addCurrentSlot(this.removeSlot);
            this.addCurrentSlot(this.addSlot);
        }

        public void perform(ToolContext tc) {
            if (tc.getAxisState(this.activationSlot).isReleased()) {
                return;
            }
            PickResult pr = tc.getCurrentPick();
            if (pr == null) {
                Viewer v = Main.this.viewerFrame.getViewer();
                if (v instanceof de.jreality.jogl.Viewer) {
                    int n = ((de.jreality.jogl.Viewer)v).getRenderer().getPolygonCount();
                    Main.log("polygon count is " + n);
                }
            } else {
                SceneGraphPath selection = pr.getPickPath();
                Main.this.selectedFace = -1;
                for (SceneGraphNode node : selection) {
                    String name = node.getName();
                    DisplayList.Item item = (DisplayList.Item)Main.this.node2item.get(node);
                    if (item != null) {
                        Main.this.selectedItem = item;
                        continue;
                    }
                    if (!name.startsWith("face:")) continue;
                    Main.this.selectedFace = Integer.parseInt(name.substring(5));
                }
                try {
                    if (tc.getAxisState(this.addSlot).isPressed()) {
                        if (Main.this.selectedItem.isTile()) {
                            Main.this.actionAddTile().actionPerformed(null);
                        } else if (Main.this.selectedItem.isEdge()) {
                            Main.this.actionAddEndNodes().actionPerformed(null);
                        } else if (Main.this.selectedItem.isNode()) {
                            Main.this.actionConnectNode().actionPerformed(null);
                        }
                    } else if (tc.getAxisState(this.removeSlot).isPressed()) {
                        if (Main.this.selectedItem.isTile()) {
                            Main.this.actionRemoveTile().actionPerformed(null);
                        } else if (Main.this.selectedItem.isEdge()) {
                            Main.this.actionRemoveEdge().actionPerformed(null);
                        } else if (Main.this.selectedItem.isNode()) {
                            Main.this.actionRemoveNode().actionPerformed(null);
                        }
                    } else {
                        final Container comp = Main.this.viewerFrame.getContentPane();
                        final java.awt.Point pos = comp.getMousePosition();
                        if (Main.this.selectedItem.isTile()) {
                            Invoke.andWait(new Runnable(){

                                public void run() {
                                    Main.this.selectionPopupForTiles().show(comp, pos.x, pos.y);
                                }
                            });
                        } else if (Main.this.selectedItem.isNode()) {
                            Invoke.andWait(new Runnable(){

                                public void run() {
                                    Main.this.selectionPopupForNodes().show(comp, pos.x, pos.y);
                                }
                            });
                        } else if (Main.this.selectedItem.isEdge()) {
                            Invoke.andWait(new Runnable(){

                                public void run() {
                                    Main.this.selectionPopupForEdges().show(comp, pos.x, pos.y);
                                }
                            });
                        } else {
                            Main.log("Selected: " + Main.this.selectedItem);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

