/*
 * Decompiled with CFR 0.152.
 */
package org.gavrog.apps._3dt;

import buoy.event.EventSource;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gavrog.box.simple.NamedConstant;
import org.gavrog.joss.geometry.Vector;
import org.gavrog.joss.pgraphs.basic.IEdge;
import org.gavrog.joss.pgraphs.basic.INode;
import org.gavrog.joss.pgraphs.basic.PeriodicGraph;
import org.gavrog.joss.tilings.Tiling;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayList
extends EventSource
implements Iterable<Item> {
    public static EventType BEGIN = new EventType("Begin");
    public static EventType END = new EventType("End");
    public static EventType ADD = new EventType("Add");
    public static EventType DELETE = new EventType("Delete");
    public static EventType RECOLOR = new EventType("Recolor");
    private final Map<Item, Color> map = new HashMap<Item, Color>();

    private void dispatchEvent(EventType type, Item inst, Color oldColor, Color newColor) {
        this.dispatchEvent(new Event(type, inst, oldColor, newColor));
    }

    private void dispatchEvent(EventType type, Item inst, Color oldColor) {
        this.dispatchEvent(type, inst, oldColor, null);
    }

    private void dispatchEvent(EventType type, Item inst) {
        this.dispatchEvent(type, inst, null, null);
    }

    private void dispatchEvent(EventType type) {
        this.dispatchEvent(type, null, null, null);
    }

    private Item add(Item inst) {
        if (!this.map.containsKey(inst)) {
            this.map.put(inst, null);
            this.dispatchEvent(ADD, inst);
            return inst;
        }
        return null;
    }

    public Item add(Tiling.Tile tile, Vector shift) {
        return this.add(new Item(tile, shift));
    }

    public Item add(Tiling.Facet facet, Vector shift) {
        return this.add(new Item(facet, shift));
    }

    public Item add(IEdge edge, Vector shift) {
        this.dispatchEvent(BEGIN);
        Item item = this.add(new Item(edge, shift));
        if (item != null) {
            this.addIncident(item);
        }
        this.dispatchEvent(END);
        return item;
    }

    public Item add(INode node, Vector shift) {
        return this.add(new Item(node, shift));
    }

    public boolean remove(Item item) {
        if (this.map.containsKey(item)) {
            Color oldColor = this.color(item);
            this.map.remove(item);
            this.dispatchEvent(DELETE, item, oldColor);
            return true;
        }
        return false;
    }

    public boolean recolor(Item item, Color newColor) {
        if (this.map.containsKey(item)) {
            Color oldColor = this.color(item);
            this.map.put(item, newColor);
            this.dispatchEvent(RECOLOR, item, oldColor, newColor);
            return true;
        }
        return false;
    }

    public boolean recolor(Tiling.Tile tile, Vector shift, Color color) {
        return this.recolor(new Item(tile, shift), color);
    }

    public Item addNeighbor(Item item, int face) {
        Tiling.Tile tile = item.getTile();
        Vector shift = item.getShift();
        Vector newShift = (Vector)shift.plus(tile.neighborShift(face));
        return this.add(tile.neighbor(face), newShift);
    }

    public Item addNeighborFacet(Item item, int face) {
        Tiling.Tile tile = item.getTile();
        Vector shift = item.getShift();
        Vector newShift = (Vector)shift.plus(tile.neighborShift(face));
        return this.add(tile.facet(face).opposite(), newShift);
    }

    public int addIncident(Item item) {
        int count = 0;
        if (item.isEdge()) {
            this.dispatchEvent(BEGIN);
            IEdge edge = item.getEdge();
            Vector shift = item.getShift();
            INode v = edge.source();
            INode w = edge.target();
            Vector s = ((PeriodicGraph)edge.owner()).getShift(edge);
            if (this.add(v, shift) != null) {
                ++count;
            }
            if (this.add(w, (Vector)shift.plus(s)) != null) {
                ++count;
            }
            this.dispatchEvent(END);
        } else if (item.isNode()) {
            this.dispatchEvent(BEGIN);
            INode node = item.getNode();
            Vector shift = item.getShift();
            PeriodicGraph net = (PeriodicGraph)node.owner();
            for (IEdge e : net.allIncidences(node)) {
                if (this.add(e, shift) == null) continue;
                ++count;
            }
            this.dispatchEvent(END);
        }
        return count;
    }

    public int connectToExisting(Item item) {
        int count = 0;
        if (item.isNode()) {
            this.dispatchEvent(BEGIN);
            INode node = item.getNode();
            Vector shift = item.getShift();
            PeriodicGraph net = (PeriodicGraph)node.owner();
            for (IEdge e : net.allIncidences(node)) {
                Vector t;
                Vector s;
                INode w;
                if (e.oriented().source().equals(node)) {
                    w = e.oriented().target();
                    s = shift;
                    t = (Vector)s.plus(net.getShift(e));
                } else {
                    w = e.oriented().source();
                    t = shift;
                    s = (Vector)t.minus(net.getShift(e));
                }
                if (!this.map.containsKey(new Item(w, t)) || this.add(e, s) == null) continue;
                ++count;
            }
            this.dispatchEvent(END);
        }
        return count;
    }

    public boolean remove(List<Item> list) {
        if (list.isEmpty()) {
            return false;
        }
        this.dispatchEvent(BEGIN);
        for (Item i : list) {
            this.remove(i);
        }
        this.dispatchEvent(END);
        return true;
    }

    public boolean removeKind(Item item) {
        int kind = item.getTile().getKind();
        LinkedList<Item> list = new LinkedList<Item>();
        for (Item i : this) {
            if (!i.isTile() || i.getTile().getKind() != kind) continue;
            list.add(i);
        }
        return this.remove(list);
    }

    public boolean removeAll() {
        LinkedList<Item> list = new LinkedList<Item>();
        for (Item i : this) {
            list.add(i);
        }
        return this.remove(list);
    }

    public boolean removeAllTiles() {
        LinkedList<Item> list = new LinkedList<Item>();
        for (Item i : this) {
            if (!i.isTile()) continue;
            list.add(i);
        }
        return this.remove(list);
    }

    public boolean removeAllFacets() {
        LinkedList<Item> list = new LinkedList<Item>();
        for (Item i : this) {
            if (!i.isFacet()) continue;
            list.add(i);
        }
        return this.remove(list);
    }

    public boolean removeAllEdges() {
        LinkedList<Item> list = new LinkedList<Item>();
        for (Item i : this) {
            if (!i.isEdge()) continue;
            list.add(i);
        }
        return this.remove(list);
    }

    public boolean removeAllNodes() {
        LinkedList<Item> list = new LinkedList<Item>();
        for (Item i : this) {
            if (!i.isNode()) continue;
            list.add(i);
        }
        return this.remove(list);
    }

    @Override
    public Iterator<Item> iterator() {
        return this.map.keySet().iterator();
    }

    public int size() {
        return this.map.size();
    }

    public Color color(Item inst) {
        return this.map.get(inst);
    }

    public class Event {
        private final EventType eventType;
        private final Item instance;
        private final Color oldColor;
        private final Color newColor;

        protected Event(EventType type, Item instance, Color oldColor, Color newColor) {
            this.eventType = type;
            this.instance = instance;
            this.oldColor = oldColor;
            this.newColor = newColor;
        }

        public Color getOldColor() {
            return this.oldColor;
        }

        public Color getNewColor() {
            return this.newColor;
        }

        public Item getInstance() {
            return this.instance;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(100);
            buf.append(this.getEventType());
            buf.append(" ");
            buf.append(this.getInstance());
            buf.append(", ");
            buf.append(this.getOldColor());
            buf.append(", ");
            buf.append(this.getNewColor());
            return buf.toString();
        }
    }

    private static class EventType
    extends NamedConstant {
        protected EventType(String name) {
            super(name);
        }
    }

    public class Item {
        private final Template template;
        private final Vector shift;

        private Item(Template t, Vector shift) {
            this.template = t;
            this.shift = shift;
        }

        private Item(Tiling.Tile tile, Vector shift) {
            this.template = new TTile(tile);
            this.shift = shift;
        }

        private Item(Tiling.Facet facet, Vector shift) {
            this.template = new TFacet(facet);
            this.shift = shift;
        }

        private Item(INode node, Vector shift) {
            this.template = new TNode(node);
            this.shift = shift;
        }

        private Item(IEdge edge, Vector shift) {
            this.template = new TEdge(edge);
            this.shift = shift;
        }

        public boolean isTile() {
            return this.template instanceof TTile;
        }

        public boolean isFacet() {
            return this.template instanceof TFacet;
        }

        public boolean isNode() {
            return this.template instanceof TNode;
        }

        public boolean isEdge() {
            return this.template instanceof TEdge;
        }

        public Tiling.Tile getTile() {
            if (this.isTile()) {
                return ((TTile)this.template).getTile();
            }
            throw new RuntimeException("illegal template class " + this.template.getClass().getName());
        }

        public Tiling.Facet getFacet() {
            if (this.isFacet()) {
                return ((TFacet)this.template).getFacet();
            }
            throw new RuntimeException("illegal template class " + this.template.getClass().getName());
        }

        public INode getNode() {
            if (this.isNode()) {
                return ((TNode)this.template).getNode();
            }
            throw new RuntimeException("illegal template class " + this.template.getClass().getName());
        }

        public IEdge getEdge() {
            if (this.isEdge()) {
                return ((TEdge)this.template).getEdge();
            }
            throw new RuntimeException("illegal template class " + this.template.getClass().getName());
        }

        public Vector getShift() {
            return this.shift;
        }

        public int hashCode() {
            if (this.isEdge()) {
                IEdge e = this.getEdge();
                long a = e.source().id();
                long b = e.target().id();
                Vector s = ((PeriodicGraph)e.owner()).getShift(e);
                if (a <= b) {
                    return (((int)a * 37 + (int)b) * 37 + s.hashCode()) * 37 + this.shift.hashCode();
                }
                return (((int)b * 37 + (int)a) * 37 + s.negative().hashCode()) * 37 + this.shift.plus(s).hashCode();
            }
            return this.template.hashCode() * 37 + this.shift.hashCode();
        }

        public boolean equals(Object arg) {
            Item other = (Item)arg;
            if (this.isEdge()) {
                if (!other.isEdge()) {
                    return false;
                }
                IEdge e1 = this.getEdge();
                IEdge e2 = other.getEdge();
                if (!e1.owner().equals(e2.owner())) {
                    return false;
                }
                long a1 = e1.source().id();
                long b1 = e1.target().id();
                Vector s1 = ((PeriodicGraph)e1.owner()).getShift(e1);
                long a2 = e2.source().id();
                long b2 = e2.target().id();
                Vector s2 = ((PeriodicGraph)e2.owner()).getShift(e2);
                return a1 == a2 && b1 == b2 && s1.equals(s2) && this.shift.equals(other.shift) || a1 == b2 && b1 == a2 && s1.equals(s2.negative()) && this.shift.plus(s1).equals(other.shift);
            }
            return other.template.equals(this.template) && other.shift.equals(this.shift);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(40);
            buf.append(this.template.toString());
            buf.append(" + ");
            buf.append(this.getShift());
            return buf.toString();
        }
    }

    private class TEdge
    extends Template {
        private final IEdge edge;

        private TEdge(IEdge edge) {
            this.edge = edge;
        }

        public IEdge getEdge() {
            return this.edge;
        }

        public int hashCode() {
            return this.getEdge().hashCode();
        }

        public boolean equals(Object arg) {
            if (arg instanceof TEdge) {
                return this.getEdge().equals(((TEdge)arg).getEdge());
            }
            return false;
        }

        public String toString() {
            return this.getEdge().toString();
        }
    }

    private class TFacet
    extends Template {
        private final Tiling.Facet facet;

        private TFacet(Tiling.Facet facet) {
            this.facet = facet;
        }

        public Tiling.Facet getFacet() {
            return this.facet;
        }

        public int hashCode() {
            return this.getFacet().hashCode();
        }

        public boolean equals(Object arg) {
            if (arg instanceof TFacet) {
                return this.getFacet().equals(((TFacet)arg).getFacet());
            }
            return false;
        }

        public String toString() {
            return String.format("T%d-F%d", this.getFacet().getTileIndex(), this.getFacet().getIndex());
        }
    }

    private class TNode
    extends Template {
        private final INode node;

        private TNode(INode node) {
            this.node = node;
        }

        public INode getNode() {
            return this.node;
        }

        public int hashCode() {
            return this.getNode().hashCode();
        }

        public boolean equals(Object arg) {
            if (arg instanceof TNode) {
                return this.getNode().equals(((TNode)arg).getNode());
            }
            return false;
        }

        public String toString() {
            return this.getNode().toString();
        }
    }

    private class TTile
    extends Template {
        private final Tiling.Tile tile;

        private TTile(Tiling.Tile tile) {
            this.tile = tile;
        }

        public Tiling.Tile getTile() {
            return this.tile;
        }

        public int hashCode() {
            return this.getTile().hashCode();
        }

        public boolean equals(Object arg) {
            if (arg instanceof TTile) {
                return this.getTile().equals(((TTile)arg).getTile());
            }
            return false;
        }

        public String toString() {
            return "T" + this.getTile().getIndex();
        }
    }

    private abstract class Template {
        private Template() {
        }

        public abstract int hashCode();

        public abstract boolean equals(Object var1);

        public abstract String toString();
    }
}

