/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.BButton;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;

public abstract class WindowWidget
extends WidgetContainer {
    protected Widget content;
    protected Dimension lastSize;
    private Boolean mockVisible;
    private BButton defaultButton;
    private static ThreadLocal encodingInProgress = new ThreadLocal();

    @Override
    public Window getComponent() {
        return (Window)this.component;
    }

    public void setBounds(Rectangle rectangle) {
        if (encodingInProgress.get() != Boolean.TRUE && !this.getComponent().isDisplayable()) {
            this.getComponent().addNotify();
        }
        this.lastSize = new Dimension(rectangle.width, rectangle.height);
        this.getComponent().setBounds(rectangle);
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget widget) {
        if (this.content != null) {
            this.remove(this.content);
        }
        this.content = widget;
        if (this.content != null) {
            if (this.content.getParent() != null) {
                this.content.getParent().remove(this.content);
            }
            JComponent jComponent = (JComponent)((RootPaneContainer)((Object)this.getComponent())).getContentPane();
            jComponent.add(this.content.getComponent());
            this.setAsParent(this.content);
        }
    }

    public void pack() {
        if (!this.getComponent().isDisplayable()) {
            this.getComponent().addNotify();
        }
        JComponent jComponent = (JComponent)((RootPaneContainer)((Object)this.getComponent())).getContentPane();
        if (this.content == null) {
            jComponent.setPreferredSize(new Dimension(0, 0));
        } else {
            jComponent.setPreferredSize(this.content.getPreferredSize());
        }
        Dimension dimension = this.getPreferredSize();
        Rectangle rectangle = this.getBounds();
        this.setBounds(new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height));
    }

    @Override
    public void layoutChildren() {
        if (this.content != null) {
            Container container = ((RootPaneContainer)((Object)this.getComponent())).getContentPane();
            container.validate();
            Dimension dimension = this.content.getMaximumSize();
            Dimension dimension2 = container.getSize();
            this.content.getComponent().setBounds(0, 0, Math.min(dimension.width, dimension2.width), Math.min(dimension.height, dimension2.height));
            if (this.content instanceof WidgetContainer) {
                ((WidgetContainer)this.content).layoutChildren();
            }
        }
    }

    public void dispose() {
        this.getComponent().dispose();
    }

    public void toFront() {
        this.getComponent().toFront();
    }

    public void toBack() {
        this.getComponent().toBack();
    }

    @Override
    public boolean isVisible() {
        if (this.mockVisible != null) {
            return this.mockVisible;
        }
        return this.getComponent().isVisible();
    }

    @Override
    public void setVisible(boolean bl) {
        if (encodingInProgress.get() == Boolean.TRUE) {
            this.mockVisible = bl ? Boolean.TRUE : Boolean.FALSE;
            return;
        }
        super.setVisible(bl);
    }

    public BButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setDefaultButton(BButton bButton) {
        this.defaultButton = bButton;
        this.getRootPane().setDefaultButton(bButton == null ? null : bButton.getComponent());
    }

    protected abstract JRootPane getRootPane();
}

