/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.SingleWidgetPanel;
import buoy.widget.BSeparator;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.IndexedContainerDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BToolBar
extends WidgetContainer {
    private ArrayList<Widget> child;
    public static final Orientation HORIZONTAL = new Orientation(0);
    public static final Orientation VERTICAL = new Orientation(1);

    static {
        WidgetEncoder.setPersistenceDelegate(BToolBar.class, new IndexedContainerDelegate(new String[]{"getChild"}));
        WidgetEncoder.setPersistenceDelegate(Orientation.class, new StaticFieldDelegate(BToolBar.class));
    }

    public BToolBar() {
        this(HORIZONTAL);
    }

    public BToolBar(Orientation orientation) {
        this.component = this.createComponent();
        this.child = new ArrayList();
        this.setOrientation(orientation);
    }

    protected JToolBar createComponent() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        return toolbar;
    }

    @Override
    public JToolBar getComponent() {
        return (JToolBar)this.component;
    }

    public Orientation getOrientation() {
        int orientation = this.getComponent().getOrientation();
        return orientation == 0 ? HORIZONTAL : VERTICAL;
    }

    public void setOrientation(Orientation orientation) {
        this.getComponent().setOrientation(orientation.value);
    }

    public void add(Widget widget) {
        this.add(widget, this.getChildCount());
    }

    public void add(Widget widget, int index) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(index, widget);
        this.getComponent().add((Component)new SingleWidgetPanel(widget), index);
        this.setAsParent(widget);
    }

    public void addSeparator() {
        this.add(new BSeparator(this.getOrientation() == HORIZONTAL ? BSeparator.VERTICAL : BSeparator.HORIZONTAL));
    }

    @Override
    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return this.child.get(i);
    }

    @Override
    public Collection<Widget> getChildren() {
        return new ArrayList<Widget>(this.child);
    }

    @Override
    public void remove(Widget widget) {
        this.child.remove(widget);
        this.getComponent().remove(widget.getComponent().getParent());
        this.removeAsParent(widget);
    }

    @Override
    public void removeAll() {
        int i = 0;
        while (i < this.child.size()) {
            this.removeAsParent(this.child.get(i));
            ++i;
        }
        this.getComponent().removeAll();
        this.child.clear();
    }

    public int getChildIndex(Widget widget) {
        return this.child.indexOf(widget);
    }

    @Override
    public void layoutChildren() {
        this.getComponent().validate();
        int i = 0;
        while (i < this.child.size()) {
            Widget w = this.child.get(i);
            if (w instanceof WidgetContainer) {
                ((WidgetContainer)w).layoutChildren();
            }
            ++i;
        }
    }

    public static class Orientation {
        private int value;

        private Orientation(int value) {
            this.value = value;
        }
    }
}

