/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.ValueChangedEvent;
import buoy.internal.SingleWidgetPanel;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BSplitPaneDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BSplitPane
extends WidgetContainer {
    private Widget[] child;
    private int suppressEvents;
    public static final Orientation HORIZONTAL = new Orientation(1);
    public static final Orientation VERTICAL = new Orientation(0);

    static {
        WidgetEncoder.setPersistenceDelegate(BSplitPane.class, new BSplitPaneDelegate());
        WidgetEncoder.setPersistenceDelegate(Orientation.class, new StaticFieldDelegate(BSplitPane.class));
    }

    public BSplitPane() {
        this(HORIZONTAL, null, null);
    }

    public BSplitPane(Orientation orient) {
        this(orient, null, null);
    }

    public BSplitPane(Orientation orient, Widget child1, Widget child2) {
        this.component = this.createComponent();
        this.getComponent().addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent ev) {
                BSplitPane.this.layoutChildren();
                if (BSplitPane.this.suppressEvents == 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BSplitPane.this.dispatchEvent(new ValueChangedEvent(BSplitPane.this));
                        }
                    });
                }
            }
        });
        this.child = new Widget[2];
        if (child1 != null) {
            this.add(child1, 0);
        }
        if (child2 != null) {
            this.add(child2, 1);
        }
        this.setOrientation(orient);
    }

    protected JSplitPane createComponent() {
        return new JSplitPane(1, false);
    }

    @Override
    public JSplitPane getComponent() {
        return (JSplitPane)this.component;
    }

    public int getDividerLocation() {
        return this.getComponent().getDividerLocation();
    }

    public void setDividerLocation(int location) {
        try {
            ++this.suppressEvents;
            this.getComponent().setDividerLocation(location);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public void setDividerLocation(double location) {
        try {
            ++this.suppressEvents;
            this.getComponent().setDividerLocation(location);
        }
        finally {
            --this.suppressEvents;
        }
    }

    public void resetToPreferredSizes() {
        try {
            ++this.suppressEvents;
            this.getComponent().resetToPreferredSizes();
        }
        finally {
            --this.suppressEvents;
        }
    }

    public Orientation getOrientation() {
        return this.getComponent().getOrientation() == 1 ? HORIZONTAL : VERTICAL;
    }

    public void setOrientation(Orientation orient) {
        this.getComponent().setOrientation(orient.value);
    }

    public boolean isContinuousLayout() {
        return this.getComponent().isContinuousLayout();
    }

    public void setContinuousLayout(boolean continuous) {
        this.getComponent().setContinuousLayout(continuous);
    }

    public boolean isOneTouchExpandable() {
        return this.getComponent().isOneTouchExpandable();
    }

    public void setOneTouchExpandable(boolean expandable) {
        this.getComponent().setOneTouchExpandable(expandable);
    }

    public double getResizeWeight() {
        return this.getComponent().getResizeWeight();
    }

    public void setResizeWeight(double weight) {
        this.getComponent().setResizeWeight(weight);
    }

    @Override
    public int getChildCount() {
        int count = 0;
        int i = 0;
        while (i < this.child.length) {
            if (this.child[i] != null) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> ls = new ArrayList<Widget>(2);
        int i = 0;
        while (i < this.child.length) {
            if (this.child[i] != null) {
                ls.add(this.child[i]);
            }
            ++i;
        }
        return ls;
    }

    public Widget getChild(int index) {
        return this.child[index];
    }

    @Override
    public void layoutChildren() {
        this.getComponent().validate();
        int i = 0;
        while (i < this.child.length) {
            if (this.child[i] instanceof WidgetContainer) {
                ((WidgetContainer)this.child[i]).layoutChildren();
            }
            ++i;
        }
    }

    public void add(Widget widget, int index) {
        if (this.child[index] != null) {
            this.remove(index);
        }
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child[index] = widget;
        if (index == 0) {
            this.getComponent().setLeftComponent(new SingleWidgetPanel(widget));
        } else {
            this.getComponent().setRightComponent(new SingleWidgetPanel(widget));
        }
        this.setAsParent(widget);
        this.invalidateSize();
    }

    @Override
    public void remove(Widget widget) {
        int i = 0;
        while (i < this.child.length) {
            if (this.child[i] == widget) {
                this.remove(i);
                return;
            }
            ++i;
        }
    }

    public void remove(int index) {
        if (this.child[index] == null) {
            return;
        }
        this.getComponent().remove(this.child[index].getComponent().getParent());
        this.removeAsParent(this.child[index]);
        this.child[index] = null;
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        this.getComponent().removeAll();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim0 = this.child[0] == null ? new Dimension() : this.child[0].getMinimumSize();
        Dimension dim1 = this.child[1] == null ? new Dimension() : this.child[1].getMinimumSize();
        int dividerWidth = this.getComponent().getDividerSize();
        if (this.getOrientation() == HORIZONTAL) {
            return new Dimension(dim0.width + dim1.width + dividerWidth, Math.max(dim0.height, dim1.height));
        }
        return new Dimension(Math.max(dim0.width, dim1.width), dim0.height + dim1.height + dividerWidth);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim0 = this.child[0] == null ? new Dimension() : this.child[0].getPreferredSize();
        Dimension dim1 = this.child[1] == null ? new Dimension() : this.child[1].getPreferredSize();
        int dividerWidth = this.getComponent().getDividerSize();
        if (this.getOrientation() == HORIZONTAL) {
            return new Dimension(dim0.width + dim1.width + dividerWidth, Math.max(dim0.height, dim1.height));
        }
        return new Dimension(Math.max(dim0.width, dim1.width), dim0.height + dim1.height + dividerWidth);
    }

    public static class Orientation {
        protected int value;

        private Orientation(int value) {
            this.value = value;
        }
    }
}

