/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.RepaintEvent;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BScrollBar;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BScrollPane
extends WidgetContainer {
    private ContentViewport contentPort;
    private JViewport rowHeaderPort;
    private JViewport colHeaderPort;
    private Widget content;
    private Widget rowHeader;
    private Widget colHeader;
    private BScrollBar hscroll;
    private BScrollBar vscroll;
    private ScrollbarPolicy hPolicy;
    private ScrollbarPolicy vPolicy;
    private Dimension preferredViewSize;
    private Dimension prefSize;
    private Dimension minSize;
    private boolean forceWidth;
    private boolean forceHeight;
    public static final ScrollbarPolicy SCROLLBAR_NEVER = new ScrollbarPolicy();
    public static final ScrollbarPolicy SCROLLBAR_AS_NEEDED = new ScrollbarPolicy();
    public static final ScrollbarPolicy SCROLLBAR_ALWAYS = new ScrollbarPolicy();
    private static final boolean IS_MACINTOSH;

    public BScrollPane() {
        this(SCROLLBAR_AS_NEEDED, SCROLLBAR_AS_NEEDED);
    }

    public BScrollPane(Widget widget) {
        this(SCROLLBAR_AS_NEEDED, SCROLLBAR_AS_NEEDED);
        this.setContent(widget);
    }

    public BScrollPane(ScrollbarPolicy scrollbarPolicy, ScrollbarPolicy scrollbarPolicy2) {
        JScrollPane jScrollPane = this.createComponent();
        this.component = jScrollPane;
        this.hPolicy = scrollbarPolicy;
        this.vPolicy = scrollbarPolicy2;
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Point point = BScrollPane.this.contentPort.getViewPosition();
                if (BScrollPane.this.hPolicy != SCROLLBAR_NEVER) {
                    point.x = BScrollPane.this.hscroll.getValue();
                }
                if (BScrollPane.this.vPolicy != SCROLLBAR_NEVER) {
                    point.y = BScrollPane.this.vscroll.getValue();
                }
                BScrollPane.this.contentPort.setViewPositionInternal(point);
                BScrollPane.this.rowHeaderPort.setViewPosition(new Point(0, point.y));
                BScrollPane.this.colHeaderPort.setViewPosition(new Point(point.x, 0));
            }
        };
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                int n;
                BScrollBar bScrollBar = null;
                if (mouseWheelEvent.getSource() == BScrollPane.this.vscroll.getComponent()) {
                    bScrollBar = BScrollPane.this.vscroll;
                } else if (mouseWheelEvent.getSource() == BScrollPane.this.hscroll.getComponent()) {
                    bScrollBar = BScrollPane.this.hscroll;
                } else if (BScrollPane.this.vscroll.isVisible() && BScrollPane.this.vscroll.isEnabled() && BScrollPane.this.vscroll.getExtent() < BScrollPane.this.vscroll.getMaximum()) {
                    bScrollBar = BScrollPane.this.vscroll;
                } else if (BScrollPane.this.hscroll.isVisible() && BScrollPane.this.hscroll.isEnabled() && BScrollPane.this.hscroll.getExtent() < BScrollPane.this.hscroll.getMaximum()) {
                    bScrollBar = BScrollPane.this.hscroll;
                } else {
                    return;
                }
                int n2 = n = mouseWheelEvent.getWheelRotation() > 0 ? 1 : -1;
                if (mouseWheelEvent.getScrollType() == 1) {
                    bScrollBar.setValue(bScrollBar.getValue() + bScrollBar.getBlockIncrement(n) * mouseWheelEvent.getWheelRotation());
                } else {
                    bScrollBar.setValue(bScrollBar.getValue() + bScrollBar.getUnitIncrement(n) * mouseWheelEvent.getScrollAmount() * n);
                }
            }
        };
        this.vscroll = new ScrollPaneScrollBar(0, 1, 0, 100, BScrollBar.VERTICAL);
        jScrollPane.add(this.vscroll.getComponent());
        this.setAsParent(this.vscroll);
        this.vscroll.getComponent().getModel().addChangeListener(changeListener);
        this.vscroll.getComponent().addMouseWheelListener(mouseWheelListener);
        this.hscroll = new ScrollPaneScrollBar(0, 1, 0, 100, BScrollBar.HORIZONTAL);
        jScrollPane.add(this.hscroll.getComponent());
        this.setAsParent(this.hscroll);
        this.hscroll.getComponent().getModel().addChangeListener(changeListener);
        this.hscroll.getComponent().addMouseWheelListener(mouseWheelListener);
        this.contentPort = new ContentViewport();
        jScrollPane.setViewport(this.contentPort);
        this.rowHeaderPort = new JViewport();
        jScrollPane.setRowHeader(this.rowHeaderPort);
        this.colHeaderPort = new JViewport();
        jScrollPane.setColumnHeader(this.colHeaderPort);
        this.rowHeaderPort.setLayout(null);
        this.colHeaderPort.setLayout(null);
        this.rowHeaderPort.setOpaque(false);
        this.colHeaderPort.setOpaque(false);
        this.forceWidth = this.hPolicy == SCROLLBAR_NEVER;
        this.forceHeight = this.vPolicy == SCROLLBAR_NEVER;
        this.contentPort.addMouseWheelListener(mouseWheelListener);
    }

    public BScrollPane(Widget widget, ScrollbarPolicy scrollbarPolicy, ScrollbarPolicy scrollbarPolicy2) {
        this(scrollbarPolicy, scrollbarPolicy2);
        this.setContent(widget);
    }

    protected JScrollPane createComponent() {
        return new ScrollPaneComponent();
    }

    @Override
    public JScrollPane getComponent() {
        return (JScrollPane)this.component;
    }

    public Widget getContent() {
        return this.content;
    }

    public void setContent(Widget widget) {
        if (this.content != null) {
            this.removeAsParent(this.content);
        }
        this.content = widget;
        if (this.content == null) {
            this.contentPort.setView(null);
        } else {
            this.setAsParent(this.content);
            this.contentPort.setView(this.content.getComponent());
        }
        this.invalidateSize();
    }

    public Widget getRowHeader() {
        return this.rowHeader;
    }

    public void setRowHeader(Widget widget) {
        if (this.rowHeader != null) {
            this.removeAsParent(this.rowHeader);
        }
        this.rowHeader = widget;
        if (this.rowHeader != null) {
            this.setAsParent(this.rowHeader);
        }
        this.rowHeaderPort.setView(this.rowHeader == null ? null : this.rowHeader.getComponent());
        this.invalidateSize();
    }

    public Widget getColHeader() {
        return this.colHeader;
    }

    public void setColHeader(Widget widget) {
        if (this.colHeader != null) {
            this.removeAsParent(this.colHeader);
        }
        this.colHeader = widget;
        if (this.colHeader != null) {
            this.setAsParent(this.colHeader);
        }
        this.colHeaderPort.setView(this.colHeader == null ? null : this.colHeader.getComponent());
        this.invalidateSize();
    }

    public BScrollBar getHorizontalScrollBar() {
        return this.hscroll;
    }

    public BScrollBar getVerticalScrollBar() {
        return this.vscroll;
    }

    public ScrollbarPolicy getHorizontalScrollbarPolicy() {
        return this.hPolicy;
    }

    public void setHorizontalScrollbarPolicy(ScrollbarPolicy scrollbarPolicy) {
        this.hPolicy = scrollbarPolicy;
        this.invalidateSize();
        this.layoutChildren();
    }

    public ScrollbarPolicy getVerticalScrollbarPolicy() {
        return this.vPolicy;
    }

    public void setVerticalScrollbarPolicy(ScrollbarPolicy scrollbarPolicy) {
        this.vPolicy = scrollbarPolicy;
        this.invalidateSize();
        this.layoutChildren();
    }

    public Dimension getPreferredViewSize() {
        return this.preferredViewSize;
    }

    public void setPreferredViewSize(Dimension dimension) {
        this.preferredViewSize = dimension;
        this.invalidateSize();
    }

    public Dimension getViewSize() {
        return this.contentPort.getSize();
    }

    public boolean getForceWidth() {
        return this.forceWidth;
    }

    public void setForceWidth(boolean bl) {
        this.forceWidth = bl;
    }

    public boolean getForceHeight() {
        return this.forceHeight;
    }

    public void setForceHeight(boolean bl) {
        this.forceHeight = bl;
    }

    @Override
    public int getChildCount() {
        int n = 2;
        if (this.content != null) {
            ++n;
        }
        if (this.rowHeader != null) {
            ++n;
        }
        if (this.colHeader != null) {
            ++n;
        }
        return n;
    }

    @Override
    public Collection<Widget> getChildren() {
        ArrayList<Widget> arrayList = new ArrayList<Widget>(5);
        if (this.content != null) {
            arrayList.add(this.content);
        }
        if (this.rowHeader != null) {
            arrayList.add(this.rowHeader);
        }
        if (this.colHeader != null) {
            arrayList.add(this.colHeader);
        }
        arrayList.add(this.hscroll);
        arrayList.add(this.vscroll);
        return arrayList;
    }

    @Override
    public void remove(Widget widget) {
        if (this.content == widget) {
            this.setContent(null);
        }
        if (this.rowHeader == widget) {
            this.setRowHeader(null);
        }
        if (this.colHeader == widget) {
            this.setColHeader(null);
        }
        this.invalidateSize();
    }

    @Override
    public void removeAll() {
        this.setContent(null);
        this.setRowHeader(null);
        this.setColHeader(null);
    }

    @Override
    public void layoutChildren() {
        Dimension dimension;
        boolean bl;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension2 = this.colHeader == null ? null : this.colHeader.getPreferredSize();
        Dimension dimension3 = this.rowHeader == null ? null : this.rowHeader.getPreferredSize();
        Dimension dimension4 = this.hscroll.getPreferredSize();
        Dimension dimension5 = this.vscroll.getPreferredSize();
        Dimension dimension6 = this.content == null ? new Dimension() : this.content.getPreferredSize();
        Rectangle rectangle = this.getBounds();
        if (dimension2 != null) {
            n = dimension2.height;
        }
        if (dimension3 != null) {
            n2 = dimension3.width;
        }
        boolean bl2 = this.hPolicy == SCROLLBAR_ALWAYS || this.hPolicy == SCROLLBAR_AS_NEEDED && rectangle.width - n2 - dimension5.width < dimension6.width;
        boolean bl3 = bl = this.vPolicy == SCROLLBAR_ALWAYS || this.vPolicy == SCROLLBAR_AS_NEEDED && rectangle.height - n - dimension4.height < dimension6.height;
        if (bl2) {
            n3 = dimension4.height;
        }
        if (bl) {
            n4 = dimension5.width;
        }
        if (this.hPolicy == SCROLLBAR_AS_NEEDED && this.vPolicy == SCROLLBAR_AS_NEEDED && rectangle.width - n2 >= dimension6.width && rectangle.height - n >= dimension6.height) {
            bl2 = false;
            bl = false;
            n3 = 0;
            n4 = 0;
        }
        Rectangle rectangle2 = new Rectangle(n2, n, rectangle.width - n2 - n4, rectangle.height - n - n3);
        Dimension dimension7 = new Dimension(rectangle2.width, rectangle2.height);
        if (this.content != null) {
            dimension = this.content.getMinimumSize();
            Dimension dimension8 = this.content.getMaximumSize();
            dimension7.width = Math.max(dimension.width, Math.min(dimension8.width, dimension7.width));
            dimension7.height = Math.max(dimension.height, Math.min(dimension8.height, dimension7.height));
        }
        this.colHeaderPort.setBounds(new Rectangle(n2, 0, rectangle2.width, n));
        if (this.colHeader != null) {
            dimension = new Dimension(dimension2);
            if (this.forceWidth) {
                dimension.width = dimension7.width;
            }
            this.colHeader.getComponent().setSize(dimension);
        }
        this.rowHeaderPort.setBounds(new Rectangle(0, n, n2, rectangle2.height));
        if (this.rowHeader != null) {
            dimension = new Dimension(dimension3);
            if (this.forceHeight) {
                dimension.height = dimension7.height;
            }
            this.rowHeader.getComponent().setSize(dimension);
        }
        this.contentPort.setBounds(rectangle2);
        if (this.content != null) {
            dimension = new Dimension(dimension6);
            if (this.forceWidth) {
                dimension.width = dimension7.width;
            }
            if (this.forceHeight) {
                dimension.height = dimension7.height;
            }
            this.content.getComponent().setSize(dimension);
        }
        int n5 = rectangle2.width;
        int n6 = rectangle2.height;
        if (IS_MACINTOSH && bl2 != bl) {
            WidgetContainer widgetContainer;
            for (widgetContainer = this.getParent(); widgetContainer != null && !(widgetContainer instanceof WindowWidget); widgetContainer = widgetContainer.getParent()) {
            }
            if (widgetContainer instanceof BFrame && ((BFrame)widgetContainer).isResizable() || widgetContainer instanceof BDialog && ((BDialog)widgetContainer).isResizable()) {
                Rectangle rectangle3 = widgetContainer.getBounds();
                Point point = SwingUtilities.convertPoint(this.getComponent(), 0, 0, widgetContainer.getComponent());
                if (rectangle.x + rectangle.width + point.x == rectangle3.width && rectangle.y + rectangle.height + point.y == rectangle3.height) {
                    if (!bl2) {
                        n6 -= dimension4.height;
                    }
                    if (!bl) {
                        n5 -= dimension5.width;
                    }
                }
            }
        }
        this.hscroll.getComponent().setBounds(new Rectangle(n2, rectangle2.y + rectangle2.height, n5, n3));
        if (this.content == null) {
            this.hscroll.setEnabled(false);
        } else {
            this.hscroll.setEnabled(true);
            int n7 = this.content.getComponent().getWidth();
            this.hscroll.setMaximum(n7);
            if (this.hscroll.getValue() + rectangle2.width > n7) {
                this.hscroll.setValue(n7 - rectangle2.width);
            }
        }
        this.hscroll.setExtent(rectangle2.width);
        this.vscroll.getComponent().setBounds(new Rectangle(rectangle2.x + rectangle2.width, n, n4, n6));
        if (this.content == null) {
            this.vscroll.setEnabled(false);
        } else {
            this.vscroll.setEnabled(true);
            int n8 = this.content.getComponent().getHeight();
            this.vscroll.setMaximum(n8);
            if (this.vscroll.getValue() + rectangle2.height > n8) {
                this.vscroll.setValue(n8 - rectangle2.height);
            }
        }
        this.vscroll.setExtent(rectangle2.height);
        if (this.content instanceof WidgetContainer) {
            ((WidgetContainer)this.content).layoutChildren();
        }
        if (this.colHeader instanceof WidgetContainer) {
            ((WidgetContainer)this.colHeader).layoutChildren();
        }
        if (this.rowHeader instanceof WidgetContainer) {
            ((WidgetContainer)this.rowHeader).layoutChildren();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            Dimension dimension;
            Dimension dimension2;
            this.minSize = new Dimension();
            if (this.colHeader != null) {
                this.minSize.height += this.colHeader.getMinimumSize().height;
            }
            if (this.rowHeader != null) {
                this.minSize.width += this.rowHeader.getMinimumSize().width;
            }
            Dimension dimension3 = dimension2 = this.content == null ? new Dimension() : this.content.getMinimumSize();
            if (this.hPolicy == SCROLLBAR_ALWAYS || this.hPolicy == SCROLLBAR_AS_NEEDED && dimension2.width > 0) {
                dimension = this.hscroll.getMinimumSize();
                this.minSize.width += dimension.width;
                this.minSize.height += dimension.height;
            }
            if (this.vPolicy == SCROLLBAR_ALWAYS || this.vPolicy == SCROLLBAR_AS_NEEDED && dimension2.height > 0) {
                dimension = this.vscroll.getMinimumSize();
                this.minSize.height += dimension.height;
                this.minSize.width += dimension.width;
            }
        }
        return new Dimension(this.minSize);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension dimension;
            Dimension dimension2;
            Dimension dimension3 = dimension2 = this.content == null ? new Dimension() : this.content.getPreferredSize();
            if (this.content != null && this.content.getComponent() instanceof Scrollable) {
                dimension = ((Scrollable)((Object)this.content.getComponent())).getPreferredScrollableViewportSize();
                dimension2 = new Dimension(Math.min(dimension2.width, dimension.width), Math.min(dimension2.height, dimension.height));
            }
            this.prefSize = this.preferredViewSize != null ? new Dimension(this.preferredViewSize) : new Dimension(dimension2);
            if (this.colHeader != null) {
                dimension = this.colHeader.getPreferredSize();
                if (dimension.width > this.prefSize.width) {
                    this.prefSize.width = dimension.width;
                }
                this.prefSize.height += dimension.height;
            }
            if (this.rowHeader != null) {
                dimension = this.rowHeader.getPreferredSize();
                if (dimension.height > this.prefSize.height) {
                    this.prefSize.height = dimension.height;
                }
                this.prefSize.width += dimension.width;
            }
            if (this.hPolicy == SCROLLBAR_ALWAYS || this.hPolicy == SCROLLBAR_AS_NEEDED && this.prefSize.width < dimension2.width) {
                dimension = this.hscroll.getPreferredSize();
                if (dimension.width > this.prefSize.width) {
                    this.prefSize.width = dimension.width;
                }
                this.prefSize.height += dimension.height;
            }
            if (this.vPolicy == SCROLLBAR_ALWAYS || this.vPolicy == SCROLLBAR_AS_NEEDED && this.prefSize.height < dimension2.height) {
                dimension = this.vscroll.getPreferredSize();
                if (dimension.height > this.prefSize.height) {
                    this.prefSize.height = dimension.height;
                }
                this.prefSize.width += dimension.width;
            }
        }
        return new Dimension(this.prefSize);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.contentPort.setBackground(color);
        this.rowHeaderPort.setBackground(color);
        this.colHeaderPort.setBackground(color);
    }

    @Override
    protected void invalidateSize() {
        this.minSize = null;
        this.prefSize = null;
        super.invalidateSize();
    }

    static {
        WidgetEncoder.setPersistenceDelegate(ScrollbarPolicy.class, new StaticFieldDelegate(BScrollPane.class));
        String string = System.getProperty("os.name", "").toLowerCase();
        IS_MACINTOSH = string.startsWith("mac os x");
    }

    public static class ScrollbarPolicy {
        private ScrollbarPolicy() {
        }
    }

    private class ContentViewport
    extends JViewport {
        @Override
        public void setViewPosition(Point point) {
            BScrollPane.this.hscroll.setValue(point.x);
            BScrollPane.this.vscroll.setValue(point.y);
        }

        public void setViewPositionInternal(Point point) {
            super.setViewPosition(point);
        }

        @Override
        public void doLayout() {
            BScrollPane.this.layoutChildren();
        }
    }

    private class ScrollPaneScrollBar
    extends BScrollBar {
        public ScrollPaneScrollBar(int n, int n2, int n3, int n4, BScrollBar.Orientation orientation) {
            super(n, n2, n3, n4, orientation);
        }

        @Override
        public int getUnitIncrement(int n) {
            if (BScrollPane.this.content != null && BScrollPane.this.content.getComponent() instanceof Scrollable) {
                return ((Scrollable)((Object)BScrollPane.this.content.getComponent())).getScrollableUnitIncrement(BScrollPane.this.contentPort.getViewRect(), this.getOrientation().value, n);
            }
            return super.getUnitIncrement(n);
        }

        @Override
        public int getBlockIncrement(int n) {
            if (BScrollPane.this.content != null && BScrollPane.this.content.getComponent() instanceof Scrollable) {
                return ((Scrollable)((Object)BScrollPane.this.content.getComponent())).getScrollableBlockIncrement(BScrollPane.this.contentPort.getViewRect(), this.getOrientation().value, n);
            }
            return super.getBlockIncrement(n);
        }
    }

    private class ScrollPaneComponent
    extends JScrollPane {
        private ScrollPaneComponent() {
            this.setLayout(null);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            if (BScrollPane.this.isOpaque()) {
                Dimension dimension = this.getSize();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                graphics.setColor(this.getForeground());
            }
            BScrollPane.this.dispatchEvent(new RepaintEvent(BScrollPane.this, (Graphics2D)graphics));
        }

        @Override
        public boolean isOpaque() {
            return BScrollPane.this.isOpaque();
        }
    }
}

