/*
 * Decompiled with CFR 0.152.
 */
package buoy.internal;

import buoy.event.MouseExitedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.ToolTipEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BToolTip;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ToolTipMonitor {
    private static WidgetMouseEvent lastMoveEvent;
    private static Timer timer;
    private static final int SHOW_DELAY = 1500;
    private static final int UPDATE_DELAY = 250;

    public static void processMouseEvent(WidgetMouseEvent widgetMouseEvent) {
        if (widgetMouseEvent instanceof MouseExitedEvent || widgetMouseEvent instanceof MousePressedEvent) {
            lastMoveEvent = null;
            timer.setInitialDelay(250);
            timer.restart();
        } else if (widgetMouseEvent instanceof MouseMovedEvent) {
            lastMoveEvent = (MouseMovedEvent)widgetMouseEvent;
            timer.setInitialDelay(BToolTip.getShowingToolTip() == null ? 1500 : 250);
            timer.restart();
        }
    }

    static {
        timer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (lastMoveEvent == null) {
                            BToolTip.hide();
                            return;
                        }
                        Widget widget = lastMoveEvent.getWidget();
                        if (!widget.getComponent().isDisplayable()) {
                            return;
                        }
                        Point point = lastMoveEvent.getPoint();
                        Point point2 = new Point(point.x, point.y + 15);
                        widget.dispatchEvent(new ToolTipEvent(widget, lastMoveEvent.getWhen(), lastMoveEvent.getPoint(), point2));
                    }
                });
            }
        });
        timer.setRepeats(false);
        timer.stop();
    }
}

