# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_cons.ipynb.

# %% auto 0
__all__ = ['ASPEC', 'DSPEC', 'MSPEC', 'SKIND', 'DKIND', 'MKIND', 'ATTRSPECS', 'Spec']

# %% ../nbs/00_cons.ipynb 4
from enum import StrEnum, auto
from typing import Tuple
# from pstr.nlit import (INPLACE, __COPYING__, __PASSSELF__, __READONLY__, __ATTRSPECS__, __SLOTS__)
from pstr.nlit import (SPEC, SPECS, INPLACE, __COPYING__, __PASSSELF__, __READONLY__, __ATTRSPECS__,)

# %% ../nbs/00_cons.ipynb 6
# SPEC: str = 'spec'
ASPEC: str = 'aspec'
DSPEC: str = 'dspec'
MSPEC: str = 'mspec'

# SPECS: str = 'specs'

SKIND: set = {'static',  'attr',  ASPEC, 's',  'a'}
DKIND: set = {'dynamic', 'dattr', DSPEC, 'dyn', 'd', }

MKIND = {'mutable', 'mattr', MSPEC, 'mut', 'm', }

ATTRSPECS: set = {ASPEC, DSPEC }

__DKIND__     = '__dkind__'
__SKIND__     = '__skind__'

# __SLOTS__     = '__slots__'
# __COPYING__   = '__copying__'
# __READONLY__  = '__readonly__'
# __PASSSELF__  = '__passself__'
# __ATTRSPECS__ = '__attrspecs__'

# %% ../nbs/00_cons.ipynb 8
class Spec(StrEnum):
    '''
    Enumeration class that contains attribute specification keys.

    Attributes
    ----------
    aspec : str
        Key for attribute specification.
        
    dspec : str
        Key for dynamic attribute specification.
    '''    
    aspec = auto()
    dspec = auto()

    @classmethod
    def specs(cls) -> Tuple[str]:
        '''Returns a tuple of all the values.'''
        return tuple(list(map(lambda e: e.value, cls)))

Spec.specs()
