# Docker volumes

Don't use the constructor directly. Instead use 
```python
from pydock import docker

my_docker_volume = docker.volume.inspect("my-volume")

# or

my_docker_image = docker.volume.create()
```
For type hints, use this

```python
from pydock import docker, Volume

def print_file(my_volume: Volume):
    print(
        docker.run(
            "ubuntu", 
            ["cat", "/some_volume/some_file"],
            volumes=[(my_volume, "/some_volume/some_file")]
        )
    )
```


## Attributes

It attributes are the same that you get with the command line:
`docker volume inspect ...`

To get a complete description of those attributes, you 
can take a look at 
the [daemon api reference page](https://docs.docker.com/engine/api/v1.40/#operation/VolumeInspect) 
and click on "200 No error".

An example is worth many lines of descriptions.

```
In [1]: from pydock import docker

In [2]: volume = docker.volume.create()

In [3]: def super_print(obj):
   ...:     print(f"type={type(obj)}, value={obj}")
   ...:

@INSERT_GENERATED_CODE@
```

## Methods

{{autogenerated}}
