import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type FreyrAIM::Spider::LoadBalancer::MODULE
 *
 * @schema CfnLoadBalancerModuleProps
 */
export interface CfnLoadBalancerModuleProps {
    /**
     * @schema CfnLoadBalancerModuleProps#Parameters
     */
    readonly parameters?: CfnLoadBalancerModulePropsParameters;
    /**
     * @schema CfnLoadBalancerModuleProps#Resources
     */
    readonly resources?: CfnLoadBalancerModulePropsResources;
}
/**
 * Converts an object of type 'CfnLoadBalancerModuleProps' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModuleProps(obj: CfnLoadBalancerModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsParameters
 */
export interface CfnLoadBalancerModulePropsParameters {
    /**
     * The ELB logs bucket name
     *
     * @schema CfnLoadBalancerModulePropsParameters#ELBBucketName
     */
    readonly elbBucketName?: CfnLoadBalancerModulePropsParametersElbBucketName;
    /**
     * The environment name
     *
     * @schema CfnLoadBalancerModulePropsParameters#EnvName
     */
    readonly envName?: CfnLoadBalancerModulePropsParametersEnvName;
    /**
     * The ImageDigest
     *
     * @schema CfnLoadBalancerModulePropsParameters#ImageDigest
     */
    readonly imageDigest?: CfnLoadBalancerModulePropsParametersImageDigest;
    /**
     * The RunTime
     *
     * @schema CfnLoadBalancerModulePropsParameters#RunTime
     */
    readonly runTime?: CfnLoadBalancerModulePropsParametersRunTime;
    /**
     * Vpc-ID
     *
     * @schema CfnLoadBalancerModulePropsParameters#VpcID
     */
    readonly vpcId?: CfnLoadBalancerModulePropsParametersVpcId;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsParameters' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsParameters(obj: CfnLoadBalancerModulePropsParameters | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResources
 */
export interface CfnLoadBalancerModulePropsResources {
    /**
     * @schema CfnLoadBalancerModulePropsResources#SpiderEC2Instance
     */
    readonly spiderEc2Instance?: CfnLoadBalancerModulePropsResourcesSpiderEc2Instance;
    /**
     * @schema CfnLoadBalancerModulePropsResources#TargetGroup1
     */
    readonly targetGroup1?: CfnLoadBalancerModulePropsResourcesTargetGroup1;
    /**
     * @schema CfnLoadBalancerModulePropsResources#TargetGroup2
     */
    readonly targetGroup2?: CfnLoadBalancerModulePropsResourcesTargetGroup2;
    /**
     * @schema CfnLoadBalancerModulePropsResources#LoadBalancer1
     */
    readonly loadBalancer1?: CfnLoadBalancerModulePropsResourcesLoadBalancer1;
    /**
     * @schema CfnLoadBalancerModulePropsResources#Listener1
     */
    readonly listener1?: CfnLoadBalancerModulePropsResourcesListener1;
    /**
     * @schema CfnLoadBalancerModulePropsResources#ListenerRule1
     */
    readonly listenerRule1?: CfnLoadBalancerModulePropsResourcesListenerRule1;
    /**
     * @schema CfnLoadBalancerModulePropsResources#ELBBucketPolicy
     */
    readonly elbBucketPolicy?: CfnLoadBalancerModulePropsResourcesElbBucketPolicy;
    /**
     * @schema CfnLoadBalancerModulePropsResources#ELBBucket
     */
    readonly elbBucket?: CfnLoadBalancerModulePropsResourcesElbBucket;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResources(obj: CfnLoadBalancerModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * The ELB logs bucket name
 *
 * @schema CfnLoadBalancerModulePropsParametersElbBucketName
 */
export interface CfnLoadBalancerModulePropsParametersElbBucketName {
    /**
     * @schema CfnLoadBalancerModulePropsParametersElbBucketName#Type
     */
    readonly type: string;
    /**
     * @schema CfnLoadBalancerModulePropsParametersElbBucketName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsParametersElbBucketName' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsParametersElbBucketName(obj: CfnLoadBalancerModulePropsParametersElbBucketName | undefined): Record<string, any> | undefined;
/**
 * The environment name
 *
 * @schema CfnLoadBalancerModulePropsParametersEnvName
 */
export interface CfnLoadBalancerModulePropsParametersEnvName {
    /**
     * @schema CfnLoadBalancerModulePropsParametersEnvName#Type
     */
    readonly type: string;
    /**
     * @schema CfnLoadBalancerModulePropsParametersEnvName#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsParametersEnvName' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsParametersEnvName(obj: CfnLoadBalancerModulePropsParametersEnvName | undefined): Record<string, any> | undefined;
/**
 * The ImageDigest
 *
 * @schema CfnLoadBalancerModulePropsParametersImageDigest
 */
export interface CfnLoadBalancerModulePropsParametersImageDigest {
    /**
     * @schema CfnLoadBalancerModulePropsParametersImageDigest#Type
     */
    readonly type: string;
    /**
     * @schema CfnLoadBalancerModulePropsParametersImageDigest#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsParametersImageDigest' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsParametersImageDigest(obj: CfnLoadBalancerModulePropsParametersImageDigest | undefined): Record<string, any> | undefined;
/**
 * The RunTime
 *
 * @schema CfnLoadBalancerModulePropsParametersRunTime
 */
export interface CfnLoadBalancerModulePropsParametersRunTime {
    /**
     * @schema CfnLoadBalancerModulePropsParametersRunTime#Type
     */
    readonly type: string;
    /**
     * @schema CfnLoadBalancerModulePropsParametersRunTime#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsParametersRunTime' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsParametersRunTime(obj: CfnLoadBalancerModulePropsParametersRunTime | undefined): Record<string, any> | undefined;
/**
 * Vpc-ID
 *
 * @schema CfnLoadBalancerModulePropsParametersVpcId
 */
export interface CfnLoadBalancerModulePropsParametersVpcId {
    /**
     * @schema CfnLoadBalancerModulePropsParametersVpcId#Type
     */
    readonly type: string;
    /**
     * @schema CfnLoadBalancerModulePropsParametersVpcId#Description
     */
    readonly description: string;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsParametersVpcId' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsParametersVpcId(obj: CfnLoadBalancerModulePropsParametersVpcId | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesSpiderEc2Instance
 */
export interface CfnLoadBalancerModulePropsResourcesSpiderEc2Instance {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesSpiderEc2Instance#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesSpiderEc2Instance#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesSpiderEc2Instance' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesSpiderEc2Instance(obj: CfnLoadBalancerModulePropsResourcesSpiderEc2Instance | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesTargetGroup1
 */
export interface CfnLoadBalancerModulePropsResourcesTargetGroup1 {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesTargetGroup1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesTargetGroup1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesTargetGroup1' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesTargetGroup1(obj: CfnLoadBalancerModulePropsResourcesTargetGroup1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesTargetGroup2
 */
export interface CfnLoadBalancerModulePropsResourcesTargetGroup2 {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesTargetGroup2#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesTargetGroup2#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesTargetGroup2' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesTargetGroup2(obj: CfnLoadBalancerModulePropsResourcesTargetGroup2 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesLoadBalancer1
 */
export interface CfnLoadBalancerModulePropsResourcesLoadBalancer1 {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesLoadBalancer1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesLoadBalancer1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesLoadBalancer1' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesLoadBalancer1(obj: CfnLoadBalancerModulePropsResourcesLoadBalancer1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesListener1
 */
export interface CfnLoadBalancerModulePropsResourcesListener1 {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesListener1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesListener1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesListener1' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesListener1(obj: CfnLoadBalancerModulePropsResourcesListener1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesListenerRule1
 */
export interface CfnLoadBalancerModulePropsResourcesListenerRule1 {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesListenerRule1#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesListenerRule1#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesListenerRule1' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesListenerRule1(obj: CfnLoadBalancerModulePropsResourcesListenerRule1 | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesElbBucketPolicy
 */
export interface CfnLoadBalancerModulePropsResourcesElbBucketPolicy {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesElbBucketPolicy#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesElbBucketPolicy#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesElbBucketPolicy' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesElbBucketPolicy(obj: CfnLoadBalancerModulePropsResourcesElbBucketPolicy | undefined): Record<string, any> | undefined;
/**
 * @schema CfnLoadBalancerModulePropsResourcesElbBucket
 */
export interface CfnLoadBalancerModulePropsResourcesElbBucket {
    /**
     * @schema CfnLoadBalancerModulePropsResourcesElbBucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnLoadBalancerModulePropsResourcesElbBucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnLoadBalancerModulePropsResourcesElbBucket' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerModulePropsResourcesElbBucket(obj: CfnLoadBalancerModulePropsResourcesElbBucket | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FreyrAIM::Spider::LoadBalancer::MODULE`
 *
 * @cloudformationResource FreyrAIM::Spider::LoadBalancer::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnLoadBalancerModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FreyrAIM::Spider::LoadBalancer::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnLoadBalancerModuleProps;
    /**
     * Create a new `FreyrAIM::Spider::LoadBalancer::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnLoadBalancerModuleProps);
}
