import { aws_s3 as s3, aws_sqs as sqs, aws_events } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties for S3RunFargate Construct
 */
export interface S3RunFargateTaskProps {
    /**
     * S3 bucket
     */
    readonly bucket: s3.Bucket;
    /**
     * The name or ARN of the event bus associated with the rule
     * If you omitted, the default event bus is used
     *
     * @default default
     */
    readonly eventBusName?: string;
    /**
     * The name of the rule
     */
    readonly ruleName: string;
    /**
     * Rule description
     *
     * @default '''
     */
    readonly ruleDescription?: string;
    /**
     * ECS cluster name
     */
    readonly clusterName: string;
    /**
     * Fargate task ARN
     */
    readonly taskDefinitionArn: string;
    /**
     * Container name
     */
    readonly containerName: string;
    /**
     * Subnets IDs for Fargate task
     */
    readonly subnetIds: string[];
    /**
     * Specify if assign public IP address to task
     * If running in public subnet, this should be true
     *
     * @default false
     */
    readonly assignPublicIp?: boolean;
    /**
     * Security groups for Fargate task
     */
    readonly securityGroups: string[];
}
export declare class S3RunFargateTask extends Construct {
    readonly dlq: sqs.Queue;
    readonly rule: aws_events.CfnRule;
    /**
     * @summary Construct to run a Fargate task when files have been added to S3
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {S3RunFargateTaskProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access private
    */
    constructor(scope: Construct, id: string, props: S3RunFargateTaskProps);
}
