from typing import Self

from py_framework.config.bootstrap_config_resolver import BootstrapConfigResolver
from py_framework.config.base_config_resolver import BaseConfigResolver
import os
from py_framework.py_constants import APP_ROOT_DIR_ENV_KEY


class ApplicationContext:
    """应用配置上下文"""
    config_resolver: BaseConfigResolver


# 全局应用上下文
default_application_context: ApplicationContext


def application_context(name: str = None) -> ApplicationContext:
    """获取应用请求上下文"""
    return default_application_context


class PyApplication:
    """python应用初始化"""

    """是否启动Web"""
    _enable_web: bool = True

    """应用运行的根目录"""
    _root_dir: str = None

    def root_dir(self, work_dir: str):
        self._root_dir = work_dir if work_dir.endswith('/') else work_dir + '/'
        print('应用目录:', self._root_dir)

    def enable_web(self: Self, start_web: bool = True) -> Self:
        self._enable_web = start_web
        return self

    def run(self) -> ApplicationContext:
        global default_application_context
        default_application_context = ApplicationContext()

        # 校验根目录
        if self._root_dir is None:
            self.root_dir(os.getenv(APP_ROOT_DIR_ENV_KEY))

        # 校验是否开启web
        if not self._enable_web:
            print('禁用Web服务接口')

        default_application_context.config_resolver = BootstrapConfigResolver(base_dir=os.getcwd())

        return default_application_context
