# Generated by Django 3.2.14 on 2022-07-04 14:19

from django.db import migrations


def get_operation(forwards: bool = True):
    from_app = "notifications" if forwards else "notifications_api_common"
    to_app = "notifications_api_common" if forwards else "notifications"

    def migrate_data(apps, _):
        NotificationsConfig_old = apps.get_model(f"{from_app}.NotificationsConfig")
        Subscription_old = apps.get_model(f"{from_app}.Subscription")
        NotificationsConfig = apps.get_model(f"{to_app}.NotificationsConfig")
        Subscription = apps.get_model(f"{to_app}.Subscription")

        old_config, _ = NotificationsConfig_old.objects.get_or_create()
        new_config, _ = NotificationsConfig.objects.get_or_create()
        new_config.api_root = old_config.api_root
        new_config.save()

        old_subscriptions = Subscription_old.objects.all()
        for sub in old_subscriptions:
            Subscription.objects.create(
                config=new_config,
                callback_url=sub.callback_url,
                client_id=sub.client_id,
                secret=sub.secret,
                channels=sub.channels,
                _subscription=sub._subscription,
            )
        old_subscriptions.delete()

    return migrate_data


class Migration(migrations.Migration):
    dependencies = [
        ("notifications", "0009_auto_20190729_0427"),
        ("notifications_api_common", "0001_initial"),
    ]

    operations = [
        migrations.RunPython(
            get_operation(forwards=True), get_operation(forwards=False)
        )
    ]
